/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   proc_results.c
 *
 *
 *----------------------------------------------------------------------------
 */

#ifndef SOC_VERIFICATION
#ifndef SILICON_VERIFY
#define USE_RUNTIME_LIBS_AND_BMS
#endif
#endif

#ifdef USE_RUNTIME_LIBS_AND_BMS
#include <string.h>
#include "InitBMf.h"
#endif

#include "typedef.h"

#ifndef SOC_VERIFICATION
#include "common.h"
#include "const.h"
#include "hwtest_const.h"
#include "hwtest_const2.h"
#include "hwtest_gdata.h"
#include "nmp_plfm.h"
#include "cmv_data.h"
#endif

#define TEST_INCOMPLETE 0
#define TEST_COMPLETE   1

/////////////////////
// Global variables
/////////////////////

#define FLASH_RATE   0x20000  // LED Flah Rate
int32 gl_heartbeat=0;      // Used as a heart beat counter for monitoring purpose

#ifdef USE_RUNTIME_LIBS_AND_BMS
char StateName[MAX_NUM_TESTS][MAX_STATENAME_LEN];  // Names of all Tests. Printed to trail during process results
#endif

#ifdef SOC_VERIFICATION
extern int gs_error_count;
extern MSG_Error(unsigned int addr, unsigned int expected, unsigned int actual);
extern MSG_EDone(unsigned int event);
#else
int16 gs_TestStatus = TEST_INCOMPLETE;
extern int16 gs_error_count;
#endif

extern void LED2_on(void);
extern void LED2_off(void);
extern void LED2_blink(void);
extern void LED3_on(void);
extern void LED3_off(void);
extern void LED3_blink(void);

/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*        void ProcessResults(void)
*
*       Abstract:
*
*       Parameters:
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/


void ProcessResults(void)
{

#ifdef USE_RUNTIME_LIBS_AND_BMS

   FILE *HWEngineTestResultPtr = NULL;
   char filename[64];

/* ==================================================================== */
/* Initialize Array */
/* ==================================================================== */
    strcpy(StateName[IRI_REG_TEST_ID],"IRI_REG_TEST");
    strcpy(StateName[IRI_RAM_TEST_ID],"IRI_RAM_TEST");
    strcpy(StateName[IRI_IFFT_TEST_ID],"IRI_IFFT_TEST");
    strcpy(StateName[IRI_QAM_TEST_ID],"IRI_QAM_TEST");
    strcpy(StateName[IRI_TCM_TEST_ID],"IRI_TCM_TEST");
    strcpy(StateName[IRI_FFT_TEST_ID],"IRI_FFT_TEST");
    strcpy(StateName[ZEP_REG_TEST_ID],"ZEP_REG_TEST");
    strcpy(StateName[ZEP_RAM_TEST_ID],"ZEP_RAM_TEST");
    strcpy(StateName[ZEP_TX_BYPASS_TEST_ID],"ZEP_TX_BYPASS_TEST");
    strcpy(StateName[ZEP_RX_BYPASS_TEST_ID],"ZEP_RX_BYPASS_TEST");
    strcpy(StateName[ZEP_RS_TEST_ID],"ZEP_RS_TEST");
    strcpy(StateName[ALP_REG_TEST_ID],"ALP_REG_TEST");
    strcpy(StateName[ALP_RAM_TEST_ID],"ALP_RAM_TEST");
    strcpy(StateName[CRI_REG_TEST_ID],"CRI_REG_TEST");
   strcpy(StateName[ZI_LOOPBACK_TEST_ID],"ZI_LOOPBACK_TEST");
   strcpy(StateName[ZIS_LOOPBACK_TEST_ID],"ZIS_LOOPBACK_TEST");
   strcpy(StateName[ZI_SHALF_TEST_ID],"ZI_SHALF_TEST");
   strcpy(StateName[DEC_PATH_TEST_ID],"DEC_PATH_TEST");
   strcpy(StateName[IRI_SEQGEN_TEST_ID],"IRI_SEQGEN_TEST");

/* ==================================================================== */
/* Print Results to  file */
/* ==================================================================== */

   sprintf(filename,"HWEngineTestResult_%s.txt", StateName[gs_hwTestType]);
   HWEngineTestResultPtr = fopen(filename,"w");

   fprintf(HWEngineTestResultPtr, "HW Engine %s --- ",StateName[gs_hwTestType]);
   if (gs_TestResult == 1)
      fprintf(HWEngineTestResultPtr, "PASS.\n");
   else
      fprintf(HWEngineTestResultPtr, "FAIL.\n");

   fclose(HWEngineTestResultPtr);
#endif

#ifndef SOC_VERIFICATION
   gs_TestStatus = TEST_COMPLETE;
#endif

#ifndef HWENGINE_30
#ifdef SILICON_VERIFY
   // Light up an LED to indicate test completion.
   LED2_blink();
   LED3_off();
#endif
#endif

   /* ======================================================================= */
   /*  service WINHOST messages  */
   /* ======================================================================= */

#ifndef SOC_VERIFICATION

   // Use WinHost for default and SiliconVerify builds.
   // Run MP handler loop and flash an LED.
   while (gs_MpWinhostControl == 1)
   {
      gl_heartbeat++;
      if (gl_heartbeat & FLASH_RATE)
      {
         LED2_on();
      }
      else
      {
         LED2_off();
      }
      if (NewMPCheckMessage(VBM_MAILBOX)!= 0)
      {
         gs_ModemOperationRequired = NewMPHandleMessage(VBM_MAILBOX);
      }
      if(   gft_RunProcessResultsOnce) break;
   }
#else // SOC_VERIFICATION
   // Use different signalling technique for RTL verification
   if (gs_error_count == 0)
      MSG_EDone(1);
   else
      MSG_EDone(0);

#endif


}

void SetTDPParameters(void)
{
}
