/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// Verification event codes
#define PING_CMD  (0x1)
#define  EDONE_CMD   (0x3)
#define  ERR_CMD     (0x4)

#define  ERR_FLAG_MEMORY      (0x0)
#define  ERR_FLAG_DMA      (0x1)
#define  ERR_FLAG_ARC_MEM  (0x2)
#define  ERR_FLAG_ARC_INT  (0x3)
#define  ERR_FLAG_BAD_MEI  (0x4)

#define EDONE_EVENT        (0x0)

// Auxiliary registers
#define MEI_INT_AC         (0x107)
enum {
   AUX_MB_0 = 0x400,
      AUX_MB_1,
      AUX_MB_2,
      AUX_MB_3,
      AUX_MB_4,
      AUX_MB_5,
      AUX_MB_6,
      AUX_MB_7,
      AUX_MB_8,
      AUX_MB_9,
      AUX_MB_10,
      AUX_MB_11
};

void MSG_EDone(unsigned int event) {
#ifndef HWENGINE_30
   _sr(EDONE_CMD,AUX_MB_0);
   _sr(EDONE_EVENT,AUX_MB_1);
   _sr(event, AUX_MB_2);   // indicate test result
   _sr(0x01, MEI_INT_AC);
#else
   unsigned int temp;

   do
   {
      temp = _lr(MEI_INT_AC);
   } while(temp & 0x01);      //Check that bit 0 of MEI_INT_AC is 0.

   *(unsigned int *)(0x15F80) = (unsigned int)(EDONE_CMD);
   *(unsigned int *)(0x15F84) = (unsigned int)(EDONE_EVENT);
   *(unsigned int *)(0x15F88) = (unsigned int)(event);   // indicate test result
   _sr(0x01, MEI_INT_AC);
#endif
}

void MSG_Error(unsigned int addr, unsigned int expected, unsigned int actual) {
#ifndef HWENGINE_30
   _sr(ERR_CMD,AUX_MB_0);
   _sr(ERR_FLAG_MEMORY,AUX_MB_1);
   _sr(addr,AUX_MB_2);
   _sr(expected,AUX_MB_3);
   _sr(actual,AUX_MB_4);
   _sr(0x01, MEI_INT_AC);
#else
   *(unsigned int *)(0x15F80) = (unsigned int)(ERR_CMD);
   *(unsigned int *)(0x15F84) = (unsigned int)(ERR_FLAG_MEMORY);
   *(unsigned int *)(0x15F88) = (unsigned int)(addr);
   *(unsigned int *)(0x15F8C) = (unsigned int)(expected);
   *(unsigned int *)(0x15F90) = (unsigned int)(actual);
   _sr(0x01, MEI_INT_AC);
#endif
}

void MSG_Ping(void) {
#ifndef HWENGINE_30
   _sr(PING_CMD, AUX_MB_0);
   _sr(0x01, MEI_INT_AC);
#else
   *(unsigned int *)(0x15F80) = (unsigned int)(PING_CMD);
   _sr(0x01, MEI_INT_AC);
#endif
}
