/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   utility_platform.c - platform specific utility functions
 *
 *
 *----------------------------------------------------------------------------
 */

#include "typedef.h"
#include "socrates_memrymap.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "delay.h"
#include "soc_codeswap.h"
#include "mei_iof.h"
#include "hwtest_gdata.h"

#define GPIO_CTRL 0x10C
#define GPIO_DATA 0x10D

#define GPIO9     0x0200
#define GPIO10    0x0400
#define GPIO11    0x0800
#define GPIO12    0x1000

/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*        void InitializePlatform(void)
*
*       Abstract:
*        Platform Specific Initializations.
*
*       Parameters:
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
void InitializePlatform(void)
{
#ifndef SOC_VERIFICATION
#ifndef SILICON_VERIFY
   InitBMs();
#endif
#endif

#ifdef SILICON_VERIFY

   //========================
   // Enable DSL clocks.
   //========================
   //
      // CRI_CCR0:
      //    CLK_2M_MODE = 01  Clock is generated internally based on nominal divide ratio of pll_clk.
      //    AC_CLK_MODE = 01  Clock is forced on
      //    FDF_CLK_MODE = 01 Clock is forced on
      //    STM_CLK_MODE = 01 Clock is forced on

      WriteCoreReg(CRI_CCR0_ADDR,(uint16)0x0055);

      // CRI_CCR1:
      //    AAI_CLK_MODE =    01 Clock is forced on
      //    MTE_TX_CLK_MODE = 10 Clock is gated by Iridia
      //    MTE_RX_CLK_MODE = 10 Clock is gated by Iridia
      //    FCI_TX_CLK_MODE = 10 Clock is gated by Zephyr
      //    FCI_RX_CLK_MODE = 10 Clock is gated by Zephyr
      //    AAI_TX_CLK_MODE = 10 Clock is gated by Alphaeus
      //    AAI_RX_CLK_MODE = 10 Clock is gated by Alphaeus

      WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x1AAA);

   //========================
   // Set DSL clock dividers.
   //========================
   //
      // CRI_CDC0:
      //    AC_CLK_DIV = 00         Divide by 1 to get Aware Cores clock
      //    FDF_CLK_DIV = 00     Divide by 1 to get Strymon clock
      //    STM_CLK_DIV = 00     Divide by 1 to get Electra clock

#ifndef HWENGINE_30
      WriteCoreReg(CRI_CDC0_ADDR,(uint16)0x0000);
#endif

      // CRI_CDC1:
      //    AAI_CLK_DIV = 01     Divide by 2 to get Alphaeus clock
      //    MTE_TX_CLK_DIV = 01     Divide by 2 to get Iridia Tx clock
      //    MTE_RX_CLK_DIV = 01     Divide by 2 to get Iridia Rx clock
      //    FCI_TX_CLK_DIV = 01     Divide by 2 to get Zephyr Tx clock
      //    FCI_RX_CLK_DIV = 01     Divide by 2 to get Zephyr Rx clock
      //    AAI_TX_CLK_DIV = 01     Divide by 2 to get Alphaeus Tx clock
      //    AAI_RX_CLK_DIV = 01     Divide by 2 to get Alphaeus Rx clock

#ifndef HWENGINE_30
      WriteCoreReg(CRI_CDC1_ADDR,(uint16)0x1555);
#endif

   //========================
   // Disable all interrupts
   //========================

      WriteCoreReg(CRI_MASK0_ADDR,0x0);
      WriteCoreReg(CRI_MASK1_ADDR,0x0);
      WriteCoreReg(CRI_MASK2_ADDR,0x0);
      WriteCoreReg(CRI_AMASK0_ADDR,0x0);
      WriteCoreReg(CRI_AMASK1_ADDR,0x0);


   //========================
   // Configure CRI_PLL register.
   //========================

      WriteCoreReg(CRI_PLL_ADDR,(uint16)0x1);      // DSP CLK = 105 MHz.

   //========================
   // Reset DSL cores
   //========================

      WriteCoreReg(CRI_RST_ADDR,(uint16)0x3F);
      WriteCoreReg(CRI_RST_ADDR,(uint16)0x0);

   //========================
   // Clear Status, Event registers
   //========================

      // Write 1's to clear.

      WriteCoreReg(CRI_EVENT0_ADDR,(uint16)0xFFFF);
      WriteCoreReg(CRI_EVENT1_ADDR,(uint16)0xFFFF);
      WriteCoreReg(CRI_EVENT2_ADDR,(uint16)0xFFFF);
      WriteCoreReg(CRI_STATUS0_ADDR,(uint16)0xFFFF);
      WriteCoreReg(CRI_STATUS1_ADDR,(uint16)0xFFFF);
      WriteCoreReg(CRI_STATUS2_ADDR,(uint16)0xFFFF);

   //========================
   // Clear MAD status
   //========================

      // Write 1's to clear.

      WriteCoreReg(CRI_MADST_ADDR,(uint16)0xFFFF);

   //========================
   // Set update mode
   //========================

      // FRC_MASK1_UPD = 0 No auto update.
      // DIS_MASK1_UPD = 1 Don't update CRI_AMASK1 on MTE_TFRAME
      // FRC_MASK0_UPD = 0 No auto update.
      // DIS_MASK0_UPD = 1 Don't update CRI_AMASK0 on MTE_RFRAME

      WriteCoreReg(CRI_UPDCTL_ADDR,(uint16)0x0005);


#endif

}

/*****************************************************************************
;  Prototype: int16 Read32BitData(int16 us_BaseAddr, int16 us_Offset, int32 * plu_Data)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

int16 Read32BitData(uint16 us_BaseAddr, uint16 us_Offset, int32 * plu_Data)
{

   *plu_Data = *((uint32 *) ((uint32) ((us_BaseAddr + us_Offset) << 2) + ADSL_BASE_OFFSET));

   return(0);

}

/*****************************************************************************
;  Prototype: int16 Write32BitData(int16 us_BaseAddr, int16 us_Offset, int32 ul_Data)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

int16 Write32BitData(uint16 us_BaseAddr, uint16 us_Offset, int32 ul_Data)
{

   *((uint32 *) ((uint32) ((us_BaseAddr + us_Offset) << 2) + ADSL_BASE_OFFSET)) = ul_Data;

   return(0);

}

void delay(uint16 delay_val)
{
   while (delay_val > 0) delay_val--;
}

#define SILABS_AFE
void afe_reset_init(void) {
#ifdef SOC_RTL_TEST
   #ifndef HWENGINE_30
   WriteCoreReg(AFE_CONFIG_ADDR,0x0004);
   delay(100);
   #else
      #ifndef AFE_TCR_0_ADDR
         #define AFE_TCR_0_ADDR (0x7037)
         #define AFE_TCR_1_ADDR (0x7038)
         #define AFE_TCR_2_ADDR (0x7039)
      #endif // #ifndef AFE_TCR_0_ADDR


   #endif // #ifndef HWENGINE_30

#endif // #ifdef SOC_RTL_TEST
}

// LED2 is DETECT xor'd with CONNECT and is driven solid green for link detect and blinking for link connect.
// LED3 is ADSL_SYNC or'd with ADSL_CRC and is driven solid orange(yellow) for loss of sync and blinking for CRC errors.

// GPIO9    ADSL_SYNC (Loss of Sync)
// GPIO10      CONNECT
// GPIO11      ADSL_CRC
// GPIO12      DETECT

void LED2_on(void)
{
   uint32 ul_word;

   ul_word = _lr(GPIO_DATA);
   ul_word = (ul_word | GPIO12) & (0xFFFF ^ GPIO10);
   _sr(0xFFFF, GPIO_CTRL);    // Configure GPIO pins as outputs.
   _sr(ul_word, GPIO_DATA);
}

void LED2_off(void)
{
   uint32 ul_word;

   ul_word = _lr(GPIO_DATA);
   ul_word = ul_word | GPIO10 | GPIO12;
   _sr(0xFFFF, GPIO_CTRL);    // Configure GPIO pins as outputs.
   _sr(ul_word, GPIO_DATA);
}

void LED2_blink(void)
{
   uint32 ul_word;

   ul_word = _lr(GPIO_DATA);
   ul_word = (ul_word | GPIO10) & (0xFFFF ^ GPIO12);
   _sr(0xFFFF, GPIO_CTRL);    // Configure GPIO pins as outputs.
   _sr(ul_word, GPIO_DATA);
}

void LED3_on(void)
{
   uint32 ul_word;

   ul_word = _lr(GPIO_DATA);
   ul_word = (ul_word | GPIO9) & (0xFFFF ^ GPIO11);
   _sr(0xFFFF, GPIO_CTRL);    // Configure GPIO pins as outputs.
   _sr(ul_word, GPIO_DATA);
}

void LED3_off(void)
{
   uint32 ul_word;

   ul_word = _lr(GPIO_DATA);
   ul_word = ul_word & (0xFFFF ^ GPIO9 ^ GPIO11);
   _sr(0xFFFF, GPIO_CTRL);    // Configure GPIO pins as outputs.
   _sr(ul_word, GPIO_DATA);
}

void LED3_blink(void)
{
   uint32 ul_word;

   ul_word = _lr(GPIO_DATA);
   ul_word = (ul_word | GPIO11) & (0xFFFF ^ GPIO9);
   _sr(0xFFFF, GPIO_CTRL);    // Configure GPIO pins as outputs.
   _sr(ul_word, GPIO_DATA);
}

/****************************************************************************
;  Prototype: void SendCodeSwapRequest(void)
;
;  Description:
;       Sends a codeswap request to host.
;
;  Arguments:
;
;  Return Value:
;     none
;
;
;****************************************************************************/
void SendCodeSwapRequest(void) {
   uint32 ul_data;

   // clear the CS_DONE bit
   MEI_RegisterWrite(MEI_INT_MC_ADDR, MEI_INT_MC_CS_DONE_MASK);

   // set the MSG_TYPE bit in the OMB_CODESWAP_MESSAGE register to 1
   // to indicate that the ARC->MEI message is a codeswap message
   ul_data = OMB_CODESWAP_MESSAGE_MSG_TYPE_MASK;

   // indicate which codeswap section we want
   ul_data |= ((uint32) gs_CodeSwapSection & OMB_CODESWAP_MESSAGE_CS_SECTION_MASK);
#ifndef NEW_MAILBOX_INTERFACE
   MEI_RegisterWrite(OMB_CODESWAP_MESSAGE_ADDR, ul_data);
#else
   *(int32 *)OMB_CODESWAP_MESSAGE_ADDR = ul_data;
#endif

   // notify MEI of codeswap request by assertin the ARC->MEI mailbox message interrupt
   ul_data = (uint32) MEI_INT_AC_ARC_MSGAV_MASK;
   MEI_RegisterWrite(MEI_INT_AC_ADDR, ul_data);

}

/****************************************************************************
;  Prototype: int16 HandleCodeSwap(void);
;
;  Description:
;       Handles a codeswap request from start to finish.  Send the codeswap
;     request to the MEI, checks the MEI's response to the request, and
;     informs the task layer code of the status of the codeswap request.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;
;****************************************************************************/
void HandleCodeSwap(void)
{
   uint32 ul_data;
   // check the status of the codeswap request
   if(gs_CodeSwapStatus == CODESWAP_IN_PROGRESS)
   {
      // check if the MEI has finished handling a codeswap page
      MEI_RegisterRead(MEI_INT_MC_ADDR, &ul_data);
      if(ul_data & MEI_INT_MC_CS_DONE_MASK)
      {
         // check if the MEI has finished due to an error
#ifndef NEW_MAILBOX_INTERFACE
         MEI_RegisterRead(IMB_CODESWAP_STATUS_ADDR, &ul_data);
#else
         ul_data = *(int32 *) (IMB_CODESWAP_STATUS_ADDR);
#endif
         if((ul_data & IMB_CODESWAP_STATUS_MASK) == IMB_CODESWAP_STATUS_FAIL_MASK)
         {
            //HandleException(CODESWAP_ERROR);
            //gs_RxNextState = FAIL_RX;
            //gs_TxNextState = FAIL_TX;
            return; //ERROR
         }
         gs_CodeSwapStatus = CODESWAP_COMPLETE;
         // clear the CS_DONE bit
         MEI_RegisterWrite(MEI_INT_MC_ADDR, MEI_INT_MC_CS_DONE_MASK);
      }
   }
}

void SendFastReadRequest(void)
{
}
