/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// VR9_Afedata.c
//
// This file consists of all the common variables between
// VR9, VRx318 and VRx518 platform.
//
// ******************************************************************

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "data_alloc.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "gdata.h"
/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/
uint16 gus_wrfail_done = 0;
uint16 gus_wrfail_busy = 0;
uint16 gus_rdfail_done = 0;
uint16 gus_rdfail_busy = 0;

uint16 gus_AfeChipId = 0;
uint16 gusa_AfeChipId[2] = {0, 0};


uint32 gul_ExceptionCode;

FlagT gft_NoVDSLIndication = 0;

uint16 gus_RCtimeConstCNT=0;

FlagT gft_PowerUpLink;

FlagT gft_AFEPowerBoost;        //XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise(Start_End)

#ifdef VDSL_62
// Variable to check whether the binary is for ADSL or VDSL
// If ADSL, this variable (gft_Bin_ADSL_VDSL = 0), else
// gft_Bin_ADSL_VDSL = 1 for VDSL binary
FlagT gft_Bin_ADSL_VDSL = 1; //VDSL_Mode
#else
FlagT gft_Bin_ADSL_VDSL = 0; //ADSL Mode
#endif

int16 gus_AFE_RxMode, gus_AFE_TxMode;

//SMS01369273, Debug - Overwriting the Tx and Rx Mode registers
FlagT gft_AFE_TxMode_Overwrite = 0;
FlagT gft_AFE_RxMode_Overwrite = 0;

int16 gs_PGA_Handler_count = 0;
int16 gs_AGC1_Gain_Set = 0; // AGC1 gain
int16 gs_AGC2_Gain_Set = 0; // AGC2 gain
int16 gs_AGC2_compensation = 0;
int16 gs_AGC1_compensation = 0;
int16 gs_ADC_margin = 0;

FlagT gft_EnableDoublePGATrain = FALSE;
FlagT gft_ADCOverflowed = FALSE;
int16 gs_PgaHandlerRun = 0;
int16 gs_AGC1_Margin = 0;
//int16 gs_AGC2_Margin = 0;
uint8 guc_DoublePgaHandlerState;
FlagT gft_IsBTorLLoop = FALSE;   //XDSLRTFW-3674 New_LLAPI_changes

DATA_XILVB_B4_SHOW_INIT_BEGIN

#ifdef VRX518
uint16 gusa_SpecialHybSetting[VRX_HYB_NUM_SETTINGS] =
// PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa  Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc Description
//   { 0x0253,       0x043F,          0x0133,        0xF84F};  //   7
// PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa  Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc Description
//{ 0x0253,       0x063F,          0x0414,       0xF84F}; //   0   -7.6930   123  210   1600   145   1p  133   off   1p Null Loop
{ 0x001E,       0x073D,          0x0C1E,       0xF688};  //   6    -9.4697   800   off   533  2832   1p   800   off   3p  26AWG var length (6096m, 20000ft)
#else
uint16 gusa_SpecialHybSetting[VRX_HYB_NUM_SETTINGS] =
{0x007F,0x007F,0x0000,0x00FF,0x00FE,0x80FF, 0x0001, 0xF37A}; //-12.5242  Special Hyb Settings with -9dB gain at AGC1 input
//    {RIN1 , RIN2 , RINX ,RSHUNT1,RSHUNT2,RSHUNTX,CPROG,HybGain}
// XDSLRTFW-1488 (End)
int16 gsa_cap_delta[VRX_NUM_CAP_SEARCH] = {0 , 2, 1, -2, -1}; //idx0->No Cap val change
#endif


FlagT gft_HybridTrainEnable = 1;
uint8 guc_HybTable = 0;
int16 gs_HybTrIndexDbg = -1;
uint16 *gusa_InitHybridSettings;

uint16 gusa_HybMetric[VRX518_MAX_NUM_ADAP_HYB_SETTINGS];
int16 gs_HybTableForce = -1;
int16 gs_LoadAllPGAGains = 0;
int32 gla_HybRevRefPwr[VRX518_MAX_NUM_ADAP_HYB_SETTINGS];
//int16 gsa_SignalPSD[(HYB_DECIM_POINTS+1)*VR9_NUM_ADAP_HYB_SETTINGS];


uint32 gula_VRX518_EfuseTable[EFUSE_TABLE_LEN];   // XDSLRTFW-3286 (Start_End)

#ifdef ISDN
uint16 gusa_RxL2CombinGains[512];
#endif
//XDSLRTFW-3674 Options_For_debug
int16 gsa_NMS_Force[512] =
 {

   0x0375,       0x0013,            0x0410,        (int16)0xFD0A, // hybrid forcing at zero index.
   0,        0,      0,      0,           0,        0,          0,          0,        0,          0,          0,          0,
   0,        0,      0,      0,        0,     0,       0,          0,           0,        0,          0,          0,        0,          0,          0,          0,
1024,     1024,   1024,   1024,     1024,  1024,    1024,       1024,        1024,      987,        951,        914,      878,        841,        805,        768,
 731,      695,    658,    622,      585,   549,     512,        512,         512,      512,        512,        512,      512,        512,        512,        512,
 512,      512,    512,    512,      512,   512,     512,        512,         512,      512,        512,        504,      497,        489,        482,        474,
 467,      459,    452,    444,      437,   429,     422,        414,         407,      399,        392,        384,      376,        369,        361,        354,
 346,      339,    331,    324,      316,   309,     301,        294,         286,      279,        271,        264,      244,        368,         97,        219,
  37,      110,    364,     73,      255,   110,      73,        203,         139,       74,         37,         37,        0,         37,        113,        116,
  42,      153,     82,      0,      113,   113,     131,         42,          79,       43,         42,         40,       82,         42,          0,         74,
  43,       39,    171,     46,       82,     0,      82,          0,          85,       43,         47,        131,       40,         46,        178,         97,
   0,        0,     47,     89,      125,    43,      43,          0,         121,       85,         43,         85,       43,         43,         89,         93,
  82,       89,      0,     43,       85,     0,     186,        131,         131,        0,         43,          0,       93,          0,        131,         43,
  82,       40,     40,    164,      210,    85,      42,         79,           0,      195,         40,        116,      116,         36,          0,        113,
  79,        0,    153,     74,        0,   149,       0,        149,         189,      113,         37,         76,       37,        139,         73,         36,
  33,        0,     64,     33,       37,    66,       0,         73,         110,      102,        233,         99,       33,         33,          0,          0,
  73,       33,    139,      0,       33,   139,      39,         33,         190,      203,         36,        135,       36,          0,          0,         36,
   0,       69,     37,    113,       73,   143,      37,         36,         189,      110,         73,        106,        0,        116,        189,        222,
 195,       76,    113,    248,      113,    82,     116,         46,         189,       74,         37,        264,      121,        297,        116,        284,
 158,      238,     37,    153,      195,   171,     153,        247,         247,      149,        125,        195,      231,        231,        320,        297,
 274,      284,    367,    153,      284,   400,      89,        294,         201,      121,        331,        294,      331,        400,        218,        210,
 320,      396,    294,    284,      210,   320,     178,        331,         294,      210,        158,        274,      247,        247,        178,        210,
 164,      178,    136,    320,      125,   125,     164,        195,         228,        0,          0,        143,      268,         43,        136,         89,
   0,        0,    136,    231,        0,   121,     158,        189,           0,       43,         82,         37,      158,        164,        113,         39,
  79,      158,     82,     42,      189,   158,     238,          0,         121,       76,         39,         40,      195,         73,         69,         74,
  74,       37,     37,     39,      222,    76,       0,        110,          37,       76,         74,         73,      238,        153,         74,        189,
  33,       42,    340,    116,       74,     0,      37,        121,         158,       39,         37,         82,       79,        149,         37,         39,
  40,       39,     39,    189,       40,    85,      74,         74,           0,       40,        201,        116,       43,         76,         85,         37,
  74,       85,     82,     85,       47,    40,       0,        125,         153,      125,         42,        153,      171,         82,          0,         43,
 171,      116,     46,     43,       43,     0,     171,         50,          93,       93,         50,         46,       50,         46,         50,         46,
   0,        0,      0,     57,       50,    52,      97,         57,          57,      224,          0,         54,      111,          0,        111,        118,
  61,       63,     61,     63,        0,    63,      67,         63,         139,      191,          0,        216,       77,          0,        149,        159,
 231,       82,     77,     82,       88,     0,       0,         82,          88,        0,         82,        185,      170,          0,          0,         88,
};

// Check this, code implemented without this
//int16 gsa_sum_dB_lookup[21] = {771, 650, 544, 452, 373, 305, 249, 202, 164, 132, 106, 85, 68, 54, 43, 35, 28, 22, 17, 14, 11 };


DATA_MAP_END //DATA_XILVB_B4_SHOW_INIT_BEGIN
//DATA_MAP_LOCAL_LD_ST_BEGIN
DATA_BULK_DATA2_BEGIN
int16 gsa_HybGain[VRX518_MAX_NUM_ADAP_HYB_SETTINGS*VRX_HYB_AFE_REG_GAINS];
int32 gla_BgHybAccumBuf[2*(HYB_DECIM_FACTOR * HYB_DECIM_POINTS + 1)];
DATA_MAP_END

