/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
 ** The 'CCASE' lines will be filled by ClearCase upon checkin,
 ** please do not change this information manually!
 **
 ** =============================================================================
 **
 ** All rights reserved.
 ** =============================================================================
 **
 ** =============================================================================
 **
 ** This document contains proprietary information belonging to Infineon
 ** Technologies. Passing on and copying of this document, and communication of
 ** its contents is not permitted without prior written authorisation.
 **
 ** =============================================================================
 **
 **
 ** =============================================================================
 **
 ** Revision Information :
 **
 ** CCASE_FILE = "VersionInfo.c"
 ** CCASE_DATE = "Wed Aug  3 16:16:17 2005"
 **
 ** =============================================================================
 **
 ** Contents:   Inside this file the VersionInfo is implemented.
 **
 ** Functions:  GetVersionInfo()
 **             - This function gets all informations about the Hardware-, ROM-
 **               and Firmware Version.
 **
 **             SetSystemVendorID()
 **          -   Set the SystemVendorID which represents the manufacturer of
 **              the xDSL-Board.
 **
 **             FillSystemVendorID()
 **          - Fill the array of the SystemVendorID.
 **
 ** =============================================================================
 **
 ** References: <List of related design documents>
 **
 ** =============================================================================
 ** History:
 **
 ** Date        Author        Comment
 ** 2005-05-03  Wehmann       Creation
 ** 2009        Tung Le       ported from IFX source to VR9
 ** =============================================================================
 **
Additional version control information
 ********************************************************************************
 CCASE_USER    = "wehmann"
 CCASE_VERSION = "\main\9"
 *******************************************************************************/

/*
 ** =============================================================================
 **                           INCLUDE FILES
 ** =============================================================================
 */

#include "common.h"
#include "typedef.h"
#include "Cust_CmvDefinitions.h"
#include "VersionInfo.h"
#include "eoc.h"
#include "gdata.h"
#include "version.h"
#include "LL_IOf.h"
#include "dsp_regs_62.h"

/*
 ** =============================================================================
 **                           LOCAL DEFINITIONS
 ** =============================================================================
 */

/* PayLoadSize for filled response message */
#define PAYLOAD_SIZE_VERSION_INFO    6
#define PAYLOAD_SIZE_SYS_VENDOR_ID   6
#define RESERVED_VALUE               0x0000

//XDSLRTFW-3365 (Start)
//BAR-18 Base Address: Refer to Arete-DSP_xDSL_CPE_Bonded_v3.1.pdf
//BAR-18 Base Address = (0x100000 + (16*64*1024) + (512*1024) + (64*1024)) => 0x290000
#define BAR18_BASE_ADDRESS  (0x290000)
//CHIP ID register offset: Refer to vrx518-reg_file-chipid_efuse.html or
//VRx518 data sheet "VRX518_V1.2_DS_Rev1.0.pdf"
#define CHIPID_REG_OFFSET   (0x4)
//XDSLRTFW-3365 (End)


/*
 ** =============================================================================
 **                           LOCAL DATA
 ** =============================================================================
 */


/*
 ** =============================================================================
 **                           GLOBAL DATA
 ** =============================================================================
 */

/*
 ** =============================================================================
 **                           LOCAL FUNCTION PROTOTYPES
 ** =============================================================================
 */

/*
 ** =============================================================================
 **                           IMPLEMENTATION
 ** =============================================================================
 */
/*
 ** =============================================================================
 ** FUNCTION-DESCRIPTION
 **
 ** FUNCTION-NAME:  GetVersionInfo()
 **
 ** DESCRIPTION:    This function gets version information about the Hardware-, ROM-
 **                 and Firmware Version.
 **
 ** PARAMETERS:     *us_PayLoadSize (uint16 / unsigned short)
 **                 - Payload size in actual message.
 **
 **                 uc_Length (uint8 / unsigned char)
 **                 - uc_Length parameter from header.
 **
 **                 Payload[] (uint16 / unsigned short)
 **                 - Array with the payload elements.
 **
 ** RETURN VALUE:   uc_MsgExecuted (uint8 / unsigned char)
 **                 - Value for function code creation.
 **
 ** NOTES:          OK!
 ** =============================================================================
 */
uint8 GetVersionInfo(uint16 *us_PayLoadSize, uint8 uc_Length, uint16 PayLoad[])
{

   uint32 ul_TempValue, ul_data;
   uint8  uc_MsgExecuted = CMV_WITHOUT_ERRORS;

   /*
    ** Is length parameter correct
    */
   if(uc_Length == (PAYLOAD_SIZE_VERSION_INFO >> 1))
   {

      //XDSLRTFW-3365 (Start)
      //Refer to "HW_Version" format defined in ACK_VersionInfoGet section of Message
      //Catalog Ver 2.9 or newer.

      //Populate bits 3:0 of field "HW_Version" with "Chip Version". Chip version
      //can be obtained from bits 30:28 of "CHIPID" register. We need assistance of a BAR register
      //to read "CHIPID" register
      PayLoad[0] = (uint16)((*(uint32 *)(BAR18_BASE_ADDRESS + CHIPID_REG_OFFSET) & 0x70000000) >> 28);

      //Populate bits 31:28 of field "HW_Version" with Chip configuration (i.e. VRx518 or VRx517)
      // The register ID_CFG - Chip Configuration register, consists of details about the profiles to supported by VRx518/VRx517 system.
      // The bits 15:13 is used to indicated the support of DSL profiles. And these values are mapped to the Bit 8, 6 and 5 of ARC GPIO
      // register which can be read from the ARC. The value and its interpretation is as below:
      //  |  Value  | Profile Supported
      //  |    0    |  All profiles                                      => VRx518 default EFuse config
      //  |    1    |  Disable 35B support and retain till 30a           => VRx517 default EFuse config
      //  |    2    |  Disable 35B,30a support and retain till 17a
      //  |    3    |  Disable 35B,30a,17a support and retain till 12x
      //  |    4    |  Disable 35B,30a,17a,12x support and retain till 8x
      ul_data = GetDspReg(DSP_GPIO_DATA);
      ul_data = (((ul_data & 0x100) >> 6) | ((ul_data & 0x60) >> 5));
      PayLoad[1] = (uint16)(ul_data << 12);
      //XDSLRTFW-3365 (End)

      /*
       ** ROM Code Version Number
       ** (Get info from header file)
       */
      PayLoad[3] = (VER_ROM_PRODUCT << 8) | VER_ROM_FEATURE;
      PayLoad[2] = (VER_ROM_MAINTENANCE << 8) | VER_ROM_DEBUG;

      /*
       ** Firmware Version Number
       ** (Get info from header file)
       */
      //XDSLRTFW-3364 (Start)
      ul_TempValue = ((VERSION_PLATFORM & 0xFF) << 8);
      ul_TempValue = ((ul_TempValue | (VERSION_FEATURE & 0xFF)) << 4);
      ul_TempValue = ((ul_TempValue | (VERSION_MAJOR & 0xF)) << 4);
      ul_TempValue = ((ul_TempValue | (VERSION_MINOR & 0xF)) << 2);
      ul_TempValue = ((ul_TempValue | (VERSION_REL_STATUS & 0x3)) << 6);
      ul_TempValue |= (VERSION_APP_NUM & 0x3F);
      //XDSLRTFW-3364 (End)

      PayLoad[4] = ul_TempValue;
      PayLoad[5] = ul_TempValue >> 16;

      /* Change PayLoadSize for resonse message */
      *us_PayLoadSize = PAYLOAD_SIZE_VERSION_INFO;
   }
   else
   {
      uc_MsgExecuted = CMV_WRONG_PARAMETER;
   }

   return uc_MsgExecuted;
}



