/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "xTC_CmvDefinitions.h"
** CCASE_DATE = "Fri May 12 11:01:23 2006"
**
** =============================================================================
**
** Project:    <project/component name>
** Block:      <block/module name>
**
** =============================================================================
**
** Contents:   Definitions for CMV Messages (e.g. Opcodes)
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date         Author        Comment
** 2005-04-20   Wehmann       Creation
** =============================================================================
Additional version control information
********************************************************************************
 CCASE_USER    = "Kumar"
 CCASE_VERSION = "\main\dev_hh_2\xtc_codeswap\dmtscope_20060301\4"
***C*E*************************************************************************/


#ifndef XTC_CMV_DEFINITIONS_H  /* protect */
#define XTC_CMV_DEFINITIONS_H

/*
** =============================================================================
**                           DEFINITIONS
** =============================================================================
*/
/*
** Definitions for header manipulation
*/
#define CLEAN_PAYLOADSIZE_IN_HEADER    0xFC00
#define HMP_WORD0_BITSIZE_SHIFT        14

/*
** Definitions of Mailboxcodes
*/
#define MAILBOX_CODE_NTFC              0x01
#define MAILBOX_CODE_EVENT             0x02
#define MAILBOX_CODE_ALARM             0x04
#define MAILBOX_CODE_DEBUG             0x08

/*
** Definition of local xTC codes for Function/Direction Opcodes
*/
/* Command processed without errors */
#define RC_POSITIVE                    0
#define CMV_WITHOUT_ERRORS             RC_POSITIVE
#define CMV_SLOW_MSG_ACKN              RC_POSITIVE

/* Something went wrong */
#define RC_NEGATIVE                    1
#define CMV_ERR_DURING_EXEC            RC_NEGATIVE

/* Command not allowed */
#define RC_DENIED                      2

/* Parameter out of range */
#define RC_PARAM_RANGE                 3

/* Parameter not allowed for current configuration */
#define RC_PARAM_CONFIG                4
#define CMV_WRONG_PARAMETER            RC_PARAM_CONFIG

/* Invalid payload length */
#define RC_PAYLOAD_LEN                 5
#define CMV_WRONG_PAYLOAD_SIZE         RC_PAYLOAD_LEN

/* Resource occupied */
#define RC_RES_OCC                     6

/* FW exception occured */
#define RC_FW_ERROR                    7

/* Bitsize of CMV command or unknown Msg(ID) is not allowed */
#define UNALLOWED_BITSIZE              8
#define CMV_UNALLOWED_BITSIZE          UNALLOWED_BITSIZE
#define UNKNOWN_MESSAGE_ID             UNALLOWED_BITSIZE
#define CMV_MSG_ID_UNKNOWN             UNALLOWED_BITSIZE
#define CMV_UNKNOWN                    UNALLOWED_BITSIZE

/* MDIO address error */
#define MDIO_WRONG_PHY_ADDRESS         9
#define MDIO_MMD_NON_EXISTENT          MDIO_WRONG_PHY_ADDRESS
#define MDIO_WRONG_MMD_ADDRESS         MDIO_WRONG_PHY_ADDRESS
#define MDIO_WRONG_REG_ADDRESS         MDIO_WRONG_PHY_ADDRESS

/* MDIO adress is read only */
#define MDIO_ADDRESS_READ_ONLY         10

/* Function code is wrong */
#define CMV_WRONG_FCT_OPCODE           11

/* The Background queue is full */
#define CMV_BKGD_TASK_WAITING          12

/* Debug Visibility Port is running */
#define CMV_DVP_RUNNING                13

/* Debug Visibility Port is stopped */
#define CMV_DVP_STOPPED                14

/* Waiting for message execution of xPTC MessageHandler in background  */
#define RC_PENDING                    20


/*
** Additional Function/Direction Opcode definitions
** (Corresponding to definitions in Headerfile nmp.h)
** !!!! Attention. Do not define a opcode twice !!!!
*/
#define D2H_ERROR_BKGD_TASK_WAITING    0xE1 /* 1110 0001b */
#define D2H_ERROR_GENERAL_FAILURE      0xE2 /* 1110 0010b */
#define D2H_ERROR_CMD_NOT_ALLOWED      0xE3 /* 1110 0011b */
#define D2H_ERROR_PARAMETER_WRONG      0xE4 /* 1110 0100b */
#define D2H_ERROR_RESOURCE_OCCUPIED    0xE5 /* 1110 0101b */
#define D2H_DBG_VISP_RUNNING           0xE6 /* 1110 0110b */
#define D2H_DBG_VISP_STOPPED           0xE7 /* 1110 0111b */



/*
** Definition of supported messages (MsgID: Firmware/Host)
*/
/**** INFO ****/
#define CMD_VERSION_INFO_GET                 0x0010


/**** CONFIG ****/
#define CMD_MDIO_EFM_PHY_ACCESS              0x0011 /* 0x0051 */
#define CMD_LINK_CONTROL                     0x0111 /* 0x0151 */
#define CMD_UTOPIA_L2_INIT                   0x0211 /* 0x0251 */
#define CMD_UTOPIA_L2_MODIFY                 0x0311 /* 0x0351 */
#define CMD_POSPHY_L2_INIT                   0x0411 /* 0x0451 */
#define CMD_POSPHY_L2_MODIFY                 0x0511 /* 0x0551 */
#define CMD_FLOW_MODIFY                      0x0611 /* 0x0651 */
#define CMD_SYSTEM_IF_LOOP_CONTROL           0x0711 /* 0x0751 */
#define CMD_MDIO_EXTERNAL_PHY_ACCESS         0x0811 /* 0x0851 */
#define CMD_SEGMENTATION_REASSEMBLY_CONFIG   0x0A11 /* 0x0A51 */
#define CMD_SEGMENTATION_VCC_CONFIG          0x0B11 /* 0x0B51 */
#define CMD_SEGMENTATION_CLASSFILTER_CONFIG  0x0C11 /* 0x0C51 */
#define CMD_REASSEMBLY_CLASSFILTER_CONFIG    0x0D11 /* 0x0D51 */
#define CMD_AAL5_VCC_MAPPING_GET             0x0E11
#define CMD_HW_CONFIG_SET                    0x1011 /* 0x1051 */
#define CMD_DEVICE_RESET                     0x1111 /* 0x1151 */
#define CMD_LED_CONTROL                      0x1211 /* 0x1251 */
#define CMD_MAC_CONFIG_MODIFY                0x1311 /* 0x1351 */
#define CMD_MAC_CONFIG_GET                   0x1411
#define CMD_PHY_ADDRESS_SET                  0x1511 /* 0x1551 */
#define CMD_MAC_FRAME_CONFIGURE              0x1611 /* 0x1651 */
#define CMD_DATAPATH_FAILURES_ALARM_CONFIG   0x2011 /* 0x2051 */
#define CMD_ETHERNET_OAM_CONTROL             0x4011 /* 0x4051 */
#define CMD_ETHERNET_OAM_CONFIG              0x4111 /* 0x4151 */
#define CMD_ETHERNET_OAMPDU_REQUEST          0x4211 /* 0x4251 */
#define CMD_ETHERNET_EXTRACT_CONFIG          0x4311 /* 0x4351 */
#define CMD_ETHERNET_INSERT_EXTRACT_CONTROL  0x4411 /* 0x4451 */
#define CMD_ETHERNET_FRAME_INSERT_LINE       0x4511 /* 0x4551 */
#define CMD_ETHERNET_FRAME_INSERT_SYSTEM     0x4611 /* 0x4651 */
#define EVT_ETHERNET_FRAME_LINE_EXTRACT      0x4711
#define EVT_ETHERNET_FRAME_SYSTEM_EXTRACT    0x4811
#define CMD_ATM_INSERT_EXTRACT_CONTROL       0x5011 /* 0x5051 */
#define CMD_ATM_LINE_INSERT                  0x5111 /* 0x5151 */
#define EVT_ATM_CELL_LINE_EXTRACT            0x5211
#ifdef ADSL_IFX   // Start ADSL
#define CMD_DBG_TC_LAYER_LOOP_CONTROL        0x0133 /* 0x0173 */
#else             // End ADSL, start VDSL
#define CMD_TC_LAYER_LOOP_CONTROL            0x0911 /* 0x0951 */
#endif            // End VDSL


/**** MANAGEMENT ****/


/**** MAINTENANCE ****/
#define CMD_CLAUSE30_LINE_STATS_GET          0x0113
#define CMD_CLAUSE30_SYSTEM_STATS_GET        0x0213
#define CMD_AAL5_SEGMENTATION_STATS_GET      0x0313
#define CMD_AAL5_REASSEMBLY_STATS1_GET       0x0413
#define CMD_AAL5_REASSEMBLY_STATS2_GET       0x0513
//#define CMD_RFC2863_STATS_GET                0x0813 /* Future use ->Temp value */
//#define CMD_RFC2665_STATS_GET                0x1013 /* Future use ->Temp value */
//#define CMD_RFC1213_STATS_GET                0x1813 /* Future use ->Temp value */
//#define CMD_RFC2819_STATS_GET                0x2013 /* Future use ->Temp value */
#define CMD_DATAPATH_FAILURES_GET            0x2013
#define ALM_DATAPATH_FAILURES_GET            0x2013
#define CMD_CL45_STATS_GET                   0x3013
#define CMD_G997_PTM_STATS_THRESH_SET        0x3213 /* 0x3253 */
#define CMD_G997_PTM_STATS_GET               0x3313
#define CMD_MISC_PTM_STATS_GET               0x3413
#define CMD_G997_ATM_STATS_GET               0x3513
#define CMD_G997_ATM_STATS_THRESH_SET        0x3613 /* 0x3653 */
#define CMD_G997_ATM_STATS_THRESH_GET        0x3713
#define CMD_G997_ATM_STATS_SET               0x3813 /* 0x3853 */
#define CMD_G997_PTM_STATS_SET               0x3913 /* 0x3953 */
#define ALM_ATM_CELL_EXTRACT_FAILED          0x5311
#define CMD_ATM_INSERT_EXTRACT_STATS_GET     0x5411
#define CMD_ATM_LINE_INSERT_STATS_GET        0x5511


/**** HOSTLESS ****/
#define CMD_FLASH_ACTIVE_FILE_SWAP           0x0115 /* 0x0155 */
#define CMD_IP_ADDRESS_SET                   0x0215 /* 0x0255 */ /* Future use ->Temp value */
#define CMD_FW_UPDATE_WAN_CONFIG             0x0315 /* 0x0355 */ /* Future use ->Temp value */
#define CMD_FW_UPDATE_LAN_CONFIG             0x0415 /* 0x0455 */ /* Future use ->Temp value */
#define CMD_INBAND_FW_API_CONFIG             0x0515 /* 0x0555 */ /* Future use ->Temp value */
#define CMD_PAUSE_CONFIG                     0x0615 /* 0x0655 */ /* Future use ->Temp value */

/**** DEBUG ****/
#ifdef ADSL_IFX   // Only ADSL
#define CMD_DBG_TC_LAYER_LOOP_CONTROL        0x0133 /* 0x0173 */
#endif            // End only ADSL
#define CMD_DBG_TC_BLOCK_SELECT              0x0433 /* 0x0473 */

#define CMD_DBG_COUNTER_BLOCK_READ           0x1033

#define CMD_DBG_VIS_MUX_CONFIGURE            0x4033 /* 0x4073 */
#define CMD_DBG_VIS_DATA_FORMAT_SET          0x4133 /* 0x4173 */
#define CMD_DBG_VIS_DUMMY_VAL_SET            0x4233 /* 0x4273 */
#define CMD_DBG_VIS_CORE_START               0x4333 /* 0x4373 */
#define CMD_DBG_VIS_DSP_START                0x4433 /* 0x4473 */
#define CMD_DBG_VIS_STOP                     0x4533 /* 0x4573 */

#define CMD_DBG_MEM_MAP_READ                 0xA033
#define CMD_DBG_MEM_MAP_WRITE                0xA133 /* 0xA173 */
#define CMD_DBG_AUX_REG_READ                 0xA233
#define CMD_DBG_AUX_REG_WRITE                0xA333 /* 0xA373 */
#define CMD_DBG_READ_VDSL_AFE                0xA433
#define CMD_DBG_WRITE_VDSL_AFE               0xA533 /* 0xA573 */

#define CMD_DBG_ERROR_GEN_TIME_RX_SET        0xB133 /* 0xB173 */
#define CMD_DBG_UTOPIA_WATCHDOG_CONTROL      0xB233 /* 0xB273 */

#ifdef IFX_REV2
  #define CMD_DBG_ARC_MAILBOX_LOOPBACK         0xC033 /* 0xC073 */
  #define CMD_DBG_XPTC_MESSAGE_TUNNEL          0xC133 /* 0xC173 */
#endif

/* TEST */
#define CMD_TEST_AFE_LOOP_CONTROL            0x0116 /* 0x0156 */
#define CMD_TEST_CARRIER_MASKING_TX_SET      0x0216 /* 0x0256 */
#define CMD_TEST_RX_PSD_CALIBRATE            0x0316 /* 0x0356 */
#define CMD_TEST_RX_PSD_MEASURE_MODE_SET     0x0416 /* 0x0456 */
#define CMD_TEST_RX_GAIN_CONTROL             0x0516 /* 0x0556 */
#define CMD_TEST_SRAM_TEST                   0x0616 // sram test feature
#define CMD_DBG_HW_WATCHDOG_CONTROL          0xB333 /* 0xB373 */

/*
** Groupfield definitions
*/
#define TC_INFO      0x10
#define TC_CFG       0x11
#define TC_MGNT      0x12
#define TC_MTNC      0x13
#define TC_HOSTLESS  0x15
#define TC_TEST      0x16
//#define TC_NTFC      0x21 /* Now defined inside the MailboxCode */
//#define TC_ALARM     0x22 /* Now defined inside the MailboxCode */
#define TC_DBG       0x33
#define TC_LAST      TC_DBG



/*
** =============================================================================
**                           TYPES
** =============================================================================
*/

#endif /* protect */

