/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VRX_AfeCommonConst_H
#define _VRX_AfeCommonConst_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: VRX_AfeCommonConst.h
;
;  This file contains constants used by VR9 AFE related files.
;
*****************************************************************************/

#ifndef FALSE
#define FALSE           0
#endif
#ifndef TRUE
#define TRUE            1
#endif

//Line Driver modes
//Low Noise Mode from LD_VL_ADSL to LD_VH_ADSL
//High Speed Mode from LD_VL_VDSL to LD_VH_VDSL
#define  LD_PDN            (0)
#define  LD_VL_ADSL        (1)
#define  LD_L_ADSL         (2)
#define  LD_M_ADSL         (3)
#define  LD_H_ADSL         (4)
#define  LD_VH_ADSL        (5)
#define  LD_VL_VDSL        (6)
#define  LD_L_VDSL         (7)
#define  LD_M_VDSL         (8)
#define  LD_H_VDSL         (9)
#define  LD_VH_VDSL        (10)

#define  SIZE_LD_CTL_DOUT  (22)

//Valid Modes are from (LD_PDN ==> 0) to (LD_VH_VDSL == > 10) as per #define
//Invalid mode is declared only if LD_CTL & LD_DOUT is not met the spec
//as defined in the VR9_LineDriver.doc.
#define  LD_MODE_INVALID      (0xFFFF)




// The below defines are combined ADSL and VDSL modes
// If these defines are updated, then we need to update in ADSL branch also.
//VDSL modes
#define  VDSL_30                          (0)
#define  VDSL_17                          (1)
#define  VDSL_12                          (2)
#define  VDSL_5                           (3)
#define  VDSL_8                           (VDSL_5)
#define  ADSL_A                           (4)
#define  ADSL_B                           (5)
#define  VDSL_US0                         (6)
#define  VDSL_35                          (7)
#define  BYPASSED                         (8)
#define  ADSL2_CPE_LL                     (9) //XDSLRTFW-3674 (start_end)

#define VDSL35b_CPE        (VDSL_35)
#define VDSL17_CPE         (VDSL_17)
#define VDSL8_CPE          (VDSL_8)
#define ADSL2_CPE          (ADSL_A)
#define VDSL30_CPE         (VDSL35b_CPE)  // or VDSL_30

#define  VRX_MAX_NUM_ADAP_HYB_SETTINGS    (VRX518_MAX_NUM_ADAP_HYB_SETTINGS)
#define  VRX_HYB_NUM_SETTINGS             (VRX518_HYB_NUM_SETTINGS)
#define  VRX_HYBGAIN_IDX                  (VRX518_HYBGAIN_IDX)  // Hybrid gain value index

#if 0
//gsa_HybGain[] gain offset's
#define HYB_IDX_OFFSET              (0)
#define PGA_REQ_OFFSET              (1)
#define PGA_SET_OFFSET              (2)
#define GAIN1_IDX_OFFSET            (3) //Index to get gain from Programmable array for PGA1
#define GAIN2_IDX_OFFSET            (4) //Index to get gain from Programmable array for PGA2
#define AGC1_ROUT_OFFSET            (5) //Rout register value
#define AGC2_FIXED_GAIN_OFFSET      (6) //AGC2_INPUT Fixed gain register value
#define AGC3_GAIN_OFFSET            (7) //AGC3 gain register value
#define AGC2_MILLERCAP_OFFSET       (8) //Miller capacito value.
#define AGC1_GAIN_SET_OFFSET        (9) //AGC1 gain set
#define AGC2_GAIN_SET_OFFSET        (10) //AGC2 gain set (Var gain)
#define AGC2_FIXED_GAIN_SET_OFFSET  (11)//AGC2 Fixed gain set
#define AGC3_GAIN_SET_OFFSET        (12)//AGC3 gain set
#define AGC1_GL_PA_OFFSET           (13) //gl_Pa_AGC1

#define AGC2_GL_PA_OFFSET           (15) //gl_Pa_AGC2

#define AGC1_GS_AGC2_COMP           (17) //gs_AGC2_compensation for AGC1 computation
#define AGC1_GS_PGA_REQUIRED        (18) //gs_PGA_required for AGC1 computation
#define AGC2_GS_AGC2_COMP           (19) //gs_AGC2_compensation for AGC2 computation
#define AGC2_GS_PGA_REQUIRED        (20) //gs_PGA_required for AGC2 computation
#define AGC1_GS_AGC1_COMP           (21) //gs_AGC1_compensation for AGC1 computation
#else
#define HYB_IDX_OFFSET              (0) // Hyb Idx
#define PGA_REQ_OFFSET              (1) // Total PGA required
#define PGA_SET_OFFSET              (2) // Total PGA set sum of (AGC1+AGC2)
#define AGC1_GS_PGA_REQUIRED        (3) //gs_PGA_required for AGC1 computation
#define AGC1_GAIN_SET_OFFSET        (4) //AGC1 gain set after AGC1 training
#define AGC1_GS_AGC1_COMP           (5) //gs_AGC1_compensation for AGC1 computation
#define AGC1_GS_AGC2_COMP           (6) //gs_AGC2_compensation for AGC1 computation
#define AGC1_DC_OFFSET              (7) // DC offset during AGC1 training
#define AGC1_PGA_MARGIN             (8) // PGA margin used during AGC1 training
#define AGC1_GL_PA_OFFSET           (9) //gl_Pa_AGC1
                                    //(10)
#define AGC2_GS_PGA_REQUIRED        (11) //gs_PGA_required for AGC2 computation
#define AGC2_GAIN_SET_OFFSET        (12) //AGC2 gain set (Var gain) after AGC2 training
#define AGC2_GS_AGC1_COMP           (13) //gs_AGC1_compensation for AGC1 computation
#define AGC2_GS_AGC2_COMP           (14) //gs_AGC2_compensation for AGC2 computation
#define AGC2_DC_OFFSET              (15)    // DC offset during AGC2 training
#define AGC2_PGA_MARGIN             (16) // PGA margin used during AGC2 training
#define AGC2_GL_PA_OFFSET           (17) //gl_Pa_AGC2
                                    //(18)

//#define GAIN1_IDX_OFFSET            (14) //Index to get gain from Programmable array for PGA1
//#define GAIN2_IDX_OFFSET            (15) //Index to get gain from Programmable array for PGA2
//#define AGC1_ROUT_OFFSET            (16) //Rout register value
//#define AGC2_FIXED_GAIN_OFFSET      (17) //AGC2_INPUT Fixed gain register value
//#define AGC3_GAIN_OFFSET            (18) //AGC3 gain register value
//#define AGC2_MILLERCAP_OFFSET       (19) //Miller capacito value.
//#define AGC2_FIXED_GAIN_SET_OFFSET  (20)//AGC2 Fixed gain set
//#define AGC3_GAIN_SET_OFFSET        (21)//AGC3 gain set
#endif

#define  VRX_HYB_AFE_REG_GAINS              (21+1)


#define PGA_DOUBLE_TRN_DONE            (211)

#define EFUSE_TABLE_LEN   (9)
#define EFUSE_OFFSET      (0x200)
#define BAR18_REGISTER_OFFSET    (0x18000)
#endif
