/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VRX_AfeCommonData_H
#define _VRX_AfeCommonData_H
// *********************************************************
// VRX_AfeCommonData.h
//
// This file consists of all the common variables used in
//  VR9, VRx318 and VRx518 platform.
//
//
// *********************************************************
#include "typedef.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

extern uint32 gul_ExceptionCode;
extern int16 gus_AFE_RxMode, gus_AFE_TxMode;
extern uint16 gus_RCtimeConstCNT;
extern uint16 gus_AGC1_RIN1, gus_AGC1_RIN2, gus_AGC1_RINX;
extern uint16 gus_AGC1_SHUNT1, gus_AGC1_SHUNT2, gus_AGC1_SHUNTX;
extern uint16 gus_AGC1_CPROG, gus_AGC2_LP2_CAP;
extern int16  gs_AGC1_Gain_Set; // AGC1 gain
extern int16  gs_AGC2_Gain_Set; // AGC2 gain
extern int16 gs_AGC2_compensation;
extern int16 gs_AGC1_compensation;
extern int16 gs_HybTrIndexDbg;
extern int16 gs_PgaHandlerRun;
extern int16 gs_PGA_Handler_count;
extern int16 gs_ADC_margin;
extern uint16 gus_AfeChipId;
extern int16 gs_HybTableForce;
extern int16 gs_LoadAllPGAGains;
extern int16 gs_AGC1_Margin;
extern uint16 *gusa_InitHybridSettings;
extern uint16 gusa_AfeChipId[];
extern int16 gsa_HybGain[];
extern int32 gla_HybRevRefPwr[];
extern int32 gla_BgHybAccumBuf[];
extern uint16 gusa_RxL2CombinGains[];
//Flags to overwrite the AFE Rx Mode config settings.
//When set to TRUE, the function VR9_ConfigAFERxPath_Forced is called
extern FlagT gft_AFE_TxMode_Overwrite;
//Flags to overwrite the AFE Tx Mode config settings.
//When set to TRUE, the function VR9_ConfigAFETxPath_Forced is called
extern FlagT gft_AFE_RxMode_Overwrite;
extern FlagT gft_HybridTrainEnable;
extern FlagT gft_EnableDoublePGATrain;
extern FlagT gft_PowerUpLink;
extern FlagT gft_AFEPowerBoost;  //XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise(Start_End)
extern FlagT gft_Bin_ADSL_VDSL;
// XDSLRTFW-178 (Start_End)
extern FlagT gft_NoVDSLIndication;
extern uint8 guc_TxModeConfigured;
extern uint8 guc_RxModeConfigured;
extern FlagT gft_ADCOverflowed;
extern FlagT gft_IsBTorLLoop;
extern uint8 guc_DoublePgaHandlerState;
extern uint8 guc_HybTable;


#endif
