/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2005 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;The software is owned by Aware, Inc. and is protected by United States
;;;copyright laws and international treaty provisions. Therefore, you must treat
;;;the software like any other copyrighted material.  You may not use or copy
;;;the software or any accompanying written materials for any other purpose than
;;;what is described in the Development and License Agreement
;;;entered into with Aware Inc. (the "Agreement").  Except as
;;;expressly provided in the Agreement, Aware does not grant any express or
;;;implied rights to you to or under Aware or any third party patents, copyrights,
;;;trademarks, or trade secret information.  Additionally, you shall reproduce
;;;and apply any copyright or other proprietary rights notices included on or
;;;embedded in the software to any copies or derivative works made thereof, in
;;;whole or in part, in any form.  These rights are provided for information
;;;clarification, other restrictions of rights may apply as well.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Description : AAI Loopback test using UTOPIA port
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;*/


//###############################3
// This file contains 3 tests:
// - Test_Danube_MTE_RAM   #7
// - Test_Danube_FCI_RAM   #8
// - Test_Danube_IFFT         #10


#ifdef AMAZON_SE

#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "gdata.h"
#include "cmv.h"

#define BIG_TIMEOUT (3200)
#define WaitingForTX (1)
#define WaitingForRX (2)
#define NUMBER_CONFIGURATIONS 3  /* Number of test cases to be run. */
#define SCALEBACK 0x006A         /* alternating scalebacks */
#define OVERFLOW 0               /* we don't want overflows */

int16 gs_error_count;
int16 gs_rtv_seg;
int16 gsa_buffer2[64];

int16 Test_Danube_MTE_RAM(void);
int16 Test_Danube_FCI_RAM(void);

//We can put this test in either page. Look at static functions below
//int16 Test_Danube_Loopback(void);
int16 ReadCompareReg(uint16 addr, uint16 mask, int16 expect);
int16 ReadCompareReg32(uint16 us_BaseAddr, uint16 us_Offset, uint32 mask, int32 ul_ExpectedData);

int16 Test_Danube_IFFT(void);
int16 Test_RTV(void);
void set_and_run_IFFT(int16 in_place_buffer,int16 fft_size);
void CheckResults(int16 in_place_buffer, int16 fft_size);

#define MAX_16 0x7fff
#define MIN_16 0x8000
#define MAX_32  0x7fffffff
#define MIN_32  0x80000000


#define ENCGAINMANTISSA1         0x2000
#define ENCGAINMANTISSA2         8192
#define ENCGAINMANTISSA3         9459
#define ENCGAINMANTISSA4         7327
#define ENCGAINMANTISSA5         10362
#define ENCGAINMANTISSA6         7151
#define ENCGAINMANTISSA7         10235
#define ENCGAINMANTISSA8         7108
#define ENCGAINMANTISSA9         10204
#define ENCGAINMANTISSA10           7098
#define ENCGAINMANTISSA11           10196
#define ENCGAINMANTISSA12           7095
#define ENCGAINMANTISSA13           10194
#define ENCGAINMANTISSA14           7095
#define ENCGAINMANTISSA15        10194

/* QAM Decoder constellation gains for bit-sizes 2-15. Format is [S 2.13].  */

#define DECGAINMANTISSA1               (0x2000)
#define DECGAINMANTISSA2               (0x2000)
#define DECGAINMANTISSA3               (0x376d)
#define DECGAINMANTISSA4               (0x23c7)
#define DECGAINMANTISSA5               (0x3299)
#define DECGAINMANTISSA6               (0x24a9)
#define DECGAINMANTISSA7               (0x333a)
#define DECGAINMANTISSA8               (0x24e1)
#define DECGAINMANTISSA9               (0x3362)
#define DECGAINMANTISSA10                 (0x24ef)
#define DECGAINMANTISSA11                 (0x336b)
#define DECGAINMANTISSA12                 (0x24f2)
#define DECGAINMANTISSA13                 (0x336e)
#define DECGAINMANTISSA14                 (0x24f3)
#define DECGAINMANTISSA15                 (0x336f)



/***********************************************************
*  Global Variables
***********************************************************/

int32 gl_error_location;
/************************************************************************/
/* Danube Asim Iridia Ram Test
 ; Description: The function tests Iridia RAM block for arc simulator.
 ; Prototype:
 ;    int16 Test_Danube_MTE_RAM(void)
 ;
 ; Input Arguments:
 ;    none
 ;
 ; Return Value:
 ;    int16
 ;
/************************************************************************/

int16 Test_Danube_MTE_RAM(void) {

   #define MTE_RAM_COUNT_16BITS 13
    #define MTE_RAM_COUNT_32BITS 11 //RTV in, Buffers C out


   int16 ram_addr_16bits[MTE_RAM_COUNT_16BITS] = {

   IRI_RAM_TX_GAINSCALE_ADDR,
   IRI_RAM_TX_BITALLOC_ADDR,
   IRI_RAM_TX_TONEREORDER_ADDR,

   IRI_RAM_RX_GAINSCALE_ADDR,
   IRI_RAM_RX_BITALLOC_ADDR,
   IRI_RAM_RX_TONEREORDER_ADDR,

   IRI_RAM_RX_SURVIVOR_PATH_ADDR,

   IRI_RAM_TX_GAINSCALE_PING_PONG_ADDR,
   IRI_RAM_TX_BITALLOC_PING_PONG_ADDR,
   IRI_RAM_TX_TONEREORDER_PING_PONG_ADDR,

   IRI_RAM_RX_GAINSCALE_PING_PONG_ADDR,
   IRI_RAM_RX_BITALLOC_PING_PONG_ADDR,
   IRI_RAM_RX_TONEREORDER_PING_PONG_ADDR
};

   static int16 ram_size_16bits[MTE_RAM_COUNT_16BITS] = {

      (int16) IRI_RAM_TX_GAINSCALE_SIZE,
      (int16) IRI_RAM_TX_BITALLOC_SIZE,
      (int16) IRI_RAM_TX_TONEREORDER_SIZE,

      (int16) IRI_RAM_RX_GAINSCALE_SIZE,
      (int16) IRI_RAM_RX_BITALLOC_SIZE,
      (int16) IRI_RAM_RX_TONEREORDER_SIZE,

      //(int16) IRI_RAM_RX_SURVIVOR_PATH_SIZE,
      (int16) 0x014,

      (int16) IRI_RAM_TX_GAINSCALE_PING_PONG_SIZE,
      (int16) IRI_RAM_TX_BITALLOC_PING_PONG_SIZE,
      (int16) IRI_RAM_TX_TONEREORDER_PING_PONG_SIZE,

      (int16) IRI_RAM_RX_GAINSCALE_PING_PONG_SIZE,
      (int16) IRI_RAM_RX_BITALLOC_PING_PONG_SIZE,
      (int16) IRI_RAM_RX_TONEREORDER_PING_PONG_SIZE

};

   uint16 ram_mask_16bits[MTE_RAM_COUNT_16BITS] = {

   (uint16) 0xFFFF,     // Tx Gain Scale
   (uint16) 0x000F,     // Tx BAT
   (uint16) 0x003F,     // Tx TRT

   (uint16) 0xFFFF,     // Rx Gain Scale
   (uint16) 0x000F,     // Rx BAT
   (uint16) 0x00FF,     // Rx TRT

   (uint16) 0xFFFF,     // Survivor

   (uint16) 0xFFFF,     // Tx Gain Scale Ping-pong
   (uint16) 0x000F,     // Tx BAT Ping-pong
   (uint16) 0x003F,     // Tx TRT Ping-pong

   (uint16) 0xFFFF,     // Rx Gain Scale Ping-pong
   (uint16) 0x000F,     // Rx BAT Ping-pong
   (uint16) 0x00FF         // Rx TRT Ping-pong

};

   uint16 ram_addr_32bits[MTE_RAM_COUNT_32BITS] = {
   IRI_RAM_TX_IFFT_A0_ADDR,
   IRI_RAM_TX_IFFT_B0_ADDR,

   IRI_RAM_RX_FFT_A0_ADDR,
   IRI_RAM_RX_FFT_B0_ADDR,

   IRI_RAM_RX_CYCLICPREFIX_A0_ADDR,
   IRI_RAM_RX_CYCLICPREFIX_B0_ADDR,

   IRI_RAM_RX_FDQ_MANTISSA_ADDR,
   IRI_RAM_RX_FDQ_EXPONENT_ADDR,
   IRI_RAM_RX_REVERB_SEGUE_DETECT_ENABLE_ADDR,

#ifdef AMZSE_DANUBE
   IRI_RAM_RX_FFT_C0_ADDR,
   IRI_RAM_RX_CYCLICPREFIX_C0_ADDR
#else
   IRI_RAM_RX_RTV0_ADDR,
      IRI_RAM_RX_RTV1_ADDR
#endif


};

   int16 ram_size_32bits[MTE_RAM_COUNT_32BITS] = {

      (int16) IRI_RAM_TX_IFFT_A0_SIZE,
      (int16) IRI_RAM_TX_IFFT_B0_SIZE,

      (int16) IRI_RAM_RX_FFT_A0_SIZE,
      (int16) IRI_RAM_RX_FFT_B0_SIZE,

      (int16) IRI_RAM_RX_CYCLICPREFIX_A0_SIZE,
      (int16) IRI_RAM_RX_CYCLICPREFIX_B0_SIZE,

      (int16) IRI_RAM_RX_FDQ_MANTISSA_SIZE,
      (int16) IRI_RAM_RX_FDQ_EXPONENT_SIZE,
      (int16) IRI_RAM_RX_REVERB_SEGUE_DETECT_ENABLE_SIZE,

#ifdef AMZSE_DANUBE
      (int16) IRI_RAM_RX_FFT_C0_SIZE,
      (int16) IRI_RAM_RX_CYCLICPREFIX_C0_SIZE
#else
      (int16) IRI_RAM_RTV_0_SIZE,
      (int16) IRI_RAM_RTV_1_SIZE
#endif

};

   uint32 ram_mask_32bits[MTE_RAM_COUNT_32BITS] = {
   (uint32) 0xFFFFFFFF,    // IFFT Bank A
   (uint32) 0xFFFFFFFF,    // IFFT Bank B

   (uint32) 0xFFFFFFFF,    // FFT Bank A
   (uint32) 0xFFFFFFFF,    // FFT Bank B

   (uint32) 0xFFFFFFFF,    // Cyclic Prefix Bank A
   (uint32) 0xFFFFFFFF,    // Cyclic Prefix Bank B

   (uint32) 0x3FFF3FFF,    // FDQ Mantissa
   (uint32) 0x0F0F0F0F,    // FDQ Exponent
   (uint32) 0x01010101,       // Reverb-Segue Detect Enable

#ifdef AMZSE_DANUBE  // Redundant code, left for clarity.
   (uint32) 0xFFFFFFFF,    // FFT Bank C
   (uint32) 0xFFFFFFFF     // Cyclic Prefix Bank C
#else
   (uint32) 0xFFFFFFFF,    // RTV 0
   (uint32) 0xFFFFFFFF        // RTV 1
#endif

};

   int16 i,j,us_version;
   int16 test_data = 0, test_data_inv=0;
   uint16 us_success = 0, us_temp_zep=0, us_temp_iri=0;
   uint32 ul_Data=0;
   uint32 ul_index;

   gs_error_count=0;
   gl_error_location=0;

   /* ==================================================================== */
   /* Run Test */
   /* ==================================================================== */
    //Read Version Register
    ReadCoreReg((int16)IRI_REG_IVERSION_ADDR, (uint16 *)&us_version);
#ifdef AMZSE_DANUBE
   if (us_version!=0x23) gs_error_count++;
#else
   if (us_version!=0x24) gs_error_count++;
#endif

   //--------------  Begin Test for 16 bit buffers ------------------------
   // Write incrementing data to the RAMs.  Write the RAMs from bottom to top
   for (i = 0; i < MTE_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         WriteCoreReg((int16) (ram_addr_16bits[i] + j),++test_data);
         // YC Feb 01, 2006 WriteCoreBuf and ReadCoreBuf are 16-bit addressing
         // However, the write_memory() and read_memory() interpret as
         // 32-bit addressing. Should revisit.
         //++test_data;
         //WriteCoreBuf((int16)(ram_addr_16bits[i] + j), &test_data, 1,1);
         }
   }

   // Read back the data that was written.   Read the RAMs from top to bottom.
   // Invert the data in each location after it is read.
   for (i = (MTE_RAM_COUNT_16BITS - 1); i >= 0; i--) {
      for (j = (ram_size_16bits[i] - 1); j >= 0; j--) {
         us_success=ReadCompareReg((uint16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], test_data);
         WriteCoreReg((int16) (ram_addr_16bits[i] + j), (~test_data));
         //test_data_inv=~test_data;
         //WriteCoreBuf((int16)(ram_addr_16bits[i] + j), &test_data_inv, 1,1);
         test_data--;
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << i));
         }
      }
   }

   // Verify the inverse data that was written
   for (i = 0; i < MTE_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         test_data++;
         us_success=ReadCompareReg((uint16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], (int16) (~test_data));
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << i));
         }
      }
   }


   //--------------  Begin Test for 32 bit buffers ------------------------
   // Write incrementing data to the RAMs.  Write the RAMs from bottom to top
   test_data = 0;
   for (i = 0; i < MTE_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = (uint32) (((uint32) (test_data + 1) << 16) + (uint32) test_data);
         ul_Data &= (uint32) ram_mask_32bits[i];
         //WriteCoreBuf32((uint16) (ram_addr_32bits[i]+ j), (int16 *) &ul_Data, 1);
            WriteCoreReg32((uint16) (ram_addr_32bits[i]+ j), ul_Data);
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         test_data += 2;
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << (i+16)));
         }
      }
   }

   test_data -= 2;
   for (i = (MTE_RAM_COUNT_32BITS - 1); i >= 0; i--) {
      for (j = (ram_size_32bits[i] - 1); j >= 0; j--) {
         ul_Data = (((uint32) (test_data + 1) << 16) + (uint32) test_data);
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         ul_Data = (((uint32) ~(test_data + 1) << 16) + (uint32) (~test_data));
         // YC Feb 01, 2006 WriteCoreBuf32 and ReadCoreBuf32 are DMAs, which havent
         // been implemented yet.
         //WriteCoreBuf32((uint16) (ram_addr_32bits[i]+ j),(int16 *) &ul_Data, 1);
         WriteCoreReg32((uint16) (ram_addr_32bits[i]+ j),ul_Data);
         test_data -= 2;
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << (i+16)));
         }
      }
   }

   test_data += 2;
   for (i = 0; i < MTE_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = (((uint32) ~(test_data+1) << 16) + (uint32) (~test_data));
         test_data += 2;
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << (i+16)));
         }
      }
   }

   // End of Tests
   if (gs_error_count==0) {
      return(SUCCEED);
   }
   else {
      return(FAIL);
   }

}
/****************************************************************/

int16 Test_Danube_FCI_RAM(void)
{

#ifdef AMZSE_DANUBE
#define FCI_RAM_COUNT_16BITS  6
#else
#define FCI_RAM_COUNT_16BITS  4  //SE
#endif

#define FCI_RAM_COUNT_32BITS  2

int16 ram_addr_16bits[FCI_RAM_COUNT_16BITS] = {
   (int16)ZEP_RAM_TX_FRAMEBUFFER_ADDR,
   (int16)ZEP_RAM_RX_FRAMEBUFFER_ADDR,
   (int16)ZEP_RAM_RX_LP0_CW_BUF_ADDR,
#ifdef AMZSE_DANUBE
   (int16)ZEP_RAM_RX_LP1_CW_BUF_ADDR,
   (int16)ZEP_RAM_RX_METRIC_FIFO_BUF_ADDR,
    (int16)ZEP_RAM_RX_DEBUG_NW_COEFF_BUF_ADDR
#else
   (int16)ZEP_RAM_RX_LP1_CW_BUF_ADDR
#endif

};

int16 ram_size_16bits[FCI_RAM_COUNT_16BITS] = {
   (int16) 0x100,
   (int16) 0x200,
   (int16) 0x80,
#ifdef AMZSE_DANUBE
   (int16) 0x80,
   (int16) 0x200,
   (int16)  0x80
#else
   (int16)  0x80 //SE
#endif

};

int16 ram_mask_16bits[FCI_RAM_COUNT_16BITS] = {
   (int16) 0xff,
   (int16) 0xff,
   (int16) 0xffff,
#ifdef AMZSE_DANUBE
   (int16) 0xffff,
   (int16) 0xff,
    (int16) 0xffff
#else
   (int16) 0xffff
#endif


};

int16 ram_addr_32bits[FCI_RAM_COUNT_32BITS] = {
    (int16)ZEP_RAM_TX_INTERLV_BUF_ADDR,
   (int16)ZEP_RAM_RX_INTERLV_BUF_ADDR
};

int16 ram_size_32bits[FCI_RAM_COUNT_32BITS] = {
#ifdef AMZSE_DANUBE
   (int16) 1248,
#else
   (int16) 988,
#endif
   (int16) 5120
};

int32 ram_mask_32bits[FCI_RAM_COUNT_32BITS] = {
   (int32) 0xFFFFFFFF,
   (int32) 0xFFFFFFFF
};

   int16 i,j, us_version;
   int16 test_data = 0, test_data_inv=0;
   uint16 us_success = 0;
   int32 ul_Data;

    gs_error_count = 0;
   gl_error_location = 0;
   /* Write incrementing data to the RAMs
      Write the RAMs from bottom to top
   */
     ReadCoreReg((int16)ZEP_REG_VERSION_ADDR, (uint16 *)&us_version);
#ifdef AMZSE_DANUBE
   if (us_version!=0x34) gs_error_count++;
#else
   if (us_version!=0x35) gs_error_count++;
#endif

   for (i = 0; i < FCI_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         WriteCoreReg((int16) (ram_addr_16bits[i] + j), ++test_data);
      }
   }

   // Read back the data that was written. Read the RAMs from top to bottom.
   // Invert the data in each location  after it is read.
   for (i = (FCI_RAM_COUNT_16BITS - 1); i >= 0; i--) {
      for (j = (ram_size_16bits[i] - 1); j >= 0; j--) {
         us_success=ReadCompareReg((int16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], test_data);
         WriteCoreReg((int16) (ram_addr_16bits[i] + j),(int16) (~test_data));
         test_data--;
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << i));
         }
      }
   }

   /* Verify the inverse data that was written */

   for (i = 0; i < FCI_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         test_data++;
         us_success=ReadCompareReg((int16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], (int16) (~test_data));
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << i));
         }
      }
   }

   /*  Now test the 32-bit memory locations in the zephyr core. */

   test_data = 1;
   for (i = 0; i < FCI_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = ((uint32) (test_data + 1) << 16) + (uint32) test_data;
         test_data += 2;
         WriteCoreReg32((uint16) (ram_addr_32bits[i]+j), ul_Data);
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << (i+8)));
         }
      }
   }

   test_data -= 2;
   for (i = (FCI_RAM_COUNT_32BITS - 1); i >= 0; i--) {
      for (j = (ram_size_32bits[i] - 1); j >= 0; j--) {

         ul_Data = ((uint32) (test_data + 1) << 16) + (uint32) test_data;
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);

         ul_Data = ((uint32) ~(test_data+1) << 16) + (uint32) (~test_data);
         WriteCoreReg32((uint16)(ram_addr_32bits[i]+j), ul_Data);

         test_data -= 2;
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << (i+8)));
         }
      }
   }

   test_data += 2;
   for (i = 0; i < FCI_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = ((uint32) ~(test_data+1) << 16) + (uint32) (~test_data);
         test_data += 2;
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         if (us_success==0)
         {
            gs_error_count++;
            gl_error_location |= ((int32)(1 << (i+8)));
         }
      }
   }

   /* =============================================== */
   /* End of Tests                              */
   /* =============================================== */
   if (gs_error_count==0) {
      return(SUCCEED);
   }
   else {
      return(FAIL);
   }

}





/*************************************************************************/

void set_and_run_IFFT(int16 in_place_buffer,int16 fft_size)
{

   int16 us_data, i;
   int16 us_PhysAddr;
   int32 ul_data=0;

   /*
   int32 ifft_random_input1[32]={
   0x0000FCCE, 0x00C60331, 0x031403AB, 0xFC1EFF42, 0x02E8FD1C, 0xFDF6FC5D, 0xFC42FD50, 0xFDC2FC23,
   0xFE48FEBF, 0x006EFEDC, 0xFEFAFED8, 0x0348FFBA, 0xFF69FE6E, 0x03CE0274, 0x03EEFE0D, 0x039DFC6D,
   0x01A40288, 0x03C8FFBB, 0xFE670200, 0xFED00235, 0xFC98FD96, 0xFC83FEDE, 0xFFE50017, 0xFEFD03E3,
   0xFC53FDD9, 0xFC0A0369, 0xFCCDFE0E, 0x02350170, 0x027901CB, 0xFCAEFD0F, 0x020D0103, 0xFD64FF3D};
    */

   /**************************************/
   /* set all Tx blocks to register mode */
   /**************************************/
   us_data = 0;
   us_data |= IRI_PRE_IFFT_START_SELECT;     // Register start.
   us_data |= IRI_QAM_ENCODE_START_SELECT;      // Register start.
   us_data |= 0x40;                    // Disable Buffer Swap on frame

   WriteCoreReg(IRI_REG_IT_MODE_ADDR, us_data);
   WriteCoreReg(IRI_REG_IT_AMODE_ADDR, us_data);

   /********************/
   /* select IFFT size */
   /********************/

   if(fft_size == 64)
      WriteCoreReg(IRI_REG_IT_MISC_ADDR, 0x0000);

   if(fft_size == 128)
      WriteCoreReg(IRI_REG_IT_MISC_ADDR, 0x4000);

   WriteCoreReg(IRI_REG_IT_SCALE_ADDR, SCALEBACK);

   /************/
   /* set bank */
   /************/

   if (in_place_buffer == 0)
      WriteCoreReg(IRI_REG_IBANK_ADDR, 0x0000);
   else
      WriteCoreReg(IRI_REG_IBANK_ADDR, 0x0001);

   /*******************************************************/
   /* Write data into the IFFT real and imaginary buffers */
   /*******************************************************/
   if(in_place_buffer == 1)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_A0_ADDR;
   else if(in_place_buffer == 0)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_B0_ADDR;

   /* Clear input first */

   for (i = 0; i < 64; i++)
        WriteCoreReg32((uint16) (us_PhysAddr+ i), 0);

   fft_size >>= 1;

   /* Write data */
   for (i = 0; i < fft_size; i++){
      //WriteCoreReg32((uint16) (us_PhysAddr +i), ifft_random_input1[i]);
      ul_data=((uint32)i<<16)+((i+1)&0xFFFF);
        WriteCoreReg32((uint16) (us_PhysAddr +i), ul_data);
   }


   /*****************************/
   /* CRI clocks relevant cores */
   /*****************************/

   WriteCoreReg(CRI_CCR0_ADDR,(uint16)0x0010);/* enable AC_CLK */
   WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x0500);/* enable MTE_TX_CLK, MTE_RX_CLK */


   /****************************/
   /* Start IFFT and then wait */
   /****************************/
   SetCoreReg(CRI_EVENT1_ADDR, (1<<CRI_MTE_IFFT_DONE));  /* Clear IFFT Done Event Bit */
   SetCoreReg(IRI_REG_IT_CTRL_ADDR, IRI_PRE_IFFT_START); /* start IFFT */

do {
      //ClockCores(500);
      ReadCoreReg(CRI_EVENT1_ADDR, &us_data);
      if(us_data & (1<<CRI_MTE_IFFT_DONE)) break;        /* If IFFT done, break */
   } while(1);
}

void CheckResults(int16 in_place_buffer, int16 fft_size)
{
   int16 i, us_PhysAddr;
    uint16 us_success;

   int32 ifft_reference_output1[64]={
   0x00000042,  0x0000fffe,  0x00000000,  0x0000fffc,  0x00000003,  0x0000fffd,  0x0000ffff,  0x0000fff9,
   0x00000008,  0x0000fffe,  0x0000ffff,  0x0000fffb,  0x00000001,  0x0000fffd,  0x0000fffe,  0x0000fff4,
   0x00010013,  0x0000fffe,  0x00000000,  0x0000fffb,  0x00010003,  0x0000fffd,  0x0000ffff,  0x0000fff8,
   0x00000005,  0x0000fffe,  0x00000000,  0x0000fffb,  0x00000001,  0x0000fffd,  0x0000fffe,  0x0000ffea,
   0x0001ffc0,  0x00000002,  0x00000001,  0x00000003,  0x0001fffe,   0x00000002,  0x00000002,  0x00000006,
   0x0000fffa,  0x00000002,  0x00000001,  0x00000004,  0x00000000,  0x00000003,  0x00000002,  0x0000000c,
   0x0001fff3,  0x00000002,  0x00010000,  0x00000004,  0x0000ffff,  0x00000003,  0x00000001,  0x00000008,
   0x0000fffc,  0x00000002,  0x00000001,  0x00000007,  0x00010000,  0x00000003,  0x00010002,  0x00000011};

   if(in_place_buffer == 1)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_A0_ADDR;
   else if(in_place_buffer == 0)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_B0_ADDR ;

   fft_size >>= 1;

   for(i = 0; i < fft_size; i++) {
      us_success=ReadCompareReg32(us_PhysAddr, i, (uint32) 0xFFFFFFFF, ifft_reference_output1[i]);
      if (us_success==0)   gs_error_count++;
   }

}



/***************************************************************
 *   main
 ***************************************************************/
int16 Test_Danube_IFFT(void)
{

   set_and_run_IFFT( 0, 64);     // Buffer A0, 64-point IFFT (emulation)
   CheckResults(0, 128);   // Check all 128 upsampled time-domain values

// set_and_run_IFFT(ifft_random_input2, 0, 128);   // Buffer A0, 128-point IFFT
// CheckResults(ifft_reference_output2, 0, 128);   // Check all 128 time domain values

// set_and_run_IFFT(ifft_random_input1, 1, 64);    // Buffer B0, 64-point IFFT (emulation)
// CheckResults(ifft_reference_output1, 1, 128);   // Check all 128 upsampled time-domain values

// set_and_run_IFFT(ifft_random_input2, 1, 128);   // Buffer B0, 128-point IFFT
// CheckResults(ifft_reference_output2, 1, 128);   // Check all 128 time domain values

   if(gs_error_count == 0)
      return(SUCCEED);
   else
      return(FAIL);

}


/*****************************************************************************
;  Prototype: int16 ReadCompareReg(int16 addr, uint16 mask, int16 expect)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

int16 ReadCompareReg(uint16 addr, uint16 mask, int16 expect)
{
    int16 data, expected;

   // Read register/RAM
   ReadCoreReg((uint16)addr, (uint16 *)&data);
   //ReadCoreBuf((uint16)addr, &data, 1, 1);

   // Mask both expected and read back data
   expected = expect & mask;
    data = data & mask;

   // Compare
   if (data != expected)
    {
      return FAIL;
    }
   else{
      return SUCCEED;
   }
}

/*****************************************************************************
;  Prototype: int16 ReadCompareReg32(int16 us_BaseAddr, int16 us_Offset, uint32 mask, int32 us_ExpectedData)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

int16 ReadCompareReg32(uint16 us_BaseAddr, uint16 us_Offset, uint32 mask, int32 ul_ExpectedData)
{
   int32 data32 = (int32) 0;
   int32 expected = (int32) (ul_ExpectedData & mask);

   // Read register/RAM Buffer
     ReadCoreReg32((uint16)(us_BaseAddr+us_Offset), &data32);

   // Mask both expected and read back data
   data32 = data32 & mask;

   // Compare
   if (data32 != expected)
      return(FAIL);
   else
      return(SUCCEED);
}



/***************************************************************
 *   RTV test
 ***************************************************************/
int16 Test_RTV(void)
{

   int16 test_data=0;
   int16 j;
   uint16 us_offset,us_stmode,us_data,us_success;
   uint32 ul_data, ul_RTVdata;

   gl_error_location = 0;
   gs_error_count = 0;

   /**************************************/
   /* set Rx  mode */
   /**************************************/
   WriteCoreReg(IRI_REG_IR_MODE_ADDR,0xC000); //disable buffer swap,BankB.
   WriteCoreReg(IRI_REG_IR_AMODE_ADDR,0xC000); //disable buffer swap,BankB.
   us_stmode = 0x0029; //00101001 , FFT register start, Post FFT in cascade
   WriteCoreReg(IRI_REG_IR_STMODE_ADDR,us_stmode); //everything in register start
   WriteCoreReg(IRI_REG_IR_ASTMODE_ADDR,us_stmode); //everything in register start

   WriteCoreReg(CRI_CCR0_ADDR,(uint16)0x0010);/* enable AC_CLK */
   WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x0500);/* enable MTE_RX_CLK */

   //write to fft buffer
   //reset value for ibank reg is 0. Hence Iridia uses bank B
   for (j = 0; j < IRI_RAM_RX_FFT_B0_SIZE; j++) {
      WriteCoreReg((int16) (IRI_RAM_RX_FFT_B0_ADDR + j),++test_data);
      WriteCoreReg((int16) (IRI_RAM_RX_RTV0_ADDR + j),0); // Clean RTV buffers
      WriteCoreReg((int16) (IRI_RAM_RX_RTV1_ADDR + j),0);
   }

   //select RTV content
   us_offset = 33;
   WriteCoreReg (IRI_REG_IR_RTV0_ADDR, (uint16)(us_offset|0x1000));  // FFT, enable
   //WriteCoreReg (IRI_REG_IR_RTV0_ADDR, (uint16)(us_offset|0x3000)); //Data=FDQ Output, Enable, Offset= Tone gs_RxFirstChannel  (33)
   //WriteCoreReg (IRI_REG_IR_RTV1_ADDR, (uint16)(us_offset|0xD000));//Data=Constellation Decisions, Enable, Offset= Tone gs_RxFirstChannel (33)

   SetCoreReg(CRI_EVENT0_ADDR, (1<<CRI_MTE_PST_DONE));   // Clear post FFT Done Event Bit
   SetCoreReg(IRI_REG_IR_CTRL_ADDR,0x0002); //start fft only

   //Wait
   gs_rtv_seg = 1;
   do {
      ReadCoreReg(CRI_EVENT0_ADDR, &us_data);
      if(us_data & (1<<CRI_MTE_PST_DONE)) break;         /* If FFT done, break */
   } while(1);

   gs_rtv_seg = 2;
   //read Buffer
   for (j = 0; j < 32; j++) {
      uint32 ul_Data, ul_RTVdata;

      ReadCoreReg32((uint16)(IRI_RAM_RX_FFT_B0_ADDR + j + (us_offset)), &ul_data);

      ReadCoreReg32((uint16)(IRI_RAM_RX_RTV0_ADDR + j), &ul_RTVdata);

      if (ul_RTVdata == ul_data)
         us_success = 1;
      else
         us_success = 0;

      if (us_success==0)
      {
         gs_error_count++;
         gl_error_location |= ((int32)(1 << 0));
      }
   }
      ReadCoreBuf32((int16)(IRI_RAM_RX_RTV0_ADDR + j), gsa_buffer2, 32);
Pause(3003);

   us_success = 0;
   for (j = 0; j < 32; j++) {
      ReadCoreReg32((uint16)(IRI_RAM_RX_RTV1_ADDR + j), &ul_RTVdata);
      if (ul_RTVdata == 0)
         us_success = 1;
      else
         us_success = 0;
      if (us_success==0)
      {
         gs_error_count++;
         gl_error_location |= ((int32)(1 << 1));
      }
   }

   //##############  FDQ TEST ######################################################

   //select RTV content
   WriteCoreReg (IRI_REG_IR_RTV0_ADDR, (uint16)(33|0x3000)); //Data=FDQ Output, Enable, Offset= Tone gs_RxFirstChannel  (33)
   WriteCoreReg (IRI_REG_IR_RTV1_ADDR, (uint16)(65|0x3000));//Data=Constellation Decisions, Enable, Offset= Tone gs_RxFirstChannel (33)

   //kick off operation (fft-fdq / gs-QAM) and wait

   SetCoreReg(CRI_EVENT0_ADDR, (1<<CRI_MTE_FDQ_DONE));   // Clear IFFT Done Event Bit
   WriteCoreReg(IRI_REG_IR_CTRL_ADDR,0x0008); //start fdq only

   //Wait
   gs_rtv_seg = 3;
   do {
      ReadCoreReg(CRI_EVENT0_ADDR, &us_data);
      if(us_data & (1<<CRI_MTE_FDQ_DONE)) break;         /* If Fdq done, break */
   } while(1);
   gs_rtv_seg = 4;

   //read Buffer
   for (j = 0; j < 32; j++) {
      ReadCoreReg32((uint16)(IRI_RAM_RX_FFT_B0_ADDR + j + 33), &ul_data); //read from buffer
      ReadCoreReg32((uint16)(IRI_RAM_RX_RTV0_ADDR + j), &ul_RTVdata);
      if (ul_RTVdata == ul_data)
         us_success = 1;
      else
         us_success = 0;
      if (us_success==0)
      {
         gs_error_count++;
         gl_error_location |= ((int32)(1 << 2));
      }
   }

   us_success = 0;
   for (j = 0; j < 32; j++) {
      ReadCoreReg32((uint16)(IRI_RAM_RX_FFT_B0_ADDR + j + 65), &ul_data); //read from buffer
      ReadCoreReg32((int16)(IRI_RAM_RX_RTV1_ADDR + j), &ul_RTVdata);
      if (ul_RTVdata == ul_data)
         us_success = 1;
      else
         us_success = 0;
      if (us_success==0)
      {
         gs_error_count++;
         gl_error_location |= ((int32)(1 << 3));
      }
   }

   //########### END of FDQ TEST ###################################################

   // End of test
   if(gs_error_count == 0)
      return(SUCCEED);
   else
      return(FAIL);

}



#endif //AMAZON_SE
