/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2005 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;The software is owned by Aware, Inc. and is protected by United States
;;;copyright laws and international treaty provisions. Therefore, you must treat
;;;the software like any other copyrighted material.  You may not use or copy
;;;the software or any accompanying written materials for any other purpose than
;;;what is described in the Development and License Agreement
;;;entered into with Aware Inc. (the "Agreement").  Except as
;;;expressly provided in the Agreement, Aware does not grant any express or
;;;implied rights to you to or under Aware or any third party patents, copyrights,
;;;trademarks, or trade secret information.  Additionally, you shall reproduce
;;;and apply any copyright or other proprietary rights notices included on or
;;;embedded in the software to any copies or derivative works made thereof, in
;;;whole or in part, in any form.  These rights are provided for information
;;;clarification, other restrictions of rights may apply as well.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Description : AAI Loopback test using UTOPIA port
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;*/

/*
;;; IMBOX0  ; MTE Tx Timer delay value
;;; IMBOX1  ; BC0 number of bytes
;;; IMBOX2  ; BC1 number of bytes
;;; OMBOX0  ; ATM Sync status
*/

#ifndef AMAZON_SE


#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "gdata.h"
#include "cmv.h"

#define BIG_TIMEOUT (3200)
#define WaitingForTX (1)
#define WaitingForRX (2)
#define NUMBER_CONFIGURATIONS 3  /* Number of test cases to be run. */
#define SCALEBACK 0x006A         /* alternating scalebacks */
#define OVERFLOW 0               /* we don't want overflows */

int16 gs_error_count;

int16 IMBOX0,IMBOX1=53,IMBOX2=53,OMBOX0;
int TestStat;
int TimedOut;
int myTimer;
int rxDone,txDone;
int gl_loop_counter;
int gl_RxDataTaken;
int gl_TxDataGiven;

//Danube PPE debugging
uint16 gusa_PPEATM_RxCnt[NUM_BEARER_CHANNELS][6];
uint16 gusa_PPEATM_TxCnt[NUM_BEARER_CHANNELS][2];

int16 AtmTxRxLoopInit(void);
int16 AtmTxRxLoopRun(int NumberOfTimes);
void start_aai_rx(void) ;
void CopyDataToRx(void);
int aai_tx_handler();
int aai_rx_handler();

int16 Test_Danube_MTE_RAM(void);
int16 Test_Danube_FCI_RAM(void);
int16 Test_Danube_Loopback(void);
int16 Test_Danube_IFFT(void);

void set_and_run_IFFT(int16 in_place_buffer,int16 fft_size);
void CheckResults(int16 in_place_buffer, int16 fft_size);
int16 ReadCompareReg(uint16 addr, uint16 mask, int16 expect);
int16 ReadCompareReg32(uint16 us_BaseAddr, uint16 us_Offset, uint32 mask, int32 ul_ExpectedData);

#define MAX_16 0x7fff
#define MIN_16 0x8000
#define MAX_32  0x7fffffff
#define MIN_32  0x80000000


#define ENCGAINMANTISSA1         0x2000
#define ENCGAINMANTISSA2         8192
#define ENCGAINMANTISSA3         9459
#define ENCGAINMANTISSA4         7327
#define ENCGAINMANTISSA5         10362
#define ENCGAINMANTISSA6         7151
#define ENCGAINMANTISSA7         10235
#define ENCGAINMANTISSA8         7108
#define ENCGAINMANTISSA9         10204
#define ENCGAINMANTISSA10           7098
#define ENCGAINMANTISSA11           10196
#define ENCGAINMANTISSA12           7095
#define ENCGAINMANTISSA13           10194
#define ENCGAINMANTISSA14           7095
#define ENCGAINMANTISSA15        10194

/* QAM Decoder constellation gains for bit-sizes 2-15. Format is [S 2.13].  */

#define DECGAINMANTISSA1               (0x2000)
#define DECGAINMANTISSA2               (0x2000)
#define DECGAINMANTISSA3               (0x376d)
#define DECGAINMANTISSA4               (0x23c7)
#define DECGAINMANTISSA5               (0x3299)
#define DECGAINMANTISSA6               (0x24a9)
#define DECGAINMANTISSA7               (0x333a)
#define DECGAINMANTISSA8               (0x24e1)
#define DECGAINMANTISSA9               (0x3362)
#define DECGAINMANTISSA10                 (0x24ef)
#define DECGAINMANTISSA11                 (0x336b)
#define DECGAINMANTISSA12                 (0x24f2)
#define DECGAINMANTISSA13                 (0x336e)
#define DECGAINMANTISSA14                 (0x24f3)
#define DECGAINMANTISSA15                 (0x336f)

/*-------------------------------------
Transmitter static settings
-------------------------------------*/
typedef struct {

   /* User setting parameters */
   int16 s_Codewordsize_Odd0;
   int16 s_Codewordsize_Odd1;
   int16 s_Codewordsize0;
   int16 s_Codewordsize1;

   int16 s_R1;
   int16 s_R0;

   int16 s_Dp0;
   int16 s_Dp1;
   int16 s_Mp0;
   int16 s_Mp1;
   int16 s_Tp[2];
   int16 s_Lp0;
   int16 s_Lp1;


   int16 s_Lp1_en;
   int16 s_Lp0_en;

   int16 scrambleren1;
   int16 scrambleren0;
   int16 crcenable1;
   int16 crcenable0;

   int16 s_FramingMode;
   int16 s_IBitslp;
   int16 s_MSGc;

   int16 sa_BC0_Bytes;
   int16 sa_BC1_Bytes;

   int16 sa_BC0_lpath;
   int16 sa_BC1_lpath;

   int16 transfersize0;
   int16 transfersize1;

   int16 s_trellis;
   int16 ifft128;

} tx_params;


/*-------------------------------------
Receiver Static settings
-------------------------------------*/
typedef struct {
   /* User setting parameters */
    int16 s_Codewordsize_Odd0;
   int16 s_Codewordsize_Odd1;
   int16 s_Codewordsize0;
   int16 s_Codewordsize1;
   int16 s_sHalfCodeWordSize0[2];
   int16 s_sHalfCodeWordSize1[2];
   int16 s_sHalfCntl0;
   int16 s_sHalfCntl1;

   int16 s_R1;
   int16 s_R0;

   int16 s_Dp0;
   int16 s_Dp1;
   int16 s_Mp0;
   int16 s_Mp1;
   int16 s_Tp[2];
   int16 s_Lp0;
   int16 s_Lp1;

   int16 s_Lp1_en;
   int16 s_Lp0_en;

   int16 scrambleren1;
   int16 scrambleren0;
   int16 crcenable1;
   int16 crcenable0;

   int16 s_FramingMode;
   int16 s_IBitslp;
   int16 s_MSGc;

   int16 sa_BC0_Bytes;
   int16 sa_BC1_Bytes;

   int16 sa_BC0_lpath;
   int16 sa_BC1_lpath;

   int16 transfersize0;
   int16 transfersize1;

   int16 s_trellis;


} rx_params;

static void set_tx_params(tx_params *tx);
static void set_rx_params(rx_params *rx);
static int16 configure_iridia_rams(rx_params *rx, tx_params *tx);
static void write_azi_tx_registers(tx_params *tx);
static void write_azi_rx_registers(rx_params *rx);
static void start_transmit(void);
static void start_receive(void);
static void copy_ifft_to_fft(int16 i_config);
static void TX_FIFO_Init(tx_params *tx);
static void RX_FIFO_Init(rx_params *rx);
static void mte_toneOrdering(int16 *psa_BAT, int16 s_numTones, int16 s_MaxBitPerTone, int16 *psa_ToneIndices);
static void mte_toneOrdering_tcm(int16 *psa_BAT, int16 *psa_tone_order, int16 s_numTones, int16 *psa_tone_order_tcm,int16 *psa_num1bittones, FlagT *pft_tcm_x0_ygt1, int16 *ps_MinTone);
static int16 mte_calcBATSetFineGains(FlagT ft_isTcm,  int16 s_totalDataBits, int16 s_constsize, int16 s_firstloadedtone,  int16 s_numTones, int16 s_num1bits, int16* ps_bat, int16* ps_finegain);


/***********************************************************
*  Global Variables
***********************************************************/
//int16 gs_TxNumTones;
//int16 gus_Tx_Tcm_Num1bits = 0;
//int16 gft_Tx_Tcm_X0_YGT1 = 0;
int16 gus_Tx_1Bit_Index = 0;


//int16 gs_RxNumTones;
//int16 gus_Rx_Tcm_Num1bits = 0;
//int16 gft_Rx_Tcm_X0_YGT1 = 0;
int16 gus_Rx_1Bit_Index = 0;

//int16 gus_Rx_MaxToneIndx;
//int16 gus_Rx_MinToneIndx;

/*-------------------------------------
   Global variables for user settings
-------------------------------------*/
int16 framingmode = 0x4;      //Framing Mode
int16 trellis = 1;            //Trellis ON/OFF
int16 ifft128 = 0;            //Enable/Disable IFFT128

int16 enablelp0 = 1;       //Enable/Disable LP0 path
int16 enablelp1 = 0;       //Enable/Disable LP1 path

int16 scramble_enable0 = 0;      //Enable/Disable Scrambler on LP0
int16 scramble_enable1 = 0;      //Enable/Disable Scrambler on LP1

int16 crc_enable0 = 0;        //Enable/Disable CRC on LP0
int16 crc_enable1 = 0;        //Enable/Disable CRC on LP1

int16 IBitslp = 0;            //Latency path for Indicator bits
int16 MSGc  = 0;           //Latency path for HDLC message

int16 checkbytes0 = 0;        // Number of LP0 checkbytes
int16 checkbytes1 = 0;        // Number of LP1 checkbytes

int16 BC0bytes = 23;       // BC0 payload size
int16 BC1bytes = 0;           // BC1 payload size

int16 BC0_lpath = 0;       // Latency path selection for BC0
int16 BC1_lpath = 1;       // Latency path selection for BC1

//depth can be set to 1 or 2
int16 depth0= 1;           // Interleave Depth for LP0
int16 depth1= 1;           // Interleave Depth for LP1

int16 Mp0 = 1;             // Mux Frames per Codeword for LP0 path
int16 Mp1 = 1;             // Mux Frames per Codeword for LP1 path

int16 Tp0 = 1;             // Tp counter for LP0 path
int16 Tp1 = 1;             // Tp counter for LP1 path

int16 gs_ConstSize = 14;         // Number of loaded bits for each tone
int16 gs_Num1bits = 0;           // Number of 1 bit loadded tones
//--------------------------------------------------------------------

short gsa_QAMDecConstGainMantissa[16] = {
   0,
      DECGAINMANTISSA1,
      DECGAINMANTISSA2,
      DECGAINMANTISSA3,
      DECGAINMANTISSA4,
      DECGAINMANTISSA5,
      DECGAINMANTISSA6,
      DECGAINMANTISSA7,
      DECGAINMANTISSA8,
      DECGAINMANTISSA9,
      DECGAINMANTISSA10,
      DECGAINMANTISSA11,
      DECGAINMANTISSA12,
      DECGAINMANTISSA13,
      DECGAINMANTISSA14,
      DECGAINMANTISSA15
};

short gsa_QAMEncConstGainMantissa[16] = {
      0,
      ENCGAINMANTISSA1,
      ENCGAINMANTISSA2,
      ENCGAINMANTISSA3,
      ENCGAINMANTISSA4,
      ENCGAINMANTISSA5,
      ENCGAINMANTISSA6,
      ENCGAINMANTISSA7,
      ENCGAINMANTISSA8,
      ENCGAINMANTISSA9,
      ENCGAINMANTISSA10,
      ENCGAINMANTISSA11,
      ENCGAINMANTISSA12,
      ENCGAINMANTISSA13,
      ENCGAINMANTISSA14,
      ENCGAINMANTISSA15
};

 ////////////////////////////////////////////////////

int16 AtmTxRxLoopInit(void){

int32 *pl,i;
int16 us_Reg;
//;;; START OF MAIN TEST CODE


//;;; Configure  ADSL Clocks  (not needed in this test )
/* mov   r0,0x00000001     ; Set clock dividers
   st r0,[CRI_CDC0]     ;
   mov   r0,0x00001555     ;
   st r0,[CRI_CDC1]     ;
*/

   // Enable ADSL clocks
   //us_Reg=0x1a; //mov r0,0x0000001A     ; Enable clocks
    us_Reg=0x1a; //Enable Aware and Electral Clk
   WriteCoreReg((uint16) CRI_CCR0_ADDR, us_Reg);//st  r0,[CRI_CCR0]     ;
// us_Reg=0x1aaa; //mov r0,0x00001AAA     ;
   us_Reg=0x1aa5;
   WriteCoreReg((uint16) CRI_CCR1_ADDR, us_Reg);// st r0,[CRI_CCR1]     ;

//;;; Configure the AAI Core
   us_Reg= 0xf; //mov   r0, 0xf
   WriteCoreReg((uint16) A_UTPCFG_ADDR, us_Reg); //st r0,[A_UTPCFG]

   us_Reg= 0x3C20    ; //Enable TXBC0, RXBC0, TXBC1, RXBC1
   //st  r0,[A_CFG]     ; BC0 UTOPIA address is 0, BC1 is 1
   WriteCoreReg((uint16) A_CFG_ADDR, us_Reg);

   us_Reg=0x0000     ; //Scrambler Disable

   WriteCoreReg((uint16) AT_CFG_ADDR(BC0), us_Reg);
   WriteCoreReg((uint16) AT_CFG_ADDR(BC1), us_Reg);
   WriteCoreReg((uint16) AR_CFG_ADDR(BC0), us_Reg);
   WriteCoreReg((uint16) AR_CFG_ADDR(BC1), us_Reg);

   us_Reg=0x0015        ;// Tx Utopia mode, reg start
   WriteCoreReg((uint16) AT_CNTL_ADDR, us_Reg);//  st r0,[AT_CNTL]      ;

   us_Reg=0x0015     ;// Rx Utopia mode, reg start
   WriteCoreReg((uint16) AR_CNTL_ADDR, us_Reg); //st  r0,[AR_CNTL]      ;

// ;;; set up BC0

   us_Reg=IMBOX1;    // ;BC0 number of bytes
    us_Reg--;     //  sub  r0,r0,1        ; subtract 1
   us_Reg <<= 8;  // asl   r0,r0,8        ; shift up 8 bits
   WriteCoreReg (AT_FB_SIZE_ADDR(0), us_Reg);//st  r0,[AT_FB_SIZE0]  ; Tx FB Start BC0, End BC0 addresses

   us_Reg=0    ;// Rx FB Start BC0 address
   WriteCoreReg (AR_FB_START_ADDR(0), us_Reg);//st r0,[AR_FB_START0] ;

   us_Reg=IMBOX1;    // ;BC0 number of bytes
    us_Reg--;     //  sub  r0,r0,1        ; subtract 1
   WriteCoreReg (AR_FB_END_ADDR(0), us_Reg);//st   r0,[AR_FB_END0]      ; (Rx FB End BC0 address

   //;;; set up BC1
   us_Reg = IMBOX1;
   us_Reg += IMBOX2;
   us_Reg--;
   us_Reg<<=8; //asl r1,r1,8        ; shift up 8 bits
   us_Reg |= IMBOX1; //or  r0,r0,r1    ; start, end address merge
   WriteCoreReg (AT_FB_SIZE_ADDR(1), us_Reg);// st r0,[AT_FB_SIZE1]  ; Tx FB Start BC1, End BC1 addresses

   us_Reg = IMBOX1      ; //BC0 number of bytes
   WriteCoreReg (AR_FB_START_ADDR(1), us_Reg); //st   r0,[AR_FB_START1] ; Rx FB Start BC1 address

   us_Reg = IMBOX2; // ld  r1, [IMBOX2]      ; BC1 number of bytes
   us_Reg += IMBOX1; //add r0,r0,r1
    us_Reg--; //sub  r0,r0,1        ; subtract 1
   WriteCoreReg (AR_FB_END_ADDR(1), us_Reg);//st   r0,[AR_FB_END1]      ; Rx FB End BC1 address

//;;; Set up interrupts

//;;; Initialize test parameters
   OMBOX0=0; //   st 0,[OMBOX0]     ; Clear OMBOX0

//;;; Initialize the Tx Frame buffer
//#define      ZEP_RAM_RX_FRAMEBUFFER_ADDR      0x3800
//#define      ZEP_RAM_TX_FRAMEBUFFER_ADDR      0x3a00

   for (i=0;i<106;i++)
      WriteCoreReg((int16) ( ZEP_RAM_TX_FRAMEBUFFER_ADDR+ i), 0);

      WriteCoreReg (CRI_AMASK1_ADDR, (1<<8));   //tx
   WriteCoreReg (CRI_MASK1_ADDR, (1<<8));

      WriteCoreReg (CRI_AMASK0_ADDR, (1<<10)); //rx
      WriteCoreReg (CRI_MASK0_ADDR,  (1<<10));

    //Danube PPE Debugging
    INFOMap[INFO_PPEATMRxCnt] = (uint16*) gusa_PPEATM_RxCnt;
    INFOMap[INFO_PPEATMTxCnt] = (uint16*) gusa_PPEATM_TxCnt;

   return(1);
}

int16 AtmTxRxLoopRun(int NumberOfTimesMax)
{
   int16 us_Reg;
   int TimedOut=0;
   int NumberOfTimesActual=0;
   uint16 s_bc,i,us_ATM_Cnt_RxReg_Offset,us_ATM_Cnt_TxReg_Offset;

   //gua_PPEATM_Cnt[s_bc][0]: User Cell Count
    //gua_PPEATM_Cnt[s_bc][1]: Idle Cell count
    //gua_PPEATM_Cnt[s_bc][2]: ATM Idle Cell count
    //gua_PPEATM_Cnt[s_bc][3]; Bit Error count
   //gua_PPEATM_Cnt[s_bc][4]: HEC Error count
   //gua_PPEATM_Cnt[s_bc][5]: Cell Drop count

   while ( (NumberOfTimesActual< NumberOfTimesMax) && (!TimedOut) )
   {

   //;;; Start the test with a AAI Tx Start
   ReadCoreReg((uint16) AT_CNTL_ADDR, &us_Reg);  //ld r0, [AT_CNTL]     ;
   us_Reg |= 0x20;                  //or  r0, r0, 0x00000020   ;
      WriteCoreReg (AT_CNTL_ADDR, us_Reg);  //st   r0, [AT_CNTL]     ; Start AAI Tx

   TestStat = WaitingForTX;

   //;;; Wait for all cells to be processed
   myTimer = BIG_TIMEOUT;
   txDone=0;
   while (((myTimer--) >0) && !txDone) {
   txDone = aai_tx_handler();
   }

   if (txDone)
   {
      CopyDataToRx();
      start_aai_rx(); //startRxATM();
      TestStat = WaitingForRX;

      myTimer = BIG_TIMEOUT;
      rxDone=0;
      while (((myTimer--) >0)&& !rxDone) {
         rxDone = aai_rx_handler();
         }
      if (!rxDone)
         TimedOut=1;
   }
   else
      TimedOut=1;

   if (txDone && rxDone) {
      for(s_bc = 0; s_bc < NUM_BEARER_CHANNELS; s_bc++){
         us_ATM_Cnt_RxReg_Offset = AR_CELL_ADDR(s_bc);
         for (i = 0; i < 6; i++) {
         ReadCoreReg((uint16)(us_ATM_Cnt_RxReg_Offset+2*i) , &gusa_PPEATM_RxCnt[s_bc][i]);
         if (gusa_PPEATM_RxCnt[s_bc][i]>=0x8000)
            WriteCoreReg((uint16)(us_ATM_Cnt_RxReg_Offset+2*i) , 0);
         }
           us_ATM_Cnt_TxReg_Offset = AT_CELL_ADDR(s_bc);
         for (i = 0; i < 2; i++) {
         ReadCoreReg((uint16)(us_ATM_Cnt_TxReg_Offset+2*i) , &gusa_PPEATM_TxCnt[s_bc][i]);
         if (gusa_PPEATM_TxCnt[s_bc][i]>=0x8000)
         WriteCoreReg((uint16)(us_ATM_Cnt_TxReg_Offset+2*i) , 0);
         }
      }
   }
   gl_loop_counter++;
   NumberOfTimesActual++;
} //while

   return(NumberOfTimesActual);

}
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

int aai_tx_handler(void)
{
   int16 us_Reg;

   ReadCoreReg((uint16) CRI_STATUS1_ADDR, &us_Reg);;//   ld r1,[CRI_STATUS1] Get status
   us_Reg &= (1<<8) ;//and.f  0,r1,0x00000100
   if (us_Reg==0)
      return(0);
   else
   {
      WriteCoreReg((uint16) CRI_STATUS1_ADDR, us_Reg); //   st r1,[CRI_STATUS1]   Clear CRI Int status
      return(1);
   }
}

void CopyDataToRx(void) {
   int32 *pl_Tx,*pl_Rx;
   uint16 temp_data;
   int16 lp_count;

   pl_Tx = (int32 *)  ZEP_RAM_TX_FRAMEBUFFER_ADDR;//  mov   r2,fci_txfb_base-4   ; Tx frame buffer base address, less 1 word
   pl_Rx = (int32 *)  ZEP_RAM_RX_FRAMEBUFFER_ADDR;//  mov   r3,fci_rxfb_base-4   ; Rx frame buffer base address, less 1 word

//   for (lp_count=0; lp_count<256/4;lp_count++) {
//       *pl_Rx++ = *pl_Tx++ ; //ld.a  r4,[r2,4]      ; load and update address
//                   //st.a   r4,[r3,4]      ; store and update address
//   }

  for (lp_count=0; lp_count<106;lp_count++) {
      ReadCoreReg((uint16) ( ZEP_RAM_TX_FRAMEBUFFER_ADDR+ lp_count), &temp_data);
       WriteCoreReg((uint16) (ZEP_RAM_RX_FRAMEBUFFER_ADDR+ lp_count), temp_data);
      }

}

void start_aai_rx(void ){
   int16 us_Reg;
   // let atm find its own sync.
   ReadCoreReg((uint16) AR_CNTL_ADDR, &us_Reg);//  ld r0, [AR_CNTL]     ; Get current value of AR_CNTL
   us_Reg |=  0x020 ;; // or  r0, r0, 0x00000020   ;
    WriteCoreReg((uint16) AR_CNTL_ADDR, us_Reg); //   st r0, [AR_CNTL]     ; Start AAI Rx

}
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

int aai_rx_handler(void) {

   int16 us_Reg;
   int done;
   ReadCoreReg((uint16) CRI_STATUS0_ADDR, &us_Reg) ;//   ld r1,[CRI_STATUS1] Get status
   done = us_Reg & (1<<10) ;
   if (done==0)
      return(0);
   else
   {
      WriteCoreReg((uint16) CRI_STATUS0_ADDR, us_Reg); //   st r1,[CRI_STATUS1]   Clear CRI Int status
      gl_RxDataTaken++;
      ReadCoreReg((uint16) AR_ATM_STAT_ADDR(0), &us_Reg);
      OMBOX0 = ((us_Reg>>1)&1); //update if ATM is synced.
      ReadCoreReg((uint16) AR_ATM_STAT_ADDR(1), &us_Reg);
      OMBOX0 |= ((us_Reg)&2) ;//update if ATM is synced.
      return(1);
   }
}

/************************************************************************/
/* Danube Asim Iridia Ram Test
 ; Description: The function tests Iridia RAM block for arc simulator.
 ; Prototype:
 ;    int16 Test_Danube_MTE_RAM(void)
 ;
 ; Input Arguments:
 ;    none
 ;
 ; Return Value:
 ;    int16
 ;
/************************************************************************/

int16 Test_Danube_MTE_RAM(void) {

   #define MTE_RAM_COUNT_16BITS 14
    #define MTE_RAM_COUNT_32BITS 11


   int16 ram_addr_16bits[MTE_RAM_COUNT_16BITS] = {

   IRI_RAM_TX_GAINSCALE_ADDR,
   IRI_RAM_TX_BITALLOC_ADDR,
   IRI_RAM_TX_TONEREORDER_ADDR,

   IRI_RAM_RX_GAINSCALE_ADDR,
   IRI_RAM_RX_BITALLOC_ADDR,
   IRI_RAM_RX_TONEREORDER_ADDR,

   IRI_RAM_RX_XYDECODE_FIFO_ADDR,
   IRI_RAM_RX_SURVIVOR_PATH_ADDR,

   IRI_RAM_TX_GAINSCALE_PING_PONG_ADDR,
   IRI_RAM_TX_BITALLOC_PING_PONG_ADDR,
   IRI_RAM_TX_TONEREORDER_PING_PONG_ADDR,

   IRI_RAM_RX_GAINSCALE_PING_PONG_ADDR,
   IRI_RAM_RX_BITALLOC_PING_PONG_ADDR,
   IRI_RAM_RX_TONEREORDER_PING_PONG_ADDR
};

   static int16 ram_size_16bits[MTE_RAM_COUNT_16BITS] = {

      (int16) IRI_RAM_TX_GAINSCALE_SIZE,
      (int16) IRI_RAM_TX_BITALLOC_SIZE,
      (int16) IRI_RAM_TX_TONEREORDER_SIZE,

      (int16) IRI_RAM_RX_GAINSCALE_SIZE,
      (int16) IRI_RAM_RX_BITALLOC_SIZE,
      (int16) IRI_RAM_RX_TONEREORDER_SIZE,

      (int16) IRI_RAM_RX_XYDECODE_FIFO_SIZE,
      //(int16) IRI_RAM_RX_SURVIVOR_PATH_SIZE,
      (int16) 0x014,

      (int16) IRI_RAM_TX_GAINSCALE_PING_PONG_SIZE,
      (int16) IRI_RAM_TX_BITALLOC_PING_PONG_SIZE,
      (int16) IRI_RAM_TX_TONEREORDER_PING_PONG_SIZE,

      (int16) IRI_RAM_RX_GAINSCALE_PING_PONG_SIZE,
      (int16) IRI_RAM_RX_BITALLOC_PING_PONG_SIZE,
      (int16) IRI_RAM_RX_TONEREORDER_PING_PONG_SIZE

};

   uint16 ram_mask_16bits[MTE_RAM_COUNT_16BITS] = {

   (uint16) 0xFFFF,     // Tx Gain Scale
   (uint16) 0x000F,     // Tx BAT
   (uint16) 0x003F,     // Tx TRT

   (uint16) 0xFFFF,     // Rx Gain Scale
   (uint16) 0x000F,     // Rx BAT
   (uint16) 0x00FF,     // Rx TRT

   (uint16) 0xFFFF,     // XY Fifo
   (uint16) 0xFFFF,     // Survivor

   (uint16) 0xFFFF,     // Tx Gain Scale Ping-pong
   (uint16) 0x000F,     // Tx BAT Ping-pong
   (uint16) 0x003F,     // Tx TRT Ping-pong

   (uint16) 0xFFFF,     // Rx Gain Scale Ping-pong
   (uint16) 0x000F,     // Rx BAT Ping-pong
   (uint16) 0x00FF         // Rx TRT Ping-pong

};

   uint16 ram_addr_32bits[MTE_RAM_COUNT_32BITS] = {
   IRI_RAM_TX_IFFT_A0_ADDR,
   IRI_RAM_TX_IFFT_B0_ADDR,

   IRI_RAM_RX_FFT_A0_ADDR,
   IRI_RAM_RX_FFT_B0_ADDR,
   IRI_RAM_RX_FFT_C0_ADDR,

   IRI_RAM_RX_CYCLICPREFIX_A0_ADDR,
   IRI_RAM_RX_CYCLICPREFIX_B0_ADDR,
   IRI_RAM_RX_CYCLICPREFIX_C0_ADDR,

   IRI_RAM_RX_FDQ_MANTISSA_ADDR,
   IRI_RAM_RX_FDQ_EXPONENT_ADDR,
   IRI_RAM_RX_REVERB_SEGUE_DETECT_ENABLE_ADDR
};

   int16 ram_size_32bits[MTE_RAM_COUNT_32BITS] = {

      (int16) IRI_RAM_TX_IFFT_A0_SIZE,
      (int16) IRI_RAM_TX_IFFT_B0_SIZE,

      (int16) IRI_RAM_RX_FFT_A0_SIZE,
      (int16) IRI_RAM_RX_FFT_B0_SIZE,
      (int16) IRI_RAM_RX_FFT_C0_SIZE,

      (int16) IRI_RAM_RX_CYCLICPREFIX_A0_SIZE,
      (int16) IRI_RAM_RX_CYCLICPREFIX_B0_SIZE,
      (int16) IRI_RAM_RX_CYCLICPREFIX_C0_SIZE,

      (int16) IRI_RAM_RX_FDQ_MANTISSA_SIZE,
      (int16) IRI_RAM_RX_FDQ_EXPONENT_SIZE,
      (int16) IRI_RAM_RX_REVERB_SEGUE_DETECT_ENABLE_SIZE
};

   uint32 ram_mask_32bits[MTE_RAM_COUNT_32BITS] = {
   (uint32) 0xFFFFFFFF,    // IFFT Bank A
   (uint32) 0xFFFFFFFF,    // IFFT Bank B

   (uint32) 0xFFFFFFFF,    // FFT Bank A
   (uint32) 0xFFFFFFFF,    // FFT Bank B
   (uint32) 0xFFFFFFFF,    // FFT Bank C

   (uint32) 0xFFFFFFFF,    // Cyclic Prefix Bank A
   (uint32) 0xFFFFFFFF,    // Cyclic Prefix Bank B
   (uint32) 0xFFFFFFFF,    // Cyclic Prefix Bank C

   (uint32) 0x3FFF3FFF,    // FDQ Mantissa
   (uint32) 0x0F0F0F0F,    // FDQ Exponent
   (uint32) 0x01010101        // Reverb-Segue Detect Enable
};

   int16 i,j,us_version;
   int16 test_data = 0, test_data_inv=0;
   uint16 us_success = 0, us_temp_zep=0, us_temp_iri=0;
   uint32 ul_Data=0;
   uint32 ul_index;

   gs_error_count=0;

   /* ==================================================================== */
   /* Run Test */
   /* ==================================================================== */
    //Read Version Register
    ReadCoreReg((int16)IRI_REG_IVERSION_ADDR, (uint16 *)&us_version);
   if (us_version!=0x23) gs_error_count++;


   //--------------  Begin Test for 16 bit buffers ------------------------
   // Write incrementing data to the RAMs.  Write the RAMs from bottom to top
   for (i = 0; i < MTE_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         WriteCoreReg((int16) (ram_addr_16bits[i] + j),++test_data);
         // YC Feb 01, 2006 WriteCoreBuf and ReadCoreBuf are 16-bit addressing
         // However, the write_memory() and read_memory() interpret as
         // 32-bit addressing. Should revisit.
         //++test_data;
         //WriteCoreBuf((int16)(ram_addr_16bits[i] + j), &test_data, 1,1);
         }
   }

   // Read back the data that was written.   Read the RAMs from top to bottom.
   // Invert the data in each location after it is read.
   for (i = (MTE_RAM_COUNT_16BITS - 1); i >= 0; i--) {
      for (j = (ram_size_16bits[i] - 1); j >= 0; j--) {
         us_success=ReadCompareReg((uint16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], test_data);
         WriteCoreReg((int16) (ram_addr_16bits[i] + j), (~test_data));
         //test_data_inv=~test_data;
         //WriteCoreBuf((int16)(ram_addr_16bits[i] + j), &test_data_inv, 1,1);
         test_data--;
         if (us_success==0)   gs_error_count++;
      }
   }

   // Verify the inverse data that was written
   for (i = 0; i < MTE_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         test_data++;
         us_success=ReadCompareReg((uint16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], (int16) (~test_data));
         if (us_success==0)   gs_error_count++;
      }
   }


   //--------------  Begin Test for 32 bit buffers ------------------------
   // Write incrementing data to the RAMs.  Write the RAMs from bottom to top
   test_data = 0;
   for (i = 0; i < MTE_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = (uint32) (((uint32) (test_data + 1) << 16) + (uint32) test_data);
         ul_Data &= (uint32) ram_mask_32bits[i];
         //WriteCoreBuf32((uint16) (ram_addr_32bits[i]+ j), (int16 *) &ul_Data, 1);
            WriteCoreReg32((uint16) (ram_addr_32bits[i]+ j), ul_Data);
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         test_data += 2;
         if (us_success==0)   gs_error_count++;
      }
   }

   test_data -= 2;
   for (i = (MTE_RAM_COUNT_32BITS - 1); i >= 0; i--) {
      for (j = (ram_size_32bits[i] - 1); j >= 0; j--) {
         ul_Data = (((uint32) (test_data + 1) << 16) + (uint32) test_data);
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         ul_Data = (((uint32) ~(test_data + 1) << 16) + (uint32) (~test_data));
         // YC Feb 01, 2006 WriteCoreBuf32 and ReadCoreBuf32 are DMAs, which havent
         // been implemented yet.
         //WriteCoreBuf32((uint16) (ram_addr_32bits[i]+ j),(int16 *) &ul_Data, 1);
         WriteCoreReg32((uint16) (ram_addr_32bits[i]+ j),ul_Data);
         test_data -= 2;
         if (us_success==0)   gs_error_count++;
      }
   }

   test_data += 2;
   for (i = 0; i < MTE_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = (((uint32) ~(test_data+1) << 16) + (uint32) (~test_data));
         test_data += 2;
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         if (us_success==0)   gs_error_count++;
      }
   }

   // End of Tests
   if (gs_error_count==0) {
      return(SUCCEED);
   }
   else {
      return(FAIL);
   }

}
/****************************************************************/

int16 Test_Danube_FCI_RAM(void)
{

#define FCI_RAM_COUNT_16BITS  6
#define FCI_RAM_COUNT_32BITS  2

int16 ram_addr_16bits[FCI_RAM_COUNT_16BITS] = {
   (int16)ZEP_RAM_TX_FRAMEBUFFER_ADDR,
   (int16)ZEP_RAM_RX_FRAMEBUFFER_ADDR,
   (int16)ZEP_RAM_RX_LP0_CW_BUF_ADDR,
   (int16)ZEP_RAM_RX_LP1_CW_BUF_ADDR,
   (int16)ZEP_RAM_RX_METRIC_FIFO_BUF_ADDR,
    (int16)ZEP_RAM_RX_DEBUG_NW_COEFF_BUF_ADDR
};

int16 ram_size_16bits[FCI_RAM_COUNT_16BITS] = {
   (int16) 0x100,
   (int16) 0x200,
   (int16) 0x80,
   (int16) 0x80,
   (int16) 0x200,
   (int16)  0x80
};

int16 ram_mask_16bits[FCI_RAM_COUNT_16BITS] = {
   (int16) 0xff,
   (int16) 0xff,
   (int16) 0xffff,
   (int16) 0xffff,
   (int16) 0xff,
    (int16) 0xffff
};

int16 ram_addr_32bits[FCI_RAM_COUNT_32BITS] = {
    (int16)ZEP_RAM_TX_INTERLV_BUF_ADDR,
   (int16)ZEP_RAM_RX_INTERLV_BUF_ADDR
};

int16 ram_size_32bits[FCI_RAM_COUNT_32BITS] = {
   (int16) ZEP_RAM_TX_INTERLV_BUF_SIZE,
   (int16) ZEP_RAM_RX_INTERLV_BUF_SIZE
};

int32 ram_mask_32bits[FCI_RAM_COUNT_32BITS] = {
   (int32) 0xFFFFFFFF,
   (int32) 0xFFFFFFFF
};

   int16 i,j, us_version;
   int16 test_data = 0, test_data_inv=0;
   uint16 us_success = 0;
   int32 ul_Data;

    gs_error_count = 0;

   /* Write incrementing data to the RAMs
      Write the RAMs from bottom to top
   */
     ReadCoreReg((int16)ZEP_REG_VERSION_ADDR, (uint16 *)&us_version);
   if (us_version!=0x34) gs_error_count++;

   for (i = 0; i < FCI_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         WriteCoreReg((int16) (ram_addr_16bits[i] + j), ++test_data);
      }
   }

   // Read back the data that was written. Read the RAMs from top to bottom.
   // Invert the data in each location  after it is read.
   for (i = (FCI_RAM_COUNT_16BITS - 1); i >= 0; i--) {
      for (j = (ram_size_16bits[i] - 1); j >= 0; j--) {
         us_success=ReadCompareReg((int16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], test_data);
         WriteCoreReg((int16) (ram_addr_16bits[i] + j),(int16) (~test_data));
         test_data--;
         if (us_success==0)   gs_error_count++;
      }
   }

   /* Verify the inverse data that was written */

   for (i = 0; i < FCI_RAM_COUNT_16BITS; i++) {
      for (j = 0; j < ram_size_16bits[i]; j++) {
         test_data++;
         us_success=ReadCompareReg((int16) (ram_addr_16bits[i] + j), ram_mask_16bits[i], (int16) (~test_data));
         if (us_success==0)   gs_error_count++;
      }
   }

   /*  Now test the 32-bit memory locations in the zephyr core. */

   test_data = 1;
   for (i = 0; i < FCI_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = ((uint32) (test_data + 1) << 16) + (uint32) test_data;
         test_data += 2;
         WriteCoreReg32((uint16) (ram_addr_32bits[i]+j), ul_Data);
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         if (us_success==0)   gs_error_count++;
      }
   }

   test_data -= 2;
   for (i = (FCI_RAM_COUNT_32BITS - 1); i >= 0; i--) {
      for (j = (ram_size_32bits[i] - 1); j >= 0; j--) {

         ul_Data = ((uint32) (test_data + 1) << 16) + (uint32) test_data;
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);

         ul_Data = ((uint32) ~(test_data+1) << 16) + (uint32) (~test_data);
         WriteCoreReg32((uint16)(ram_addr_32bits[i]+j), ul_Data);

         test_data -= 2;
         if (us_success==0)   gs_error_count++;
      }
   }

   test_data += 2;
   for (i = 0; i < FCI_RAM_COUNT_32BITS; i++) {
      for (j = 0; j < ram_size_32bits[i]; j++) {
         ul_Data = ((uint32) ~(test_data+1) << 16) + (uint32) (~test_data);
         test_data += 2;
         us_success=ReadCompareReg32((int16) ram_addr_32bits[i], j, ram_mask_32bits[i], ul_Data);
         if (us_success==0)   gs_error_count++;
      }
   }

   /* =============================================== */
   /* End of Tests                              */
   /* =============================================== */
   if (gs_error_count==0) {
      return(SUCCEED);
   }
   else {
      return(FAIL);
   }
}

/****************************************************************/
int16 Test_Danube_Loopback(void)
 {
#ifndef AMAZON_SE
   int16 i, i_config, us_word, us_success;
   int16 us_data;
   int16 cri_data;
   uint8 TxFrameBuffer[64], RxFrameBuffer[64]; /* Test Related Arrays */
   tx_params tx;                          /* structure for setup routines */
   rx_params rx;                          /* structure for setup routines */

   gs_error_count=0;

     for (i_config = 0; i_config < (int16) NUMBER_CONFIGURATIONS; i_config++) {//

   /* ============================================================== */
   /*  ******************  Start Test Code ************************* */
   /* ============================================================== */

   /* initialize the arrays */
   for (i=0; i<64; i++)
      TxFrameBuffer[i] = 0;

   for (i=0; i<64; i++)
      RxFrameBuffer[i] = 0;

   /* constant settings in the tx and rx structures */
   tx.s_FramingMode = rx.s_FramingMode = framingmode;
   tx.s_R1 = rx.s_R1 = checkbytes1;
   tx.s_R0 = rx.s_R0 = checkbytes0;
   tx.s_Dp0 = rx.s_Dp0 = depth0;
   tx.s_Dp1 = rx.s_Dp1 = depth1;
   tx.s_Mp0 = rx.s_Mp0 = Mp0;
   tx.s_Mp1 = rx.s_Mp1 = Mp1;

   tx.s_Tp[0] = rx.s_Tp[0] = Tp0;
   tx.s_Tp[1] = rx.s_Tp[1] = Tp1;

   tx.s_Lp1_en = rx.s_Lp1_en = enablelp1;
   tx.s_Lp0_en = rx.s_Lp0_en = enablelp0;
   tx.scrambleren0 = rx.scrambleren0 = scramble_enable0;
   tx.scrambleren1 = rx.scrambleren1 = scramble_enable1;

   tx.crcenable0 = rx.crcenable0 = crc_enable0;
   tx.crcenable1 = rx.crcenable1 = crc_enable1;

   tx.s_IBitslp = rx.s_IBitslp = IBitslp;
   tx.s_MSGc = rx.s_MSGc = MSGc;

   tx.sa_BC0_Bytes = rx.sa_BC0_Bytes = BC0bytes;
   tx.sa_BC1_Bytes = rx.sa_BC1_Bytes = BC1bytes;

   tx.sa_BC0_lpath = rx.sa_BC0_lpath = BC0_lpath;
   tx.sa_BC1_lpath = rx.sa_BC1_lpath = BC1_lpath;
   tx.s_trellis = rx.s_trellis = trellis;
   tx.ifft128 = ifft128;

   /* set rest of the parameters */
   set_tx_params(&tx);
   set_rx_params(&rx);

   /*****************************************/
   /* CRI clocks relevant cores */
   /*****************************************/
   /* enable AC_CLK - must be set before we can access any ADSL memory */
      WriteCoreReg(CRI_CCR0_ADDR,(uint16)0x0010);

   /*-------------------------------------
   Set up Iridia RAMs
   -------------------------------------*/
   if(!configure_iridia_rams(&rx, &tx))
      return(FAIL);

   /*-------------------------------------
   Write the Zephyr/Iridia TX and RX registers.
   -------------------------------------*/
   write_azi_tx_registers(&tx);
   write_azi_rx_registers(&rx);
   /*-------------------------------------
   Initialize Ilv/Dilv registers.
   -------------------------------------*/
     TX_FIFO_Init(&tx);
   RX_FIFO_Init(&rx);

     WriteCoreReg(CRI_UPDCTL_ADDR,0xA); // continuous update for A registers

   /*------------------------------------------------------------
         Load the Tx Zephyr Frame Buffer
   ------------------------------------------------------------*/
   for (i=0; i < (BC0bytes + BC1bytes); i++)
      WriteCoreReg((uint16) (ZEP_RAM_TX_FRAMEBUFFER_ADDR + i),  i );

   // clear the unused part of the Tx frame buffer
   for (i=(BC0bytes + BC1bytes); i<64; i++)
      WriteCoreReg((int16)(ZEP_RAM_TX_FRAMEBUFFER_ADDR+i), 0);

   /* Clear Rx output frame buffer */
   for (i=0; i<64; i++)
      WriteCoreReg((int16)(ZEP_RAM_RX_FRAMEBUFFER_ADDR+i), 0);


   /*****************************************/
   /* CRI clocks relevant cores */
   /*****************************************/
   /* enable FCI_TX/RX_CLK and MTE_TX/RX_CLK*/
     WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x0550);

   /* Clear Event Register */
   SetCoreReg(CRI_EVENT1_ADDR, (1<<CRI_FCI_TX_DONE)); /* Clear Zephyr TX Done Event Bit */
   SetCoreReg(CRI_EVENT1_ADDR, (1<<CRI_MTE_TCE_DONE));   /* Clear Iridia Tx Enc Done Event Bit */

   /* Start the Transmit path through Zephyr and Iridia */
   start_transmit();

      do {
   // ClockCores(1);
      ReadCoreReg(CRI_EVENT1_ADDR, &cri_data);
      if(cri_data & (1<<CRI_FCI_TX_DONE)) break;
      /* If Zephyr TX Done , break */
   } while (1);



   // Register Start Iridia TCE by setting IT_CTRL  bit
    SetCoreReg(IRI_REG_IT_CTRL_ADDR, IRI_QAM_ENCODE_START); /* start QAM encoding */

   do {
      //ClockCores(1); /* Cocomo Codes*/
      ReadCoreReg(CRI_EVENT1_ADDR, &cri_data);
      if(cri_data & (1<<CRI_MTE_TCE_DONE)) break;        // If Iridia Tx Enc done, break
        } while(1);


   /* Now copy IFFT buffers to FFT buffers */
   copy_ifft_to_fft(i_config);


   /* Clear Event Registers */
   SetCoreReg(CRI_EVENT0_ADDR, (1<<CRI_FCI_RX_DONE)); /* Clear Zephyr RX Done Event Bit */


   /* Simulate the Receive path through Iridia and Zephyr  */
   start_receive();


   /* enable MTE_RX_CLK */
   //WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x0100);
   do {
   //    ClockCores(1);    /* Cocomo Codes*/
         ReadCoreReg(CRI_EVENT0_ADDR, &us_data);
         if(us_data & (1<<CRI_MTE_RCD_DONE)) break;         /* If Iridia RX RCD done, break */
   } while(1);

   //FCI register start
     ReadCoreReg(ZEP_REG_ZR_LINE_ADDR, &us_word);
   us_word|=0x0018;
     WriteCoreReg(ZEP_REG_ZR_LINE_ADDR, us_word);

   /* enable FCI_RX_CLK */
   //WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x0010);
   do {
   //    ClockCores(1);
      ReadCoreReg(CRI_EVENT0_ADDR, &us_data);
      if(us_data & (1<<CRI_FCI_RX_DONE)) break;       /* If Zephyr RX done, break */
   } while(1);

   // Socrates does not allow word writes to word unaligned addresses
   // write to an intermediate word location, mask off the upper byte,
   // and write the lower byte into the byte array in the stack
   for (i=0; i < 64; i++) {
      ReadCoreReg((uint16) (ZEP_RAM_TX_FRAMEBUFFER_ADDR + i), (uint16 *) &us_data);
      TxFrameBuffer[i] = (uint8) us_data;
   }

   // temporary debug
   for (i=0; i < 64; i++) {
      ReadCoreReg((uint16) (ZEP_RAM_RX_FRAMEBUFFER_ADDR + i), (uint16 *) &us_data);
      RxFrameBuffer[i] = (uint8) us_data;
   }

   if ((depth0==1) || (depth1==1))
   for (i=0; i< 64 ; i++){
      us_success=ReadCompareReg((int16)(ZEP_RAM_RX_FRAMEBUFFER_ADDR+i), (int16)0xFFFF, TxFrameBuffer[i]);
      if  (us_success==0) gs_error_count++;
   }

     else if((depth0==2) || (depth1==2))
      for (i=0; i<BC0bytes-2; i++){
         us_success=ReadCompareReg((int16)(ZEP_RAM_RX_FRAMEBUFFER_ADDR+i), (int16)0xFFFF, TxFrameBuffer[i]);
      if  (us_success==0) gs_error_count++;
   }

   /* =============================================== */
   /* End of Tests                           */
   /* =============================================== */
     }
   if (gs_error_count==0) {
      return(SUCCEED);
   }
   else {
      return(FAIL);
   }
#else //AMAZON_SE
   return(FAIL);
#endif
}


/*****************************************************************************
;  Prototype: int16 ReadCompareReg(int16 addr, uint16 mask, int16 expect)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

int16 ReadCompareReg(uint16 addr, uint16 mask, int16 expect)
{
    int16 data, expected;

   // Read register/RAM
   ReadCoreReg((uint16)addr, (uint16 *)&data);
   //ReadCoreBuf((uint16)addr, &data, 1, 1);

   // Mask both expected and read back data
   expected = expect & mask;
    data = data & mask;

   // Compare
   if (data != expected)
    {
      return FAIL;
    }
   else{
      return SUCCEED;
   }
}

/*****************************************************************************
;  Prototype: int16 ReadCompareReg32(int16 us_BaseAddr, int16 us_Offset, uint32 mask, int32 us_ExpectedData)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

int16 ReadCompareReg32(uint16 us_BaseAddr, uint16 us_Offset, uint32 mask, int32 ul_ExpectedData)
{
   int32 data32 = (int32) 0;
   int32 expected = (int32) (ul_ExpectedData & mask);

   // Read register/RAM Buffer
     ReadCoreReg32((uint16)(us_BaseAddr+us_Offset), &data32);

   // Mask both expected and read back data
   data32 = data32 & mask;

   // Compare
   if (data32 != expected)
      return(FAIL);
   else
      return(SUCCEED);
}

/****************************************************************************
; Name: set_tx_params
;
; Prototype:
;  void set_tx_params(tx_params *tx)
;
; Description:
;  This function calculates some of the tx related parameters from parameter
;  that are set by user.
; Arguments:
;
;  Return Value:
*****************************************************************************/

void set_tx_params(tx_params *tx)
{
   int16 s_MuxFrameSize0 = 0;
    int16 s_MuxFrameSize1 = 0;

   if(tx->sa_BC0_Bytes)
   {
      if(tx->sa_BC0_lpath == 0)
         s_MuxFrameSize0 +=  (tx->sa_BC0_Bytes + 1);
      else
         s_MuxFrameSize1 +=  (tx->sa_BC0_Bytes + 1);
   }

   if(tx->sa_BC1_Bytes)
   {
      if(tx->sa_BC1_lpath == 0)
         s_MuxFrameSize0 +=  (tx->sa_BC1_Bytes + 1);
      else
         s_MuxFrameSize1 +=  (tx->sa_BC1_Bytes + 1);
   }

   tx->s_Codewordsize0 = s_MuxFrameSize0 * (uint8)tx->s_Mp0 + tx->s_R0;
   tx->s_Codewordsize1 = s_MuxFrameSize1 * tx->s_Mp1 + tx->s_R1;


   tx->s_Codewordsize_Odd0 = tx->s_Codewordsize0 + 1-((tx->s_Codewordsize0)&1);
   tx->s_Codewordsize_Odd1 = tx->s_Codewordsize1 + 1-((tx->s_Codewordsize1)&1);

   /* for now */
   tx->s_Lp0 = (tx->s_Codewordsize0) * 8  * tx->s_Dp0;
   tx->s_Lp1 = (tx->s_Codewordsize1) * 8  * tx->s_Dp1;
    tx->transfersize0 = tx->s_Codewordsize0;
   tx->transfersize1 = tx->s_Codewordsize1;

   gs_TxNumTones = 32 + (tx->ifft128)*32;

}

/****************************************************************************
; Name: set_rx_params
;
; Prototype:
;  void set_rx_params(rx_params *rx)
;
; Description:
;  This function calculates some of the rx related parameters from parameters
;  that are set by user.
;
; Arguments:
;
;  Return Value:
*****************************************************************************/
int16 s_muxrx0;
int16 s_muxrx1;

void set_rx_params(rx_params *rx) {

   /* receive settings */
    int16 s_MuxFrameSize0 = 0;
    int16 s_MuxFrameSize1 = 0;

   if(rx->sa_BC0_Bytes)
   {
      if(rx->sa_BC0_lpath == 0)
         s_MuxFrameSize0 +=  (rx->sa_BC0_Bytes + 1);
      else
         s_MuxFrameSize1 +=  (rx->sa_BC0_Bytes + 1);
   }

   if(rx->sa_BC1_Bytes)
   {
      if(rx->sa_BC1_lpath == 0)
         s_MuxFrameSize0 +=  (rx->sa_BC1_Bytes + 1);
      else
         s_MuxFrameSize1 +=  (rx->sa_BC1_Bytes + 1);
   }

   s_muxrx0 = s_MuxFrameSize0;
   s_muxrx1 = s_MuxFrameSize1;


   rx->s_Codewordsize0 = s_MuxFrameSize0 * rx->s_Mp0 + rx->s_R0;
   rx->s_Codewordsize1 = s_MuxFrameSize1 * rx->s_Mp1 + rx->s_R1;

   rx->s_Codewordsize_Odd0 = rx->s_Codewordsize0 + 1-((rx->s_Codewordsize0)&1);
   rx->s_Codewordsize_Odd1 = rx->s_Codewordsize1 + 1-((rx->s_Codewordsize1)&1);


   /* for now */
   rx->s_Lp0 = (rx->s_Codewordsize0) * 8 * rx->s_Dp0;
   rx->s_Lp1 = (rx->s_Codewordsize1) * 8 * rx->s_Dp1;

    rx->transfersize0 = rx->s_Codewordsize0;
   rx->transfersize1 = rx->s_Codewordsize1;


   gs_RxNumTones = gs_TxNumTones;
   gus_Rx_MinToneIndx = 0;
   gus_Rx_MaxToneIndx = gs_RxNumTones - 1;
}
/****************************************************************************
; Name: configure_iridia_rams
;
; Prototype:
;  int16 configure_iridia_rams(rx_params *rx, tx_params *tx)
;
; Description:
;    This function calculates BAT/GAIN/TRT table values, FDQ Mantissa/Exponent coeffcients
;  for both RX/TX and writes to the corresponding RAM.
;
; Arguments:
;
;  Return Value:
*****************************************************************************/
int16 configure_iridia_rams(rx_params *rx, tx_params *tx)
{
#ifndef AMAZON_SE
   int16 i;

   int16 mte_tgs_data[IRI_RAM_TX_GAINSCALE_SIZE],
      mte_tfineg_data[IRI_RAM_TX_GAINSCALE_SIZE],
      mte_trt_data[IRI_RAM_TX_TONEREORDER_SIZE],
      mte_trt_tcm_data[IRI_RAM_TX_TONEREORDER_SIZE],
      mte_tbat_data[IRI_RAM_TX_BITALLOC_SIZE],
      mte_rrt_data[IRI_RAM_RX_TONEREORDER_SIZE],
      mte_rbat_data[IRI_RAM_RX_BITALLOC_SIZE],
      mte_rgs_data[IRI_RAM_RX_GAINSCALE_SIZE],
      mte_fdqm_data[IRI_RAM_RX_FDQ_MANTISSA_SIZE],
      mte_fdqe_data[IRI_RAM_RX_FDQ_EXPONENT_SIZE],
      mte_ifft_data[IRI_RAM_TX_IFFT_A0_SIZE];


   /* Write data into the Bit Allocation Table. Use constellation sizes
   from 0 to 15 to test the whole range of shifts/constellations.
   Make sure the BAT entries do not use more data than is available. */

   /* clear buffer in case we do not use all the entries
   * (the Socrates RTL verification environment requires that any memory read from but not written to must
   * be initialized to 0) */

   for(i = 0; i < IRI_RAM_TX_BITALLOC_SIZE; i++)
         mte_tbat_data[i] = 0;

   if(!mte_calcBATSetFineGains((FlagT) tx->s_trellis, (int16)(tx->s_Lp0 + tx->s_Lp1), gs_ConstSize,0, (int16)(gs_TxNumTones), (int16) gs_Num1bits, mte_tbat_data, mte_tfineg_data))
      return(FAIL);

   /* Tone ReOrdering */
   mte_toneOrdering(mte_tbat_data,(int16)gs_TxNumTones ,TX_MAX_BITS_PER_TONE,mte_trt_data);
   if(((FlagT) tx->s_trellis) && gs_Num1bits)
      mte_toneOrdering_tcm(mte_tbat_data, mte_trt_data, gs_TxNumTones, mte_trt_tcm_data,&gus_Tx_Tcm_Num1bits,(FlagT *)&gft_Tx_Tcm_X0_YGT1,&gus_Rx_MinToneIndx );

   /* SetUp TCM related Variables*/
   gus_Tx_1Bit_Index = gs_TxNumTones - gus_Tx_Tcm_Num1bits;
   gus_Rx_Tcm_Num1bits = gus_Tx_Tcm_Num1bits;
   gft_Rx_Tcm_X0_YGT1 = gft_Tx_Tcm_X0_YGT1;
   gus_Rx_1Bit_Index = gus_Tx_1Bit_Index;

   /* Set RX bat to match TX bat for loopback */
   for (i = 0; i < IRI_RAM_RX_BITALLOC_SIZE; i++) {
      if (i < IRI_RAM_TX_BITALLOC_SIZE)
         mte_rbat_data[i] = mte_tbat_data[i];
      else
         mte_rbat_data[i] = 0;
   }

   /* Now write data into the Tx Gain Scale Memory. */
   for (i=0; i < IRI_RAM_TX_GAINSCALE_SIZE; i++) {
      mte_tgs_data[i] = 0x2000;                 /* fine gain */
      mte_rgs_data[i] = 0x2000;                 /* fine gain */
   }

   /* Now write data into the Tx,Rx Gain Scale Memory. */
   if(1)
   {
      for (i=0; i < IRI_RAM_TX_GAINSCALE_SIZE; i++) {
         mte_tgs_data[i] = gsa_QAMEncConstGainMantissa[mte_tbat_data[i]];
         mte_rgs_data[i] = gsa_QAMDecConstGainMantissa[mte_tbat_data[i]];
      }
   }
   else
   {
   // mte_calcEncodGain(gs_TxNumTones, mte_tbat_data, mte_tfineg_data, mte_tgs_data);
   // mte_calcDecodGain(gs_RxNumTones, mte_rbat_data, mte_tfineg_data, mte_rgs_data);
   }


   for (i=IRI_RAM_TX_GAINSCALE_SIZE; i < IRI_RAM_RX_GAINSCALE_SIZE; i++)
      mte_rgs_data[i] = 0;

   for (i=gs_TxNumTones; i < IRI_RAM_TX_TONEREORDER_SIZE; i++)
      mte_trt_data[i] = i;

   if((tx->s_trellis) && (gs_Num1bits >0))
   {
      for (i=gs_TxNumTones; i < IRI_RAM_TX_TONEREORDER_SIZE; i++)
         mte_trt_tcm_data[i] = i;
   }

   for (i = 0; i < IRI_RAM_RX_TONEREORDER_SIZE; i++) {
      if (i < IRI_RAM_TX_TONEREORDER_SIZE)
      {
         if(((FlagT) tx->s_trellis) && gs_Num1bits)
            mte_rrt_data[i] = mte_trt_tcm_data[i];
         else
            mte_rrt_data[i] = mte_trt_data[i];
      }
      else
         mte_rrt_data[i] = i;
   }

   /* Set up the Rx FDQ mantissa/exponent for unity (R=1,I=0) */
   for (i=0; i < IRI_RAM_RX_FDQ_MANTISSA_SIZE; i++)
      mte_fdqm_data[i] = (i&1) ? 0 : 0x1000;

   for (i=0; i < IRI_RAM_RX_FDQ_EXPONENT_SIZE; i++)
      mte_fdqe_data[i] = 1;


   /* Transmit RAMs */
   //WriteCoreBuf(IRI_RAM_TX_GAINSCALE_ADDR,mte_tgs_data,IRI_RAM_TX_GAINSCALE_SIZE,1);
   for (i=0; i <IRI_RAM_TX_GAINSCALE_SIZE ; i++)
      WriteCoreReg(IRI_RAM_TX_GAINSCALE_ADDR+i,mte_tgs_data[i]);

   //This loopback test assumes 9-bit consterllation for each tone.
   if(((FlagT) tx->s_trellis) && gs_Num1bits){
      //WriteCoreBuf(IRI_RAM_TX_TONEREORDER_ADDR,mte_trt_tcm_data,IRI_RAM_TX_TONEREORDER_SIZE,1);
      for (i=0; i <IRI_RAM_TX_TONEREORDER_SIZE ; i++)
         WriteCoreReg(IRI_RAM_TX_TONEREORDER_ADDR+i,mte_trt_tcm_data[i]);
   }
      else {
      //WriteCoreBuf(IRI_RAM_TX_TONEREORDER_ADDR,mte_trt_data,IRI_RAM_TX_TONEREORDER_SIZE,1);
      for (i=0; i <IRI_RAM_TX_TONEREORDER_SIZE ; i++)
         WriteCoreReg(IRI_RAM_TX_TONEREORDER_ADDR+i,mte_trt_data[i]);
   }
   //WriteCoreBuf(IRI_RAM_TX_BITALLOC_ADDR,mte_tbat_data,IRI_RAM_TX_BITALLOC_SIZE,1);
   for (i=0; i <IRI_RAM_TX_BITALLOC_SIZE ; i++)
         WriteCoreReg(IRI_RAM_TX_BITALLOC_ADDR+i,mte_tbat_data[i]);

   /* Receive RAMs */
   //WriteCoreBuf(IRI_RAM_RX_TONEREORDER_ADDR,mte_rrt_data,IRI_RAM_RX_TONEREORDER_SIZE,1);
   for (i=0; i <IRI_RAM_RX_TONEREORDER_SIZE ; i++)
         WriteCoreReg(IRI_RAM_RX_TONEREORDER_ADDR+i,mte_rrt_data[i]);
   //WriteCoreBuf(IRI_RAM_RX_BITALLOC_ADDR,mte_rbat_data,IRI_RAM_RX_BITALLOC_SIZE,1);
   for (i=0; i < IRI_RAM_RX_BITALLOC_SIZE; i++)
         WriteCoreReg(IRI_RAM_RX_BITALLOC_ADDR+i,mte_rbat_data[i]);
   //WriteCoreBuf(IRI_RAM_RX_GAINSCALE_ADDR,mte_rgs_data,IRI_RAM_RX_GAINSCALE_SIZE,1);
   for (i=0; i < IRI_RAM_RX_GAINSCALE_SIZE; i++)
         WriteCoreReg(IRI_RAM_RX_GAINSCALE_ADDR+i,mte_rgs_data[i]);
   //WriteCoreBuf(IRI_RAM_RX_FDQ_MANTISSA_ADDR,mte_fdqm_data,IRI_RAM_RX_FDQ_MANTISSA_SIZE,1);
   for (i=0; i < IRI_RAM_RX_FDQ_MANTISSA_SIZE; i++)
         WriteCoreReg(IRI_RAM_RX_FDQ_MANTISSA_ADDR+i,mte_fdqm_data[i]);
   //WriteCoreBuf(IRI_RAM_RX_FDQ_EXPONENT_ADDR,mte_fdqe_data,IRI_RAM_RX_FDQ_EXPONENT_SIZE,1);
   for (i=0; i < IRI_RAM_RX_FDQ_EXPONENT_SIZE; i++)
         WriteCoreReg(IRI_RAM_RX_FDQ_EXPONENT_ADDR+i,mte_fdqe_data[i]);

   /* clear the IFFT buffers in case we do not use all the entries
   * (the Socrates RTL verification environment requires that any memory read from but not written to must
   * be initialized to 0) */

   // clear the A buffer
   for(i=0; i<IRI_RAM_TX_IFFT_A0_SIZE; i++) {
      mte_ifft_data[i] = 0;
      WriteCoreReg(IRI_RAM_TX_IFFT_A0_ADDR+i,mte_ifft_data[i]);
    }
      //WriteCoreBuf(IRI_RAM_TX_IFFT_A0_ADDR, mte_ifft_data, IRI_RAM_TX_IFFT_A0_SIZE, 1);

   // clear the B buffer
   for(i=0; i<IRI_RAM_TX_IFFT_B0_SIZE; i++)  {
      mte_ifft_data[i] = 0;
      WriteCoreReg(IRI_RAM_TX_IFFT_B0_ADDR+i,mte_ifft_data[i]);
   }
      //WriteCoreBuf(IRI_RAM_TX_IFFT_B0_ADDR, mte_ifft_data, IRI_RAM_TX_IFFT_B0_SIZE, 1);

   //}
   return(SUCCEED);
#else //AMAZON_SE
   return(FAIL);
#endif
}

/****************************************************************************
; Name: write_azi_tx_registers
;
; Prototype:
;  void write_azi_tx_registers(tx_params *tx)
;
; Description:
;
;
; Arguments:
;
;  Return Value:
*****************************************************************************/

void write_azi_tx_registers(tx_params *tx)
{
#ifndef AMAZON_SE
   uint16 us_data,us_tmp;

            /*****  IT_LP0_BITS *****/
            us_data = (uint16)(tx->s_Lp0);
            WriteCoreReg (IRI_REG_IT_LP0_BITS_ADDR, us_data);

            WriteCoreReg (IRI_REG_IT_ALP0_BITS_ADDR, us_data);

            /*****  IT_LP1_BITS *****/
            us_data = (uint16)(tx->s_Lp1);
            WriteCoreReg (IRI_REG_IT_LP1_BITS_ADDR, us_data);

            WriteCoreReg (IRI_REG_IT_ALP1_BITS_ADDR, us_data);

            /*****  IT_DUMMY *****/
            us_data = 0;
            WriteCoreReg (IRI_REG_IT_DUMMY_ADDR, us_data);

            /*****  IT_MISC *****/
            ReadCoreReg(IRI_REG_IT_MISC_ADDR, &us_data);
            if(tx->s_trellis == 1) {
               us_data |= (1<<6);
            }
            if(tx->ifft128 == 1)
               us_data |= (1<<14);

            WriteCoreReg(IRI_REG_IT_MISC_ADDR, us_data);

            /*********IT_TCM_CTRL ************/
            ReadCoreReg(IRI_REG_IT_TCM_CTRL_ADDR, &us_data);
            gus_Tx_1Bit_Index = gs_TxNumTones - gus_Tx_Tcm_Num1bits;

            us_data = (gus_Tx_1Bit_Index & 0x3F) | (((gus_Tx_Tcm_Num1bits/2)&0x3F) <<6);
            if(gft_Tx_Tcm_X0_YGT1 == 1)
               us_data |= 1<<12;

            WriteCoreReg(IRI_REG_IT_TCM_CTRL_ADDR, us_data);

            /*****  ZEP_REG_ZT_LINE_ADDR *****/
            us_data =   (tx->s_Lp1_en << 12) |  /* TxLP1_En = 0 */
               (tx->s_Lp0_en << 11) |  /* TxLP0_En = 0 */
               (tx->scrambleren1 << 10)   |  /* Tx_ScramblerEnable1 = 1 */
               (tx->scrambleren0 << 9)    |  /* Tx_ScramblerEnable0 = 1 */
               (tx->crcenable1 << 8)   |  /* Tx_CRCEnable1 = 1 */
               (tx->crcenable0 << 7)   |  /* Tx_CRCEnable0 = 1 */
               (0 << 6) |  /* Tx_BadCRC1 = 0 */
               (0 << 5) |  /* Tx_BadCRC0 = 0 */
               (0 << 4) |  /* FCI_GoTx = 0 */
               (0 << 3) |  /* GoTx_Sel = 0 */
               (tx->s_FramingMode << 0); /* Tx_FrameMode = gt_TxShowTimeVars.pt_Config->s_FramingMode */
            if(tx->s_IBitslp == 1)
               us_data |= (1 << 14);
            else
               us_data |= (0 << 14);
            if(tx->s_MSGc == 1)
               us_data |= (1 << 13);
            else
               us_data |= (0 << 13);
            WriteCoreReg (ZEP_REG_ZT_LINE_ADDR, us_data);

            /*****  ZEP_REG_ZT_BC0_ADDR *****/
            if(tx->sa_BC0_Bytes ) {
               us_data = 1;                        /* Enable Transmission on LS0 */
               // if(gt_TxShowTimeVars.t_BCParms[0].sa_BC_LPath == LP1_DATA_PATH) {
               //    us_data |= (1 << 1);                /* Latency path 1 */
               // } birsen
            } else {
               us_data = 0;
            }
            WriteCoreReg (ZEP_REG_ZT_BC0_ADDR, us_data);

            /*****  ZEP_REG_ZT_BC1_ADDR *****/
            if(tx->sa_BC1_Bytes) {
               us_data = 1;
               if(tx->sa_BC1_lpath == 1) {
                  us_data |= (1 << 1);                /* Latency path 1 */
               }
               //if(gt_TxShowTimeVars.t_BCParms[1].sa_BC_LPath == LP1_DATA_PATH) {
               // us_data |= (1 << 1); /* Latency path 1 */
               //}
            } else {
               us_data = 0;
            }
            WriteCoreReg (ZEP_REG_ZT_BC1_ADDR, us_data);

            /*****  ZEP_REG_ZT_FB0_ADDR *****/
            if(tx->sa_BC0_Bytes) {
               /* compute the end address */
               us_data  =  tx->sa_BC0_Bytes - 1; /* end address is one less than the no. of bytes */
               if (tx->s_Tp[tx->sa_BC0_lpath] > 1) {
                  us_data += 1;  /* for stuffing and robbing */
               }
               us_tmp   =  (us_data + 1); /* us_tmp is used to set ZT_FB1_ADDR */
            } else {
               us_tmp = us_data = 0;
            }
            WriteCoreReg (ZEP_REG_ZT_FB0_ADDR, (uint16)(us_data << 8));


            /*****  ZEP_REG_ZT_FB1_ADDR *****/
            us_data = us_tmp;
            if(tx->sa_BC1_Bytes) {
               us_data += (tx->sa_BC1_Bytes - 1);
               if (tx->s_Tp[tx->sa_BC1_lpath] > 1) {
                  us_data += 1; /* for stuffing and robbing */
               }
            }
            us_data = (us_data << 8) | us_tmp;
            WriteCoreReg (ZEP_REG_ZT_FB1_ADDR, us_data);

            /*****  ZEP_REG_ZT_EOC_ADDR *****/
            if(tx->s_FramingMode < 4) {         /* g.dmt framing mode   */
               us_data = 0x0C;   /* bit 1 reserved for future use */
            } else if(tx->s_FramingMode == 4) { /* g.bis framing mode   */
               /* us_data should be set to hdlc message byte */
               us_data = 0x7E;
            } else {                                        /* Bypass mode          */
               /* us_data contains LP0 and LP1 framing byte */
               us_data = 0;
            }
            WriteCoreReg (ZEP_REG_ZT_EOC_ADDR, us_data);

            /***** ZEP_REG_ZT_AOC_ADDR *****/
            if(tx->s_FramingMode < 4) {         /* g.dmt framing mode   */
               us_data = 0;
            } else if(tx->s_FramingMode == 4) { /* g.bis framing mode   */
               us_data = 0xFFFF;
            }
            WriteCoreReg (ZEP_REG_ZT_AOC_ADDR, us_data);

            /***** ZEP_REG_ZT_IBITSL_ADDR *****/
            if(tx->s_FramingMode < 4) {         /* g.dmt framing mode   */
               /* if G992_2, bit 14 should be set to 0, as there is no cell delineation at start */
               /* bit 15 is reserved and hence is set to 1 */
               us_data = 0xbfff;

            } else if(tx->s_FramingMode == 4) { /* g.bis framing mode   */
               us_data = 0x1F00;
            }
            WriteCoreReg (ZEP_REG_ZT_IBITSL_ADDR, us_data);

            /***** ZEP_REG_ZT_IBITSH_ADDR *****/
            if(tx->s_FramingMode < 4) {   /* g.dmt framing mode   */
               us_data = 0xFF;
            } else if(tx->s_FramingMode == 4) { /* g.bis framing mode   */
               us_data = 0xFFF;
            }
            WriteCoreReg (ZEP_REG_ZT_IBITSH_ADDR, us_data);

            /*****  ZEP_REG_ZT_CODEWORD_ADDR *****/
            us_data = (uint16)((tx->s_Codewordsize1 << 8) |
               (tx->s_Codewordsize0));
            WriteCoreReg (ZEP_REG_ZT_CODEWORD_ADDR, us_data);

            /*****  ZEP_REG_ZT_CHECKBYTE_ADDR *****/
            us_data = 0;
            us_data |= (uint16)(((tx->s_R1 & 0x1F) << 8) |
               (tx->s_R0 & 0x1F));
            WriteCoreReg (ZEP_REG_ZT_CHECKBYTE_ADDR, us_data);

            /*****  ZEP_REG_ZT_IDEPTH_ADDR *****/
#ifdef INF_CPE
            us_data = (uint16)((tx->s_Dp1 << 9) |
               (tx->s_Dp0));
#else
            us_data = (uint16)((tx->s_Dp1 << 8) |
               (tx->s_Dp0));
#endif
         //WriteCoreReg (ZEP_REG_ZT_IDEPTH_ADDR, us_data);


            /*****  ZEP_REG_ZT_FRAME_LP0_ADDR *****/
            if(tx->s_FramingMode < 4) {   /* g.dmt framing mode   */
               us_data = (uint16)((tx->s_MSGc + 6 - 1) << 8);
            }
            else if(tx->s_FramingMode == 4)
            {
               /* g.bis framing mode   */
               us_data = 0;//(uint16)gsa_tx_SEQp[LP0_DATA_PATH] - 1; birsen
               us_data <<= 8;
            }
            WriteCoreReg (ZEP_REG_ZT_FRAME_LP0_ADDR, us_data);

            /*****  ZEP_REG_ZT_FRAME_LP1_ADDR *****/
            if(tx->s_FramingMode < 4) {   /* g.dmt framing mode   */
               us_data = (uint16)((tx->s_MSGc + 6 - 1) << 8);
            } else if(tx->s_FramingMode == 4)
            {
               /* g.bis framing mode   */
               us_data =0;// (uint16)gsa_tx_SEQp[LP1_DATA_PATH] - 1; birsen
               us_data <<= 8;
            }
            WriteCoreReg (ZEP_REG_ZT_FRAME_LP1_ADDR, us_data);

            /*****  ZEP_REG_ZT_TP0_ADDR *****/
            us_data = (uint16)((tx->s_Tp[0]) << 8);
            WriteCoreReg (ZEP_REG_ZT_TP0_ADDR, us_data);

            /*****  ZEP_REG_ZT_TP1_ADDR *****/
            us_data = (uint16)((tx->s_Tp[1]) << 8);
            WriteCoreReg (ZEP_REG_ZT_TP1_ADDR, us_data);

            /*****  ZEP_REG_ZT_MFCW0_ADDR *****/
            us_data = (uint16)(tx->s_Mp0);
            WriteCoreReg (ZEP_REG_ZT_MFCW0_ADDR, us_data);

            /*****  ZEP_REG_ZT_MFCW1_ADDR *****/
            us_data = (uint16)(tx->s_Mp1);
            WriteCoreReg (ZEP_REG_ZT_MFCW1_ADDR, us_data);

            /*****  ZEP_REG_ZT_SCR_LO0_ADDR *****/
            WriteCoreReg (ZEP_REG_ZT_SCR_LO0_ADDR, 0);

            /*****  ZEP_REG_ZT_SCR_LO1_ADDR *****/
            WriteCoreReg (ZEP_REG_ZT_SCR_LO1_ADDR, 0);

            /*****  ZEP_REG_ZT_SCR_HI_ADDR *****/
            WriteCoreReg (ZEP_REG_ZT_SCR_HI_ADDR, 0);

            /*****  ZEP_REG_ZT_CRC_ADDR *****/
            WriteCoreReg (ZEP_REG_ZT_CRC_ADDR, 0);
#else
// this file does not fit in the swap page. Subtest must be be taken in and out when needed.
#endif AMAZON_SE
}


/****************************************************************************
; Name: write_azi_rx_registers
;
; Prototype:
;  void write_azi_rx_registers (rx_params *rx)
;
; Description:
;
;
; Arguments:
;
;  Return Value:
*****************************************************************************/

void write_azi_rx_registers (rx_params *rx) {
#ifndef AMAZON_SE
   uint16 us_data;


            /*****  IR_LP0_BITS *****/
            us_data = (uint16)(rx->s_Lp0);
            WriteCoreReg (IRI_REG_IR_LP0_BITS_ADDR, us_data);
            WriteCoreReg (IRI_REG_IR_ALP0_BITS_ADDR, us_data);

            /*****  IR_LP1_BITS *****/
            us_data = (uint16)(rx->s_Lp1);
            WriteCoreReg (IRI_REG_IR_LP1_BITS_ADDR, us_data);
            WriteCoreReg (IRI_REG_IR_ALP1_BITS_ADDR, us_data);

            /*****  IR_DUMMY *****/
            us_data = 0;
            WriteCoreReg (IRI_REG_IR_DUMMY_ADDR, us_data);

            /*****  IR_MISC *****/
            ReadCoreReg(IRI_REG_IR_MISC_ADDR, &us_data);
            if(rx->s_trellis == 1) {
               us_data |= (1<<6);
            }
            us_data |= (1<<5);   // set RGS_WD for ASIC test.
            WriteCoreReg(IRI_REG_IR_MISC_ADDR, us_data);


            /************ IR_TONES ************/
            WriteCoreReg(IRI_REG_IR_MIN_TONE_ADDR, gus_Rx_MinToneIndx);
            WriteCoreReg(IRI_REG_IR_MAX_TONE_ADDR, gus_Rx_MaxToneIndx);


            /*********IR_TCM_CTRL ************/

            gus_Rx_1Bit_Index = gs_RxNumTones - gus_Rx_Tcm_Num1bits;

            if(gft_Rx_Tcm_X0_YGT1 == TRUE){
               WriteCoreReg(IRI_REG_IR_NUM_1BIT_ADDR, 0);
               WriteCoreReg(IRI_REG_IR_1BIT_INDEX_ADDR, 0);
            }
            else
            {
               WriteCoreReg(IRI_REG_IR_NUM_1BIT_ADDR, (int16)(gus_Rx_Tcm_Num1bits/2));
               WriteCoreReg(IRI_REG_IR_1BIT_INDEX_ADDR, gus_Rx_1Bit_Index);
            }


            /*****  ZEP_REG_ZR_LINE_ADDR *****/
            us_data =   (rx->s_Lp1_en << 10) |  /* RxLP1_En = 0 */
               (rx->s_Lp0_en << 9)  |  /* RxLP0_En = 0 */
               (rx->scrambleren1 << 8)    |  /* Rx_DescramblerEnable1 = 1 */
               (rx->scrambleren0 << 7)    |  /* Rx_DescramblerEnable0 = 1 */
               (rx->crcenable1 << 6)   |  /* Rx_CRCEnable1 = 1 */
               (rx->crcenable0 << 5)   |  /* Rx_CRCEnable0 = 1 */
               (0 << 4) |  /* FCI_GoRx = 0 */
               (0 << 3) |  /* GoRx_Sel = 0 */
               ((uint8)rx->s_FramingMode << 0); /* Rx_FrameMode = gt_RxShowTimeVars.pt_Config->s_FramingMode */
            if(rx->s_IBitslp == 1)
               us_data |= (1 << 12);
            else
               us_data |= (0 << 12);
            if(rx->s_MSGc == 1)
               us_data |= (1 << 11);
            else
               us_data |= (0 << 11);
            WriteCoreReg (ZEP_REG_ZR_LINE_ADDR, us_data);

            /*****  ZEP_REG_ZR_BC0_ADDR *****/
            if(rx->sa_BC0_Bytes ) {
               us_data = 1;                        /* Enable Receive on AS0 */
               if(rx->sa_BC0_lpath == 1) {
                  us_data |= (1 << 1);                /* Latency path 1 */
               }
            } else {
               us_data = 0;
            }
            WriteCoreReg (ZEP_REG_ZR_BC0_ADDR, us_data);

            /*****  ZEP_REG_ZR_BC1_ADDR *****/
            if(rx->sa_BC1_Bytes ) {
               us_data = 1;
               if(rx->sa_BC1_lpath == 1) {
                  us_data |= (1 << 1);                /* Latency path 1 */
               }
               //birsen       if(gt_RxShowTimeVars.ft_BC1isAS1) {       /* LS0 is AS1 i.e. BC1 is AS1*/
               //          us_data |= (1 << 2);
               //       }
            } else {
               us_data = 0;
            }
            WriteCoreReg (ZEP_REG_ZR_BC1_ADDR, us_data);

            /*****  ZEP_REG_ZR_FB0_START_ADDR *****/
            us_data = 0;
            WriteCoreReg (ZEP_REG_ZR_FB0_START_ADDR, us_data);

            /*****  ZEP_REG_ZR_FB0_END_ADDR *****/
            if(rx->sa_BC0_Bytes) {
               us_data = rx->sa_BC0_Bytes - 1;
               if (rx->s_Tp[rx->sa_BC0_lpath] > 1) {
                  us_data += 1;
               }
               //birsen if(gt_RxShowTimeVars.pt_Config->s_FramingMode == FULL_ASYNC) { /* g.dmt framing mode 0 */
               //       us_data += 2;  /* for AEX and LEX */
               // }
               // } else if(  (gt_RxShowTimeVars.t_BCParms[0].sa_BC_CChan) && /* C Channel */
               //          (gt_RxShowTimeVars.pt_Config->s_FramingMode == FULL_ASYNC) ) { /* g.dmt framing mode 0 */
               //       us_data += (2 - 1);  /* for AEX and LEX */
            }
            WriteCoreReg (ZEP_REG_ZR_FB0_END_ADDR, us_data);

            /*****  ZEP_REG_ZR_FB1_START_ADDR *****/
            if(us_data || rx->sa_BC0_Bytes)  us_data++;
            WriteCoreReg (ZEP_REG_ZR_FB1_START_ADDR, us_data);

            /*****  ZEP_REG_ZR_FB1_END_ADDR *****/
            if(rx->sa_BC1_Bytes) {
               us_data += (rx->sa_BC1_Bytes - 1);
               if( rx->s_Tp[rx->sa_BC1_lpath] > 1) {
                  us_data += 1;
               }
               // if(gt_RxShowTimeVars.pt_Config->s_FramingMode == FULL_ASYNC) { /* g.dmt framing mode 0 */
               //       us_data += 2;  /* for AEX and LEX */
               // }
            } //else if(   (gt_RxShowTimeVars.t_BCParms[1].sa_BC_CChan) && /* C Channel */
            //       (gt_RxShowTimeVars.pt_Config->s_FramingMode == FULL_ASYNC) ) { /* g.dmt framing mode 0 */
            //       us_data += (2 - 1);  /* for AEX and LEX */
            // }
            WriteCoreReg (ZEP_REG_ZR_FB1_END_ADDR, us_data);

            /*****  ZEP_REG_ZR_CODEWORD_ADDR *****/
            us_data = (uint16)((rx->s_Codewordsize1 << 8) |
               (rx->s_Codewordsize0));
            WriteCoreReg (ZEP_REG_ZR_CODEWORD_ADDR, us_data);

            /*****  ZEP_REG_ZR_CHECKBYTE_ADDR *****/
            us_data = 0;
            us_data |= (uint16)(((rx->s_R1 & 0x1F) << 8) |
               (rx->s_R0 & 0x1F));
            WriteCoreReg (ZEP_REG_ZR_CHECKBYTE_ADDR, us_data);

            /*****  ZEP_REG_ZR_CW_DIV_MF_ADDR *****/
            /* check Immedialtely
            if ( rx->s_Mp1 == S_HALF ){
            //birsen s_FrameSize1 =
            // (gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize & 0x01) ?
            // (gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize+1)>>1 :
            // gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize >> 1;
            }
            else
            s_FrameSize1 = gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize;

            if ( gt_RxShowTimeVars.pt_Config->s_Mp[LP0_DATA_PATH] == S_HALF ){
            s_FrameSize0 =
            (gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize & 0x01) ?
            (gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize+1)>>1 :
            gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize >> 1;
            }
            else
            s_FrameSize0 = gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize;

               us_data = (uint16)(( s_FrameSize1 << 8) | s_FrameSize0 );
               WriteCoreReg (ZEP_REG_ZR_CW_DIV_MF_ADDR, us_data);
            */
            us_data = (uint16)(( s_muxrx1 << 8) | s_muxrx0 );

            WriteCoreReg (ZEP_REG_ZR_CW_DIV_MF_ADDR, us_data);

            /*****  ZEP_REG_ZR_DDEPTH_ADDR *****/
#ifdef INF_CPE
            us_data = (uint16)((rx->s_Dp1 << 9) |
               (rx->s_Dp0));
#else
            us_data = (uint16)((rx->s_Dp1 << 8) |
               (rx->s_Dp0));
#endif
         // WriteCoreReg (ZEP_REG_ZR_DDEPTH_ADDR, us_data);



            /*****  ZEP_REG_ZR_FRAME_LP0_ADDR *****/
            if(rx->s_FramingMode < 4) {   /* g.dmt framing mode   */
               us_data = (uint16)((rx->s_MSGc + 6 - 1) << 8);
            }
            else if(rx->s_FramingMode == 4)
            {
               /* g.bis framing mode   */
               //birsen us_data = (uint16)gsa_rx_SEQp[LP0_DATA_PATH]-1;
               // us_data <<= 8;
               us_data = 0;
            }

            // WriteCoreReg(ZEP_REG_ZR_FRAME_LP0_ADDR,0x4300);    // max index 67
            //    WriteCoreReg(ZEP_REG_ZR_FRAME_LP1_ADDR,0x4300);    // max index 67

            //WriteCoreReg (ZEP_REG_ZR_FRAME_LP0_ADDR, us_data);

            /*****  ZEP_REG_ZR_FRAME_LP1_ADDR *****/
            if(rx->s_FramingMode < 4) {   /* g.dmt framing mode   */
               us_data = (uint16)((rx->s_MSGc + 6 - 1) << 8);
            }
            else if(rx->s_FramingMode == 4)
            {
               /* g.bis framing mode   */
               /* g.bis framing mode   */
               //birsen us_data = (uint16)gsa_rx_SEQp[LP1_DATA_PATH] -1;
               //us_data <<= 8;
               us_data = 0;
            }
            // WriteCoreReg (ZEP_REG_ZR_FRAME_LP1_ADDR, us_data);

            /*****  ZEP_REG_ZR_TP0_ADDR *****/
            us_data = (uint16)((rx->s_Tp[0]) << 8);
            WriteCoreReg (ZEP_REG_ZR_TP0_ADDR, us_data);

            /*****  ZEP_REG_ZR_TP1_ADDR *****/
            us_data = (uint16)((rx->s_Tp[1]) << 8);
            WriteCoreReg (ZEP_REG_ZR_TP1_ADDR, us_data);

            /*****  ZEP_REG_ZR_MFCW0_ADDR *****/
            us_data = (uint16)(rx->s_Mp0);
            // birsen us_data |= (uint16)(gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_sHalfCntl << 14);
            WriteCoreReg (ZEP_REG_ZR_MFCW0_ADDR, us_data);

            /*****  ZEP_REG_ZR_MFCW1_ADDR *****/
            us_data = (uint16)(rx->s_Mp1);
            //birsen us_data |= (uint16)(gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_sHalfCntl << 14);
            WriteCoreReg (ZEP_REG_ZR_MFCW1_ADDR, us_data);

            /*****  ZEP_REG_ZR_DSCR_LO0_ADDR *****/
            WriteCoreReg (ZEP_REG_ZR_DSCR_LO0_ADDR, 0);

            /*****  ZEP_REG_ZR_DSCR_LO1_ADDR *****/
            WriteCoreReg (ZEP_REG_ZR_DSCR_LO1_ADDR, 0);

            /*****  ZEP_REG_ZR_DSCR_HI_ADDR *****/
            WriteCoreReg (ZEP_REG_ZR_DSCR_HI_ADDR, 0);

            /*****  ZEP_REG_ZR_FEXX_ADDR *****/
            us_data = 0xffff; /* Rx_FeccF = 1, Rx_FeccI = 1 */
            WriteCoreReg (ZEP_REG_ZR_FEXX_ADDR, us_data);

            /*****  ZEP_REG_ZR_CRC_ADDR *****/
            WriteCoreReg (ZEP_REG_ZR_CRC_ADDR, 0);

            /* ZEP_REG_ZR_DCUR_CWADR_ADDR */
            WriteCoreReg (ZEP_REG_ZR_DCUR_CWADR_ADDR, 0);

            /* ZEP_REG_ZR_DECSTAT0_LP0_ADDR */
            WriteCoreReg (ZEP_REG_ZR_DECSTAT0_LP0_ADDR, 0);

            /* ZEP_REG_ZR_DECSTAT1_LP0_ADDR */
            WriteCoreReg (ZEP_REG_ZR_DECSTAT1_LP0_ADDR, 0);

            /* ZEP_REG_ZR_DECSTAT0_LP1_ADDR */
            WriteCoreReg (ZEP_REG_ZR_DECSTAT0_LP1_ADDR, 0);

            /* ZEP_REG_ZR_DECSTAT1_LP1_ADDR */
            WriteCoreReg (ZEP_REG_ZR_DECSTAT1_LP1_ADDR, 0);

            /* ZEP_REG_ZR_FRAME_BYTE_ADDR */
            WriteCoreReg (ZEP_REG_ZR_FRAME_BYTE_ADDR, 0);

              /* ZEP_REG_ZR_WB_SCORE_CTL0_ADDR */
            //WB block is provided with 0xFF as reliability metrics
            WriteCoreReg(ZEP_REG_ZR_WB_SCORE_CTL0_ADDR,(uint16) 0x3000);

               /* ZEP_REG_ZR_WB_SCORE_CTL1_ADDR */
            WriteCoreReg(ZEP_REG_ZR_WB_SCORE_CTL1_ADDR,(uint16) 0xFFFF);

            /* ZEP_REG_ZR_WB_SCORE_CTL1_ADDR */
            WriteCoreReg(ZEP_REG_ZR_WB_SCORE_CTL2_ADDR,(uint16) 0x0404);

            /* AR_CNTL_ADDR */
            // set the AAI rx path to register start mode
            WriteCoreReg((uint16) AR_CNTL_ADDR, (uint16) (1<<4));
#endif //AMAZON_SE
 }

 /****************************************************************************
 ; Name: start_transmit
 ;
 ; Prototype:
 ;    void start_transmit(void)
 ;
 ; Description:
 ; This function sets Zephyr/Iridia registers for starting the TX processing.
 ;
 ; Arguments:
 ;
 ;  Return Value:
 *****************************************************************************/
 void start_transmit(void)
 {
   int16 us_word;

   /* set everthing cascaded */
   ReadCoreReg(ZEP_REG_ZT_LINE_ADDR, &us_word);
   us_word |= 0x0008;  // use bit 4 for kicking zephyr
   WriteCoreReg(ZEP_REG_ZT_LINE_ADDR, us_word);

   ReadCoreReg(IRI_REG_IT_MODE_ADDR, &us_word);
   us_word &= 0xFFF0;  // cascade Cons, TDT iridia
   //03/07/2006 to support ifx emulator dubugging
   us_word |= 0x000E;
   // showtime uses cascade start
   // us_word |= 0x000C;   // register IFFT pre - complex

   WriteCoreReg(IRI_REG_IT_MODE_ADDR, us_word);
   WriteCoreReg(IRI_REG_IT_AMODE_ADDR, us_word);

   /* start tx */
   ReadCoreReg(ZEP_REG_ZT_LINE_ADDR, &us_word);
   us_word |= 0x0010;
   WriteCoreReg(ZEP_REG_ZT_LINE_ADDR, us_word);

 }

 /****************************************************************************
 ; Name: start_receive
 ;
 ; Prototype:
 ;    void start_receive(void)
 ;
 ; Description:
 ; This function sets Zephyr/Iridia registers for starting the RX processing.
 ;
 ; Arguments:
 ;
 ;  Return Value:
 *****************************************************************************/

 void start_receive(void)
 {
   int16 us_word;


   ReadCoreReg(IRI_REG_IT_MODE_ADDR, &us_word);
   us_word &= 0xFFF0;  // make everything register in TX side  except QAM_ENC
   us_word |=0x000C;    //to support ifx emulator debugging
   //us_word |= 0x000F;

   WriteCoreReg(IRI_REG_IT_MODE_ADDR, us_word);
   WriteCoreReg(IRI_REG_IT_AMODE_ADDR, us_word);

   ReadCoreReg(IRI_REG_IR_MODE_ADDR, &us_word);
   us_word |= (1 << 15);
   WriteCoreReg(IRI_REG_IR_MODE_ADDR, us_word);
   WriteCoreReg(IRI_REG_IR_AMODE_ADDR, us_word);

   us_word = 0;

     us_word |= (0 << 7);                    // Data Transfer out, Register-start.
   us_word |= (0 << 6);                   // Constellation decode, Register-start.
   us_word |= (0 << 4);                   // Gain Scale, Register-start (01).
   us_word |= (1 << 3);                   // FDQ, Register-start.
   us_word |= (0 << 2);                   // FFT Post-Processing, Cascade-start.
   us_word |= (0 << 0);                   // Complex-FFT, Register-start.

   WriteCoreReg(IRI_REG_IR_STMODE_ADDR, us_word);
   WriteCoreReg(IRI_REG_IR_ASTMODE_ADDR, us_word);

   /* start rx */
   WriteCoreReg(IRI_REG_IR_CTRL_ADDR,  0x0008); //kick fdq

   /* ZEP_REG_ZR_WB_SCORE_CTL0_ADDR */
   //WB block is provided with 0xFF as reliability metrics
   WriteCoreReg(ZEP_REG_ZR_WB_SCORE_CTL0_ADDR,(uint16) 0x3000);

    /* ZEP_REG_ZR_WB_SCORE_CTL1_ADDR   */
   WriteCoreReg(ZEP_REG_ZR_WB_SCORE_CTL1_ADDR,(uint16) 0xFFFF);

   /* ZEP_REG_ZR_WB_SCORE_CTL1_ADDR */
   WriteCoreReg(ZEP_REG_ZR_WB_SCORE_CTL2_ADDR,(uint16) 0x0404);

 }

 /****************************************************************************
 ; Name: copy_ifft_to_fft
 ;
 ; Prototype:
 ; void copy_ifft_to_fft(void)
 ;
 ; Description:
 ; This function copies IFFT Buffer to FFT Buffer.
 ;
 ; Arguments:
 ;
 ;  Return Value:
 *****************************************************************************/
void copy_ifft_to_fft(int16 i_config) {

   int16 i_bank, i;
   int16 us_IFFTAddr = (int16) IRI_RAM_TX_IFFT_B0_ADDR;
   int16 us_FFTAddr = (int16) IRI_RAM_RX_FFT_B0_ADDR;
   int32 ul_Data;

      int16 s_index = (i_config % 2), s_indexFFT = (i_config % 3);
      uint16 us_data;

      if(s_index == 0) {
         us_data = 0x14;      //Logical Buffer 1
         if(s_indexFFT == 0)        i_bank = 0x24;    //Use FFT Bank A
         else if(s_indexFFT == 1)   i_bank = 0x48;    //Use FFT Bank B
         else if(s_indexFFT == 2)   i_bank = 0x12;    //Use FFT Bank C
      } else if(s_index == 1) {
         us_data = 0x18;      //Logical Buffer 2
         if(s_indexFFT == 0)        i_bank = 0x12;    //Use FFT Bank A
         else if(s_indexFFT == 1)   i_bank = 0x24;    //Use FFT Bank B
         else if(s_indexFFT == 2)   i_bank = 0x48;    //Use FFT Bank C
      }
      WriteCoreReg(IRI_REG_IR_PRBUF_ADDR, us_data);
      WriteCoreReg(IRI_REG_IR_APRBUF_ADDR, us_data);
      WriteCoreReg(IRI_REG_IBANK_ADDR, i_bank);

      if (s_indexFFT == 0)    us_FFTAddr = (int16) IRI_RAM_RX_FFT_A0_ADDR;
      else if (s_indexFFT == 1)  us_FFTAddr = (int16) IRI_RAM_RX_FFT_B0_ADDR;
      else if(s_indexFFT == 2)   us_FFTAddr = (int16) IRI_RAM_RX_FFT_C0_ADDR;


   for (i = 0; i < (int16) IRI_RAM_TX_IFFT_A0_SIZE; i++) {
        //ReadCoreBuf32((uint16)(us_IFFTAddr+i), &us_data, 1);
        //ul_Data= *((uint32 *)(&us_data));
      //WriteCoreBuf32((uint16)(us_FFTAddr+i), &ul_Data, 1);
      ReadCoreReg32((uint16)(us_IFFTAddr+i), &ul_Data);
      WriteCoreReg32((uint16)(us_FFTAddr+i), ul_Data);
   }
}

/*******************************************************************/
/* Transmit FIFO Initialization*/
/*******************************************************************/

 void TX_FIFO_Init(tx_params *tx)
{
    int i;
    uint16 us_remainder, us_quotient,us_Tx_CodeWordSize0, us_Tx_CodeWordSize1;
    uint16 us_FIFO_len[256], us_BasePtr[256], us_WrPtr[256], us_RdPtr[256], us_DCIDPtr[256];
   uint16 temp_Tx_Number_FIFOS0=0,temp_Tx_Number_FIFOS1=0,temp_Tx_Dummy0=0,temp_Tx_Dummy1=0,temp_Tx_WR_FIFO_Index0=0,temp_Tx_RD_FIFO_Index0=0,
         temp_Tx_WR_FIFO_Index1=0,temp_Tx_RD_FIFO_Index1=0,
           temp_Tx_RD_Step0=0,temp_Tx_RD_Step1=0;
   uint16 us_Tx_Lp0, us_Tx_Lp1,us_S_Inv0, us_S_Inv1;
   uint16 INTERLEAVE_DEPTH_LP0, INTERLEAVE_DEPTH_LP1,us_bptr_start_offset=0;
    uint16 PREBUFFER_LENGTH=0;
   uint32 ul_bptr_addr[256];

   INTERLEAVE_DEPTH_LP0=tx->s_Dp0;
    INTERLEAVE_DEPTH_LP1=tx->s_Dp1;
    us_Tx_Lp0=tx->s_Lp0;
    us_Tx_Lp1=tx->s_Lp1;
    us_Tx_CodeWordSize0=tx->s_Codewordsize0;
    us_Tx_CodeWordSize1=tx->s_Codewordsize1;

   if (us_Tx_CodeWordSize0>0) {
      us_remainder=(us_Tx_Lp0>>3)%us_Tx_CodeWordSize0;
      if    (us_remainder==0)
          us_S_Inv0=(us_Tx_Lp0>>3)/us_Tx_CodeWordSize0;
      else
          us_S_Inv0=(us_Tx_Lp0>>3)/us_Tx_CodeWordSize0+1;
   }
   else
      us_S_Inv0=0;

   if (us_Tx_CodeWordSize1>0) {
      us_remainder=(us_Tx_Lp1>>3)%us_Tx_CodeWordSize1;
      if    (us_remainder==0)
         us_S_Inv1=(us_Tx_Lp1>>3)/us_Tx_CodeWordSize1;
      else
         us_S_Inv1=(us_Tx_Lp1>>3)/us_Tx_CodeWordSize1+1;
   }
   else
      us_S_Inv1=0;

   for (i=0; i<256; i++)
   {
      us_FIFO_len[i]=0;
        us_BasePtr[i]=0;
      us_WrPtr[i]=0;
      us_RdPtr[i]=0;
      us_DCIDPtr[i]=0;
   }

   /*****************/
   /*Latency Path 0 */
   /*****************/

   //calculate number of Dummy Bytes
    if (us_Tx_CodeWordSize0%2==0)
      temp_Tx_Dummy0=1;
   else
        temp_Tx_Dummy0=0;

   // calculate number of FIFO required
   temp_Tx_Number_FIFOS0 =us_Tx_CodeWordSize0+temp_Tx_Dummy0;

    // Calculate FIFO Length at CPE transmitter side.
   for (i=0; i<temp_Tx_Number_FIFOS0; i++)
   {
      us_quotient=(INTERLEAVE_DEPTH_LP0*i+1)/temp_Tx_Number_FIFOS0;
        us_remainder=(INTERLEAVE_DEPTH_LP0*i+1)%temp_Tx_Number_FIFOS0;
      if (us_remainder>0)
      us_FIFO_len[i] =(uint16)(us_quotient+1+PREBUFFER_LENGTH)+us_S_Inv0;
      else
      us_FIFO_len[i] =(uint16)(us_quotient+PREBUFFER_LENGTH)+us_S_Inv0;
    }

    // Initializations
    us_BasePtr[0]=0;
   us_WrPtr[0]=us_FIFO_len[0]-1;
   us_RdPtr[0]=us_FIFO_len[0]-1;
   ul_bptr_addr[0]=((us_RdPtr[0] &0x7F) <<19 )|((us_WrPtr[0] & 0x7F)<<12) | (us_BasePtr[0] & 0x3FF);

   WriteCoreReg32((uint16)ZEP_RAM_TX_INTERLV_BUF_ADDR,ul_bptr_addr[0]);
   for (i=1; i<=temp_Tx_Number_FIFOS0; i++) {
      us_BasePtr[i]=us_BasePtr[i-1]+us_FIFO_len[i-1];
      if (i<temp_Tx_Number_FIFOS0) {
         us_WrPtr[i]=us_FIFO_len[i]-1;
         us_remainder=us_FIFO_len[0]%us_FIFO_len[i];
         us_RdPtr[i]=us_FIFO_len[i]-us_remainder-1;
            ul_bptr_addr[i]=((us_DCIDPtr[i] & 0x3F)<<26)|((us_RdPtr[i] &0x7F)<<19)|((us_WrPtr[i] & 0x7F)<<12) | (us_BasePtr[i] & 0x3FF);
         WriteCoreReg32((uint16)(ZEP_RAM_TX_INTERLV_BUF_ADDR+i),ul_bptr_addr[i]);
      }
    }


   //solve for interleaver read step
    for (i=1; i<temp_Tx_Number_FIFOS0; i++) {
         if (INTERLEAVE_DEPTH_LP0*i%temp_Tx_Number_FIFOS0==1)
      temp_Tx_RD_Step0  =i;
   }

   //Initialize FIFO index and bptr Register
   temp_Tx_WR_FIFO_Index0=temp_Tx_Dummy0;
   temp_Tx_RD_FIFO_Index0=temp_Tx_Dummy0*temp_Tx_RD_Step0;
   us_bptr_start_offset=ZEP_RAM_TX_INTERLV_BASE_LP1_OFFSET;

   /*****************/
   /*Latency Path 1 */
   /*****************/
    //calculate number of Dummy Bytes
   if (us_Tx_CodeWordSize1>0) {

   if (us_Tx_CodeWordSize1%2==0)
      temp_Tx_Dummy1=1;
   else
        temp_Tx_Dummy1=0;

   // calculate number of FIFO required
   temp_Tx_Number_FIFOS1 =us_Tx_CodeWordSize1+temp_Tx_Dummy1;

   // Calculate FIFO Length at CPE transmitter side.
   for (i=0; i<temp_Tx_Number_FIFOS1; i++) {
      us_quotient=(INTERLEAVE_DEPTH_LP1*i+1)/temp_Tx_Number_FIFOS1;
        us_remainder=(INTERLEAVE_DEPTH_LP1*i+1)%temp_Tx_Number_FIFOS1;
      if (us_remainder>0)
      us_FIFO_len[i] = us_quotient+1+PREBUFFER_LENGTH+us_S_Inv1;
      else
      us_FIFO_len[i] = us_quotient+PREBUFFER_LENGTH+us_S_Inv1;
    }


 // Initializations
    us_BasePtr[0]=1472;  //(1248-512)/2*4=1472
   us_WrPtr[0]=us_FIFO_len[0]-1;
   us_RdPtr[0]=us_FIFO_len[0]-1;
   ul_bptr_addr[0]=((us_DCIDPtr[i] & 0x3F)<<26)|((us_RdPtr[0] &0x7F) <<19 )|((us_WrPtr[0] & 0x7F)<<12) | (us_BasePtr[0] & 0x3FF);

   WriteCoreReg32((uint16)ZEP_RAM_TX_INTERLV_BUF_ADDR+256,ul_bptr_addr[0]);
   for (i=1; i<=temp_Tx_Number_FIFOS0; i++) {
      us_BasePtr[i]=us_BasePtr[i-1]+us_FIFO_len[i-1];
      if (i<temp_Tx_Number_FIFOS0) {
         us_WrPtr[i]=us_FIFO_len[i]-1;
         us_remainder=us_FIFO_len[0]%us_FIFO_len[i];
         us_RdPtr[i]=us_FIFO_len[i]-us_remainder-1;
            ul_bptr_addr[i]=((us_RdPtr[i] &0x7F)<<19)|((us_WrPtr[i] & 0x7F)<<12) | (us_BasePtr[i] & 0x3FF);
         WriteCoreReg32((uint16)(ZEP_RAM_TX_INTERLV_BUF_ADDR+256+i),ul_bptr_addr[i]);
      }
    }

   //solve for interleaver read step
    for (i=1; i<temp_Tx_Number_FIFOS1; i++)  {
              if (INTERLEAVE_DEPTH_LP1*i%temp_Tx_Number_FIFOS1==1)
            temp_Tx_RD_Step1 =i;
           }

    //Initialize FIFO index and bptr Register
      temp_Tx_WR_FIFO_Index1=temp_Tx_Dummy1;
      temp_Tx_RD_FIFO_Index1=temp_Tx_Dummy1*temp_Tx_RD_Step1;
      us_bptr_start_offset= ZEP_RAM_TX_INTERLV_OFFSET;
   }

/*Write Transmit Registers*/
   WriteCoreReg(ZEP_REG_ZT_NUM_FIFOS_ADDR,(uint16)((temp_Tx_Number_FIFOS1<<8)|temp_Tx_Number_FIFOS0));
   WriteCoreReg(ZEP_REG_ZT_DUMMY_BYTES_ADDR,(uint16)((temp_Tx_Dummy1<<8)|temp_Tx_Dummy0));
    WriteCoreReg(ZEP_REG_ZT_WR_FIFO_IDX_ADDR,(uint16) ((temp_Tx_WR_FIFO_Index1<<8)|temp_Tx_WR_FIFO_Index0));
    WriteCoreReg(ZEP_REG_ZT_RD_FIFO_IDX_ADDR,(uint16)((temp_Tx_RD_FIFO_Index1<<8)|temp_Tx_RD_FIFO_Index0));
   WriteCoreReg(ZEP_REG_ZT_RD_STEP_ADDR,(uint16) ((temp_Tx_RD_Step1<<8)|temp_Tx_RD_Step0));
   WriteCoreReg(ZEP_REG_ZT_BPTR_BASE_ADDR,(uint16) us_bptr_start_offset );
  }
/*******************************************************************/
/* Receive FIFO Initialization*/
/*******************************************************************/
void  RX_FIFO_Init(rx_params *rx)
{
    int i;
    uint16 us_remainder,us_quotient,us_Rx_CodeWordSize0, us_Rx_CodeWordSize1, us_Rx_Mp0, us_Rx_Mp1,us_Rx_sHalfCntl0,us_Rx_sHalfCntl1;
    uint32 ul_PrevBase, ul_CurrBase;
   uint16 us_FIFO_len[256],us_BasePtr[256], us_WrPtr[256], us_RdPtr[256], us_DCIDPtr[256];
    uint16 temp_Rx_Number_FIFOS0=0,temp_Rx_Number_FIFOS1=0, temp_Rx_Dummy_Odd0=0,temp_Rx_Dummy_Even0=0,temp_Rx_Dummy_Odd1=0,temp_Rx_Dummy_Even1=0,temp_Rx_WR_FIFO_Index0=0,temp_Rx_RD_FIFO_Index0=0,
           temp_Rx_WR_FIFO_Index1=0,temp_Rx_RD_FIFO_Index1=0,temp_Rx_WR_Step0=0,temp_Rx_WR_Step1=0;
   uint16 us_Rx_Lp0, us_Rx_Lp1,us_S_Inv0, us_S_Inv1;
   uint16  INTERLEAVE_DEPTH_LP0, INTERLEAVE_DEPTH_LP1,us_bptr_start_offset=0;
   uint16  PREBUFFER_LENGTH=0;
    uint32 ul_bptr_addr[256];

   INTERLEAVE_DEPTH_LP0=rx->s_Dp0;
    INTERLEAVE_DEPTH_LP1=rx->s_Dp1;
    us_Rx_CodeWordSize0=rx->s_Codewordsize0;
    us_Rx_CodeWordSize1=rx->s_Codewordsize1;
   us_Rx_Lp0=rx->s_Lp0;
    us_Rx_Lp1=rx->s_Lp1;
   us_Rx_Mp0=rx->s_Mp0;
   us_Rx_Mp1=rx->s_Mp0;
    us_Rx_sHalfCntl0=0;
    us_Rx_sHalfCntl1=0;

   if (us_Rx_CodeWordSize0>0) {
      us_remainder=(us_Rx_Lp0>>3)%us_Rx_CodeWordSize0;
      if    (us_remainder==0)
          us_S_Inv0=(us_Rx_Lp0>>3)/us_Rx_CodeWordSize0;
      else
          us_S_Inv0=(us_Rx_Lp0>>3)/us_Rx_CodeWordSize0+1;
   }
   else
      us_S_Inv0=0;

   if (us_Rx_CodeWordSize1>0) {
      us_remainder=(us_Rx_Lp1>>3)%us_Rx_CodeWordSize1;
      if    (us_remainder==0)
         us_S_Inv1=(us_Rx_Lp1>>3)/us_Rx_CodeWordSize1;
      else
         us_S_Inv1=(us_Rx_Lp1>>3)/us_Rx_CodeWordSize1+1;
   }
   else
      us_S_Inv1=0;

   /*****************/
    /*Latency Path 0 */
    /*****************/
   for (i=0; i<256; i++)
   {
      us_FIFO_len[i]=0;
        us_BasePtr[i]=0;
      us_WrPtr[i]=0;
      us_RdPtr[i]=0;
      us_DCIDPtr[i]=0;
   }
    //calculate number of Dummy Bytes
    if ((us_Rx_Mp0>0) && ( us_Rx_CodeWordSize0% 2 == 0))
   {
      temp_Rx_Dummy_Odd0=1;
      temp_Rx_Dummy_Even0=1;
   }

    /*****  ZEP_REG_ZR_DUMMY_BYTES_ADDR *******/
   else if ((us_Rx_Mp0 == S_HALF)&&(us_Rx_sHalfCntl0==0))
      {
         temp_Rx_Dummy_Odd0=0;
         temp_Rx_Dummy_Even0=0;
   }
   else if ((us_Rx_Mp0 == S_HALF)&&(us_Rx_sHalfCntl0==1))
   {
         temp_Rx_Dummy_Odd0=1;
         temp_Rx_Dummy_Even0=0;
   }
    else if ((us_Rx_Mp0 == S_HALF)&&(us_Rx_sHalfCntl0==2))
   {
         temp_Rx_Dummy_Odd0=2;
         temp_Rx_Dummy_Even0=1;
   }
    else if ((us_Rx_Mp0 == S_HALF)&&(us_Rx_sHalfCntl0==3))
   {
         temp_Rx_Dummy_Odd0=1;
         temp_Rx_Dummy_Even0=1;
   }

    // calclulate number of FIFOs
    temp_Rx_Number_FIFOS0 =us_Rx_CodeWordSize0+temp_Rx_Dummy_Even0;

    // calculate FIFO length at CPE receiver side.
   for (i=0; i<temp_Rx_Number_FIFOS0 ; i++) {
      us_quotient=INTERLEAVE_DEPTH_LP0*i/temp_Rx_Number_FIFOS0;
        //us_FIFO_len[i] = INTERLEAVE_DEPTH_LP0-us_quotient+PREBUFFER_LENGTH+MAX_INV_S;
        us_FIFO_len[i] = INTERLEAVE_DEPTH_LP0-us_quotient+PREBUFFER_LENGTH+us_S_Inv0;
      }

   //Initialize Base Pointer RAM and Writing Pointer RAM
   ul_PrevBase=0;
   for (i=1; i<=temp_Rx_Number_FIFOS0; i+=2) {
      ul_CurrBase=us_FIFO_len[i-1]+ul_PrevBase;
      WriteCoreReg32((uint16)(ZEP_RAM_RX_INTERLV_BUF_ADDR+i/2),(ul_CurrBase<<16)|ul_PrevBase);
      ul_PrevBase= us_FIFO_len[i]+ul_CurrBase;
   }

     // Initializations of pointers
   for (i=0; i<temp_Rx_Number_FIFOS0; i++) {
      us_WrPtr[i]=us_FIFO_len[i]-1;
      us_remainder=us_FIFO_len[0]%us_FIFO_len[i];
      us_RdPtr[i]=us_FIFO_len[i]-us_remainder-1;
        ul_bptr_addr[i]=((us_DCIDPtr[i] &0x3FF)<<22)|((us_RdPtr[i] & 0x7FF)<<11)|(us_WrPtr[i] & 0x7FF);
      WriteCoreReg32((uint16)(ZEP_RAM_RX_INTERLV_BUF_ADDR+128+i),ul_bptr_addr[i]);
      }

   //solve for write step
   for (i=1; i<temp_Rx_Number_FIFOS0; i++) {
           if (INTERLEAVE_DEPTH_LP0*i%temp_Rx_Number_FIFOS0==1)
            temp_Rx_WR_Step0=i;
    }

   //FIFO index initialization
      temp_Rx_WR_FIFO_Index0=temp_Rx_Dummy_Even0*temp_Rx_WR_Step0;
      temp_Rx_RD_FIFO_Index0=temp_Rx_Dummy_Even0;

     us_bptr_start_offset=ZEP_RAM_RX_INTERLV_BASE_LP1_OFFSET;
   /*****************/
   /*Latency Path 1 */
   /*****************/

    //calculate number of Dummy Bytes
   if (us_Rx_CodeWordSize1>0) {
      if ((us_Rx_Mp1>0) && (us_Rx_CodeWordSize1 % 2 == 0))
      {
         temp_Rx_Dummy_Odd1=1;
         temp_Rx_Dummy_Even1=1;
      }

      else if ((us_Rx_Mp1 == S_HALF) && (us_Rx_sHalfCntl1==0))
      {
         temp_Rx_Dummy_Odd1=0;
         temp_Rx_Dummy_Even1=0;
      }
      else if ((us_Rx_Mp1 == S_HALF) && (us_Rx_sHalfCntl1==1))
      {
         temp_Rx_Dummy_Odd1=1;
         temp_Rx_Dummy_Even1=0;
      }
      else if ((us_Rx_Mp1 == S_HALF) && (us_Rx_sHalfCntl1==2))
      {
         temp_Rx_Dummy_Odd1=2;
         temp_Rx_Dummy_Even1=1;
      }
      else if ((us_Rx_Mp1== S_HALF) && (us_Rx_sHalfCntl1==3))
      {
         temp_Rx_Dummy_Odd1=1;
         temp_Rx_Dummy_Even1=1;
      }

      // calclulate number of FIFOs
         temp_Rx_Number_FIFOS1 =us_Rx_CodeWordSize1+temp_Rx_Dummy_Even1;

      // calculate FIFO length at CPE receiver side.
      for (i=0; i<temp_Rx_Number_FIFOS1 ; i++)
      {
         us_quotient=(INTERLEAVE_DEPTH_LP1*i)/temp_Rx_Number_FIFOS1;
         //us_FIFO_len[i] = INTERLEAVE_DEPTH_LP1-us_quotient+PREBUFFER_LENGTH+MAX_INV_S;
         us_FIFO_len[i] = INTERLEAVE_DEPTH_LP1-us_quotient+PREBUFFER_LENGTH+us_S_Inv1;
      }

    //Initialize other Base/WR/RD Pointer RAM for LP1
   ul_PrevBase=8704; //    (5120-768)/2*4
   //ul_PrevBase=256;
   for (i=1; i<=temp_Rx_Number_FIFOS1; i+=2) {
      ul_CurrBase=us_FIFO_len[i-1]+ul_PrevBase;
        WriteCoreReg32((uint16)(ZEP_RAM_RX_INTERLV_BUF_ADDR+384+i/2),(ul_CurrBase<<16)|ul_PrevBase);
      ul_PrevBase= us_FIFO_len[i]+ul_CurrBase;
   }

   // Initializations of pointers
   for (i=0; i<temp_Rx_Number_FIFOS1; i++) {
      us_WrPtr[i]=us_FIFO_len[i]-1;
      us_remainder=us_FIFO_len[0]%us_FIFO_len[i];
      us_RdPtr[i]=us_FIFO_len[i]-us_remainder-1;
        ul_bptr_addr[i]=((us_DCIDPtr[i] &0x3FF)<<22)|((us_RdPtr[i] & 0x7FF)<<11)|(us_WrPtr[i] & 0x7FF) ;
      WriteCoreReg32((uint16)(ZEP_RAM_RX_INTERLV_BUF_ADDR+512+i),ul_bptr_addr[i]);
      }


      //solve for write step
   //Workaround due to mpy32() in arc6
     for (i=1; i<temp_Rx_Number_FIFOS1; i++)
          if (INTERLEAVE_DEPTH_LP1*i%temp_Rx_Number_FIFOS1==1)
            temp_Rx_WR_Step1=i;

   //FIFO index initialization
   temp_Rx_WR_FIFO_Index1=temp_Rx_WR_Step1*temp_Rx_Dummy_Even1;
    temp_Rx_RD_FIFO_Index1=temp_Rx_Dummy_Even1;

   us_bptr_start_offset= ZEP_RAM_RX_INTERLV_OFFSET;
   }

   /*Write Receive Registers*/
    WriteCoreReg(ZEP_REG_ZR_NUM_FIFOS_ADDR, (uint16)((temp_Rx_Number_FIFOS1<<8)|temp_Rx_Number_FIFOS0));
   WriteCoreReg(ZEP_REG_ZR_DUMMY_BYTES_ADDR,(uint16) ((temp_Rx_Dummy_Odd1<<10)|(temp_Rx_Dummy_Even1<<8)|(temp_Rx_Dummy_Odd0<<2)|temp_Rx_Dummy_Even0));
   WriteCoreReg(ZEP_REG_ZR_WR_FIFO_IDX_ADDR,(uint16) ((temp_Rx_WR_FIFO_Index1<<8)|temp_Rx_WR_FIFO_Index0));
   WriteCoreReg(ZEP_REG_ZR_RD_FIFO_IDX_ADDR,(uint16) ((temp_Rx_RD_FIFO_Index1<<8)|temp_Rx_RD_FIFO_Index0));
   WriteCoreReg(ZEP_REG_ZR_WR_STEP_ADDR, (uint16) ((temp_Rx_WR_Step1<<8)|temp_Rx_WR_Step0));
    WriteCoreReg(ZEP_REG_ZR_BPTR_BASE_ADDR, (uint16) us_bptr_start_offset);

}



/*****************************************************************************
;  Prototype: int16 mte_calcBATSetFineGains(FlagT ft_isTcm,
;                       int16 s_totalDataBits,
;                       int16 s_constsize,
;                       int16 s_firstloadedtone,
;                       int16 s_numTones,
;                       int16 s_num1bits,
;                       int16* ps_bat,
;                       int16* ps_finegain)
;
;  Input Arguments:
;     ft_isTcm       -     TRUE=>TCM on, FALSE=> TCM off
;     s_totalDataBits      -     num data bits to be encoded/decoded
;     s_constsize       -     constellation size
;     s_firstloadedtone -     first loaded tone
;     s_numTones        -     total number of tones available
;
;  Output Arguments:
;     ps_bat         -     bat table
;     ps_finegain    -     fine gain table
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
int16 mte_calcBATSetFineGains(FlagT ft_isTcm,
                        int16 s_totalDataBits,
                        int16 s_constsize,
                        int16 s_firstloadedtone,
                        int16 s_numTones,
                        int16 s_num1bits,
                        int16* ps_bat,
                        int16* ps_finegain)
{

   int16 i, s_numTonesLoaded;
   int16 s_bits, s_leftbits, s_extrabits;

   /* ========================================================================= */
   /* init variables
   /* ========================================================================= */

   /* we need to add 4 bits to the BAT table to send predetermined sequence to drive TCM Encode/Decoder to know state */
   if(ft_isTcm == TRUE)
      s_totalDataBits += 4;


   if(s_constsize > (TX_MAX_BITS_PER_TONE-(int16)ft_isTcm))
      return(FAIL);

   s_bits = 0;
   s_leftbits= 0;

   /* ========================================================================= */
   /* load BAT, set Fine Gain */
   /* ========================================================================= */
   s_numTonesLoaded = 0;
   for(i=s_numTones - s_num1bits; i< s_numTones ; i++)
   {
      s_bits++;
      ps_bat[i] = 1;
      s_numTonesLoaded++;
   }

   for(i=0; i < (s_numTones - s_num1bits); i++)
   {
      s_leftbits = s_totalDataBits - s_bits;
      //No more tones to be loaded
      if(s_leftbits == 0 || i < s_firstloadedtone)
      {
         ps_bat[i]=0;
         ps_finegain[i] = 0;
         continue;
      }
      //Load tone
      else if (s_leftbits > s_constsize)
      {
         ps_bat[i] = s_constsize;
         s_bits += s_constsize;
      }
      else if(s_leftbits > 1)
      {
         ps_bat[i] = s_leftbits;
         s_bits += s_leftbits;
      }
      else
      {
         ps_bat[i-1]--;
         ps_bat[i] = s_leftbits+1;
         s_bits += s_leftbits;
      }
      ps_finegain[i] = 0x2000;   //Set fine gain to unity

      s_numTonesLoaded++;
}

   if(ft_isTcm)
   {
      s_extrabits = (s_numTonesLoaded - (s_num1bits >> 1) + 1) >> 1;

      while(s_extrabits >0)
      {
         for(i=0; i < (s_numTones - s_num1bits), s_extrabits>0; i++)
         {
            if(ps_bat[i]>1)
            {
               ps_bat[i]++;
               s_extrabits --;

            }

         }
      }
   }


   if(s_leftbits != 0)
      return(FAIL);
   else
      return(SUCCEED);
}

/*****************************************************************************
;  Prototype:
;     void mte_toneOrdering(int16 *psa_BAT, int16 s_numTones, int16 s_MaxBitPerTone, int16 *psa_ToneIndices)
;
;  This subroutine performs the tone ordering as specified in G992.1 specification.
;
;
;  Input Arguments:
;     psa_BAT        -- pointer to the Bit Allocation Table
;
;     s_numTones     -- total number of frequency tones or bands (DC and Nyquist tone is consider to
;                    be one tone)
;     s_MaxBitsPerTone-- maximum number of bits per tone
;
;  Output Arguments:
;     psa_ToneIndices -- pointer to an array of tone indices with the number of bits per tone
;              in ascending order (for those tones with the same number of bits,
;              the tone indices are in ascending order)
;
;  Global Variables Used:
;
;****************************************************************************/
void mte_toneOrdering(int16 *psa_BAT,
               int16 s_numTones,
               int16 s_MaxBitsPerTone,
               int16 *psa_ToneIndices)
{
      int16 i, j, k;
      int16 sa_count[TX_MAX_BITS_PER_TONE+1];
      int16 sa_idx[TX_MAX_BITS_PER_TONE+1];

      /* Init tone count to 0 */
      for(k=0; k<=s_MaxBitsPerTone; k++)
         sa_count[k] = 0;

      /* Count the number of tones in each bit-assignment group */
      for(i=0; i<s_numTones; i++) {
         k = psa_BAT[i];
         sa_count[k]++;
      }

      /* Compute the first tone location for each bit-assignment group */
      sa_idx[0] = 0;
      sa_idx[1] = sa_count[0];

   // sa_idx[2] = sa_count[0];

      for(k=2; k<=s_MaxBitsPerTone; k++) {

         j = k-1;
         sa_idx[k] = sa_idx[j] + sa_count[j];
      }

      /* Sort indices according to tone ordering rule  */
      for(i=0; i<s_numTones; i++) {
         k = psa_BAT[i];
         psa_ToneIndices[sa_idx[k]] = i;
         sa_idx[k]++;
      }
}

/*****************************************************************************
;  Prototype:
;     void mte_toneOrdering_tcm(int16 *psa_BAT, int16 *psa_tone_order, int16 s_numTones, int16 *psa_tone_order_tcm,int16 *psa_num1bittones, FlagT *pft_tcm_x0_ygt1, int16 *ps_MinTone)
;
;  This subroutine performs the tone ordering as specified in G992.1 specification.
;
;
;  Input Arguments:
;     psa_BAT        -- pointer to the Bit Allocation Table
;
;     psa_tone_order -- pointer to the Tone Ordering Table
;
;     s_numTones     -- total number of frequency tones or bands (DC and Nyquist tone is consider to
;                    be one tone)
;
;  Output Arguments:
;     psa_tone_order_tcm   -- pointer to an array of tone indices with the number of bits per tone
;                       in order required for TCM
;     psa_num1bittones  -- number of 1 bit tones
;
;     pft_tcm_x0_ygt1      --  condition x=0 and y>1 for tcm
;
;  Global Variables Used:
;
;****************************************************************************/
void mte_toneOrdering_tcm(int16 *psa_BAT,
               int16 *psa_tone_order,
               int16 s_numTones,
               int16 *psa_tone_order_tcm,
               int16 *ps_num1bittones,
               FlagT *pft_tcm_x0_ygt1,
               int16 *ps_MinTone)
{
   int16 i, j, k, s_NumLoadedTones;

   *ps_num1bittones = 0;

   for(i=0, s_NumLoadedTones=0; i < s_numTones; i++) {
      s_NumLoadedTones += (int16) (psa_BAT[i] > 0);
      *ps_num1bittones += (int16) (psa_BAT[i] == 1);
   }

   if((s_NumLoadedTones - (*ps_num1bittones >> 1)) &0x1 == 1)
      *pft_tcm_x0_ygt1 = 1;

   for(i=0, j=0; i < s_numTones;i++)
   {
      if(psa_BAT[psa_tone_order[i]] == 0)
      {
         psa_tone_order_tcm[j] = psa_tone_order[i]; j++;
      }

   }

   for(i=0, k=0; i < s_numTones;i++)
   {
      if(psa_BAT[psa_tone_order[i]] == 1)
      {
         psa_tone_order_tcm[s_numTones - *ps_num1bittones + k]= psa_tone_order[i]; k++;

      }
      else if(psa_BAT[psa_tone_order[i]] != 0)
      {
         psa_tone_order_tcm[j] = psa_tone_order[i]; j++;
      }
   }

   if((*pft_tcm_x0_ygt1) == 1)
      *ps_MinTone = s_numTones - s_NumLoadedTones -1;
   else
      *ps_MinTone = s_numTones - s_NumLoadedTones;
}





/*************************************************************************/

void set_and_run_IFFT(int16 in_place_buffer,int16 fft_size)
{

   int16 us_data, i;
   int16 us_PhysAddr;
   int32 ul_data=0;

   /*
   int32 ifft_random_input1[32]={
   0x0000FCCE, 0x00C60331, 0x031403AB, 0xFC1EFF42, 0x02E8FD1C, 0xFDF6FC5D, 0xFC42FD50, 0xFDC2FC23,
   0xFE48FEBF, 0x006EFEDC, 0xFEFAFED8, 0x0348FFBA, 0xFF69FE6E, 0x03CE0274, 0x03EEFE0D, 0x039DFC6D,
   0x01A40288, 0x03C8FFBB, 0xFE670200, 0xFED00235, 0xFC98FD96, 0xFC83FEDE, 0xFFE50017, 0xFEFD03E3,
   0xFC53FDD9, 0xFC0A0369, 0xFCCDFE0E, 0x02350170, 0x027901CB, 0xFCAEFD0F, 0x020D0103, 0xFD64FF3D};
    */

   /**************************************/
   /* set all Tx blocks to register mode */
   /**************************************/
   us_data = 0;
   us_data |= IRI_PRE_IFFT_START_SELECT;     // Register start.
   us_data |= IRI_QAM_ENCODE_START_SELECT;      // Register start.
   us_data |= 0x40;                    // Disable Buffer Swap on frame

   WriteCoreReg(IRI_REG_IT_MODE_ADDR, us_data);
   WriteCoreReg(IRI_REG_IT_AMODE_ADDR, us_data);

   /********************/
   /* select IFFT size */
   /********************/

   if(fft_size == 64)
      WriteCoreReg(IRI_REG_IT_MISC_ADDR, 0x0000);

   if(fft_size == 128)
      WriteCoreReg(IRI_REG_IT_MISC_ADDR, 0x4000);

   WriteCoreReg(IRI_REG_IT_SCALE_ADDR, SCALEBACK);

   /************/
   /* set bank */
   /************/

   if (in_place_buffer == 0)
      WriteCoreReg(IRI_REG_IBANK_ADDR, 0x0000);
   else
      WriteCoreReg(IRI_REG_IBANK_ADDR, 0x0001);

   /*******************************************************/
   /* Write data into the IFFT real and imaginary buffers */
   /*******************************************************/
   if(in_place_buffer == 1)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_A0_ADDR;
   else if(in_place_buffer == 0)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_B0_ADDR;

   /* Clear input first */

   for (i = 0; i < 64; i++)
        WriteCoreReg32((uint16) (us_PhysAddr+ i), 0);

   fft_size >>= 1;

   /* Write data */
   for (i = 0; i < fft_size; i++){
      //WriteCoreReg32((uint16) (us_PhysAddr +i), ifft_random_input1[i]);
      ul_data=((uint32)i<<16)+((i+1)&0xFFFF);
        WriteCoreReg32((uint16) (us_PhysAddr +i), ul_data);
   }


   /*****************************/
   /* CRI clocks relevant cores */
   /*****************************/

   WriteCoreReg(CRI_CCR0_ADDR,(uint16)0x0010);/* enable AC_CLK */
   WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x0500);/* enable MTE_TX_CLK, MTE_RX_CLK */


   /****************************/
   /* Start IFFT and then wait */
   /****************************/
   SetCoreReg(CRI_EVENT1_ADDR, (1<<CRI_MTE_IFFT_DONE));  /* Clear IFFT Done Event Bit */
   SetCoreReg(IRI_REG_IT_CTRL_ADDR, IRI_PRE_IFFT_START); /* start IFFT */

do {
      //ClockCores(500);
      ReadCoreReg(CRI_EVENT1_ADDR, &us_data);
      if(us_data & (1<<CRI_MTE_IFFT_DONE)) break;        /* If IFFT done, break */
   } while(1);
}

void CheckResults(int16 in_place_buffer, int16 fft_size)
{
   int16 i, us_PhysAddr;
    uint16 us_success;

   int32 ifft_reference_output1[64]={
   0x00000042,  0x0000fffe,  0x00000000,  0x0000fffc,  0x00000003,  0x0000fffd,  0x0000ffff,  0x0000fff9,
   0x00000008,  0x0000fffe,  0x0000ffff,  0x0000fffb,  0x00000001,  0x0000fffd,  0x0000fffe,  0x0000fff4,
   0x00010013,  0x0000fffe,  0x00000000,  0x0000fffb,  0x00010003,  0x0000fffd,  0x0000ffff,  0x0000fff8,
   0x00000005,  0x0000fffe,  0x00000000,  0x0000fffb,  0x00000001,  0x0000fffd,  0x0000fffe,  0x0000ffea,
   0x0001ffc0,  0x00000002,  0x00000001,  0x00000003,  0x0001fffe,   0x00000002,  0x00000002,  0x00000006,
   0x0000fffa,  0x00000002,  0x00000001,  0x00000004,  0x00000000,  0x00000003,  0x00000002,  0x0000000c,
   0x0001fff3,  0x00000002,  0x00010000,  0x00000004,  0x0000ffff,  0x00000003,  0x00000001,  0x00000008,
   0x0000fffc,  0x00000002,  0x00000001,  0x00000007,  0x00010000,  0x00000003,  0x00010002,  0x00000011};

   if(in_place_buffer == 1)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_A0_ADDR;
   else if(in_place_buffer == 0)
      us_PhysAddr = (int16) IRI_RAM_TX_IFFT_B0_ADDR ;

   fft_size >>= 1;

   for(i = 0; i < fft_size; i++) {
      us_success=ReadCompareReg32(us_PhysAddr, i, (uint32) 0xFFFFFFFF, ifft_reference_output1[i]);
      if (us_success==0)   gs_error_count++;
   }
}



/***************************************************************
 *   main
 ***************************************************************/
int16 Test_Danube_IFFT(void)
{
   set_and_run_IFFT( 0, 64);     // Buffer A0, 64-point IFFT (emulation)
   CheckResults(0, 128);   // Check all 128 upsampled time-domain values

// set_and_run_IFFT(ifft_random_input2, 0, 128);   // Buffer A0, 128-point IFFT
// CheckResults(ifft_reference_output2, 0, 128);   // Check all 128 time domain values

// set_and_run_IFFT(ifft_random_input1, 1, 64);    // Buffer B0, 64-point IFFT (emulation)
// CheckResults(ifft_reference_output1, 1, 128);   // Check all 128 upsampled time-domain values

// set_and_run_IFFT(ifft_random_input2, 1, 128);   // Buffer B0, 128-point IFFT
// CheckResults(ifft_reference_output2, 1, 128);   // Check all 128 time domain values

   if(gs_error_count == 0)
      return(SUCCEED);
   else
      return(FAIL);

}

#endif // !AMAZON_SE
