/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2005 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;The software is owned by Aware, Inc. and is protected by United States
;;;copyright laws and international treaty provisions. Therefore, you must treat
;;;the software like any other copyrighted material.  You may not use or copy
;;;the software or any accompanying written materials for any other purpose than
;;;what is described in the Development and License Agreement
;;;entered into with Aware Inc. (the "Agreement").  Except as
;;;expressly provided in the Agreement, Aware does not grant any express or
;;;implied rights to you to or under Aware or any third party patents, copyrights,
;;;trademarks, or trade secret information.  Additionally, you shall reproduce
;;;and apply any copyright or other proprietary rights notices included on or
;;;embedded in the software to any copies or derivative works made thereof, in
;;;whole or in part, in any form.  These rights are provided for information
;;;clarification, other restrictions of rights may apply as well.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Description : AAI Loopback test using UTOPIA port
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;*/

//##################################333
// This file include only the atm_loopback test


/*
;;; IMBOX0  ; MTE Tx Timer delay value
;;; IMBOX1  ; BC0 number of bytes
;;; IMBOX2  ; BC1 number of bytes
;;; OMBOX0  ; ATM Sync status
*/

#ifdef AMAZON_SE
// this is an SE and SEOD test set, maybe a we can modify the files for danube.

#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "gdata.h"
#include "cmv.h"

#define BIG_TIMEOUT (3200)
#define WaitingForTX (1)
#define WaitingForRX (2)
#define NUMBER_CONFIGURATIONS 3  /* Number of test cases to be run. */
#define SCALEBACK 0x006A         /* alternating scalebacks */
#define OVERFLOW 0               /* we don't want overflows */

int16 IMBOX0,IMBOX1=53,IMBOX2=53,OMBOX0;
int TestStat;
int TimedOut;
int myTimer;
int rxDone,txDone;
int gl_loop_counter;
int gl_RxDataTaken;
int gl_TxDataGiven;

//Danube PPE debugging
uint16 gusa_PPEATM_RxCnt[NUM_BEARER_CHANNELS][6];
uint16 gusa_PPEATM_TxCnt[NUM_BEARER_CHANNELS][2];

int16 AtmTxRxLoopInit(void);
int16 AtmTxRxLoopRun(int NumberOfTimes);
void start_aai_rx(void) ;
void CopyDataToRx(void);
int aai_tx_handler();
int aai_rx_handler();

int16 ReadCompareReg(uint16 addr, uint16 mask, int16 expect);
int16 ReadCompareReg32(uint16 us_BaseAddr, uint16 us_Offset, uint32 mask, int32 ul_ExpectedData);

#define MAX_16 0x7fff
#define MIN_16 0x8000
#define MAX_32  0x7fffffff
#define MIN_32  0x80000000


#define ENCGAINMANTISSA1         0x2000
#define ENCGAINMANTISSA2         8192
#define ENCGAINMANTISSA3         9459
#define ENCGAINMANTISSA4         7327
#define ENCGAINMANTISSA5         10362
#define ENCGAINMANTISSA6         7151
#define ENCGAINMANTISSA7         10235
#define ENCGAINMANTISSA8         7108
#define ENCGAINMANTISSA9         10204
#define ENCGAINMANTISSA10           7098
#define ENCGAINMANTISSA11           10196
#define ENCGAINMANTISSA12           7095
#define ENCGAINMANTISSA13           10194
#define ENCGAINMANTISSA14           7095
#define ENCGAINMANTISSA15        10194

/* QAM Decoder constellation gains for bit-sizes 2-15. Format is [S 2.13].  */

#define DECGAINMANTISSA1               (0x2000)
#define DECGAINMANTISSA2               (0x2000)
#define DECGAINMANTISSA3               (0x376d)
#define DECGAINMANTISSA4               (0x23c7)
#define DECGAINMANTISSA5               (0x3299)
#define DECGAINMANTISSA6               (0x24a9)
#define DECGAINMANTISSA7               (0x333a)
#define DECGAINMANTISSA8               (0x24e1)
#define DECGAINMANTISSA9               (0x3362)
#define DECGAINMANTISSA10                 (0x24ef)
#define DECGAINMANTISSA11                 (0x336b)
#define DECGAINMANTISSA12                 (0x24f2)
#define DECGAINMANTISSA13                 (0x336e)
#define DECGAINMANTISSA14                 (0x24f3)
#define DECGAINMANTISSA15                 (0x336f)


/***********************************************************
*  Global Variables
***********************************************************/

 ////////////////////////////////////////////////////

int16 AtmTxRxLoopInit(void){

int32 *pl,i;
int16 us_Reg;
//;;; START OF MAIN TEST CODE


//;;; Configure  ADSL Clocks  (not needed in this test )
/* mov   r0,0x00000001     ; Set clock dividers
   st r0,[CRI_CDC0]     ;
   mov   r0,0x00001555     ;
   st r0,[CRI_CDC1]     ;
*/

   // Enable ADSL clocks
   //us_Reg=0x1a; //mov r0,0x0000001A     ; Enable clocks
    us_Reg=0x1a; //Enable Aware and Electral Clk
   WriteCoreReg((uint16) CRI_CCR0_ADDR, us_Reg);//st  r0,[CRI_CCR0]     ;
// us_Reg=0x1aaa; //mov r0,0x00001AAA     ;
   us_Reg=0x1aa5;
   WriteCoreReg((uint16) CRI_CCR1_ADDR, us_Reg);// st r0,[CRI_CCR1]     ;

//;;; Configure the AAI Core
   us_Reg= 0xf; //mov   r0, 0xf
   WriteCoreReg((uint16) A_UTPCFG_ADDR, us_Reg); //st r0,[A_UTPCFG]

   us_Reg= 0x3C20    ; //Enable TXBC0, RXBC0, TXBC1, RXBC1
   //st  r0,[A_CFG]     ; BC0 UTOPIA address is 0, BC1 is 1
   WriteCoreReg((uint16) A_CFG_ADDR, us_Reg);

   us_Reg=0x0000     ; //Scrambler Disable

   WriteCoreReg((uint16) AT_CFG_ADDR(BC0), us_Reg);
   WriteCoreReg((uint16) AT_CFG_ADDR(BC1), us_Reg);
   WriteCoreReg((uint16) AR_CFG_ADDR(BC0), us_Reg);
   WriteCoreReg((uint16) AR_CFG_ADDR(BC1), us_Reg);

   us_Reg=0x0015        ;// Tx Utopia mode, reg start
   WriteCoreReg((uint16) AT_CNTL_ADDR, us_Reg);//  st r0,[AT_CNTL]      ;

   us_Reg=0x0015     ;// Rx Utopia mode, reg start
   WriteCoreReg((uint16) AR_CNTL_ADDR, us_Reg); //st  r0,[AR_CNTL]      ;

// ;;; set up BC0

   us_Reg=IMBOX1;    // ;BC0 number of bytes
    us_Reg--;     //  sub  r0,r0,1        ; subtract 1
   us_Reg <<= 8;  // asl   r0,r0,8        ; shift up 8 bits
   WriteCoreReg (AT_FB_SIZE_ADDR(0), us_Reg);//st  r0,[AT_FB_SIZE0]  ; Tx FB Start BC0, End BC0 addresses

   us_Reg=0    ;// Rx FB Start BC0 address
   WriteCoreReg (AR_FB_START_ADDR(0), us_Reg);//st r0,[AR_FB_START0] ;

   us_Reg=IMBOX1;    // ;BC0 number of bytes
    us_Reg--;     //  sub  r0,r0,1        ; subtract 1
   WriteCoreReg (AR_FB_END_ADDR(0), us_Reg);//st   r0,[AR_FB_END0]      ; (Rx FB End BC0 address

   //;;; set up BC1
   us_Reg = IMBOX1;
   us_Reg += IMBOX2;
   us_Reg--;
   us_Reg<<=8; //asl r1,r1,8        ; shift up 8 bits
   us_Reg |= IMBOX1; //or  r0,r0,r1    ; start, end address merge
   WriteCoreReg (AT_FB_SIZE_ADDR(1), us_Reg);// st r0,[AT_FB_SIZE1]  ; Tx FB Start BC1, End BC1 addresses

   us_Reg = IMBOX1      ; //BC0 number of bytes
   WriteCoreReg (AR_FB_START_ADDR(1), us_Reg); //st   r0,[AR_FB_START1] ; Rx FB Start BC1 address

   us_Reg = IMBOX2; // ld  r1, [IMBOX2]      ; BC1 number of bytes
   us_Reg += IMBOX1; //add r0,r0,r1
    us_Reg--; //sub  r0,r0,1        ; subtract 1
   WriteCoreReg (AR_FB_END_ADDR(1), us_Reg);//st   r0,[AR_FB_END1]      ; Rx FB End BC1 address

//;;; Set up interrupts

//;;; Initialize test parameters
   OMBOX0=0; //   st 0,[OMBOX0]     ; Clear OMBOX0

//;;; Initialize the Tx Frame buffer
//#define      ZEP_RAM_RX_FRAMEBUFFER_ADDR      0x3800
//#define      ZEP_RAM_TX_FRAMEBUFFER_ADDR      0x3a00

   for (i=0;i<106;i++)
      WriteCoreReg((int16) ( ZEP_RAM_TX_FRAMEBUFFER_ADDR+ i), 0);

      WriteCoreReg (CRI_AMASK1_ADDR, (1<<8));   //tx
   WriteCoreReg (CRI_MASK1_ADDR, (1<<8));

      WriteCoreReg (CRI_AMASK0_ADDR, (1<<10)); //rx
      WriteCoreReg (CRI_MASK0_ADDR,  (1<<10));

    //Danube PPE Debugging
    INFOMap[INFO_PPEATMRxCnt] = (uint16*) gusa_PPEATM_RxCnt;
    INFOMap[INFO_PPEATMTxCnt] = (uint16*) gusa_PPEATM_TxCnt;

   return(1);
}

int16 AtmTxRxLoopRun(int NumberOfTimesMax)
{
   int16 us_Reg;
   int TimedOut=0;
   int NumberOfTimesActual=0;
   uint16 s_bc,i,us_ATM_Cnt_RxReg_Offset,us_ATM_Cnt_TxReg_Offset;

   //gua_PPEATM_Cnt[s_bc][0]: User Cell Count
    //gua_PPEATM_Cnt[s_bc][1]: Idle Cell count
    //gua_PPEATM_Cnt[s_bc][2]: ATM Idle Cell count
    //gua_PPEATM_Cnt[s_bc][3]; Bit Error count
   //gua_PPEATM_Cnt[s_bc][4]: HEC Error count
   //gua_PPEATM_Cnt[s_bc][5]: Cell Drop count

   while ( (NumberOfTimesActual< NumberOfTimesMax) && (!TimedOut) )
   {

   //;;; Start the test with a AAI Tx Start
   ReadCoreReg((uint16) AT_CNTL_ADDR, &us_Reg);  //ld r0, [AT_CNTL]     ;
   us_Reg |= 0x20;                  //or  r0, r0, 0x00000020   ;
      WriteCoreReg (AT_CNTL_ADDR, us_Reg);  //st   r0, [AT_CNTL]     ; Start AAI Tx

   TestStat = WaitingForTX;

   //;;; Wait for all cells to be processed
   myTimer = BIG_TIMEOUT;
   txDone=0;
   while (((myTimer--) >0) && !txDone) {
   txDone = aai_tx_handler();
   }

   if (txDone)
   {
      CopyDataToRx();
      start_aai_rx(); //startRxATM();
      TestStat = WaitingForRX;

      myTimer = BIG_TIMEOUT;
      rxDone=0;
      while (((myTimer--) >0)&& !rxDone) {
         rxDone = aai_rx_handler();
         }
      if (!rxDone)
         TimedOut=1;
   }
   else
      TimedOut=1;

   if (txDone && rxDone) {
      for(s_bc = 0; s_bc < NUM_BEARER_CHANNELS; s_bc++){
         us_ATM_Cnt_RxReg_Offset = AR_CELL_ADDR(s_bc);
         for (i = 0; i < 6; i++) {
         ReadCoreReg((uint16)(us_ATM_Cnt_RxReg_Offset+2*i) , &gusa_PPEATM_RxCnt[s_bc][i]);
         if (gusa_PPEATM_RxCnt[s_bc][i]>=0x8000)
            WriteCoreReg((uint16)(us_ATM_Cnt_RxReg_Offset+2*i) , 0);
         }
           us_ATM_Cnt_TxReg_Offset = AT_CELL_ADDR(s_bc);
         for (i = 0; i < 2; i++) {
         ReadCoreReg((uint16)(us_ATM_Cnt_TxReg_Offset+2*i) , &gusa_PPEATM_TxCnt[s_bc][i]);
         if (gusa_PPEATM_TxCnt[s_bc][i]>=0x8000)
         WriteCoreReg((uint16)(us_ATM_Cnt_TxReg_Offset+2*i) , 0);
         }
      }
   }
   gl_loop_counter++;
   NumberOfTimesActual++;
} //while

   return(NumberOfTimesActual);

}
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

int aai_tx_handler(void)
{
   int16 us_Reg;

   ReadCoreReg((uint16) CRI_STATUS1_ADDR, &us_Reg);;//   ld r1,[CRI_STATUS1] Get status
   us_Reg &= (1<<8) ;//and.f  0,r1,0x00000100
   if (us_Reg==0)
      return(0);
   else
   {
      WriteCoreReg((uint16) CRI_STATUS1_ADDR, us_Reg); //   st r1,[CRI_STATUS1]   Clear CRI Int status
      return(1);
   }
}

void CopyDataToRx(void) {
   int32 *pl_Tx,*pl_Rx;
   uint16 temp_data;
   int16 lp_count;

   pl_Tx = (int32 *)  ZEP_RAM_TX_FRAMEBUFFER_ADDR;//  mov   r2,fci_txfb_base-4   ; Tx frame buffer base address, less 1 word
   pl_Rx = (int32 *)  ZEP_RAM_RX_FRAMEBUFFER_ADDR;//  mov   r3,fci_rxfb_base-4   ; Rx frame buffer base address, less 1 word

//   for (lp_count=0; lp_count<256/4;lp_count++) {
//       *pl_Rx++ = *pl_Tx++ ; //ld.a  r4,[r2,4]      ; load and update address
//                   //st.a   r4,[r3,4]      ; store and update address
//   }

  for (lp_count=0; lp_count<106;lp_count++) {
      ReadCoreReg((uint16) ( ZEP_RAM_TX_FRAMEBUFFER_ADDR+ lp_count), &temp_data);
       WriteCoreReg((uint16) (ZEP_RAM_RX_FRAMEBUFFER_ADDR+ lp_count), temp_data);
      }

}

void start_aai_rx(void ){
   int16 us_Reg;
   // let atm find its own sync.
   ReadCoreReg((uint16) AR_CNTL_ADDR, &us_Reg);//  ld r0, [AR_CNTL]     ; Get current value of AR_CNTL
   us_Reg |=  0x020 ;; // or  r0, r0, 0x00000020   ;
    WriteCoreReg((uint16) AR_CNTL_ADDR, us_Reg); //   st r0, [AR_CNTL]     ; Start AAI Rx

}
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

int aai_rx_handler(void) {

   int16 us_Reg;
   int done;
   ReadCoreReg((uint16) CRI_STATUS0_ADDR, &us_Reg) ;//   ld r1,[CRI_STATUS1] Get status
   done = us_Reg & (1<<10) ;
   if (done==0)
      return(0);
   else
   {
      WriteCoreReg((uint16) CRI_STATUS0_ADDR, us_Reg); //   st r1,[CRI_STATUS1]   Clear CRI Int status
      gl_RxDataTaken++;
      ReadCoreReg((uint16) AR_ATM_STAT_ADDR(0), &us_Reg);
      OMBOX0 = ((us_Reg>>1)&1); //update if ATM is synced.
      ReadCoreReg((uint16) AR_ATM_STAT_ADDR(1), &us_Reg);
      OMBOX0 |= ((us_Reg)&2) ;//update if ATM is synced.
      return(1);
   }
}

#endif //AMAZON_SE
