/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   testModeOPeration.c
 *
 *   module for running tests *
 *----------------------------------------------------------------------------
 */

#include "const.h"
#include "gdata.h"

/*
#include "file_io.h"
#include <stdio.h>
#include <stdlib.h>
#include "modem_hw.h"
#include "InitBMf.h"
#include "trail.h"
#include "trailend.h"
#include "file_io3.h"
#include "ghs.h"
#include "string.h"
#include "mp.h"
*/
#include "cmv.h"
/*
#include "nmp.h"
#include "nmp_plfm.h"
#include "channel.h"
#include "bert.h"
#include "STR_IOf.h"
*/
//#include "ALP_IOf.h"
/*
#include "stateini.h"
#include "ec_data.h"
#include "gdata_bis.h"
#include "sach.h"        // For Sachmo channel
#include "data_alloc.h"
#include "cnfg_eng.h"
#include "cnfg_task.h"
#include "LinkStart.h"
#include "LinkStartForTest.h"
*/
#include "compiler.h"
#include "codeswap.h"
#include "soc_codeswap.h"

/*
#include "AllocateDataBuffers_PreHndshk.h"
#include "states.h"
*/
#include "memrymap.h"
#include "ll_iof.h"
/*
#include "tx_plam.h"
#include "delay.h"
#include "hndshk_Data.h"
#include "me_hdlc_txprocessor_bis.h"
#include "interrupt.h"
*/

#ifdef SLEEP_TEST_BUILD
#include "ifft_fix.h"

void enableCache(void);
void disableCache(void);

extern int16 AtmTxRxLoopInit(void);
extern int16 AtmTxRxLoopRun(int NumberOfTimes);
extern int16 Test_Danube_MTE_RAM(void);
extern int16 Test_Danube_FCI_RAM(void);
extern int16 Test_Danube_Loopback(void);
//extern int16 Test_Danube_FFT(void);
extern int16 Test_Danube_IFFT(void);
extern int16 Test_RTV(void);


#define TEST_PASSED (0x900d)
#define TEST_ACTIVE (0x0090)            // should be read as "go" meaning running
#define TEST_FAILED (0x0bad)

#endif


/*-------------------------------------------------------------------
*
*  int testModeOperation
*
*  Description: This is the main program for running Aware test Mode Code.
*
*  Command line arguments:
*        None
*
*-------------------------------------------------------------------
*^^^
*/
#ifdef SLEEP_TEST_BUILD
int16 gs_SleepLog;
int32 gl_SleepResult;
int16 gs_TestPage;

extern int32 *gpl_XdmaTestBuf;

// these are 32-bit variables to make ez to do debug mem reads.
uint32 gul_TestLoopCount = 0;
int32 gl_TxTestState = 0;
int32 gl_TxTestStateAfterSwap;

int16 gs_B[4];

#define USE_CACHE
int testModeOperation(void) {

    static int ATMInit_OK=0;

    int16 i;
    int stat;


    if (CNTLArray[0] & 0x08)
    {
        gul_TestLoopCount++;

        switch (gl_TxTestState)
        {
            case -1:  // clean-up substate
                TESTArray[TEST_TxSubState] = 0;
                gl_TxTestState = 0;
                break;

            case 0:  // Default substate
                if (0 != TESTArray[TEST_TxSubState])
                {
                    gl_TxTestState = TESTArray[TEST_TxSubState];
                }
                break;

            case 1:   // testing XDMA swapping
                gs_TestPage = CSPAGE_BIS_XDMA_TEST;
                gl_TxTestStateAfterSwap = 101;
                gl_TxTestState = 0x100;
                break;
#ifndef AMAZON_SE
// gpl_XdmaTestBuf is not declared
            case 101: // actual test
                for(i = 0; i < 256; i++)
                {
                    if ((gpl_XdmaTestBuf[2*i] != (0x01020300 + i)) ||
                        (gpl_XdmaTestBuf[2*i+1] != (0x0a0b0c00 + i)))
                    {
                        gl_SleepResult = (TEST_FAILED<<16)| 0x0001;
                        gl_TxTestState = -1;
                        break;
                    }
                }

                gl_SleepResult = (TEST_PASSED<<16)| 0x00001;    // should be read as Good, test# 01
                gl_TxTestState = -1;
                break;
#endif
            case 2:    //always passes
                gl_SleepResult = (TEST_PASSED<<16)| 0x02;
                gl_TxTestState = -1;
                break;


            case 3:     // testing running functions on BG_CACHE
                {
                int16 A[256],B[256];
                int16 REF[4] = {8129,-16318 ,128,20096};


                enableCache(); //assembly function to hit IC_CTRL aux reg.

                for (i=0;i<256;i++)
                {
                    A[i]=i<<4;
                }
                IfftReal(A, B, (int16)(256>>1), (int16)(8-1));


                for(i=0,stat=0;i<3;i++)
                {
                    gs_B[i]=B[i];
                    stat += (B[i] != REF[i]);
                }

                if (stat==0)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x0003;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x0003;

                gl_TxTestState = -1;
                }
                break;


            case 4:     // codeswap to test ATM Loopback
                // swap in sleep page
                gs_TestPage = CSPAGE_BIS_ATM_LOOPBACK;
                gl_TxTestStateAfterSwap = 104;
                gl_TxTestState = 0x100;
                break;

            case 104:     // the actual ATM Loopback test
                stat = AtmTxRxLoopInit();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x0004;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x0004;
                gl_TxTestState = 5;
                ATMInit_OK =1;
                gl_TxTestState = -1;
                break;

            case 5:
                gs_TestPage = CSPAGE_BIS_ATM_LOOPBACK;
                gl_TxTestStateAfterSwap = 105;
                gl_TxTestState = 0x100;
                break;

            case 105:     // testing running functions on BG_CACHE
                // HWTESTS_1 page should already swapped in by test case 5.
                /* default TESTArray[Test_EncoderGain] = ENCGAIN2 */
                {
                stat = 0;
                if (ATMInit_OK==1)
                {
                    stat =AtmTxRxLoopRun(1);
                }
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x0005;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x0005;
                }
                break;

            case 6:    //Disable Cache :always passes
                disableCache();
                gl_SleepResult = (TEST_PASSED<<16)| 0x0006;
                gl_TxTestState = -1;
                break;

            case 7:   //MTE Memory Test
                // swap in HWTESTS_1 page
                gs_TestPage = CSPAGE_BIS_HWTESTS_1;
                gl_TxTestStateAfterSwap = 107;
                gl_TxTestState = 0x100;
                break;

            case 107:   //MTE Memory Test
                stat=0;
                stat=Test_Danube_MTE_RAM();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x0007;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x0007;
                gl_TxTestState = -1;
                break;

            case 8: // FCI Memory Test
                // swap in HWTESTS_1 page
                gs_TestPage = CSPAGE_BIS_HWTESTS_1;
                gl_TxTestStateAfterSwap = 108;
                gl_TxTestState = 0x100;
                break;

            case 108: // FCI Memory Test
                stat=0;
                stat=Test_Danube_FCI_RAM();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x0008;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x0008;
                gl_TxTestState = -1;
                break;

#ifndef AMAZON_SE
            case 9: // FCI/MTE Loopback Test
                // swap in HWTESTS_1 page
                gs_TestPage = CSPAGE_BIS_MTE_FCI_LOOPBACK;
                gl_TxTestStateAfterSwap = 109;
                gl_TxTestState = 0x100;
                break;

            case 109: // FCI/MTE Loopback Test
                stat=0;
                stat=Test_Danube_Loopback();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x0009;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x0009;
                gl_TxTestState = -1;
                break;
#endif

            case 10:
                // swap in HWTESTS_1 page
                gs_TestPage = CSPAGE_BIS_HWTESTS_1;
                gl_TxTestStateAfterSwap = 110;
                gl_TxTestState = 0x100;
                break;

            case 110:
                // MTE IFFT Test
                stat=0;
                stat=Test_Danube_IFFT();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x000A;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x000A;
                gl_TxTestState = -1;
                break;


            case 11:
                // MTE FFT Test
                stat=0;
                //    stat=Test_Danube_FFT();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x000B;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x000B;

                gl_TxTestState = -1;
                break;

            case 12:    //always passes
                gl_SleepResult = (TEST_FAILED<<16)| 0x000C;
                gl_TxTestState = -1;
                break;

            case 13:
                // swap in HWTESTS_1 page
                gs_TestPage = CSPAGE_BIS_HWTESTS_1;
                gl_TxTestStateAfterSwap = 113;
                gl_TxTestState = 0x100;
                break;

            case 113:
                // MTE IFFT Test
                stat=0;
            gl_SleepResult  = (TEST_ACTIVE<<16)| 0x000D;
                stat=Test_RTV();
                if  (stat==1)
                    gl_SleepResult = (TEST_PASSED<<16)| 0x000D;
                else
                    gl_SleepResult = (TEST_FAILED<<16)| 0x000D;
                gl_TxTestState = -1;
                break;


            // special case to swap in test pages
            case 0x100:
                gs_CodeSwapStatus = CODESWAP_START;
                gs_CodeSwapSection = gs_TestPage;
                do {
                    HandleCodeSwap();
                }while (gs_CodeSwapStatus != CODESWAP_COMPLETE);

                gl_TxTestState = gl_TxTestStateAfterSwap;
                break;

            default:
                gl_SleepResult = ((TEST_FAILED<<16) | gl_TxTestState);
                gl_TxTestState = -1;
                    break;

        }

    }
    return(gl_SleepResult) ;
}
#endif


//////////////////////////////////////////////////
// CaCHE CONTROL ROUTINES
// - Not sure if the regular modem will need
// these funcitons if so we will move them into
// their own file. Right now enabling the cache
// is true on reset and we will keep it enabled.
/////////////////////////////////////////////////
#define AUX_ICACHE_IVIC (0x10)
#define AUX_ICACHE_CTRL (0x11)
#define AUX_ICACHE_LOCK_LINE (0x13)
#define AUX_ICACHE_INVALID_LINE (0x19)
#define AUX_ICACHE_TYPE (0x77)

void enableCache(void){
    _sr(0x0002, AUX_ICACHE_CTRL);
    }
void disableCache(void){
    _sr(0x0001, AUX_ICACHE_CTRL);
    }
void InValidateCache(void){
    _sr(0x0000, AUX_ICACHE_IVIC);
    }

