/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_FFT.C
 *
 *   Iridia CPE Data Transfer Layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "iridia.h"
#include "alphaeus_const.h"

#include "const.h"
#include "gdata.h"
#include "error.h"
#include "goertzel.h"
#include "aoc.h"

#include "LL_Iof.h"
#include "memrymap.h"
#include "string.h"
#include "IRI_Iof.h"

#include "socrates_memrymap.h"
#include "dma_iof.h"

extern void WhichIFFTBuffers(uint16 *, uint16 *);


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    LoadTxOutBuffer
 *
 * Prototype:
 *    LoadTxOutBuffer (int16 *ps_data, int ndata);
 *
 *  Abstract:
 *    LoadTxOutBuffer() -
 *
  *      Copies "ndata" 16-bit data from ps_data to Tx buffer.
 *
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      gs_TxFftLength, gsa_TxToneBuf,
 *    gs_Tx_OutBuf_Size, gs_TxCPLength
 *------------------------------------------------------------------------
 */

void LoadTxOutBuffer(int16 *ps_data, int16 ndata)
{
   uint16 RealPart;
   uint16 ImagPart;
   uint32 ul_StartAddress;

   WhichIFFTBuffers(&RealPart, &ImagPart);

   mComputeSocOffsetAddress(ul_StartAddress, RealPart);

   SetUpDMATransfer((uint32) ps_data, (uint32) &ps_data[ndata-1], ul_StartAddress);

}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    GetTxOutBuffer
 *
 * Prototype:
 *    GetTxOutBuffer (int16 *ps_data, int ndata);
 *
 *  Abstract:
 *    GetTxOutBuffer() -
 *
  *      Copies "ndata" 16-bit data from Tx buffer to ps_data.
 *
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      gs_TxFftLength, gsa_TxToneBuf,
 *    gs_Tx_OutBuf_Size, gs_TxCPLength
 *------------------------------------------------------------------------
 */
void GetTxOutBuffer(int16 *ps_data, int16 ndata)
{
   uint16 RealPart;
   uint16 ImagPart;
   uint32 ul_StartAddress, l_NumberOfBytes;

   WhichIFFTBuffers(&RealPart, &ImagPart);
   l_NumberOfBytes = (ndata - 1) << 1;

   mComputeSocOffsetAddress(ul_StartAddress, RealPart);

   SetUpDMATransfer(ul_StartAddress, (ul_StartAddress + l_NumberOfBytes),(uint32) ps_data );

}

