/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_FFT_showtime.C
 *
 *   Iridia CPE Data Transfer Layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "iridia.h"
#include "alphaeus_const.h"

#include "const.h"
#include "gdata.h"
#include "error.h"
#include "goertzel.h"
#include "aoc.h"

#include "LL_Iof.h"
#include "memrymap.h"
#include "string.h"
#include "IRI_Iof.h"

#include "socrates_memrymap.h"
#include "dma_iof.h"

/***************************************************************************************
;  Subroutine Name: GetRxData
;
;  Description:
;     This routine copies the FFT buffer output from Iridia
;
;  Prototype:
;     void GetRxData(int16 *psa_buffer, int16 s_logicalBuffer, int16 s_offset, int16 s_numTones)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;             None
;
;**********************************************************************************************/
C_SCOPE void GetRxData(int16 *psa_buffer, int16 s_logicalBuffer, int16 s_offset, int16 s_numTones)
{
   uint32 ul_StartAddress;
   int l_NumberOfBytes;

   uint16 us_addr;

   //only get data when we have valid number of tones.
   if (s_numTones)
   {
      us_addr = WhichPhysicalBuffer(s_logicalBuffer);

      // Compute the end offset of the DMA.
      // If we transfer N words from buffer sa_buf
      // then we want to transfer all words from &sa_buf[0]
      // to &sa_buf[N-1], inclusive.
      // &sa_buf[N-1] - &sa_buf[0] = 2N - 2.
      // Here N = gs_RxNumTones << 1.
      // So the end offset is:
      l_NumberOfBytes = (s_numTones << 2) - 2;

      // Compute start address of the DMA
      us_addr += s_offset;
      mComputeSocOffsetAddress(ul_StartAddress, us_addr);

      SetUpDMATransfer(ul_StartAddress, (ul_StartAddress + l_NumberOfBytes),(uint32) psa_buffer);
   }
}
