/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   InitBMf.c
 *
 *   BM initialization
 *
 *
 *----------------------------------------------------------------------------
 */

#include ".\..\common\include\const.h"
#include ".\..\common\include\gdata.h"
#include "iridia.h"
#include "strymon_cpe.h"
#include "zephyr.h"
#include "alphaeus.h"
#include "cri_cocomo_interface.h"
#include "cri_dsp_interface.h"
#include "memrymap.h"
#include "file_io3.h"

#ifdef SIMEXT_ONLY
#include "simext_cocomo_interface.h"
#endif

/* Estimated Latencies in clock cycles */
// Two sets of values. Changing from one set
// to the other may change a symbol count in
// the output trail files by +/1 symbol.

#if 1
// These latency values are are ASIC group.

#define  LATENCY_DATA_XFER_IN    64
#define  LATENCY_QAM_ENCODE         256
#define  LATENCY_TCM_QAM_ENCODE     256
#define  LATENCY_PRE_IFFT        128
#define  LATENCY_COMPLEX_IFFT    576


/* Estimated RX Latencies in clock cycles */
#define  LATENCY_COMPLEX_FFT        3072
#define  LATENCY_POST_FFT        512
#define  LATENCY_FDQ             768
#define  LATENCY_RX_GAINSCALE    512
#define  LATENCY_QAM_DECODE         512
#define  LATENCY_TCM_QAM_DECODE     4000
#define  LATENCY_DATA_XFER_OUT      256

/* Estimated processing latencies in clock cycles for zephyr*/
#define  ZEP_LATENCY_TXTOTAL           500
#define  ZEP_LATENCY_RXTOTAL           1000

#else
// These values can be used to speed up simulation.

#define  LATENCY_DATA_XFER_IN    2
#define  LATENCY_QAM_ENCODE         2
#define  LATENCY_TCM_QAM_ENCODE     2
#define  LATENCY_PRE_IFFT        2
#define  LATENCY_COMPLEX_IFFT    2


/* Estimated RX Latencies in clock cycles */
#define  LATENCY_COMPLEX_FFT        2
#define  LATENCY_POST_FFT        2
#define  LATENCY_FDQ             2
#define  LATENCY_RX_GAINSCALE    2
#define  LATENCY_QAM_DECODE         2
#define  LATENCY_TCM_QAM_DECODE     2
#define  LATENCY_DATA_XFER_OUT      2

/* Estimated processing latencies in clock cycles for zephyr*/
#define  ZEP_LATENCY_TXTOTAL           2
#define  ZEP_LATENCY_RXTOTAL           2

#endif


/* Useful macros */
#define  MASK_BIT0   0x1
#define  MASK_BIT1   0x2
#define  MASK_BIT2   0x4
#define  MASK_BIT3   0x8
#define  MASK_BIT4   0x10
#define  MASK_BIT5   0x20
#define  MASK_BIT6   0x40
#define  MASK_BIT7   0x80
#define  MASK_BIT8   0x100
#define  MASK_BIT9   0x200
#define  MASK_BIT10  0x400
#define  MASK_BIT11  0x800
#define  MASK_BIT12  0x1000
#define  MASK_BIT13  0x2000
#define  MASK_BIT14  0x4000
#define  MASK_BIT15  0x8000

//////////////////////////////
// Zephyr BM
///////////////////////////////

void IRI_DefineLatencies(Iridia_Latencies *Latencies)
{
   Latencies->FDQ = LATENCY_FDQ;
   Latencies->ComplexFFT = LATENCY_COMPLEX_FFT;
   Latencies->PostFFT = LATENCY_POST_FFT;
   Latencies->PreIFFT = LATENCY_PRE_IFFT;
   Latencies->ComplexIFFT = LATENCY_COMPLEX_IFFT;
   Latencies->QAMDecode = LATENCY_QAM_DECODE;
   Latencies->QAMDecodeTrellis = LATENCY_TCM_QAM_DECODE;
   Latencies->QAMEncode = LATENCY_QAM_ENCODE;
   Latencies->QAMEncodeTrellis = LATENCY_TCM_QAM_ENCODE;
   Latencies->DataXferIn = LATENCY_DATA_XFER_IN;
   Latencies->DataXferOut = LATENCY_DATA_XFER_OUT;
   Latencies->RxGainScale = LATENCY_RX_GAINSCALE;
}


void IRI_DefineMemoryMap(Iridia_MemoryMap *MemoryMap)
{

/**********************************************************************
 * Memory map for RAM blocks
 **********************************************************************/

    MemoryMap->REG_RegisterBlock_Start = IRI_REGISTERBLOCK_ADDR;
   MemoryMap->RAM_Tx_Gainscale_Start = IRI_RAM_TX_GAINSCALE_ADDR;
   MemoryMap->RAM_Tx_BitAlloc_Start = IRI_RAM_TX_BITALLOC_ADDR;
   MemoryMap->RAM_Tx_ToneReorder_Start = IRI_RAM_TX_TONEREORDER_ADDR;
#ifndef HWENGINE_30
   MemoryMap->RAM_Tx_Input_Ratebuf_Start = IRI_RAM_TX_INPUT_RATEBUF_ADDR;
#endif
   MemoryMap->RAM_Tx_IFFT_A0_Start = IRI_RAM_TX_IFFT_A0_ADDR;
   MemoryMap->RAM_Tx_IFFT_A1_Start = IRI_RAM_TX_IFFT_A1_ADDR;
   MemoryMap->RAM_Tx_IFFT_B0_Start = IRI_RAM_TX_IFFT_B0_ADDR;
   MemoryMap->RAM_Tx_IFFT_B1_Start = IRI_RAM_TX_IFFT_B1_ADDR;
   MemoryMap->RAM_Rx_FFT_A0_Start = IRI_RAM_RX_FFT_A0_ADDR;
   MemoryMap->RAM_Rx_FFT_A1_Start = IRI_RAM_RX_FFT_A1_ADDR;
   MemoryMap->RAM_Rx_FFT_B0_Start = IRI_RAM_RX_FFT_B0_ADDR;
   MemoryMap->RAM_Rx_FFT_B1_Start = IRI_RAM_RX_FFT_B1_ADDR;
   MemoryMap->RAM_Rx_FFT_C0_Start = IRI_RAM_RX_FFT_C0_ADDR;
   MemoryMap->RAM_Rx_FFT_C1_Start = IRI_RAM_RX_FFT_C1_ADDR;
   MemoryMap->RAM_Rx_FDQ_Mantissa_Start = IRI_RAM_RX_FDQ_MANTISSA_ADDR;
   MemoryMap->RAM_Rx_FDQ_Exponent_Start = IRI_RAM_RX_FDQ_EXPONENT_ADDR;
#ifdef HWENGINE_30
   MemoryMap->RAM_Rx_Reverb_Segue_Detect_Enable_Start = IRI_RAM_RX_REVERB_SEGUE_DETECT_ENABLE_ADDR;
#endif
   MemoryMap->RAM_Rx_BitAlloc_Start = IRI_RAM_RX_BITALLOC_ADDR;
   MemoryMap->RAM_Rx_Gainscale_Start = IRI_RAM_RX_GAINSCALE_ADDR;
   MemoryMap->RAM_Rx_ToneReorder_Start = IRI_RAM_RX_TONEREORDER_ADDR;
#ifndef HWENGINE_30
   MemoryMap->RAM_Rx_Output_Ratebuf_Start = IRI_RAM_RX_OUTPUT_RATEBUF_ADDR;
#endif
   MemoryMap->RAM_Rx_XYDecodeFifo_Start = IRI_RAM_RX_XYDECODE_FIFO_ADDR;
   MemoryMap->RAM_Rx_SurvivorPath_Start = IRI_RAM_RX_SURVIVOR_PATH_ADDR;
   MemoryMap->RAM_Rx_CyclicPrefix_A0_Start = IRI_RAM_RX_CYCLICPREFIX_A0_ADDR;
   MemoryMap->RAM_Rx_CyclicPrefix_A1_Start = IRI_RAM_RX_CYCLICPREFIX_A1_ADDR;
   MemoryMap->RAM_Rx_CyclicPrefix_B0_Start = IRI_RAM_RX_CYCLICPREFIX_B0_ADDR;
   MemoryMap->RAM_Rx_CyclicPrefix_B1_Start = IRI_RAM_RX_CYCLICPREFIX_B1_ADDR;
   MemoryMap->RAM_Rx_CyclicPrefix_C0_Start = IRI_RAM_RX_CYCLICPREFIX_C0_ADDR;
   MemoryMap->RAM_Rx_CyclicPrefix_C1_Start = IRI_RAM_RX_CYCLICPREFIX_C1_ADDR;

   MemoryMap->RAM_Tx_Gainscale_PingPong_Start = IRI_RAM_TX_GAINSCALE_PING_PONG_ADDR ;
   MemoryMap->RAM_Tx_BitAlloc_PingPong_Start = IRI_RAM_TX_BITALLOC_PING_PONG_ADDR ;
   MemoryMap->RAM_Tx_ToneReorder_PingPong_Start = IRI_RAM_TX_TONEREORDER_PING_PONG_ADDR;
   MemoryMap->RAM_Rx_BitAlloc_PingPong_Start = IRI_RAM_RX_BITALLOC_PING_PONG_ADDR ;
   MemoryMap->RAM_Rx_Gainscale_PingPong_Start = IRI_RAM_RX_GAINSCALE_PING_PONG_ADDR;
   MemoryMap->RAM_Rx_ToneReorder_PingPong_Start = IRI_RAM_RX_TONEREORDER_PING_PONG_ADDR;


};

void ZEP_DefineLatencies(Zephyr_Latencies *pt_Latencies)
{
   pt_Latencies->TxTotal = ZEP_LATENCY_TXTOTAL;
   pt_Latencies->RxTotal = ZEP_LATENCY_RXTOTAL;
}

void ZEP_DefineMemoryMap(Zephyr_MemoryMap *pt_MemoryMap)
{

    pt_MemoryMap->RAM_BaseAddr = 0;
    pt_MemoryMap->Reg_BaseAddr = 0;

    /**********************************************************************
     * Memory map for RAM blocks
     **********************************************************************/
    // The following are offset values with respect to RAM_BaseAddr.

    pt_MemoryMap->RAM_Rx_LP0_CW_BUF_Start       = ZEP_RAM_RX_LP0_CW_BUF_ADDR;
    pt_MemoryMap->RAM_Rx_LP1_CW_BUF_Start       = ZEP_RAM_RX_LP1_CW_BUF_ADDR;
    pt_MemoryMap->RAM_Tx_InterleaveBuffer_Start = ZEP_RAM_TX_INTERLV_BUF_ADDR;
    pt_MemoryMap->RAM_Rx_InterleaveBuffer_Start = ZEP_RAM_RX_INTERLV_BUF_ADDR;
    pt_MemoryMap->RAM_Tx_FrameBuffer_Start      = ZEP_RAM_TX_FRAMEBUFFER_ADDR;
    pt_MemoryMap->RAM_Rx_FrameBuffer_Start      = ZEP_RAM_RX_FRAMEBUFFER_ADDR;

    /**********************************************************************
     * Memory map for registers
     **********************************************************************/

    pt_MemoryMap->Reg_VERSION_Addr      = ZEP_REG_VERSION_ADDR;
    pt_MemoryMap->Reg_RXIB_TEST_Addr    = ZEP_REG_RXIB_TEST_ADDR;
    pt_MemoryMap->Reg_ZT_LINE_Addr      = ZEP_REG_ZT_LINE_ADDR;
   pt_MemoryMap->Reg_ZT_STATUS_Addr = ZEP_REG_ZT_STATUS_ADDR;
   pt_MemoryMap->Reg_ZT_BC0_Addr    = ZEP_REG_ZT_BC0_ADDR;
    pt_MemoryMap->Reg_ZT_FB0_Addr      = ZEP_REG_ZT_FB0_ADDR;
   pt_MemoryMap->Reg_ZT_BC1_Addr    = ZEP_REG_ZT_BC1_ADDR;
   pt_MemoryMap->Reg_ZT_FB1_Addr    = ZEP_REG_ZT_FB1_ADDR;
   pt_MemoryMap->Reg_ZT_EOC_Addr       = ZEP_REG_ZT_EOC_ADDR;
    pt_MemoryMap->Reg_ZT_AOC_Addr       = ZEP_REG_ZT_AOC_ADDR;
    pt_MemoryMap->Reg_ZT_IBITSL_Addr    = ZEP_REG_ZT_IBITSL_ADDR;
    pt_MemoryMap->Reg_ZT_IBITSH_Addr    = ZEP_REG_ZT_IBITSH_ADDR;
    pt_MemoryMap->Reg_ZT_CODEWORD_Addr  = ZEP_REG_ZT_CODEWORD_ADDR;
    pt_MemoryMap->Reg_ZT_CHECKBYTE_Addr = ZEP_REG_ZT_CHECKBYTE_ADDR;
    pt_MemoryMap->Reg_ZT_IDEPTH_Addr    = ZEP_REG_ZT_IDEPTH_ADDR;
    pt_MemoryMap->Reg_ZT_IBASE0_Addr    = ZEP_REG_ZT_IBASE0_ADDR;
    pt_MemoryMap->Reg_ZT_ILIMIT0_Addr   = ZEP_REG_ZT_ILIMIT0_ADDR;
    pt_MemoryMap->Reg_ZT_ICUR_ADR0_Addr = ZEP_REG_ZT_ICUR_ADR0_ADDR;
    pt_MemoryMap->Reg_ZT_ICUR_BASE0_Addr = ZEP_REG_ZT_ICUR_BASE0_ADDR;
    pt_MemoryMap->Reg_ZT_ICUR_IDX0_Addr = ZEP_REG_ZT_ICUR_IDX0_ADDR;
    pt_MemoryMap->Reg_ZT_IBASE1_Addr   = ZEP_REG_ZT_IBASE1_ADDR;
    pt_MemoryMap->Reg_ZT_ILIMIT1_Addr   = ZEP_REG_ZT_ILIMIT1_ADDR;
    pt_MemoryMap->Reg_ZT_ICUR_ADR1_Addr = ZEP_REG_ZT_ICUR_ADR1_ADDR;
    pt_MemoryMap->Reg_ZT_ICUR_BASE1_Addr = ZEP_REG_ZT_ICUR_BASE1_ADDR;
    pt_MemoryMap->Reg_ZT_ICUR_IDX1_Addr = ZEP_REG_ZT_ICUR_IDX1_ADDR;
    pt_MemoryMap->Reg_ZT_FRAME_LP0_Addr   = ZEP_REG_ZT_FRAME_LP0_ADDR;
    pt_MemoryMap->Reg_ZT_FRAME_LP1_Addr   = ZEP_REG_ZT_FRAME_LP1_ADDR;
    pt_MemoryMap->Reg_ZT_TP0_Addr      = ZEP_REG_ZT_TP0_ADDR;
    pt_MemoryMap->Reg_ZT_TP1_Addr      = ZEP_REG_ZT_TP1_ADDR;
    pt_MemoryMap->Reg_ZT_MFCW0_Addr    = ZEP_REG_ZT_MFCW0_ADDR;
    pt_MemoryMap->Reg_ZT_MFCW1_Addr    = ZEP_REG_ZT_MFCW1_ADDR;
    pt_MemoryMap->Reg_ZT_SCR_LO0_Addr   = ZEP_REG_ZT_SCR_LO0_ADDR;
    pt_MemoryMap->Reg_ZT_SCR_LO1_Addr   = ZEP_REG_ZT_SCR_LO1_ADDR;
    pt_MemoryMap->Reg_ZT_SCR_HI_Addr    = ZEP_REG_ZT_SCR_HI_ADDR;
    pt_MemoryMap->Reg_ZT_CRC_Addr       = ZEP_REG_ZT_CRC_ADDR;

    pt_MemoryMap->Reg_ZR_LINE_Addr      = ZEP_REG_ZR_LINE_ADDR;
    pt_MemoryMap->Reg_ZR_STATUS_Addr   = ZEP_REG_ZR_STATUS_ADDR;
    pt_MemoryMap->Reg_ZR_BC0_Addr      = ZEP_REG_ZR_BC0_ADDR;
    pt_MemoryMap->Reg_ZR_FB0_START_Addr   = ZEP_REG_ZR_FB0_START_ADDR;
    pt_MemoryMap->Reg_ZR_FB0_END_Addr  = ZEP_REG_ZR_FB0_END_ADDR;
    pt_MemoryMap->Reg_ZR_BC1_Addr      = ZEP_REG_ZR_BC1_ADDR;
    pt_MemoryMap->Reg_ZR_FB1_START_Addr   = ZEP_REG_ZR_FB1_START_ADDR;
    pt_MemoryMap->Reg_ZR_FB1_END_Addr  = ZEP_REG_ZR_FB1_END_ADDR;
    pt_MemoryMap->Reg_ZR_EOC_Addr       = ZEP_REG_ZR_EOC_ADDR;
    pt_MemoryMap->Reg_ZR_AOC_Addr       = ZEP_REG_ZR_AOC_ADDR;
    pt_MemoryMap->Reg_ZR_IBITSL_Addr    = ZEP_REG_ZR_IBITSL_ADDR;
    pt_MemoryMap->Reg_ZR_IBITSH_Addr    = ZEP_REG_ZR_IBITSH_ADDR;
    pt_MemoryMap->Reg_ZR_CODEWORD_Addr  = ZEP_REG_ZR_CODEWORD_ADDR;
    pt_MemoryMap->Reg_ZR_CHECKBYTE_Addr = ZEP_REG_ZR_CHECKBYTE_ADDR;
   pt_MemoryMap->Reg_ZR_CW_DIV_MF_Addr = ZEP_REG_ZR_CW_DIV_MF_ADDR;
    pt_MemoryMap->Reg_ZR_DDEPTH_Addr    = ZEP_REG_ZR_DDEPTH_ADDR;
    pt_MemoryMap->Reg_ZR_DBASE0_Addr     = ZEP_REG_ZR_DBASE0_ADDR;
    pt_MemoryMap->Reg_ZR_DLIMIT0_Addr    = ZEP_REG_ZR_DLIMIT0_ADDR;
    pt_MemoryMap->Reg_ZR_DCUR_BASE0_Addr = ZEP_REG_ZR_DCUR_BASE0_ADDR;
    pt_MemoryMap->Reg_ZR_DBASE1_Addr     = ZEP_REG_ZR_DBASE1_ADDR;
    pt_MemoryMap->Reg_ZR_DLIMIT1_Addr    = ZEP_REG_ZR_DLIMIT1_ADDR;
    pt_MemoryMap->Reg_ZR_DCUR_BASE1_Addr = ZEP_REG_ZR_DCUR_BASE1_ADDR;
    pt_MemoryMap->Reg_ZR_FRAME_LP0_Addr   = ZEP_REG_ZR_FRAME_LP0_ADDR;
   pt_MemoryMap->Reg_ZR_FRAME_LP1_Addr = ZEP_REG_ZR_FRAME_LP1_ADDR;
    pt_MemoryMap->Reg_ZR_TP0_Addr      = ZEP_REG_ZR_TP0_ADDR;
   pt_MemoryMap->Reg_ZR_TP1_Addr    = ZEP_REG_ZR_TP1_ADDR;
   pt_MemoryMap->Reg_ZR_MFCW0_Addr     = ZEP_REG_ZR_MFCW0_ADDR;
    pt_MemoryMap->Reg_ZR_MFCW1_Addr    = ZEP_REG_ZR_MFCW1_ADDR;
    pt_MemoryMap->Reg_ZR_DSCR_LO0_Addr  = ZEP_REG_ZR_DSCR_LO0_ADDR;
    pt_MemoryMap->Reg_ZR_DSCR_LO1_Addr  = ZEP_REG_ZR_DSCR_LO1_ADDR;
    pt_MemoryMap->Reg_ZR_DSCR_HI_Addr   = ZEP_REG_ZR_DSCR_HI_ADDR;
    pt_MemoryMap->Reg_ZR_FEC0_CNT_Addr  = ZEP_REG_ZR_FEC0_CNT_ADDR;
    pt_MemoryMap->Reg_ZR_FEC1_CNT_Addr  = ZEP_REG_ZR_FEC1_CNT_ADDR;

    pt_MemoryMap->Reg_ZR_FEXX_Addr      = ZEP_REG_ZR_FEXX_ADDR;
    pt_MemoryMap->Reg_ZR_CRC_Addr       = ZEP_REG_ZR_CRC_ADDR;
   pt_MemoryMap->Reg_ZR_DCUR_CWADR_Addr   = ZEP_REG_ZR_DCUR_CWADR_ADDR;
   pt_MemoryMap->Reg_ZR_DECSTAT0_LP0_Addr = ZEP_REG_ZR_DECSTAT0_LP0_ADDR;
   pt_MemoryMap->Reg_ZR_DECSTAT1_LP0_Addr = ZEP_REG_ZR_DECSTAT1_LP0_ADDR;
   pt_MemoryMap->Reg_ZR_DECSTAT0_LP1_Addr = ZEP_REG_ZR_DECSTAT0_LP1_ADDR;
   pt_MemoryMap->Reg_ZR_DECSTAT1_LP1_Addr = ZEP_REG_ZR_DECSTAT1_LP1_ADDR;
   pt_MemoryMap->Reg_ZR_FRAME_BYTE_Addr   = ZEP_REG_ZR_FRAME_BYTE_ADDR;
};

void ALP_DefineMemoryMap(Alphaeus_MemoryMap *pt_MemoryMap)
{
   pt_MemoryMap->us_Reg_BaseAddr = ALP_REGISTERBLOCK_ADDR;
   pt_MemoryMap->us_TxCellBuffBaseAddr = ALP_TX_CELLBUFFER_ADDR;
   pt_MemoryMap->us_RxCellBuffBaseAddr = ALP_RX_CELLBUFFER_ADDR;
}

int16 InitBMs(void)
{

    int32 l_temp;
   uint16 *pusa_RAM_Rx_FastInterleave, *pusa_RAM_Tx_FastInterleave;

   Iridia_Latencies t_Iri_Latencies;
   Iridia_MemoryMap t_Iri_MemoryMap;

    Zephyr_Latencies t_Zep_Latencies;
    Zephyr_MemoryMap t_Zep_MemoryMap;

   Alphaeus_MemoryMap t_Alp_MemoryMap;

    /* ======================================================================== */
   /* Initialize the Zephyr Behavioral model first.  This includes assigning the    */
   /* the TxFramebuffer and RxFrameBuffer to the model (it is expected to     */
   /* reside externally, e.g. in the Alphaeus model).                   */
   /*                                                       */
   /* ======================================================================== */

    ZEP_DefineLatencies(&t_Zep_Latencies);
   ZEP_DefineMemoryMap(&t_Zep_MemoryMap);

   ZEP_InitializeBM(&t_Zep_Latencies, &t_Zep_MemoryMap);

   /* Reset the Zephyr BM.                                     */
   ZEP_Reset();

   /* Get the C pointers to the Zephyr BM's internal interleaver and deinterleaver buffers.  These must be
   passed to the Iridia BM during its initialization. */

    l_temp = ZEP_GetBaseAddressVirtual(ZEP_RAM_TX_INTERLV_BUF, (uint16 **)&pusa_RAM_Tx_FastInterleave);
    l_temp = ZEP_GetBaseAddressVirtual(ZEP_RAM_RX_INTERLV_BUF, (uint16 **)&pusa_RAM_Rx_FastInterleave);

   //==============================================
   // Initialize Iridia Behavioral Model
   //==============================================

   IRI_DefineLatencies(&t_Iri_Latencies);
   IRI_DefineMemoryMap(&t_Iri_MemoryMap);

    IRI_InitializeBM(pusa_RAM_Tx_FastInterleave, pusa_RAM_Rx_FastInterleave, &t_Iri_Latencies, &t_Iri_MemoryMap, 0);

   // Simulate hardware reset.
   IRI_Reset();

   //==============================================
   // Initialize Strymon Behavioral Model
   //==============================================

   Set_StrymonCPE_MemBaseAddr((uint16) STR_BASE_ADDR); /* set base addresses */
   StrymonCPE_Reset(); /* reset core */
   /* connect Strymon Rx input */
   Connect_StrymonCPE_RxInput((int16 (*)(int16 *s_Input)) GetRxInputSample);
   /* connect Strymon Tx input */
   Connect_StrymonCPE_TxInput((int16 (*)(int16 *s_Input)) IRI_Tx_GetOutputDataSample);

   /* connect Strymon Tx Output */
   Connect_StrymonCPE_TxOutput((int16 (*)(int16 s_Output)) WriteStrymonTxOutput);
   /* connect Strymon AEC Output */
   Connect_StrymonCPE_AECOutput((int16 (*)(int16 s_Output)) WriteStrymonAECOutput);

   //==============================================
   // Initialize Alphaeus Behavioral Model
   //==============================================

   // Set-up memory map
   ALP_DefineMemoryMap(&t_Alp_MemoryMap);
   Set_AlphaeusMemoryMap(&t_Alp_MemoryMap);

#ifndef HWENGINE_30
   Set_Alphaeus_TxFrameBuffBaseAddr(ZEP_RAM_TX_FRAMEBUFFER_ADDR);
   Set_Alphaeus_RxFrameBuffBaseAddr(ZEP_RAM_RX_FRAMEBUFFER_ADDR);
#endif

   // Reset core
   Alphaeus_Reset(Get_TxFrameBuffer(), Get_RxFrameBuffer());

   //==============================================
   // Initialize CRI Behavioral Model
   //==============================================

   CRI_InitializeBM(CRI_REGISTERBLOCK_ADDR);

   /* Reset the CRI BM.                                  */
   CRI_Reset();

#ifdef SIMEXT_ONLY
   // Read configuration file
   ConfigureTestFiles();
    InitInterp();
#endif
   return(TRUE);
}
