/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   InitModem_PreHandshake.c
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

// ******************************************************************
// InitModem_PreHandshake.c
//
// History
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new function 'ConfigAdslFeatureMap()' that provides info on the feature subset
//                 supported by FW. This feature map can be read out by SW using CMV 'DSL 19'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new function 'ConfigVdslFeatureMap()' that provides info on the feature subset
//                 supported by FW. This feature map can be read out by SW using CMV 'DSL 20'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// ******************************************************************

#include <stdio.h>
#include <stdlib.h>

#include "const.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "compiler.h"
#include "mtkernel.h"
#include "FormRRates.h"
#include "FormRMsgs1.h"
#include "DecodCInfo1.h"
#include "DecodCInfoRA.h"
#include "SelectDSRateOption.h"
#include "VerifyRateWithTwoCG.h"
#include "xgdata.h"
#include "ghs.h"
#include "pll.h"
#include "states.h"
#include "tx_ops.h"
#include "file_io3.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "fifo.h"
#include "file_io.h"
#include "bert.h"
#include "mp.h"
#include "cmv.h"
#include "stateini.h"
#include "trail.h"
#include "cri_ini.h"
#include "DebugBuffer.h"
#include "ppe_memmap.h"

#ifndef ADSL_62
    #include "cri.h"
#endif

#ifdef ADSL_62
    #include "cri_memmap.h"
   #include "hmp_funcs.h"
#endif

#include "cri_cocomo_interface.h"

#ifndef HERCULES_ADSL_CPE
   #include "strymon_cpe.h"
   #include "strymon_cpe_typedef.h"
   #include "iridia.h"
   #include "Zephyr.h"
   #include "alphaeus.h"
   #include "alphaeus_typedef.h"
#endif

#include "dsp_op.h"
#include "file_io3.h"
#include "statein1.h"
#include "interrupt.h"
#include "data_alloc.h"
#include "nmp_plfm.h"
#include "xy_iof.h"
#include "gpio.h"

//#ifdef DANUBE
    #include "dataswap.h"
//#endif

#ifdef CUSTOMER_TASKS
    #include "CustomerTasks.h"
#endif

#ifdef SLEEP_TEST_BUILD
int16 InitModem_Sleep(void);
#endif

extern void AllocateDataBuffers_PreHndshk(void);
extern void ConfigAdslFeatureMap(void);

/*****************************************************************************
;  Prototype: void KernelInit(void)
;
;  Initialization of kernel-specific variables.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;****************************************************************************/
void KernelInit(void) {

   TaskQueue[0].Front=TaskQueue[0].Rear=NULL;
   TaskQueue[1].Front=TaskQueue[1].Rear=NULL;

   gs_GlobalInterruptFlag=TRUE;

}


/*****************************************************************************
;  Prototype: int16 InitModem_PreHandshake(void)
;
;  This subroutine initialize the modem variables based on the initial state
;  to start the modem.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     SUCCEED              - Initialization is done successfully
;     FAIL                 - Initialization fails
;
;****************************************************************************/
int16 InitModem_PreHandshake(void)
{
   uint32 ul_data, ul_addr;

#ifdef SLEEP_TEST_BUILD

   return (InitModem_Sleep());

#else

#ifndef ADSL_62
   // Read the CRI_CCR0 register for AC_CLK bit
   ReadCoreReg(CRI_CCR0_ADDR, &us_data);

   if((us_data & 0x0030) == 0x0010) // AC_CLK is bits 4 and 5
   {
      // AC_CLK is on
      gft_AC_CLK_NotEnabled = FALSE;
   }
   else
   {
      // AC_CLK is disabled
      gft_AC_CLK_NotEnabled = TRUE;
   }
#endif

   /* Initialize Clock, Reset, Interrupt Controller  */
   InitCRI();

   // Allocate data buffers and define buffer pointers that are
   // only used for handshake
   AllocateDataBuffers_PreHndshk();

   // For faster NoiseAcc/Accum16to32/multiplication routines.
   XYDecodeBypass_AddrDecode();

   /* initialize states to 0 - unknown, emptystate */
   /* CNTL is used to get to sleep state */
   gs_TxState = 0;
   gs_RxState = 0;
   gs_TxNextState = 0;
   gs_RxNextState = 0;
   gpF_TxStateFunc = (PtrToFunc)EmptyState;
   gpF_RxStateFunc = (PtrToFunc)EmptyState;


   guc_IntoL2=0;



   /* turn off LED's at reset */
#ifdef DANUBE
    SetGPIODirectionBits(GPIO9 | GPIO11 | GPIO12 );
    SetGPIOBits(GPIO9 | GPIO11 | GPIO12 );
#elif ADSL_62
      SetGPIODirectionBits(0);

 //   SetGPIODirectionBits(GPIO9 | GPIO11 | GPIO12 );
  //  SetGPIOBits(GPIO9 | GPIO11 | GPIO12 );

#else
    SetGPIODirectionBits(GPIO9 | GPIO10 | GPIO11 | GPIO12 );
   SetGPIOBits(GPIO9 | GPIO10 | GPIO11 | GPIO12 );
#endif

    #ifdef HERCULES_ADSL_CPE
   #ifdef TARGET_HW
   InitLedsHw();
   #endif // TARGET_HW
    #endif

   KernelInit();
   InitCodeSwap();
#ifdef DEBUG_TRACES
//#ifdef DANUBE
    InitDataSwap();
//#endif
#endif // #ifdef DEBUG_TRACES

   //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
   //To be called before InitGlobalVariables() and CMVInit_PreHandshake()
   ConfigAdslFeatureMap();
   //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

   // XDSLRTFW-3548 (Start)
   gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ResetState;
   gusa_HercADSL_MONIMap_Curr[0] = MONI_RESET;
   // XDSLRTFW-3548 (End)

   InitGlobalVariables();  // These initializations have no dependence on CMV settings.

   CMVInit_PreHandshake(); // Initialize CMVs


   InitModemTasks_PreHandshake();

   InitEngine();  // Rename this InitEngine_PreHandshake() ?

   Enable_MTEtoDFE_TxRx();

   /* Initialize cmv to Enable Utopia workaround if using 3.0 BMs */
   CMVInit_UtopiaFix();

   gs_MpWinhostControl = 0;
   gs_UpdateTimingRecoveryHWEnable = 1;  /* turn on SRC */

   #ifdef CUSTOMER_TASKS
   Customer_HwSetUp();
   #endif // CUSTOMER_TASKS

   // XDSLRTFW-3712 (Start)
   // Making sure that the DREG registers are cleared before modem ready. This is
   // essential if the CPE has crashed (or could not do a graceful shutdown) on the
   // previous run. Also, now the for PPE Frequency scaling, we are relying on the bits
   // of the DREG register (DREG_FRAMER_REQUEST_ENABLE --> 0x7DC7). Refer the PPE_DSL_Notification
   // document for further bit definitions.
   // Resetting of DREG_BC0_LINK_STATUS --> 0x7DC0

   // Bit defintion of various DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF

   // Bit definition of 0X7DC6 (DREG_MISCRAM6_ADDR):
   //  Bit 0      --> Framer Request Enable (Set by the PPE driver and cleared by DSL FW)
   //  Bit 1      --> Dynamic Frequency supported (Set by the PPE driver and cleared by DSL FW)

   // Bit definition of 0x7DC7 (DREG_MISCRAM7_ADDR)
   //  Bit 0     --> Framer Request Stopped (Set by DSL FW and cleared by PPE FW)

   ul_addr = DREG_MISCRAM0_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data & (MASK_BIT0 | MASK_BIT1))
   {
      ul_data &= (~(MASK_BIT0 | MASK_BIT1));
      WritePpeReg(ul_addr,ul_data);

      // Resetting of DREG_FRAMER_REQUEST_STOPPED --> 0x7DC7
      ul_addr = DREG_MISCRAM7_ADDR;
      ReadPpeReg(ul_addr, &ul_data);
      ul_data |= MASK_BIT0;
      WritePpeReg(ul_addr,ul_data);
   }

   // Resetting of DREG_FRAMER_REQUEST_ENABLE --> 0x7DC6
   ul_addr = DREG_MISCRAM6_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data & (MASK_BIT0 | MASK_BIT1))
   {
      ul_data &= ~(MASK_BIT0 | MASK_BIT1);
      WritePpeReg(ul_addr,ul_data);
   }
   // XDSLRTFW-3712 (End)

   /* ======================================================================= */
   /*  Attempt WINHOST connectivity */
   /* ======================================================================= */
   NewMPInitialize();

   NewMPSetupReadyMessage();

   /* ======================================================================= */
   /*  Enable ARC interrupts                                                  */
   /* ======================================================================= */
#ifndef ADSL_62
   _enable();
#endif

   return((int16)SUCCEED);
#endif   // #ifdef/#else SLEEP_TEST_BUILD
}


#ifdef SLEEP_TEST_BUILD
int16 InitModem_Sleep(void)
{
   uint32 ul_reg;
   uint16 us_data;

    /* ======================================================================= */
    /*  Initialize CMV's */
    /* ======================================================================= */
    AllocateDataBuffers_PreHndshk();
    CMVInit_PreHandshake();

    /* initialize states to 0 - unknown, emptystate */
    /* CNTL is used to get to sleep state */
    gs_TxState = 0;
    gs_RxState = 0;
    gs_TxNextState = 0;
    gs_RxNextState = 0;
    gpF_TxStateFunc = (PtrToFunc)EmptyState;
    gpF_RxStateFunc = (PtrToFunc)EmptyState;

    KernelInit();
#ifdef DEBUG_TRACES
    InitCodeSwap();
//#ifdef DANUBE
    InitDataSwap();
//#endif
#endif //#ifdef DEBUG_TRACES

    InitModemTasks_PreHandshake();

    /* Initialize cmv to Enable Utopia workaround if using 3.0 BMs */
    gs_MpWinhostControl = 0;
    gs_UpdateTimingRecoveryHWEnable = 1;  /* turn on SRC */

    /* ======================================================================= */
    /*  Attempt WINHOST connectivity    */
    /* ======================================================================= */
    NewMPInitialize();

    NewMPSetupReadyMessage();

    /* ======================================================================= */
    /*  Enable ARC interrupts                                                  */
    /* ======================================================================= */

    return((int16)SUCCEED);
}
#endif // #ifdef SLEEP_TEST_BUILD


// At expense of data memory we can save on MIPS by decoding XY address beforehand
// instead of doing it @ run time. This is feasible if the memory location of the
// buffers on which X-Y memory routines operate do not change. If they do, we need
// to update them; an example being the ping-pong FDQ o/p buffer.
// Functionality added to save on MIPS during DD processing in showtime
void XYDecodeBypass_AddrDecode()
{
   gl_XYDec_DD_rxQAMOutput_Y16 = XYAddrDecode((int32 *)(void *)gsa_DD_rxQAMOutput, ADDR_MODE_16);
   gl_XYDec_DD_rxQAMOutput_Y32 = (gl_XYDec_DD_rxQAMOutput_Y16 >> 1); /* ADDR_MODE_32 */
   gl_XYDec_DD_rxFDQOutput0_X16 = XYAddrDecode((int32 *)(void *)&gsa_DD_rxFDQOutput[0][0], ADDR_MODE_16);
   gl_XYDec_DD_rxFDQOutput1_X16 = XYAddrDecode((int32 *)(void *)&gsa_DD_rxFDQOutput[1][0], ADDR_MODE_16);

   gl_XYDec_DD_1byRxCombinedGains_X32 = XYAddrDecode((int32 *)(void *)gpsa_DD_1byRxCombinedGains, ADDR_MODE_32);
   gl_XYDec_DD_RxGainScaleShifts_X16 = XYAddrDecode((int32 *)(void *)gpsa_DD_RxGainScaleShifts, ADDR_MODE_16);

   gl_XYDec_DD_NoiseError_Y16 = XYAddrDecode((int32 *)(void *)gpsa_DD_NoiseError, ADDR_MODE_16);
   gl_XYDec_DD_CmplxMultScratchPadX_X16 = XYAddrDecode((int32 *)(void *)gpsa_DD_CmplxMultScratchPadX, ADDR_MODE_16);
   gl_XYDec_DD_CmplxMultScratchPadY_Y16 = XYAddrDecode((int32 *)(void *)gpsa_DD_CmplxMultScratchPadY, ADDR_MODE_16);

   gl_XYDec_DD_rxFDQErrCorrBuf_X16     = XYAddrDecode((int32 *)(void *)gpsa_DD_rxFDQErrCorrBuf, ADDR_MODE_16);
   gl_XYDec_RxShowtimeSnrAccumBuf_X32  = XYAddrDecode(gla_RxShowtimeSnrAccumBuf, ADDR_MODE_32);

#ifndef ADSL_62
   gl_XYDec_RxToneBuf_X32           = XYAddrDecode((int32 *) gsa_RxToneBuf, ADDR_MODE_32);
   gl_XYDec_FdqCoef_Y16          = XYAddrDecode((int32 *) gsa_pre_FDQ_coef, ADDR_MODE_16);
#else
   gl_XYDec_FdqCoef_Y16          = XYAddrDecode((int32 *)(void *)gsa_RxToneBuf, ADDR_MODE_16);
#endif
}
