/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: LL_IOf.c
;
;  Low-level core interface layer.
;
;  Note: Currently these functions can access memory and
;     registers in Strymon and Iridia only.
*****************************************************************************/

#include "typedef.h"
#include "LL_Iof.h"
#include "socrates_memrymap.h"
#include "dma_iof.h"

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    SetUpDMATransfer
 *
 * Prototype:
 *    SetUpDMATransfer(uint32 SourceStart, uint32 SourceEnd, uint32 DestStart);
 *
 *  Abstract:
 *    SetUpDMATransfer() -
 *
 *    Sets up a DMA transfer from the SourceStart to DestStart until the SourceEnd address
 *
 *  Returns:
 *    None
 *
 *------------------------------------------------------------------------
 */

void SetUpDMATransfer(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr)
{
   uint32 ul_status;

   if (SourceAddr > SourceEnd)
   {
      return;
   }

   /* If a DMA is already in progress, wait till it is done */
   do {
      DMA_RegisterRead((uint32) ADMA_STAT_AC_ADDR, &ul_status);
   } while((ul_status & ADMA_STAT_AC_PROC_MASK) == ADMA_STAT_AC_PROC_MASK);

   // both time domain and freq domain signals are copied in the same way
   DMA_RegisterWrite(ADMA_SAD_S_AC_ADDR, SourceAddr);
   DMA_RegisterWrite(ADMA_SAD_E_AC_ADDR, SourceEnd);
   DMA_RegisterWrite(ADMA_DAD_S_AC_ADDR, DestAddr);
   DMA_RegisterWrite(ADMA_CTRL_AC_ADDR, (uint32) ADMA_CTRL_AC_START_MASK);

   do {
      DMA_RegisterRead((uint32) ADMA_STAT_AC_ADDR, &ul_status);
   } while(((ul_status & ADMA_STAT_AC_ERR_MASK) == 0) && ((ul_status & ADMA_STAT_AC_PROC_MASK) == ADMA_STAT_AC_PROC_MASK));

}

/****************************************************************************
; Name: SetCoreReg
;
; Prototype:
;  void SetCoreReg(uint16 us_addr, uint16 us_mask)
;
; Description:
;  Function for setting bits in a register in the Strymon CPE
;  BM.
;
; Arguments:
;  us_addr     (I)      physical address of register
;  us_mask     (I)      bits set to 1 cause the corresponding
;                 bits in the register to be set to 1
;
;  Return Value:
;  N/A
*****************************************************************************/
void SetCoreReg(uint16 us_addr, uint16 us_mask)
{
   uint16 tmp;

   ReadCoreReg(us_addr, &tmp);
   tmp |= us_mask;
   WriteCoreReg(us_addr, tmp);
}

/****************************************************************************
; Name: ResetCoreReg
;
; Prototype:
;  void ResetCoreReg(uint16 us_addr, uint16 us_mask)
;
; Description:
;  Function for resetting bits in a register in the Strymon CPE
;  BM.
;
; Arguments:
;  us_addr     (I)      physical address of register
;  us_mask     (I)      bits set to 1 cause the corresponding
;                 bits in the register to be set to 0
;
;  Return Value:
;  N/A
*****************************************************************************/
void ResetCoreReg(uint16 us_addr, uint16 us_mask)
{
   uint16 tmp;

   ReadCoreReg(us_addr, &tmp);
   tmp &= ~us_mask;
   WriteCoreReg(us_addr, tmp);
}

void WriteCoreBuf32(uint16 us_addr, int16 *psa_words, uint16 us_num)
{
   uint32 ul_StartAddress;

   mComputeSocOffsetAddress(ul_StartAddress, us_addr);
   SetUpDMATransfer((uint32) psa_words, (uint32) &psa_words[2*us_num-1], ul_StartAddress);
}

void ReadCoreBuf32(uint16 us_addr, int16 *psa_words, uint16 us_num)
{
   uint32 ul_StartAddress, l_NumberOfBytes;

   mComputeSocOffsetAddress(ul_StartAddress, us_addr);

   l_NumberOfBytes = 4*us_num-2;

   SetUpDMATransfer(ul_StartAddress, (ul_StartAddress + l_NumberOfBytes),(uint32) psa_words );
}

void FillCoreBuf32LowHigh(uint16 us_addr, int16 s_value, uint16 us_num, int16 s_WriteControl)
{
   uint32 ul_StartAddress;

   uint32 ul_data;

   ul_data = ((uint32) (s_value & 0xFFFF) << (s_WriteControl * 16));

   FillCoreBuf32(us_addr, (uint32) ul_data, us_num);
}

