/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   RunBackground.C
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>

#include "const.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "compiler.h"
#include "mtkernel.h"
#include "modem_hw.h"
#include "FormRRates.h"
#include "FormRMsgs1.h"
#include "DecodCInfo1.h"
#include "DecodCInfoRA.h"
#include "SelectDSRateOption.h"
#include "VerifyRateWithTwoCG.h"
#include "xgdata.h"
#include "ghs.h"
#include "pll.h"
#include "states.h"
#include "tx_ops.h"
#include "file_io3.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "fifo.h"
#include "file_io.h"
#include "bert.h"
#include "mp.h"
#include "cmv.h"
#include "stateini.h"

#ifndef ADSL_62
    #include "cri.h"
#endif

#include "cri_cocomo_interface.h"
#ifndef HERCULES_ADSL_CPE
   #include "strymon_cpe.h"
   #include "strymon_cpe_typedef.h"
   #include "iridia.h"
   #include "Zephyr.h"
   #include "alphaeus.h"
   #include "alphaeus_typedef.h"
#endif
#include "dsp_op.h"
#include "file_io3.h"
#include "statein1.h"
#include "interrupt.h"
#include "data_alloc.h"
#include "nmp_plfm.h"
#include "rx_ovrhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "cri_iof.h"
#include "socrates_memrymap.h"
#ifdef DANUBE
#ifdef TARGET_HW
   #include "dataswap.h"
#endif
#endif
#ifdef CUSTOMER_TASKS
#include "CustomerTasks.h"
#endif

#include "ifx_vdsl2_afe_memmap.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

/* This function moved from Modem_hw.c to reduce RES page
Program Memory Reduction */
/*-------------------------------------------------------------------
*
*  int RunBackground(void)
*
*  Description: Function to execute the Background Tasks.
*
*
*-------------------------------------------------------------------
*^^^
*/
#ifdef ADSL_62
    void restore1_save(int32);
    void disable1_save(int32*);
#endif

int16 RunBackground(void) {
    #ifdef ADSL_62
    int32 l_IntStat;
    #endif
   void (*BGTask)(void);


    //Dont proceed the background running if not in a proper state.
    //Assume all "ready-state" has "STAT_MacroState" greater than STAT_ReadyState.
    if (STATArray[STAT_MacroState] == STAT_InitState)
        return((int16)SUCCEED);

   /* =============================================================================== */
   /*  BackgroundTask processing */
   /* =============================================================================== */
#ifdef DANUBE
#ifdef TARGET_HW
   /* Swap showtime states trail to external memory */
   Check_ShowtimeDataSwap();
#endif
#endif

#ifdef CUSTOMER_TASKS
      CustomerBgTaskManager();
#endif

   /* If there are pending Background processes, run them here */
   while(RemoveFunctionFromBkgdFifo(gp_BGTaskFifo , &BGTask))
   {
      //update the bg task pointer and counter before running the bg task
      gl_CurrentBGTask = (PtrToFunc)(BGTask);
      gus_BgLoopCnt++;

      (gl_CurrentBGTask)();

      CheckStackOverflow((int16)E_CODE_STACK_OVERFLOW_IN_BG);

      //reset the bg task point after the bg task return
      gl_CurrentBGTask = 0;

      _ASM("sr 0, [%lp_end]");   //clear lp_end to avoid accidental triggering of lp mechanism

#ifdef DANUBE
#ifdef TARGET_HW
      /* Swap showtime states trail to external memory */
      Check_ShowtimeDataSwap();
#endif
#endif
   }

   /* In Adsl2/+ modes, we process ovhd message in the background too */
   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      //Special case, where we add a func to Bkgrd fifo from Bkgrd Task
      //disable interrupts so that we arent interrupted
      //by a TC task that executes loading function
#ifdef ADSL_62
      disable1_save(&l_IntStat);
#else
      DisableADSLInterrupts();
#endif

      if (gs_RxState == R_C_SHOWTIME_RX)
      {
         AddFunctionToBkgdFifo((PtrToBkgdFunc)RxHDLCProcessor);
      }
      if (gs_TxState == R_SHOWTIME_TX)
      {
         AddFunctionToBkgdFifo((PtrToBkgdFunc)ME_HDLC_TxProcessor);
         if(gft_RestoreShowtimeBGState == 2)
         {
            AddFunctionToBkgdFifo((PtrToBkgdFunc)TxHDLCProcessor);
         }
      }

#ifdef ADSL_62
      restore1_save(l_IntStat);
#else
      EnableADSLInterrupts(); //reenable interrupts
#endif
   }


#ifdef DEBUG_STREAMING
   //only execute when debug streaming is enabled
   if((gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK) == TRUE)
   {
      // XDSLRTFW-2701 Make sure we leave sufficient space in BGTaskFifo and do not flood it with debug stream tasks to avoid E_CODE_BKGD_FIFO_ADD_EXCEPTION
      // 8 was the BGTaskFifio size before debug streams were implemented, so make sure this space is always reserved
      if (gp_BGTaskFifo->PendingFunctionCount < (NUM_BG_BUFFERS-BUFFER_RESERVE))
      {
         if (gus_RequeueBGFunction & DSH_REQUEUE_DSH_BG_SERVICE)
         {
            gus_RequeueBGFunction &= ~DSH_REQUEUE_DSH_BG_SERVICE;
            AddFunctionToBkgdFifo((PtrToFunc)DSH_BgService);
         }
         if (gus_RequeueBGFunction & DSH_REQUEUE_NMP_BG_SERVICE)
         {
            gus_RequeueBGFunction &= ~DSH_REQUEUE_NMP_BG_SERVICE;
            AddFunctionToBkgdFifo((PtrToFunc)NMP_BgService);
         }
      }
      else
      {
         // we ran out of space, keep track of this event
         gus_Dbg_DSH_skip_BGF_add++;
      }
   }
#endif

   return((int16)SUCCEED);
}

