/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: Simext_IOf.c
;
;  Simext interface functions for ISS.
;
*****************************************************************************/

#include "typedef.h"
#include "socrates_memrymap.h"
#include "file_io3.h"
#include "ll_iof.h"
#include "delay.h"

/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*        void ClockCores(int32 l_clocks)
*
*       Abstract:
*
*
*       Parameters:
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
void ClockCores(int32 l_clocks)
{
   delay((uint16) (l_clocks & 0xFFFF));
   return;
}

/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*        void WaitForCores(int32 s_clocks)
*
*       Abstract:
*
*
*       Parameters:
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
void WaitForCores(int32 l_clocks)
{
   ClockCores(l_clocks);
}

///////////////////////////////////////////
#ifdef TARGET_SIM


void delay(uint16 delay_val); /* corresponds to delay_val (usec) */

/*** ISS SPECIFIC FUNCTIONS FROM HERE TO THE END ***/

/*****************************************************************************
;  Subroutine Name: InitializeHW()
;
;  Function to initialize the hardware
;
;  Prototype:
;  int32 Initialize(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     Returns 0 if no error.
;
;****************************************************************************/
int16 InitializeHW(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)INIT_HW;

   return 0;
}

#ifndef SILICON_VERIFY
/*****************************************************************************
;  Subroutine Name: InitBMs()
;
;  Function to initialize the behavioral models.
;
;  Prototype:
;  int32 InitBMs(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     Returns 0 if no error.
;
;****************************************************************************/
int16 InitBMs(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)INIT_BMS;

   return 0;
}

/*****************************************************************************
;  Subroutine Name: IRI_Reset()
;
;  Calling this function is equivalent to asserting the RESETN input signal to Iridia.
;
;  Prototype:
;  int32 IRI_Reset(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     Returns 0 if no error.
;
;****************************************************************************/
int32 IRI_Reset(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)IRI_RESET;

   return 0;
}

/*****************************************************************************
;  Subroutine Name: ZEP_Reset()
;
;  Calling this function is equivalent to asserting the RESETN input signal to Iridia.
;
;  Prototype:
;  int32 ZEP_Reset(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     Returns 0 if no error.
;
;****************************************************************************/
int32 ZEP_Reset(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)ZEP_RESET;

   return 0;
}

/*****************************************************************************
;  Subroutine Name: ALP_Reset()
;
;  Calling this function is equivalent to asserting the RESETN input signal to Alphaeus.
;
;  Prototype:
;  void ALP_Reset(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     None.
;
;****************************************************************************/
void ALP_Reset(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)ALP_RESET;

   return;
}

/*****************************************************************************
;  Subroutine Name: Electra_Reset()
;
;  Calling this function is equivalent to asserting the RESETN input signal to Electra.
;
;  Prototype:
;  void Electra_Reset(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     None.
;
;****************************************************************************/
void Electra_Reset(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)ELE_RESET;

   return;
}

/*****************************************************************************
;  Subroutine Name: CRI_Reset()
;
;  Calling this function is equivalent to asserting the RESETN input signal to CRI.
;
;  Prototype:
;  void CRI_Reset(void)
;
;  Input Arguments:
;     None.
;
;  Output Arguments:
;     None.
;
;  Return Value:
;     None.
;
;****************************************************************************/
void CRI_Reset(void)
{

   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)CRI_RESET;

   return;
}

#endif      // #ifndef SILICON_VERIFY

#ifndef  SILICON_VERIFY
/*****************************************************************************
;  Prototype:  void ClockCoresUntilInterrupt(void)
;
;     Clock cores until an interrupt occurs.  This function
;  calls ClockCores repeatedly until the gt_Cri_Output.uc_acAggrInt
;  signal indicates an interrupt has occurred.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

void ClockCoresUntilInterrupt(void)
{

/***********************************************
      Clock Cores until Interrupt
***********************************************/
/*
   while (gt_Cri_Output.uc_acAggrInt == 0)
   {
      ClockCores(1);
   }
*/
      *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)CLOCK_CORES_UNTIL_INT;

   return;
}

/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*        int16 RunCores(void)
*
*       Abstract:
*
*
*       Parameters:
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
int16 RunCores(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)RUN_CORES;

   return((int16) (*(uint16*)(EOF_REG)));
}

/*****************************************************************************
;  Prototype: void InitInterp(void)
;
;     This function configures the interpolator.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
void InitInterp(void) {
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)INIT_INTERP;
}

/*****************************************************************************
;  Prototype: int16 MPHandler_CONN()
;
;     This function configures the modem in reaction to a CONN(ECTIVITY) MP
;   command.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
int16 MPHandler_CONN(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)INIT_CONN;
   return((int16) (*(uint16*)(INIT_CONN_REG)));
}

/*^^^
*-------------------------------------------------------------------
*
*  void ExitChannel(void)
*
*  Description:
*
*     This function shuts down the connectivity channel.
*
*-------------------------------------------------------------------
*^^^
*/
void ExitChannel(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)EXIT_CHANNEL;
}

/*^^^
*-------------------------------------------------------------------
*
*  void SetWinhostControl(void)
*
*  Description:
*
*-------------------------------------------------------------------
*^^^
*/
void SetWinhostControl(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16) SET_WINHOST_CONTROL;
}

/*^^^
*-------------------------------------------------------------------
*
*  void SetFileControl(void)
*
*  Description:
*
*-------------------------------------------------------------------
*^^^
*/
void SetFileControl(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)SET_FILE_CONTROL;
}

/*****************************************************************************
;  Prototype: int16 Mphandler(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;       SUCCEED/FAIL
;
;  Global Variables:

;****************************************************************************/

int16 Mphandler(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)MP_HANDLER;
   return((int16) (*(uint16*)(MP_HANDLER_REG)));
}

/*^^^
*-------------------------------------------------------------------
*
*  void CloseFiles(void)
*
*  Description:
*
*-------------------------------------------------------------------
*^^^
*/
int16 CloseFiles(void)
{
   *(uint16*)(COCOMO_INTERFACE_REG) = (uint16)CLOSE_FILES;
   return 0;
}

#endif      // #ifndef SILICON_VERIFY


#endif   // TARGET_SIM
///////////////////////////////////////////

