;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        adsl_int.s
;
; DESCRIPTION:     the Socrates ADSL interrupt handler
;
;*************************************************************************
.include "asm.h"
.include "aux_reg_asm.h"

;------------------------------------------------------------------------
;
;  Name : adsl_interrupt_handler
;
;  Description:
;     the Socrates ADSL interrupt handler
;
;  Prototype:
;     _Interrupt1 void adsl_interrupt_handler(void)
;
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Notes:
;
;------------------------------------------------------------------------
;  _Interrupt1 void adsl_interrupt_handler(void);
.text
.global adsl_interrupt_handler
.define NUM_ISR_SAVE_REGISTERS, 42
.define ISR_FPSIZE, BTSIZE_IN_BYTES + (NUM_ISR_SAVE_REGISTERS << LOG2_BYTES_PER_LONGWORD)
adsl_interrupt_handler:
   ; ==================== ;
   ; allocate stack space ;
   ; ==================== ;
   sub   %sp, %sp, ISR_FPSIZE

   ; ============== ;
   ; save registers ;
   ; ============== ;
   st %r0, [%sp, 16]
   st %r1, [%sp, 20]
   st %r2, [%sp, 24]
   st %r3, [%sp, 28]
   st %r4, [%sp, 32]
   st %r5, [%sp, 36]
   st %r6, [%sp, 40]
   st %r7, [%sp, 44]
   st %r8, [%sp, 48]
   st %r9, [%sp, 52]
   st %r10, [%sp, 56]
   st %r11, [%sp, 60]
   st %r12, [%sp, 64]
   st %fp, [%sp, 68]
   st %blink, [%sp, 72]
   st %lp_count, [%sp, 76]
   lr %r12, [%lp_start]
   st %r12, [%sp, 80]
   lr %r12, [%lp_end]
   st %r12, [%sp, 84]
   ; XMAC registers
   st  %xmac0, [%sp, 88]
   st  %xmac1, [%sp, 92]
   st  %t0, [%sp, 96]
   st  %t1, [%sp, 100]
   st  %t2, [%sp, 104]
   st  %t3, [%sp, 108]
   lr  %r12, [%ax0]
   st  %r12, [%sp, 112]
   lr  %r12, [%mx0]
   st  %r12, [%sp, 116]
   lr  %r12, [%ax1]
   st  %r12, [%sp, 120]
   lr  %r12, [%mx1]
   st  %r12, [%sp, 124]
   lr  %r12, [%ay0]
   st  %r12, [%sp, 128]
   lr  %r12, [%my0]
   st  %r12, [%sp, 132]
   lr  %r12, [%ay1]
   st  %r12, [%sp, 136]
   lr  %r12, [%my1]
   st  %r12, [%sp, 140]
   lr  %r12, [%xyconfig]
   st  %r12, [%sp, 144]
   lr  %r12, [%aux_xmac1]
   st  %r12, [%sp, 148]
   lr  %r12, [%aux_xmac2]
   st  %r12, [%sp, 152]
   lr  %r12, [%aux_xmac0]
   st  %r12, [%sp, 156]
   lr  %r12, [%aux_macmode]
   st  %r12, [%sp, 160]
   ; ARC DMA engine registers
   lr  %r12, [ADMA_CTRL_AC]
   st  %r12, [%sp, 164]
   lr  %r12, [ADMA_SAD_S_AC]
   st  %r12, [%sp, 168]
   lr  %r12, [ADMA_DAD_S_AC]
   st  %r12, [%sp, 172]
   lr  %r12, [ADMA_SAD_E_AC]
   st  %r12, [%sp, 176]
   st  %ilink1, [%sp, 180]    ; save to allow nested interrupts
   add   %fp, %sp, ISR_FPSIZE

   sr 0, [%lp_end]         ; clear lp_end to avoid accidental triggering of lp mechanism

   ; ==================== ;
   ; handle the interrupt ;
   ; ==================== ;
   bl adsl_interrupt_handler_body

   ; ================= ;
   ; restore registers ;
   ; ================= ;
   ld %r0, [%sp, 16]
   ld %r1, [%sp, 20]
   ld %r2, [%sp, 24]
   ld %r3, [%sp, 28]
   ld %r4, [%sp, 32]
   ld %r5, [%sp, 36]
   ld %r6, [%sp, 40]
   ld %r7, [%sp, 44]
   ld %r8, [%sp, 48]
   ld %r9, [%sp, 52]
   ld %r10, [%sp, 56]
   ld %r11, [%sp, 60]
   ld %fp, [%sp, 68]
   ld %blink, [%sp, 72]
   ld %lp_count, [%sp, 76]
   ld %r12, [%sp, 80]
   sr %r12, [%lp_start]
   ld %r12, [%sp, 84]
   sr %r12, [%lp_end]
   ; XMAC registers
   ld  %xmac0, [%sp, 88]
   ld  %xmac1, [%sp, 92]
   ld  %t0, [%sp, 96]
   ld  %t1, [%sp, 100]
   ld  %t2, [%sp, 104]
   ld  %t3, [%sp, 108]
   ld  %r12, [%sp, 112]
   sr  %r12, [%ax0]
   ld  %r12, [%sp, 116]
   sr  %r12, [%mx0]
   ld  %r12, [%sp, 120]
   sr  %r12, [%ax1]
   ld  %r12, [%sp, 124]
   sr  %r12, [%mx1]
   ld  %r12, [%sp, 128]
   sr  %r12, [%ay0]
   ld  %r12, [%sp, 132]
   sr  %r12, [%my0]
   ld  %r12, [%sp, 136]
   sr  %r12, [%ay1]
   ld  %r12, [%sp, 140]
   sr  %r12, [%my1]
   ld  %r12, [%sp, 144]
   sr  %r12, [%xyconfig]
   ld  %r12, [%sp, 148]
   sr  %r12, [%aux_xmac1]
   ld  %r12, [%sp, 152]
   sr  %r12, [%aux_xmac2]
   ld  %r12, [%sp, 156]
   sr  %r12, [%aux_xmac0]  ; aux_xmac0 (the extension register) must be restored after aux_xmac1 and aux_xmac2
   ld  %r12, [%sp, 160]
   sr  %r12, [%aux_macmode]
   ; ARC DMA engine registers
   ld  %r12, [%sp, 164]
   sr  %r12, [ADMA_CTRL_AC]
   ld  %r12, [%sp, 168]
   sr  %r12, [ADMA_SAD_S_AC]
   ld  %r12, [%sp, 172]
   sr  %r12, [ADMA_DAD_S_AC]
   ld  %r12, [%sp, 176]
   sr  %r12, [ADMA_SAD_E_AC]
   ld  %ilink1, [%sp, 180]
   ld %r12, [%sp, 64]

   ; ======================= ;
   ; de-allocate stack space ;
   ; ======================= ;
   add   %sp, %sp, ISR_FPSIZE

   ; ===================== ;
   ; return from interrupt ;
   ; ===================== ;
   j.f   [%ilink1]


