/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gpio.c
*
*  Functions for reading, writing GPIO signals
*
*-------------------------------------------------------------------------
*/

#include "typedef.h"
#include "gdata.h"
#include "cmv.h"

#ifdef TARGET_HW

#include "gpio.h"
#include "LL_IOf.h"  //XDSLRTFW-3717 (Start_End)

#define OPTN_GPIO0_MASK          (0x1) // i.e. BIT0 mask
#define OPTN_GPIO1_MASK          (0x2) // i.e. BIT1 mask
#define OPTN_GPIO2_MASK          (0x4) // i.e. BIT1 mask
#define OPTN_GPIO0_HI         (OPTN_GPIO0_MASK) // i.e. GPIO BIT0 set to HI
#define OPTN_GPIO1_HI         (OPTN_GPIO1_MASK) // i.e. GPIO BIT1 set to HI
#define OPTN_GPIO2_HI         (OPTN_GPIO2_MASK) // i.e. GPIO BIT2 set to HI

void WriteGPIOBits(uint16 us_data_write)
{
#ifdef ENABLE_LEDs
   uint16 us_mask;


    #ifdef HERCULES_ADSL_CPE
    #else
   SetDspReg(GPIO_CTRL, gt_Gpio.s_GPIO_Ctrl);   // write to GPIO_CTRL register.
    #endif

   us_mask = gt_Gpio.us_GPIO_Data_Mask;
   gul_GPIO_Data &= (~us_mask);     // zero out the bits that are enabled for writing. Don't change disabled data
   gul_GPIO_Data |= (us_data_write & us_mask);  //n set to one the bits set in us_data, provided that they are enabled. If disabled, don't change

    #ifdef HERCULES_ADSL_CPE
   if (gt_Gpio.us_GPIO_Data_Mask & OPTN_GPIO0_MASK)
   {
      if ((gul_GPIO_Data & OPTN_GPIO0_MASK) == OPTN_GPIO0_HI)
         switchOffLosLED();
      else
         switchOnLosLED();

   } // Handle GPIO0 using gt_Gpio which maps to *INFOMap[INFO_GPIO_Control] CMV
   if (gt_Gpio.us_GPIO_Data_Mask & OPTN_GPIO1_MASK)
   {
      if ((gul_GPIO_Data & OPTN_GPIO1_MASK) == OPTN_GPIO1_HI)
         switchOffDetectLED();
      else
         switchOnDetectLED();
   } // Handle GPIO1 using gt_Gpio which maps to *INFOMap[INFO_GPIO_Control] CMV

   if (gt_Gpio.us_GPIO_Data_Mask & OPTN_GPIO2_MASK)
   {
      if ((gul_GPIO_Data & OPTN_GPIO2_MASK) == OPTN_GPIO2_HI)
         switchOffConnectLED();
      else
         switchOnConnectLED();
   } // Handle GPIO2 using gt_Gpio which maps to *INFOMap[INFO_GPIO_Control] CMV

    #else
   SetDspReg(GPIO_DATA, gul_GPIO_Data);   // write to GPIO_DATA register
    #endif
#endif
}

/* Get the status of all the GPIO pins */
uint16 GetGPIOStatus (void)
{
#ifdef ENABLE_LEDs
   uint32 ul_word;
   // Configure GPIO Pins  as input.
   ul_word = GetDspReg(GPIO_DATA);

   return ((uint16)ul_word);

#else
    return(0);
#endif
}

//Note: the argument for GetGPIOBit, i.e., Pin_Num, is the actual number of GPIO pin
//not the mask, like 0x0200 for GPIO9, defined above.
//So to retrieve GPIO Pin8, s_value = GetGPIOBit(8);
int16 GetGPIOBit (int16 Pin_Num)
{
#ifdef ENABLE_LEDs
   uint32 ul_word;

   // Configure GPIO Pin we want to get info from as input.
#ifndef ADSL_62
   s_ctrl = 0xFFFF & (~(1<<Pin_Num));
   SetDspReg(GPIO_CTRL, s_ctrl);
#endif
   ul_word = GetDspReg(GPIO_DATA);

   return ((ul_word >> Pin_Num) & 0x1);
#endif
}


/******************************************************************************/
// GPIO10: ADSL Layer connectivity LED as defined in TR-068, clause I-31.
//
// OFF = Power off (We also turn LED off in fail state and when modem is not trying to link.)
// ON =     Good DSL sync (showtime)
// 2Hz flash = Modem trying to detect CO (i.e. sending G.hs and/or T.1413 tones)
// 4Hz flash = CO detected, trying to train.
//
// We also add the following, not specified in TR-068.
// 1Hz flash = Loop Diagnostics train
/******************************************************************************/

#define LED_1Hz_FLASH   (uint32) (0x00000800)
#define LED_2Hz_FLASH   (uint32) (0x00000400)
#define LED_4Hz_FLASH   (uint32) (0x00000200)
#define LED_16Hz_FLASH  (uint32) (0x00000080)   // 16Hz
#define LED_ON       (uint32) (0xFFFFFFFF)
#define LED_OFF         (uint32) (0x00000000)
#define GPIO_OFF        0x0
#define GPIO_FLASH         0x1
#define GPIO_PROG_FLASH    0x2
#define GPIO_ON            0x3


void FlashGPIO(void)
{
#ifdef ENABLE_LEDs
   int i;
   uint32 ul_AdslConnectLedDutyCycle = LED_OFF;

   uint16 us_invert;
   uint16 us_data_write, us_LED_State;

   // Read the status of GPIO pins
    #ifdef HERCULES_ADSL_CPE
    // Read of GPIO status is not implemented.
    // This is worked around by writing bits individually in the write routine.
   gt_Gpio.us_GPIO_Data_Read = 0;
    #else
   gt_Gpio.us_GPIO_Data_Read = GetGPIOStatus();
    #endif
   us_data_write = gt_Gpio.us_GPIO_Data_Write;  // Data from ME

   /////////////////////////////////////////
   // TR68-compliant Link status signal
   /////////////////////////////////////////

   gl_RxSymbolRunningCount++;

   // Note that prior to linkstart, or in fail state, TR68 LED state is OFF.
   if (STATArray[STAT_MacroState] == STAT_ReadyState)
      ul_AdslConnectLedDutyCycle = LED_2Hz_FLASH;
   else if ((STATArray[STAT_MacroState] == STAT_GhsState) ||
      (STATArray[STAT_MacroState] == STAT_T1413) || (STATArray[STAT_MacroState] == STAT_FullInitState))
      ul_AdslConnectLedDutyCycle = LED_4Hz_FLASH;
   else if (STATArray[STAT_MacroState] == STAT_LoopDiagMode)
      ul_AdslConnectLedDutyCycle = LED_1Hz_FLASH;
   else if (STATArray[STAT_MacroState] == STAT_ShowTimeState)
      ul_AdslConnectLedDutyCycle = LED_ON;

   if (gt_Gpio.s_GPIO_For_TR68_Adsl_LED & 0x1)  // TR68 ADSL LED Signal is enabled
   {
      i = (gt_Gpio.s_GPIO_For_TR68_Adsl_LED & 0xF00) >> 8;  // index of bit for TR68 signal

      if (gl_RxSymbolRunningCount & ul_AdslConnectLedDutyCycle)
         us_LED_State = 1; // ON
      else
         us_LED_State = 0; // OFF

      us_invert = (gt_Gpio.s_GPIO_For_TR68_Adsl_LED & 0x2)>>1;
      if (us_LED_State ^ us_invert)
         us_data_write &= (~((1<<i)&0xFFFF));   // Led ON
      else
         us_data_write |= ((1<<i) & 0xFFFF);    // Led OFF
   }

   /////////////////////////////////////////
   // Programmable flash signal.
   // Prior to linkstart, this signal can be turned ON and OFF by ME,
   // but flashing is not supported.
   /////////////////////////////////////////

   i = (gt_Gpio.s_GPIO_16Hz_Flash_LED & 0xF00) >> 8;  // index of bit for 16Hz flash LED signal

   // Count down from max to 0, toggle LED, and repeat.
   gl_AdslProgFlashLedCtr--;

   if (gl_AdslProgFlashLedCtr > gl_AdslProgFlashLedCtrMax)
      gl_AdslProgFlashLedCtr = gl_AdslProgFlashLedCtrMax;

   if (gl_AdslProgFlashLedCtr <= 0)
   {
      // Toggle LED state
      gus_ProgFlashState = ~gus_ProgFlashState;

      // Reset counter
      gl_AdslProgFlashLedCtr = gl_AdslProgFlashLedCtrMax;
   }

   us_data_write &= ~(1<<i);     // Clear bit state
   us_data_write |= (gus_ProgFlashState & (1<<i)); // Set to 0 or 1.

   // Check whether prog flash frequency has changed.

   if ((gt_Gpio.s_GPIO_16Hz_Flash_LED & 0x3) == GPIO_FLASH)
   {
      gl_AdslProgFlashLedCtrMax = 125; //16 Hz flash
   }
   else if ((gt_Gpio.s_GPIO_16Hz_Flash_LED & 0x3) == GPIO_PROG_FLASH)
   {
      //
      gl_AdslProgFlashLedCtrMax = 4000 / ((gt_Gpio.s_GPIO_16Hz_Flash_LED >> 2) & 0x3f);
   }
   else if ((gt_Gpio.s_GPIO_16Hz_Flash_LED & 0x3) == GPIO_ON)
   {
      us_data_write &= (~((1<<i)&0xFFFF));   // Led ON
   }
   else
      us_data_write |= ((1<<i) & 0xFFFF);    // Led OFF

   WriteGPIOBits(us_data_write);
#endif
}


#ifdef HERCULES_ADSL_CPE

//**********************
// TR68 LED Additions
/*
** ============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: switchOffConnectLED
**
** DESCRIPTION:   Switches the connect LED off
**
** PARAMETERS:    -
**
** RETURN VALUE:  -
**
** NOTES:         The connect LED is connected to ball xx (GPIO2_D)
** ============================================================================
*/
void switchOffConnectLED(void)
{
#ifdef ENABLE_LEDs
    /* The sequence of the following two lines must */
    /* be as it is now. Otherwise it won't work!    */
    /* Note there is an inverter on the board, so this programs it Hi    */
    GPIO_GPIODOH_SET(GPIO_GPIODOH_GET | GPIO2_MASK);
    GPIO_GPIODOL_SET(GPIO_GPIODOL_GET & ~GPIO2_MASK);
#endif
}


/*
** ============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: switchOnConnectLED
**
** DESCRIPTION:   Switches the connect LED
**
** PARAMETERS:    -
**
** RETURN VALUE:  -
**
** NOTES:         The connect LED is connected to ball xx (GPIO2_D)
** ============================================================================
*/
void switchOnConnectLED(void)
{
#ifdef ENABLE_LEDs
    /* The sequence of the following two lines must */
    /* be as it is now. Otherwise it won't work!    */
    /* Note there is an inverter on the board, so this programs it Lo    */
    GPIO_GPIODOL_SET(GPIO_GPIODOL_GET | GPIO2_MASK);
    GPIO_GPIODOH_SET(GPIO_GPIODOH_GET & ~GPIO2_MASK);
#endif
}

/*
** ============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: switchOffDetectLED
**
** DESCRIPTION:   Switches the Detect LED off
**
** PARAMETERS:    -
**
** RETURN VALUE:  -
**
** NOTES:         The Detect LED is connected to ball xx (GPIO1_D)
** ============================================================================
*/
void switchOffDetectLED(void)
{
#ifdef ENABLE_LEDs
    /* The sequence of the following two lines must */
    /* be as it is now. Otherwise it won't work!    */
    /* Note there is an inverter on the board, so this programs it Hi    */
    GPIO_GPIODOH_SET(GPIO_GPIODOH_GET | GPIO1_MASK);
    GPIO_GPIODOL_SET(GPIO_GPIODOL_GET & ~GPIO1_MASK);
#endif
}


/*
** ============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: switchOnDetectLED
**
** DESCRIPTION:   Switches the Detect LED on
**
** PARAMETERS:    -
**
** RETURN VALUE:  -
**
** NOTES:         The Detect LED is connected to ball xx (GPIO1_D)
** ============================================================================
*/
void switchOnDetectLED(void)
{
#ifdef ENABLE_LEDs
    /* The sequence of the following two lines must */
    /* be as it is now. Otherwise it won't work!    */
    /* Note there is an inverter on the board, so this programs it Lo    */
    GPIO_GPIODOL_SET(GPIO_GPIODOL_GET | GPIO1_MASK);
    GPIO_GPIODOH_SET(GPIO_GPIODOH_GET & ~GPIO1_MASK);
#endif
}

/*
** ============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: switchOffLosLED
**
** DESCRIPTION:   Switches the LOS LED off
**
** PARAMETERS:    -
**
** RETURN VALUE:  -
**
** NOTES:         The LOS LED is connected to ball xx (GPIO0_D)
** ============================================================================
*/
void switchOffLosLED(void)
{
#ifdef ENABLE_LEDs
    /* The sequence of the following two lines must */
    /* be as it is now. Otherwise it won't work!    */
    /* Note there is an inverter on the board, so this programs it Hi    */
    GPIO_GPIODOH_SET(GPIO_GPIODOH_GET | GPIO0_MASK);
    GPIO_GPIODOL_SET(GPIO_GPIODOL_GET & ~GPIO0_MASK);
#endif
}


/*
** ============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: switchOnLosLED
**
** DESCRIPTION:   Switches the Los LED on
**
** PARAMETERS:    -
**
** RETURN VALUE:  -
**
** NOTES:         The LOS LED is connected to ball xx (GPIO0_D)
** ============================================================================
*/
void switchOnLosLED(void)
{
#ifdef ENABLE_LEDs
    /* The sequence of the following two lines must */
    /* be as it is now. Otherwise it won't work!    */
    /* Note there is an inverter on the board, so this programs it Lo    */
    GPIO_GPIODOL_SET(GPIO_GPIODOL_GET | GPIO0_MASK);
    GPIO_GPIODOH_SET(GPIO_GPIODOH_GET & ~GPIO0_MASK);
#endif
}

/*^^^
*-------------------------------------------------------------------
*
*  void InitLedsHw(void);
*
*  Abstract:
*
*      This function inits the LED HW.
*
*  Global Variables:
*
*
*-------------------------------------------------------------------
*^^^
*/
void InitLedsHw()
{
#ifdef ENABLE_LEDs
    // Pull Up Config
    uint32 Temp32;
    Temp32 = GPIO_GPIOCFG_GET;
    Temp32 &= ~0x7;        // GPIO Bit 2, 1, and 0 as "0" push pull mode
    GPIO_GPIOCFG_SET(Temp32);

    // Direction Regs
    Temp32 = GPIO_GPIODIR_GET;
    Temp32 |= 0x7;         // GPIO Bit 2, 1, and 0 as "1" outputs
    GPIO_GPIODIR_SET(Temp32);

    // Move this to init routine as well
    switchOffLosLED();
    switchOffDetectLED();
    switchOffConnectLED();
#endif
}

#endif // HERCULES_ADSL_CPE
#endif // TARGET_HW
