/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gpio_ini.c
*
*  Functions for setting, clearing GPIO signals
*
*-------------------------------------------------------------------------
*/

#include "common.h"
//#include "typedef.h"
#include "gdata.h"
#include "cmv.h"
#include "gpio.h"
#include "ll_iof.h"

#ifdef TARGET_HW

/*-------------------------------------------------------------------
*
*  Function:   SetGPIOBits(data)
*           ClearGPIOBits(data)
*
*  Description: These functions set/clear the bits GPIO bits set in parameter data
*           GPIO (i.e. General Purppose IO) bits 9-12 are typically used
*           to control the LOS, Connect, CRC, and Detect, respectively.
*
*
*-------------------------------------------------------------------
*^^^
*/

/*-------------------------------------------------------------------
*
*  Function:   SetGPIOBits(data)
*           ClearGPIOBits(data)
*
*  Description: These functions set/clear the bits GPIO bits set in parameter data
*           GPIO (i.e. General Purppose IO) bits 9-12 are typically used
*           to control the LOS, Connect, CRC, and Detect, respectively.
*
*
*-------------------------------------------------------------------
*^^^
*/
void SetGPIODirectionBits(int16 s_data)
{
#ifdef ENABLE_LEDs
   uint32 ul_GPIO_Dir;
   ul_GPIO_Dir = 0xFFFF & s_data;
   SetDspReg(GPIO_CTRL, ul_GPIO_Dir);  // write to GPIO_CTRL register.

#endif

}

void SetGPIOBits(int16 s_data)
{
#ifdef ENABLE_LEDs

   SetDspReg(GPIO_CTRL, 0xFFFF); // write to GPIO_CTRL register.
   gul_GPIO_Data |= (s_data & 0xFFFF);
   SetDspReg(GPIO_DATA, gul_GPIO_Data);
#endif
}

void ClearGPIOBits(int16 s_data)
{
#ifdef ENABLE_LEDs

   SetDspReg(GPIO_CTRL, 0xFFFF); // write to GPIO_CTRL register.

   gul_GPIO_Data &= (~(s_data&0xFFFF));
   SetDspReg(GPIO_DATA, gul_GPIO_Data);
#endif
}

#endif

