/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2002 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       int_service.c
*
*-------------------------------------------------------------------
*/
#include "typedef.h"
#include "interrupt.h"
#include "mtkernel.h"
#include "gdata.h"
#include "nmp_plfm.h"
#include "states.h"

void Infinite_loop()
{
   gus_ExceptionState = gs_RxState;

   // Run Exception Handler sets FAIL state and triggers ME reboot, including showtime
   ExceptionHandler();

   // for debug purpose
   Pause(5678);

}

void  mem_service()
{
   gus_ExceptionCode = E_CODE_BAD_MEM_ACCESS;
   Infinite_loop();
}

void instr_service()
{
   gus_ExceptionCode = E_CODE_BAD_INSTRUCTION_ACCESS;
   Infinite_loop();
}
void dma_complete_handler()
{
   gus_ExceptionCode = E_CODE_DMA_INTERRUPT;
   Infinite_loop();
}
void mailbox_complete_handler()
{
   gus_ExceptionCode = E_CODE_MAILBOX_INTERRUPT;
   Infinite_loop();
}

void reserved_int()
{
   gus_ExceptionCode = E_CODE_RESERVED_INT;
   Infinite_loop();
}
void codeswap_handler()
{
   gus_ExceptionCode = E_CODE_CODESWAP;
   Infinite_loop();
}
void expansion_bus_handler()
{
   gus_ExceptionCode = E_CODE_EXPANSION;
   Infinite_loop();
}






