;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**

        ;.define    SIMULATED_HWWAITSTATES,    "nop"
        .define    SIMULATED_HWWAITSTATES,   ""
   .define    ADSL_BASE_OFFSET,           0x20000

;
;       WriteCoreBuf Function
;

   .global WriteCoreBuf
WriteCoreBuf:
        ;      DestAddr = (us_addr << 2) + ADSL_BASE_OFFSET
        asl    %r0,%r0,2
        asl    %r3,%r3,1            ; src_pitch in terms of bytes
        add    %r4,%r0,ADSL_BASE_OFFSET
        ; If us_num <= 0, quit the function
        sub.f  0,%r2,0
        sub    %r0,%r0,%r0          ; dummy
        jle    [%blink]
        ldw    %r0,[%r1]            ; Get the word from *psa_words
                                    ; and extend it to 32 bit
        st     %r0,[%r4]            ; store it in core memory
        sub.f  %lp_count,%r2,1
        sub    %r0,%r0,%r0
        jle    [%blink]
        lpnz   lpend_WriteCoreBuf
lpstart_WriteCoreBuf:
        ldw.a  %r0,[%r1,r3]        ; get word from psa_words+pitch
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
        st.a   %r0,[%r4,4]
lpend_WriteCoreBuf:
        j.d    [%blink]
        sub    %r0,%r0,%r0


;
;       WriteCoreBuf32NoDMA Function
;

   .global WriteCoreBuf32NoDMA
WriteCoreBuf32NoDMA:
        ;      DestAddr = (us_addr << 2) + ADSL_BASE_OFFSET
        asl    %r0,%r0,2
        add    %r4,%r0,ADSL_BASE_OFFSET
        ; If us_num <= 0, quit the function
        sub.f  0,%r2,0
        sub    %r0,%r0,%r0          ; dummy
        jle    [%blink]
        ldw    %r0,[%r1]         ; Get the long word from *psa_words
      ldw.a  %r3,[%r1,2]         ; by reading word at a time, so that
        asl    %r3,%r3,16        ; input buffer need not be defined at
        add    %r0,%r0,%r3       ; a long word boundary
        st     %r0,[%r4]            ; Store it in core memory
        sub.f  %lp_count,%r2,1
        sub    %r0,%r0,%r0
        jle    [%blink]
        lpnz   lpend_WriteCoreBuf32NoDMA
lpstart_WriteCoreBuf32NoDMA:
        ldw.a   %r0,[%r1,2]         ; Get the long word from *psa_words as above
        ldw.a   %r3,[%r1,2]
        asl     %r3,%r3,16
        add       %r0,%r0,%r3
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
        st.a   %r0,[%r4,4]
lpend_WriteCoreBuf32NoDMA:
        j.d    [%blink]
        sub    %r0,%r0,%r0


;
;       WriteCoreBuf8 Function
;

   .global WriteCoreBuf8
WriteCoreBuf8:
        ;      DestAddr = (us_addr << 2) + ADSL_BASE_OFFSET
        asl    %r0,%r0,2
        add    %r4,%r0,ADSL_BASE_OFFSET
        ; If us_num <= 0, quit the function
        sub.f  0,%r2,0
        sub    %r0,%r0,%r0          ; dummy
        jle    [%blink]
        ldb    %r0,[%r1]            ; Get the byte from *psa_words
                                    ; and extend it to 32 bit
        st     %r0,[%r4]            ; store it in core memory
        sub.f  %lp_count,%r2,1
        sub    %r0,%r0,%r0
        jle    [%blink]
        lpnz   lpend_WriteCoreBuf8
lpstart_WriteCoreBuf8:
        ldb.a  %r0,[%r1,1]        ; get word from psa_words+pitch
        st.a   %r0,[%r4,4]
lpend_WriteCoreBuf8:
        j.d    [%blink]
        sub    %r0,%r0,%r0


;       ReadCoreBuf Function
;

   .global ReadCoreBuf
ReadCoreBuf:
         ;Source address on the core memory, so translation required
         ;  (us_addr << 2) + ADSL_BASE_OFFSET
         asl    %r0,%r0,2
         asl    %r3,%r3,1     ; destination pitch in terms of bytes
         add    %r4,%r0,ADSL_BASE_OFFSET
         ; If us_num <= 0, quit the function
   sub.f  0,%r2,0
   sub    %r0,%r0,%r0          ; dummy
   jle    [%blink]
   ld     %r0,[%r4]            ; read from the core memory
     stw    %r0,[%r1]            ; store as 16 bit quantity
   add   %r1,%r1,%r3        ;Increment by the pitch etc
     sub.f  %lp_count,%r2,1
   sub    %r0,%r0,%r0
   jle    [%blink]
   lpnz   lpend_ReadCoreBuf
lpstart_ReadCoreBuf:
         ld.a   %r0,[%r4,4]         ; read the next long word
         stw    %r0,[%r1]        ;Write to the firmware buffer taking the pitch parameter
                                    ;  into account
         add   %r1,%r1,%r3       ;Increment by the pitch etc
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
lpend_ReadCoreBuf:
         j.d      [%blink]
         sub      %r0,%r0,%r0

;
;       FillCoreBuf Function
;
         .global  FillCoreBuf
FillCoreBuf:
         ;Destination address on the core memory, so translation required
         ;  (us_addr << 2) + ADSL_BASE_OFFSET
         asl    %r0,%r0,2
         asl    %r3,%r3,2     ; destination pitch in terms of longword bytes
         add    %r4,%r0,ADSL_BASE_OFFSET
          ; If us_num <= 0, quit the function
   sub.f  0,%r2,0
   sub    %r0,%r0,%r0          ; dummy
   jle    [%blink]
         mov    %lp_count,%r2        ; no of time the loop needs to be executed
         lpnz   lpend_FillCoreBuf
lpstart_FillCoreBuf:
         st     %r1,[%r4]            ;store it in core memory
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
         add    %r4,%r4,%r3          ;Increment the pointer by 4*pitch
lpend_FillCoreBuf:
         j      [%blink]

;
;       FillCoreBuf32 Function
;
         .global  FillCoreBuf32
FillCoreBuf32:
         ;Destination address on the core memory, so translation required
         ;  (us_addr << 2) + ADSL_BASE_OFFSET
         asl    %r0,%r0,2
         add    %r4,%r0,ADSL_BASE_OFFSET
          ; If us_num <= 0, quit the function
   sub.f  0,%r2,0
   sub    %r0,%r0,%r0          ; dummy
   jle    [%blink]
         mov    %lp_count,%r2        ; no of time the loop needs to be executed
         lpnz   lpend_FillCoreBuf32
lpstart_FillCoreBuf32:
         st     %r1,[%r4]            ;store it in core memory
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
         add    %r4,%r4,4          ;Increment the pointer by 4 bytes
lpend_FillCoreBuf32:
         j      [%blink]



   .global ReadCoreBuf8
ReadCoreBuf8:
         ;Source address on the core memory, so translation required
         ;  (us_addr << 2) + ADSL_BASE_OFFSET
         asl    %r0,%r0,2
         add    %r4,%r0,ADSL_BASE_OFFSET
         ; If us_num <= 0, quit the function
   sub.f  0,%r2,0
   sub    %r0,%r0,%r0          ; dummy
   jle    [%blink]
   ld     %r0,[%r4]            ; read from the core memory
     stb    %r0,[%r1]            ; store as 8 bit quantity
   add   %r1,%r1,1             ;Increment by the 1 byte
     sub.f  %lp_count,%r2,1
   sub    %r0,%r0,%r0
   jle    [%blink]
   lpnz   lpend_ReadCoreBuf8
lpstart_ReadCoreBuf8:
         ld.a   %r0,[%r4,4]         ; read the next long word
         stb    %r0,[%r1]        ;Write to the firmware buffer
         add   %r1,%r1,1         ;Increment by 1 for the byte buffer
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
   SIMULATED_HWWAITSTATES
lpend_ReadCoreBuf8:
         j.d      [%blink]
         sub      %r0,%r0,%r0
