/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_hw.c
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */
#include "common.h"
#include "gdata.h"
#include "modem_hw.h"
#include "cmv.h"
#include "nmp_plfm.h"
#include "memrymap.h"
#include "ll_iof.h"

#ifdef SLEEP_TEST_BUILD
#include "soc_codeswap.h"
int32 testModeOperation(void);
#ifdef AMAZON_SE
#include "codeswap.h"
#endif
#endif



#ifdef DANUBE
#ifdef TARGET_HW
#include "dataswap.h"
#endif
#endif

#ifdef CUSTOMER_TASKS
#include "CustomerTasks.h"
#endif
#ifdef HERC_API
#include "cmv_remap.h"
#endif

uint32 gul_MainLoopCount = 0;
int16 RunBackground(void);

void StartModemOperation(void);
void ProcessCNTL00(void);
#ifdef ADSL_VDSL_MODE_SWITCH
void ProcessCNTL10(void);
#endif
/*-------------------------------------------------------------------
*
*  int main(void)
*
*  Description: This is the main program for running Aware Modem Code.
*
*  Command line arguments:
*     None
*
*-------------------------------------------------------------------
*^^^
*/
#ifdef SLEEP_TEST_BUILD
int32 gl_testResult;
int16 gs_TestModeLoaded;
#endif

volatile FlagT gft_running = 0; // will be 0 after download , we change to 1 after arc has started running.
extern uint8 guc_PortActive;

void ClearDataSwapPages(void);

int32 gt_ExceptionInfo[7];
int32 gl_other_exception;
int32 gl_mem_except;
int32 gl_instr_err;

void main(void) {

#ifdef DANUBE
#ifdef TARGET_HW
    // enable core clocks to allow regiters programming during init stage.
    WriteCoreReg(CRI_CCR0_ADDR,(uint16)0x0055);
    WriteCoreReg(CRI_CCR1_ADDR,(uint16)0x1555);
#endif

   /* reset check */
   if (gft_running == 0)
      gft_running=1;
   else
   {
      // Set the exception code, arc was reset without a code download.
      gus_ExceptionCode  = E_CODE_JUMP_FROM_RESET_ERROR;
      Pause((E_CODE_JUMP_FROM_RESET_ERROR & 0xffff));
   }

#ifdef TARGET_HW
   /* Check to make sure we can access to external SDRAM via XDMA */
   Verify_XdmaAccess ();

   /* Clear external SDRAM buffers */
   Xdma_ClearXmem();
#endif
#endif   // #ifdef DANUBE

#ifdef ADSL_62
    ClearDataSwapPages();
#endif

    /* ============================================================================= */
   /*  Perform Pre-Handshake Modem Initialization */
   /* ============================================================================= */
   InitModem_PreHandshake();

   #ifdef CUSTOMER_TASKS
   InitCustomer_PowerUp();
   InitCustomer_PreHandshake();
   #endif // CUSTOMER_TASKS

   /* ==================================================================== */
   /*  Processing Data */
   /* ==================================================================== */
   while (1)
   {

      gul_MainLoopCount++;

      /* ==================================================================== */
      /* process START MP command   */
      /* ==================================================================== */

        if (gs_ModemOperationRequired == 1)
        {
            ProcessCNTL00();
        }
#ifdef ADSL_VDSL_MODE_SWITCH
        else if (gs_ModemOperationRequired == 2)
        {
            ProcessCNTL10();
        }
#endif



      /* ==================================================================== */
      /* wait for START MP command  */
      /* ==================================================================== */

      if (gs_MpWinhostControl == 0)
      {
         // This code is run only prior to link start.
            if (NewMPCheckMessage(VBM_MAILBOX)!= 0)
         {
            gs_ModemOperationRequired = NewMPHandleMessage(VBM_MAILBOX);
         }

            #ifdef HERC_API
            HercMonitorUpdate();
            #endif
         FlashGPIO();
      }


      /* ==================================================================== */
      /* Run Background Tasks */
      /* ==================================================================== */

      if(RunBackground() == FAIL)
         break;

#ifdef SLEEP_TEST_BUILD
        if (CNTLArray[0] & 0x08)
        {
            if (gs_TestModeLoaded == 0)
            {
                gs_CodeSwapStatus = CODESWAP_START;
                gs_CodeSwapSection = CSPAGE_BIS_MODEM_TEST;
                do
                {
                    HandleCodeSwap();
                }while (gs_CodeSwapStatus != CODESWAP_COMPLETE);
                gs_TestModeLoaded = 1;
         }
            else
            {
                gl_testResult = testModeOperation();
                STATArray[1]= (gl_testResult>>16);
                STATArray[2]= (gl_testResult & 0xFFFF);
            }
        }
#endif

   } //while
}

FlagT gft_LinkInitiated;

void ProcessCNTL00(void)
{
    switch(CNTLArray[CNTL_ModemControl] & 0x000F)
    {
        case 0:     // CNTL_0_0_0   auto restart
            gft_LinkInitiated = 0;

            // for the time being, instead of auto-restart, we'll do a soft mode_switch_reset
            // equivalent to an "rb"
         ProcessCNTL10();
            break;

        default:    // other than auto restart
            if (gft_LinkInitiated == 0)
            {
                gft_LinkInitiated = 1;
            #ifndef SLEEP_TEST_BUILD
                StartModemOperation();
                guc_PortActive = 2;
            #endif
            }
            break;
    }
}


#ifdef ADSL_VDSL_MODE_SWITCH

#include "dsp_regs_62.h"

void ReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes);
void hw_reset(void);


#define BOOT_PAGE_MASK              0x80000000

typedef struct {
    int32 l_ImageSize;
    int32 l_ImageCheckSum;
    int32 l_NumOfSwaps;
} ImageHeader_t;

ImageHeader_t gt_ImageHeader;

typedef struct {
    int32 l_PmSrcOffset;
    int32 l_PmDestAddr;
    int32 l_PmSize;

    int32 l_DmSrcOffset;
    int32 l_DmDestAddr;
    int32 l_DmSize;
} SwapPageHeader_t;
SwapPageHeader_t gt_SwapHeader;

extern PortModeControl_t gt_PortModeControl;

int32 gl_ModemID = 0xAD51;

void LoadBootLoader62(void)
{
    int32 l_SwapHeaderOffset, l_Page, l_PageSrcAddr, l_PageSize, l_SramOffset;

    guc_xdma_reg_offset = 0;
    guc_ch_id = 0;

    // set xdma fields in PORT_SEL register
    // the macro DSP_PORT_0_SEL_MASK already contains correct XDMA setting for either ports.
    SetDspReg(DSP_PORT_SEL, DSP_PORT_0_SEL_MASK);


    // set SramOffset to zero for bootloader image
    l_SramOffset = 0;

    // read XDSL image header
    ReadXdmaBlock(l_SramOffset, (int32)&gt_ImageHeader, sizeof(ImageHeader_t));
    l_SwapHeaderOffset = l_SramOffset + sizeof(ImageHeader_t);


    // bring in boot page for the bootloader
    for (l_Page = 0; l_Page < gt_ImageHeader.l_NumOfSwaps; l_Page++)
    {
        // the swap header
        ReadXdmaBlock(l_SwapHeaderOffset, (int32)&gt_SwapHeader,  sizeof(SwapPageHeader_t));

        // after toggle the MSB, the boot page size should be > 0
        if ((l_PageSize = gt_SwapHeader.l_PmSize ^ BOOT_PAGE_MASK) > 0)
        {
            l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_PmSrcOffset;

            ReadXdmaBlock(l_PageSrcAddr, gt_SwapHeader.l_PmDestAddr, l_PageSize << 2);
        }

        if ((l_PageSize = gt_SwapHeader.l_DmSize ^ BOOT_PAGE_MASK) > 0)
        {
            l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_DmSrcOffset;

            ReadXdmaBlock(l_PageSrcAddr, gt_SwapHeader.l_DmDestAddr, l_PageSize << 2);
        }

        l_SwapHeaderOffset += sizeof(SwapPageHeader_t);
    }

}

void ProcessCNTL10(void)
{
    uint8 uc_XdslMode;
    uint8 uc_PortMode;

    // wait for CNTL_1_0 ack to be serviced by ME before switching mode
    while(guc_MPMsgReq || TxMailBoxPending())
    {
    }

    // effectively halt the other port
    _disable1();

    // validate mode-switch request and set desired modes
    if (CNTLArray[CNTL_ModemModeSwitch] != MODESWITCH_SOFT_RESET)
    {
        switch (CNTLArray[CNTL_ModemModeSwitch])
        {
            case ONE_PORT_ADSL:
                uc_XdslMode = ADSL_PORT_MODE;
                uc_PortMode = SINGLE_PORT_MODE;
                break;

            case ONE_PORT_VDSL:
                uc_XdslMode = VDSL_PORT_MODE;
                uc_PortMode = SINGLE_PORT_MODE;
                break;

            case TWO_PORT_ADSL:
                uc_XdslMode = ADSL_PORT_MODE;
                uc_PortMode = DUAL_PORT_MODE;
                break;

            case TWO_PORT_VDSL:
                uc_XdslMode = VDSL_PORT_MODE;
                uc_PortMode = DUAL_PORT_MODE;
                break;

            default:
                // invalid mode requested; just resume modem operation
                _enable1();
                return;
        }

        gt_PortModeControl.uc_XdslModeCurrent = uc_XdslMode;
        gt_PortModeControl.uc_DualPortModeCurrent = uc_PortMode;
    }

    // Note that ModeSwitching is happing in the BG so all ADMA transfers have
    // been finished.

    // terminate all XDMA transfers
    SetDspReg(DSP_XDMA0_CTRL, 0);
    SetDspReg(DSP_XDMA1_CTRL, 0);

    // Bring in bootable pages for BootLoader
    LoadBootLoader62();

    // transition to Bootloader
    hw_reset();
}

#endif
