/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   modem_hw.C
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */
 // ******************************************************************
 // modem_hw.C
 //
 // Change History
 //
 // 07/05/2015 Sriram Shastry : Implement  Final Fail  state. Introduced Infinite_loop .  During  this  state, MEI and  PPE will have  no access to  ARC.
 //          Grep for  :XDSLRTFW-2186
 // ******************************************************************

#include <stdio.h>
#include <stdlib.h>

#include "const.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "compiler.h"
#include "mtkernel.h"
#include "FormRRates.h"
#include "FormRMsgs1.h"
#include "DecodCInfo1.h"
#include "DecodCInfoRA.h"
#include "SelectDSRateOption.h"
#include "VerifyRateWithTwoCG.h"
#include "xgdata.h"
#include "ghs.h"
#include "pll.h"
#include "states.h"
#include "tx_ops.h"
#include "file_io3.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "fifo.h"
#include "file_io.h"
#include "bert.h"
#include "mp.h"
#include "cmv.h"
#include "stateini.h"
#include "aux_regs.h"

#include "IRI_Iof.h"
#ifndef ADSL_62
    #include "cri.h"
#endif

#include "cri_cocomo_interface.h"
#ifndef HERCULES_ADSL_CPE
   #include "strymon_cpe.h"
   #include "strymon_cpe_typedef.h"
   #include "iridia.h"
   #include "Zephyr.h"
   #include "alphaeus.h"
   #include "alphaeus_typedef.h"
#endif
#include "dsp_op.h"
#include "file_io3.h"
#include "statein1.h"
#include "interrupt.h"
#include "data_alloc.h"
#include "nmp_plfm.h"
#include "rx_ovrhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "cri_iof.h"
#include "socrates_memrymap.h"
#ifdef DANUBE
#ifdef TARGET_HW
   #include "dataswap.h"
#endif
#endif
#ifdef CUSTOMER_TASKS
#include "CustomerTasks.h"
#endif

#if defined(HERCULES_ADSL_CPE) || defined(ADSL_62)
    #include "DetectInterrupts.h"
#endif
//#define DEBUG_TX      /* Debugs showtime Tx path */

int16 gs_bypass_strymon = 0;

#if !defined(DANUBE) && !defined(ADSL_62)
#pragma Data(DATA,"SIM_RAM")
int16 gs_AecDacSample;
int16 gs_AecDacSampleValid;   /* AEC DAC sample valid flag */

int16 gs_Interrupt_Detected=0;

int32 gl_RxFrameCnt, gl_TxFrameCnt;
int16 gs_TmpRxInBufIndex;
int16 gs_TmpTxOutBufIndex;
int16 gsa_TmpRxInBuf[1300];

int16 gs_upIndex;
int16 gs_sampleCnt;


int16 gs_AtoD_PutPtr = (3*(512+32))/2;          /* ADC buffer put pointer */
int16 gs_AtoD_GetPtr;                           /* ADC buffer get pointer */

uint32 gl_TotalRxSampleCount = 0;
DATA_MAP_END
#endif   // #ifndef DANUBE

int32 gl_RxFrameCnt, gl_TxFrameCnt;
int16 gs_rxFrameInt, gs_txFrameInt;
int16 gs_TmpRxInBufIndex;
int16 gs_TmpTxOutBufIndex;
int16 gs_CriStatus2;
int16 gs_CriMadSt;

void DisableADSLInterrupts()
{
#ifndef ADSL_62
   uint32 ul_reg;
// ul_reg = _lr(ARC_INT_MASK_ADDR);             // disable ADSL interrupts on the ARC
    ul_reg = GetDspReg(ARC_INT_MASK_ADDR);               // disable ADSL interrupts on the ARC
   ul_reg &= (uint32) ~ARC_INT_MASK_ADSL_MASK;
// _sr(ul_reg, ARC_INT_MASK_ADDR);
    SetDspReg(ARC_INT_MASK_ADDR, ul_reg);
#endif
}

void EnableADSLInterrupts()
{
#ifndef ADSL_62
   uint32 ul_reg;

// ul_reg = _lr(ARC_INT_MASK_ADDR);             // enable ADSL interrupts on the ARC
    ul_reg = GetDspReg(ARC_INT_MASK_ADDR);               // disable ADSL interrupts on the ARC
   ul_reg |= (uint32) ARC_INT_MASK_ADSL_MASK;
// _sr(ul_reg, ARC_INT_MASK_ADDR);
    SetDspReg(ARC_INT_MASK_ADDR, ul_reg);
#endif
}


/*****************************************************************************
;  Prototype:  int16 DetectInterrupts(void)
;
;  This function detects interrupts generated by the ADSL cores.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     -1    no interrupts detected
;     else  interrupt detected
;
;  Global Variables:
;
;****************************************************************************/

#ifdef ADSL_62

int16 DetectInterrupts(void)
{
   int32 l_CriEvent;

    /************************************************/
   /* Read CRI to get interrupt status          */
   /************************************************/

   ReadCoreReg(CRI_EVENT_ADDR, &l_CriEvent);

   gs_InterruptMask = 0;

    /* detect interrupt */
   //Since we only enabled one interrupt, i.e., TSC_RX_INT,
   //we will only look for this interrupt and ignore all the others
   if(l_CriEvent & CRI_MASK_RX_TSC_INT)
   {
      //By doing this, we can share some code with soc/herc5.0 build
      gs_InterruptMask = (1<<RX_TSC_INT);

      //Clear this interrupt
      WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_RX_TSC_INT);
   }

#ifndef TARGET_HW
    //TX_FTB_FRAME and RX_FTB_FRAME are for cocomo test only
    //TSC_RX_INT is the only one that starts TX/RX TC TASK
    else if (l_CriEvent & CRI_MASK_TX_FTB_FRAME)
    {

        gs_InterruptMask = (1<< TX_FRAME_START);
        //tx frame boundary  for cocomo
        gs_txFrameInt =1;

        //Clear this interrupt
      WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_TX_FTB_FRAME);
    }
#endif

    else if (l_CriEvent & CRI_MASK_RX_FTB_FRAME)
    {
        gs_InterruptMask = (1<<RX_FRAME_START);
        //Clear this interrupt
      WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_RX_FTB_FRAME);
    }

   return((int16) (gs_InterruptMask != 0) || (gs_txFrameInt !=0) );
}
#endif

#if defined(HERCULES_ADSL_CPE) && !defined(ADSL_62)
extern uint32 gula_MapInterruptToMask[NUM_INTERRUPTS];

int16 DetectInterrupts(void)
{
    uint32 l_CriStatus0;
   int16 i;

   /****************************************************/
   /* Clear ADSL bit in ARC interrupt status register  */
   /****************************************************/
   //_sr((uint32) ARC_INT_STAT_ADSL_MASK, ARC_INT_STAT_ADDR);
   SetDspReg(ARC_INT_STAT_ADDR, (uint32)ARC_INT_STAT_ADSL_MASK);

   ReadCoreReg(CRI_STATUS0_ADDR, &l_CriStatus0);

   if (l_CriStatus0)
   {
      // detect rx interrupts first
      for (i = 0; i < NUM_INTERRUPTS; i++)
      {
         if (l_CriStatus0 & gula_MapInterruptToMask[i])
         {
            /* clear interrupt */
            WriteCoreReg(CRI_STATUS0_ADDR, gula_MapInterruptToMask[i]);
            return((int16)i);
         }
      }
   }
   return (-1);
}
#endif

#if !defined(HERCULES_ADSL_CPE) && !defined(ADSL_62)
int16 DetectInterrupts(void)
{
   int i;
   uint16 usa_CriAMaskAddr[3] = {CRI_AMASK0_ADDR, CRI_AMASK1_ADDR, CRI_MASK2_ADDR};
   uint16 usa_CriStatusAddr[3] = {CRI_STATUS0_ADDR, CRI_STATUS1_ADDR, CRI_STATUS2_ADDR};
   uint16 usa_CriAMask[3], usa_CriStatus[3];

   /****************************************************/
   /* Clear ADSL bit in ARC interrupt status register  */
   /****************************************************/

   //_sr((uint32) ARC_INT_STAT_ADSL_MASK, ARC_INT_STAT_ADDR);
   SetDspReg(ARC_INT_STAT_ADDR, (uint32)ARC_INT_STAT_ADSL_MASK);

   for (i = 0; i < 3; i++)
   {
      ReadCoreReg(usa_CriAMaskAddr[i], &usa_CriAMask[i]);
      ReadCoreReg(usa_CriStatusAddr[i], &usa_CriStatus[i]);
      usa_CriStatus[i] &= usa_CriAMask[i];
   }

   /* Status2 Enabled -- MAD -- Highest Priority, Terminate */
   if (usa_CriStatus[2])
   {
      gs_CriStatus2 = usa_CriStatus[2];
      ReadCoreReg(CRI_MADST_ADDR, &gs_CriMadSt);
      gus_ExceptionCode = E_CODE_CRI_STATUS2_INTERRUPT;
      Infinite_loop();
   }
   /* detect rx interrupts first */
   else if (usa_CriStatus[0])
   {
      for (i = 0; i < NUM_RX_INTERRUPTS; i++)
//    for (i = 0; i < NUM_INTERRUPTS; i++)
      {
         if (usa_CriStatus[0] & gusa_MapInterruptToMask[i])
         {
            /* clear interrupt */
#ifdef RUN_ASIM
            // A hook to run the exact target binary on the simulator
                if (i==RX_FDQ_DONE) *((int32*)SIMEXT_PTR_gs_rxFrameInt) = 1;
#endif
            WriteCoreReg(usa_CriStatusAddr[0], gusa_MapInterruptToMask[i]);
            return((int16)i);
         }
      }
   }
   /* then detect tx interrupts */
   else if (usa_CriStatus[1])
   {
      for (i = NUM_RX_INTERRUPTS; i < NUM_INTERRUPTS; i++)
//    for (i = 0; i < NUM_INTERRUPTS; i++)
      {
         if (usa_CriStatus[1] & gusa_MapInterruptToMask[i])
         {
            /* clear interrupt */
#ifdef RUN_ASIM
            // A hook to run the exact target binary on the simulator
                if (i==TX_FRAME_START) *((int32*)SIMEXT_PTR_gs_txFrameInt) = 1;
#endif
            WriteCoreReg(usa_CriStatusAddr[1], gusa_MapInterruptToMask[i]);
            return((int16)i);
         }
      }
   }
   return (-1);
}
#endif


/*-------------------------------------------------------------------
*
*  void Pause(int16 s_Marker)
*
*  Description: For debugging purposes.  Stops the DSL cores and allows
*  external debug reads and writes to be performed.
*  If the value of s_Marker is < 0, then Strymon will not be halted.  This allows
*  the Tx output signal to be maintained - a single frame will be transmitted
*  repeatedly.
*-------------------------------------------------------------------
*^^^
*/

#ifdef ADSL_62
void disable1_save(uint32 *pul_stat);
void restore1_save(uint32 ul_stat);
#endif

void Pause(int16 s_Marker)
{
#ifdef ADSL_62
    uint32 ul_IntrStat;
#endif

   if (gft_PauseOff) {
      return;
   }

#ifndef ADSL_62
   // Disable DSL interrupts so that the state machine's MP handler
   // does not interfere with the handler loop in this function.
   DisableADSLInterrupts();

   // Disable Tx Buffer swap.
   DisableTxBufferSwap();

   // Disable Strymon to send any Rx or Tx frame start signals by putting it in Software Trigger Mode.
   // This would stop the hardware.
   // If s_Marker is >= 0 then Strymon is halted, else the Tx frame currently accessed by
   // Strymon will be read from and transmitted repeatedly.
   if (s_Marker >= 0)
   {
#ifndef HERCULES_ADSL_CPE
    //  BRW - TAKE OUT TO BUILD HERC ADSL
   WriteCoreReg32((uint16) SMODE1_ADDR, 0x01);
#endif
   }
#else
    disable1_save(&ul_IntrStat);
#endif

   gs_PauseMarker = s_Marker;
   gft_Resume = 0;
   //XDSLRTFW-2186(Start)
   if (gs_PauseMarker == 1)
    {
        while (gft_Resume == 0){
         gft_Resume = 0;
      }
    }
    else
    {
      while (gft_Resume == 0){
         if (NewMPCheckMessage(VBM_MAILBOX)!= 0)
         {
            NewMPHandleMessage(VBM_MAILBOX);
         }
      }
   }
    //XDSLRTFW-2186(End)
#ifdef ADSL_62
    restore1_save(ul_IntrStat);
#endif
}

