/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2002 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       mp.c
*
*       ADSL Configuration and Management protocol
*
*-------------------------------------------------------------------
*/

#ifndef MP_C
#define MP_C

#define IN_MP_C

///////////////////////////////////////
#ifdef TARGET_SIM

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "typedef.h"
#include "const.h"
#include "cmv.h"
#include "mp.h"
#include "gdata.h"
#include "trail.h"
#include "ghs.h"
#include "rx_eoc.h"
#include "tdq_init.h"
#include "rinfotbl.h"
#include "dec_gain.h"
#include "enc_gain.h"
#include "tone_ord.h"
#include "sach.h" // For Sachmo channel DLL
#include "iri_ini.h"

#include "bert.h"



int16 gs_IridiaUpClockPeriod = 512;


int16 gs_FirstTimeCounter;

int16 gs_TrailFile = 1;
int16 gs_downSampleCnt = 16;


/*****************************************************************************
;  Prototype: int16 MPHandler_STRY(char *setting)
;
;     This function configures the modem in reaction to a STRY(MON BYPASS) MP
;   command.
;
;  Input Arguments:
;
;        char *setting   -- Currently one of ON/OFF
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_STRY(void)
{
   int16 us_stat = (int16)SUCCEED;


      gs_bypass_strymon = 1;
      gs_downSampleCnt = 1;

   return(us_stat);
}

/*****************************************************************************
;  Prototype: int16 MPHandler_BERT(char *setting)
;
;     This function configures the modem in reaction to a BERT MP
;   command.
;
;  Input Arguments:
;
;        char *setting   -- Currently one of ON/OFF
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_BERT(void)
{
   int16 us_stat = (int16)SUCCEED;
   int16 i;
#ifndef DISABLE_BERT
   gs_do_bert = 1;

   for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
   {
      Init_Rx_Bert(&gta_RxBertStat[i] , 0);
      gta_RxBertStat[i].s_num_bytes = (gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].sa_B_alloc[i] +
         gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].sa_B_alloc[i]);
   }
   for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
      Init_Tx_Bert(&gta_TxBertStat[i], 0, 1000);


   return(us_stat);
#endif
}

/*****************************************************************************
;  Prototype: int16 MPHandler_BERT_SF(void)
;
;     This function configures the modem in reaction to a BERT_SF MP
;   command.
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_BERT_SF(void)
{
#ifndef DISABLE_BERT
   int16 us_stat = (int16)SUCCEED;

   gs_bert_sf_cnt = TESTArray[TEST_BertSFCnt];

   return(us_stat);
#endif
}

/*****************************************************************************
;  Prototype: int16 MPHandler_TCM()
;
;     This function configures the modem in reaction to a TCM MP
;   command.
;
;  Input Arguments:
;
;        char *setting   -- Currently one of ON/OFF
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_TCM(void)
{
    int16 i;

      gt_RMsgs1.us_TrellisCoding_Option = TRUE;

#ifndef TARGET_HW
        for(i=0; i<4; i++)
         gt_config_set[i].psa_BAT = (int16*)guca_DS_BAT68_TCM_ON;

        for(i=4; i<12; i++)
         gt_config_set[i].psa_BAT = (int16*)guca_US_BAT23_TCM_ON;

   gt_config_set[12].psa_BAT = (int16*)guca_DS_BAT68_TCM_ON;
   gt_config_set[13].psa_BAT = (int16*)guca_US_BAT23_TCM_ON;
   gt_config_set[14].psa_BAT = (int16*)guca_US_BAT23_TCM_ON;

        gt_config_set[15].psa_BAT = (int16*)guca_DS_BAT68_TCM_ON;
   gt_config_set[16].psa_BAT = (int16*)guca_DS_BAT68_TCM_ON;

        for(i=17; i<21; i++)
      gt_config_set[i].psa_BAT = (int16*)guca_US_BAT23_TCM_ON;
#endif   /* TARGET_HW */

      gft_TcmFlag = TRUE;


    return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: void MPHandler_ModemType()
;
;  selects either G.dmt or G.dmt.bis mode
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
void MPHandler_ModemType(void)
{

   if ( (OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_A) != 0) // Bis bit is set
      gft_ModemType = G_DMT_BIS;
   else
      gft_ModemType = G_DMT;
}




/*****************************************************************************
;  Prototype: int16 MPHandler_IFFT()
;
;  Updates engine layer for any change in IFFT size.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
int16 MPHandler_IFFT(void)
{
   int16 s_temp;

   /* =============================================================================== */
   /* Update Tx FFT length and registers for a chosen IFFT size*/
   /* =============================================================================== */

   /* if ISDN mode selected IFFT size is always 128 */
   if ((OPTNArray[OPTN_AlgControl]&OPTN_IFFT128_Enable) || (OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_1_B))
      gs_TxFftLength = 128;
   else
      gs_TxFftLength = 64;

   gs_TxCPLength = (int16) (gs_TxFftLength>>4);

   /* Compute log2(gs_TxFftLength)-1 = log2(gs_TxFftLength/2) */
   gs_TxLog2FftLength1 = 0;
   s_temp = (gs_TxFftLength >> 1);
   while((s_temp&1) == 0)
   {
      gs_TxLog2FftLength1++;
      s_temp >>= 1;
   }

   /* Update POTS HPF and INTERP1 filter */
   Reconfig_DFE_Tx();

   /* Reconfigure the registers in Iridia to allow IFFT size change */
   Reconfig_IRI_IFFT_Size();

#ifndef TARGET_HW
   if (gs_TxFftLength == 128) {

      gs_IridiaUpClockPeriod = 256;
      gs_FirstTimeCounter = 0;
   }
   else {


      gs_IridiaUpClockPeriod = 512;


      gs_FirstTimeCounter = 4;
   }
   /* Set the default input/output buffer sizes */
   gs_Tx_OutBuf_Size = gs_TxFftLength;
#endif

   return 0;
}

#endif TARGET_SIM
///////////////////////////////////////

#endif
