/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*       Phone (781) 276 - 4000
*       Fax   (781) 276 - 4001
*
*       MP.H
*
*       Messaage Protocol Defines and Prototypes
*
*-------------------------------------------------------------------
*/
#ifndef MP_H
#define MP_H


#include "const.h"
#include "config.h"

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
typedef void  (*PtrToFunc)(void);

/* Variable type definitions */
typedef double float64;          /* prefix d in hungarian notation */
typedef short int16;          /* prefix s  */
typedef long  int32;          /* prefix l */
typedef char  int8;              /* prefix c */
typedef unsigned char uint8;     /* prefix uc */
typedef unsigned long uint32;    /* prefix ul */
typedef unsigned short uint16;      /* prefix us */
typedef unsigned long Float32;      /* prefix f */
typedef unsigned char FlagT;     /* prefix ft */
typedef unsigned short bool;     /* prefix b */
#endif

typedef void (*InitRxADCBufferPtrs_f)(int16 *, int16 *, int16, int16 *, int16 *);
typedef int (*InitiateDLIProcess_f)(char *, int16, int16, FlagT, int16);
typedef int (*DliHandler_f)(int16 *, int16, int16, FlagT *);
typedef void (*ExitRequest_f)(void);
typedef void (*ReleaseEventHandlers_f)(void);

typedef  void (*WriteMPtoModem_f)(int16, int16 );
typedef  int16 (*ReadMPtoModem_f)(int16 );
typedef  void (*WriteModemtoMP_f)(int16, int16 );
typedef  int16 (*ReadModemtoMP_f)(int16 );
typedef  void (*WriteNewMPtoModem_f)(int16, int16 );
typedef  int16 (*ReadNewMPtoModem_f)(int16 );
typedef  void (*WriteModemtoNewMP_f)(int16, int16 );
typedef  int16 (*ReadModemtoNewMP_f)(int16 );
typedef int16 (*SelectNewMPPort_f)(int16);

/*****               *****/
/*****               *****/
/*****      constant definitions *****/
/*****               *****/
/*****               *****/

#ifndef IN_ASM

/*****               *****/
/*****               *****/
/*****      typedef enum declarations  *****/
/*****               *****/
/*****               *****/


/*****               *****/
/*****               *****/
/*****      function prototypes  *****/
/*****               *****/
/*****               *****/
void  MPHandler_InitialState(void);
int16 MPHandler_BERT(void);
int16 MPHandler_BERT_SF(void);
//int16 MPHandler_MULTIMODE(void);
int16 MPHandler_STRY(void);
int16 MPHandler_IFFT(void);
int16 MPHandler_TCM(void);
int16 MPHandler_IFFT(void);
void MPHandler_ModemType(void);






/*==========================================================*/
/*  Functions                                   */
/*==========================================================*/
char * SetInputDir(char * input_string);
int16 AttachDLL(void);
void ReleaseDLL(void);
int16 AttachMPDLL(void);
void ReleaseMPDLL(void);

int16 ConfigTaskLayerForInitialState(void);

/*==========================================================*/
/*  Variables                                   */
/*==========================================================*/

extern int16 gs_bypass_strymon;
extern int16 gs_IridiaUpClockPeriod;
extern int16 gs_FirstTimeCounter;
extern int16 gs_downSampleCnt;

extern FlagT gft_OpenFiles;

extern int16 gs_AtoD_GetPtr;                    /* ADC buffer get pointer */
extern int16 gs_AtoD_PutPtr;                    /* ADC buffer put pointer */
extern int16 gsa_RxAtoDBuf[RX_ADCBUF_SIZE];           /*  input ADC byffer */

extern InitiateDLIProcess_f InitiateDLIProcess;
extern InitRxADCBufferPtrs_f InitRxADCBufferPtrs;
extern DliHandler_f DliHandler;
extern ExitRequest_f ExitRequest;
extern ReleaseEventHandlers_f ReleaseEventHandlers;

extern WriteMPtoModem_f WriteMPtoModem;
extern ReadMPtoModem_f ReadMPtoModem;
extern WriteModemtoMP_f WriteModemtoMP;
extern ReadModemtoMP_f ReadModemtoMP;
extern WriteNewMPtoModem_f WriteNewMPtoModem;
extern ReadNewMPtoModem_f ReadNewMPtoModem;
extern WriteModemtoNewMP_f WriteModemtoNewMP;
extern ReadModemtoNewMP_f ReadModemtoNewMP;
extern SelectNewMPPort_f SelectNewMPPort;

/* assume both File and WINHOST MP control are available.   */
/* clear these variables if control is not found.        */

extern void InitAtoDBufPointers(void);


// common to both BIS and DMT
typedef struct {
   int16 s_MaxAllowedTxMsgLength;   // Max allowed Tx HDLC message length in bytes. Read only by ME
   int16 s_MaxAllowedRxMsgLength;   // Max allowed Rx HDLC message length in bytes. Read only by ME
   int16 s_ME_HdlcTxMsgLength;      // Size in bytes of the command msg waiting to be sent in the
                           // ME_HDLC Tx Buffer. Written by ME for each msg sent
   int16 s_ME_HdlcRxMsgLength;      // Size in bytes of the received response msg in the
                           // ME_HDLC Rx Buffer. Written by ATU-R for each response received
   int16 s_DmtTxCeocSpacing;        // If set to N, then consecutive Tx Clear EOC messages (each 2 bytes)
                           // will be separated by N non-ClearEOC messages.
                           // Clear EOC message, assuming
} ME_HDLC_Params_t;

#ifndef IN_MP_C

/*****               *****/
/*****               *****/
/*****  external variable declarations *****/
/*****               *****/
/*****               *****/

extern void  MPHandler_InitialState(void);
extern int16 MPHandler_BERT(void);
extern int16 MPHandler_BERT_SF(void);
//extern int16 MPHandler_MULTIMODE(void);
extern int16 MPHandler_STRY(void);
extern int16 MPHandler_IFFT(void);
extern int16 MPHandler_TCM(void);
extern int16 MPHandler_IFFT(void);
extern void MPHandler_ModemType(void);



#endif

#endif

extern char Tx_Infile_Name[80];
extern char Tx_Outfile_Name[80];
extern char Rx_Infile_Name[80];
extern char Rx_Outfile_Name[80];
extern char Taps_Infile_Name[80];

#endif
