/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2002 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       mp_c.c
*
*       ADSL Configuration and Management protocol
*
*-------------------------------------------------------------------
*/

#ifndef MP_C
#define MP_C

#define IN_MP_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "typedef.h"
#include "const.h"
#include "cmv.h"
#include "cmv_data.h"
#include "mp.h"
#include "gdata.h"
#include "trail.h"
#include "ghs.h"
#include "rx_eoc.h"
#include "pll.h"
#include "showinit.h"
#include "bitload.h"
#include "cnfgshwt.h"
#include "tdq_init.h"
#include "load_prf.h"
#include "ec_data.h"
#include "rinfotbl.h"
#include "dec_gain.h"
#include "enc_gain.h"
#include "tone_ord.h"
#include "file_io3.h"
#include "sach.h" // For Sachmo channel DLL
#include "simext_sharedVars.h"



#define R_PILOT_TONE 16


// Local functions
int16 Initialize_DLI_Connectivity(void);
int16 Initialize_Sachmo_Connectivity(void);

/* Link DLI connectivity functions  */

InitiateDLIProcess_f    InitiateDLIProcess;
InitRxADCBufferPtrs_f   InitRxADCBufferPtrs;
DliHandler_f            DliHandler;
ExitRequest_f           ExitRequest;
ReleaseEventHandlers_f  ReleaseEventHandlers;

/* MP connectivity functions  */

WriteMPtoModem_f     WriteMPtoModem;
ReadMPtoModem_f         ReadMPtoModem;
WriteModemtoMP_f     WriteModemtoMP;
ReadModemtoMP_f         ReadModemtoMP;
WriteNewMPtoModem_f     WriteNewMPtoModem;
ReadNewMPtoModem_f      ReadNewMPtoModem;
WriteModemtoNewMP_f     WriteModemtoNewMP;
ReadModemtoNewMP_f      ReadModemtoNewMP;
SelectNewMPPort_f    SelectNewMPPort;

/*******************************************************************
*
*       Define Variables
*
*******************************************************************/


/* flags set based on file availability.  initialzed to available state.   */

int16 gs_TxInputFile = 1;
int16 gs_TxOutputFile = 1;
int16 gs_TxConfigFile = 1;
int16 gs_RxInputFile = 1;
int16 gs_RxOutputFile = 1;
int16 gs_RxConfigFile = 1;
int16 gs_TrailFile = 1;

FILE *Mp_infid = NULL;
FILE *Taps_infid=NULL;

char Tx_Infile_Name[80];
char Tx_Outfile_Name[80];
char Rx_Infile_Name[80];
char Rx_Outfile_Name[80];
char Taps_Infile_Name[80];
char input_dir[80]="";

/* assume both File and WINHOST MP control are available.   */
/* clear these variables if control is not found.        */

int16 gs_MpFileControl = 1;

int16 gs_DLI_TxFftLength;

// hp mod 1-31
#ifdef MSVC_ONLY
HINSTANCE Dll, MPDll;
#endif


/*****************************************************************************
;  Prototype: int16 ConfigureTestFiles(void)
;
;  This subroutine processes the command line arguments of C program.
;
;  Input Arguments:
;     argc  -- number of command line arguments
;     argv[]  -- actual command line arguments
;
;  Output Arguments:
;
;  Return:
;     SUCCEED -- input argument valid
;     FAIL  -- one or more input argument is invalid
;
;  Global Variables:
;     gus_tx_config_num -- (O) TX configuration number
;     gus_rx_config_num -- (O) RX configuration number
;     gs_InitialState      -- (o) ID to represent initial state to start with
;
;****************************************************************************/

int16 ConfigureTestFiles(void)
{
   FILE *fp;
   int argc=0;
   char argv[10][80];

   // Open test configuration file
   fp = fopen("../../soc_bld/modem/test_cfg.txt", "r");

   if(fp==NULL)
   {
      fprintf(stderr,"Can't open test configuration file !!!");
      return((int16)FAIL);
   }

   // read input and output file names from the test configuration file
   while(fscanf(fp, "%s", argv[argc++]) != EOF);
   argc--;

   //==========================================================================
   // Initialize TEST register
   //==========================================================================
   if (gft_TestControl == WINHOST_CONTROL)
   {
      if (AttachDLL() == SUCCEED)
      {
         fprintf(stderr, "Assuming connectivity or Winhost control --- \n ");

         /* clear variables to indicate that files are not available */

         gs_TxInputFile = 0;
         gs_TxOutputFile = 0;
         gs_TxConfigFile = 0;
         gs_RxInputFile = 0;
         gs_RxOutputFile = 0;
         gs_RxConfigFile = 0;
      }

      return((int16)SUCCEED);
   }

   /* ================================================================= */
   /* if arguments are passed, then process them                     */
   /* ================================================================= */

   if (argc > 0)
   {
      strcpy(input_dir, argv[0]);
      strcpy(Tx_Infile_Name, argv[1]);
      strcpy(Tx_Outfile_Name, argv[2]);
      strcpy(Rx_Infile_Name, argv[3]);
      strcpy(Rx_Outfile_Name, argv[4]);
   }

   if (argc < 6)
   {
      fprintf(stderr, "test_cfg.txt format:\n");
      fprintf(stderr, "input_dir TxInfile TxOutFile RxInFile ");
      fprintf(stderr, "RxOutFile MpFile [TX_Config_Num RX_Config_Num]\n");
      return((int16)FAIL);
   }

   /*  if extra command line arg(s) is present, get config number (defaults to 0) */
   if (argc >= 7)
    {
      TESTArray[TEST_TxConfigNum] = (int16) atoi(argv[6]);
      if (TESTArray[TEST_TxConfigNum] >= NUM_CONFIG_SETS)
        {
         fprintf(stderr, "TX configuration number is too high\n");
         return((int16)FAIL);
      }
   }

   if (argc >= 8)
    {
      TESTArray[TEST_RxConfigNum] = (int16) atoi(argv[7]);
      if (TESTArray[TEST_RxConfigNum] >= NUM_CONFIG_SETS)
        {
         fprintf(stderr, "RX configuration number is too high\n");
         return((int16)FAIL);
      }
   }

   if (argc == 9)
      strcpy(Taps_Infile_Name, argv[8]);
   else
      strcpy(Taps_Infile_Name, "");

   // Close test configuration file
   fclose(fp);

   OpenFiles();

   return((int16)SUCCEED);

}

/*****************************************************************************
;  Prototype: char * SetInputDir(char * input_string)
;
;     If this function finds an INPUTDIR environment variable,
;     it will return a combination of the INPUTDIR and the
;     input_string.  Otherwise, this function will return an
;     unchanged input_string.
;
;  Input Arguments:
;
;     char * input_string - usually an input filename
;
;  Output Arguments:
;
;     char * - always expected to be a valid char *
;
;  Return:
;
;     Will return either the original character pointer, or a
;     newly formed one.  This function is never expected to
;     return NULL.
;
;  Global Variables:
;
;  Environment Variables:
;
;     INPUTDIR - as input
;
;****************************************************************************/
char * SetInputDir(char * input_string)
{

//    char * input_dir;
    char * file_path;
    unsigned int len_input_dir = 0;

// hp mod 2-13
//    input_dir = getenv ("INPUTDIR");

    if( input_dir != NULL ) {
        /* Strip any spaces off the end of input_dir */
        len_input_dir = strlen(input_dir);
      while ((len_input_dir > 0) &&
         (input_dir[len_input_dir-1] == ' ')) {
             input_dir[(len_input_dir--)-1] = '\0';
      }

        if (len_input_dir > 0) {
            /* Allocate enough space for both strings, a slash, and a null char */
            file_path = (char *) malloc (len_input_dir + strlen (input_string) + 2);
            strcpy(file_path, input_dir);
            /* Add a slash between, if needed */
            if ((input_dir[len_input_dir-1] != '\\') &&
                (input_dir[len_input_dir-1] != '/'))
                strcat(file_path, "/");
            strcat(file_path, input_string);
            return(file_path);
        }
    }

    /* Return input_string if there is no input directory */
    /* environment variable or if it is empty.            */
    return (input_string);
}

/*****************************************************************************
;  Prototype: int16 AttachDLL()
;
;     This function load the DLL library and initiate function pointers to
;   the functions defined in the DLL library:
;     InitiateDLIProcess()
;     InitRxADCBufferPtrs()
;     DliHandler()
;     ExitRequest()
;     ReleaseEventHandlers();
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;  Return:
;       SUCCEED/FAIL
;
;  Global Variables:
;
;****************************************************************************/


int16 AttachDLL()
{
    char DllName[MAX_PATH];


   strcpy(DllName, "dli.dll");
    Dll = LoadLibrary(DllName);

   if( !Dll )
    {
        FreeLibrary(Dll);
        fprintf(stderr,"LoadLibrary %s failed\n",DllName);
        return FAIL;
    }
    else
    {
        InitiateDLIProcess = (InitiateDLIProcess_f)GetProcAddress(Dll, "InitiateDLIProcess");
        if (!InitiateDLIProcess)
        {
            FreeLibrary(Dll);
            fprintf(stderr,"GetProcAddress() failed for InitiateDLIProcess\n");
            return FAIL;
        }

        InitRxADCBufferPtrs = (InitRxADCBufferPtrs_f)GetProcAddress(Dll, "InitRxADCBufferPtrs");
        if (!InitRxADCBufferPtrs)
        {
            FreeLibrary(Dll);
            fprintf(stderr,"GetProcAddress() failed for InitRxADCBufferPtrs\n");
            return FAIL;
        }

        DliHandler = (DliHandler_f)GetProcAddress(Dll, "DliHandler");
        if (!DliHandler)
        {
            FreeLibrary(Dll);
            fprintf(stderr,"GetProcAddress() failed for DliHandler\n");
            return FAIL;
        }

        ExitRequest = (ExitRequest_f)GetProcAddress(Dll, "ExitRequest");
        if (!ExitRequest)
        {
            FreeLibrary(Dll);
            fprintf(stderr,"GetProcAddress() failed for ExitRequest\n");
            return FAIL;
        }

        ReleaseEventHandlers = (ReleaseEventHandlers_f)GetProcAddress(Dll, "ReleaseEventHandlers");
        if (!ReleaseEventHandlers)
        {
            FreeLibrary(Dll);
            fprintf(stderr,"GetProcAddress() failed for ReleaseEventHandlers\n");
            return FAIL;
        }

    }

    return SUCCEED;
}

/*****************************************************************************
;
;  Prototype: void ReleaseDLL(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

void ReleaseDLL(void)
{
    FreeLibrary(Dll);
}

/*******************************************************************************
*
*  Prototype: int16 AttachMPDLL(void)
*
*  This function loads the MP-DLI library and initiates function pointers to
*   the functions defined in old & New MP connectivity.
*
*  WriteMPtoModem()     WriteNewMPtoModem()        SelectNewMPPort()
*  ReadMPtoModem()         ReadNewMPtoModem()
*  WriteModemtoMP()     WriteModemtoNewMP()
*  ReadModemtoMP()         ReadModemtoNewMP()
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*     SUCCEED/FAIL
*
*  Global Variables:
*
*******************************************************************************/

int16 AttachMPDLL(void)
{
   char DllName[MAX_PATH];

   // Load libraray. Look for 3 locations


   strcpy(DllName, "mpdli.dll");
   MPDll = LoadLibrary(DllName);

   if (!MPDll) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: LoadLibrary %s failed.\n",DllName);
      return (int16)FAIL;
   }

   // Old MP functions

   WriteMPtoModem = (WriteMPtoModem_f)GetProcAddress(MPDll,"WriteMPtoModem");
   if (!WriteMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteMPtoModem.\n");
      return (int16)FAIL;
   }
   ReadMPtoModem = (ReadMPtoModem_f)GetProcAddress(MPDll,"ReadMPtoModem");
   if (!ReadMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadMPtoModem.\n");
      return (int16)FAIL;
   }
   WriteModemtoMP = (WriteModemtoMP_f)GetProcAddress(MPDll,"WriteModemtoMP");
   if (!WriteModemtoMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteModemtoMP.\n");
      return (int16)FAIL;
   }
   ReadModemtoMP = (ReadModemtoMP_f)GetProcAddress(MPDll,"ReadModemtoMP");
   if (!ReadModemtoMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadModemtoMP.\n");
      return (int16)FAIL;
   }

   // New MP functions

   WriteNewMPtoModem = (WriteNewMPtoModem_f)GetProcAddress(MPDll,"WriteNewMPtoModem");
   if (!WriteNewMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteNewMPtoModem.\n");
      return (int16)FAIL;
   }
   ReadNewMPtoModem = (ReadNewMPtoModem_f)GetProcAddress(MPDll,"ReadNewMPtoModem");
   if (!ReadNewMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadNewMPtoModem.\n");
      return (int16)FAIL;
   }
   WriteModemtoNewMP = (WriteModemtoNewMP_f)GetProcAddress(MPDll,"WriteModemtoNewMP");
   if (!WriteModemtoNewMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteModemtoNewMP.\n");
      return (int16)FAIL;
   }
   ReadModemtoNewMP = (ReadModemtoNewMP_f)GetProcAddress(MPDll,"ReadModemtoNewMP");
   if (!ReadModemtoNewMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadModemtoNewMP.\n");
      return (int16)FAIL;
   }
   SelectNewMPPort = (SelectNewMPPort_f)GetProcAddress(MPDll,"SelectNewMPPort");
   if (!SelectNewMPPort) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAffress() failed for SelectNewMPPort.\n");
      return (int16)FAIL;
   }

   return (int16)SUCCEED;
}

/*****************************************************************************
;
;  Prototype: void ReleaseMPDLL(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

void ReleaseMPDLL(void)
{
    FreeLibrary(MPDll);
}

//////////////
/*****************************************************************************
;  Prototype: int16 MPHandler_CONN()
;
;     This function configures the modem in reaction to a CONN(ECTIVITY) MP
;   command.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_CONN(void)
{
   int16 s_retcode;

   if (((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
      s_retcode = Initialize_DLI_Connectivity();
#if 0 // LK mod: 3/28/02, no Sachmo connectivity yet
   else
      s_retcode = Initialize_Sachmo_Connectivity();
#endif //#if 0 // LK mod: 3/28/02, no Sachmo connectivity yet

   return(s_retcode);
}

/*****************************************************************************
;  Prototype: int16 Initialize_DLI_Connectivity()
;
;     This function performs initialization for DLI-based connectivity.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
int16 Initialize_DLI_Connectivity(void)
{
   int16 s_scale;

   if(AttachDLL() == FAIL)
      exit(-1);

   /*==============================================================*/
   /* Synchronize CO and CPE threads and open shared memory        */
   /*==============================================================*/

   fprintf(stderr, "----- CPE Modem Starts -------\n");


   /* Init AtoD buffer pointers */
   InitAtoDBufPointers();

   /* ====================================================== */
   /* (In order to perform EC properly, we always read in    */
   /*  gs_Tx_OutBuf_Size/gs_DECUpsamplingFactor RX samples   */
   /* =======================================================*/
   gs_AtoDBuf_Size = (int16)(gs_Tx_OutBuf_Size*gs_TxFftLength/gs_RxFftLength);

   /* Set DLI Tx FFT length */
   if (OPTNArray[OPTN_LinkControl] & OPTN_ISDNMode)
      gs_DLI_TxFftLength = 128;
   else

      gs_DLI_TxFftLength = 64;


   InitRxADCBufferPtrs(&gs_AtoD_GetPtr, &gs_AtoD_PutPtr, RX_ADCBUF_SIZE,
      gsa_RxAtoDBuf, &gs_AtoDBuf_Size);

   if (TESTArray[TEST_Control] & TEST_UpsampleControl)
      s_scale = 1;
   else
      s_scale = 0;


   if(!InitiateDLIProcess("CPE", gs_DLI_TxFftLength, (int16) (gs_RxFftLength >> s_scale),
      (FlagT)(TESTArray[TEST_InitState] == TEST_ShowtimeInitState),
      gs_TxOutSymbolCount))
   {
      return((int16) FAIL);
   }


   return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: int16 Initialize_Sachmo_Connectivity()
;
;     This function performs initialization for Sachmo-based connectivity.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
#if 0 // LK mod: 3/28/02, no Sachmo connectivity yet
int16 Initialize_Sachmo_Connectivity(void)
{
   int16 s_retcode;
   uint8 uc_ModemType, *puca_ModemName, uc_ChannelState;

   uc_ModemType = SAC_TYPE_RT;
   puca_ModemName = "RT";


   s_retcode = (int16) SACHMO_RegisterWithChannel(uc_ModemType);
   if (s_retcode != SAC_RETCODE_SUCCESS){
      fprintf(stderr,"\nError registering %s with Sachmo Channel\n", puca_ModemName);
      return((int16) FAIL);
   }

   fprintf(stderr,"\n --- %s Registered Successfully with Sachmo Channel ---\n", puca_ModemName);

   SACHMO_Ready();

   fprintf(stderr,"\n --- Waiting for channel to be ready ---\n");

   uc_ChannelState=SAC_CHANSTATE_NOTREADY;
    while ((uc_ChannelState!=SAC_CHANSTATE_READY))
                  s_retcode = SACHMO_GetChannelState(&uc_ChannelState);

   fprintf(stderr, "--- Channel is ready.  Both modems are ready. ---\n\n");


   return((int16) SUCCEED);
}

#endif
#endif //#if 0 // LK mod: 3/28/02, no Sachmo connectivity yet

/*^^^
*-------------------------------------------------------------------
*
*  void ExitChannel(void)
*
*  Description:
*
*     This function shuts down the connectivity channel.
*
*-------------------------------------------------------------------
*^^^
*/
void ExitChannel(void)
{
   if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
   {
      // DLI-based connectivity
      ExitRequest();
      ReleaseEventHandlers();
      ReleaseDLL();
   }
#if 0 // LK mod: 3/28/02, no Sachmo connectivity yet
   else {
      // Sachmo-based connectivity
      SACHMO_TerminateChannel();
   }
#endif //#if 0 // LK mod: 3/28/02, no Sachmo connectivity yet
}

/////////////////////
