/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   mtkernel.c
*
*   Routines to implement multi-tasking kernel.
*-------------------------------------------------------------------------
*/


#include <stdio.h>
#include "typedef.h"
#include "xception.h"
#include "mtkernel.h"
#include "gdata.h"
#include "interrupt.h"
#include "profdbg.h"
#include "socrates_memrymap.h"
#define TARGET

#define WhichThreadIsTask(task) ((((task)->TaskID)>>12)&0x7)
uint8           guc_PortActive;
int16           FGActive=0;
int16           FirstTimeKernel=1;

/* Define stack pointer & stacks with corresponding stack pointers array */

int16 KernelFault;
int16 SchedulerFault;
int16 Thread = 0;
Queue_t TaskQueue[NUM_THREADS];

void TxForeGround(void);
void RxForeGround(void);
void CheckStackOverflow(int16 us_ErrorCode);
/*****************************************************************************
;  Prototype: void AddTaskToQueue(TCB_t *NewTask,Queue_t *Q);
;              void DeleteTaskFromQueue(Queue_t *Q);
;
;  These subroutines add or delete tasks to or from task queue Q.
;
;  Input Arguments:
;       TCB_t *NewTask          - pointer to TCB to be added to queue.
;       Queue_t *Q              - pointer to queue to or from which a task
;                                 is to be added or deleted.
;  Output Arguments: none.
;
;  Return: none.
;
;  Comments:
;   An empty queue is characterized by having both the Front and the
;   Rear pointers pointing to NULL:
;
;                 Front -> NULL
;                  Rear -> NULL
;
;   An one-element queue has both the Front and Rear point to the SAME TCB,
;   and that TCB in turns point to NULL:
;
;                 Front -> [1] -> NULL
;                           ^
;                           |
;                         Rear
;
;   An M-element queue has both the Front pointing to the 1st element and the
;   Rear pointing to the M-th element:
;
;                   [1] -> .... -> [M] -> NULL
;                    ^              ^
;                    |              |
;                  Front          Rear
;
;   Each time an element is added to the rear of the queue, the Rear marker
;   moves. Each time an element is deleted from the front of the queue, the
;   Front marker moves.
;   Special care needs to be taken when going from empty queue to 1 element
;   queue and vice versa.
;
;****************************************************************************/
static void AddTaskToQueue(TCB_t *NewTask,Queue_t *Q) {

    /* See if new task is already in queue. */
   if (NewTask->TaskID & 0x8000) {
      KernelException(QUEUE_ADD_EXCEPTION);
      return;
   }

   /* Add new task to rear of queue: */
   if (Q->Front == NULL) { /* empty queue */
      Q->Front = NewTask;
      Q->Rear  = NewTask;
      NewTask->Next = NULL;
   } else { /* non-empty queue */
      Q->Rear->Next = NewTask;
      NewTask->Next  = NULL;
      Q->Rear = NewTask;
   }

   /* Set MSB TaskID bit to indicate TCB is now added to the queue. */
   NewTask->TaskID |= 0x8000;
}


static void DeleteTaskFromQueue(Queue_t *Q) {
    /* See if queue is empty. */
   if (Q->Front == NULL) {
      KernelException(QUEUE_DELETE_EXCEPTION);
      return;
   }

    /* Clear MSB TaskID bit to indicate TCB is now deleted from the queue. */
   Q->Front->TaskID &= ~0x8000;

   /* Delete old task from front of queue: */
   Q->Front = Q->Front->Next;

   /* If there are none left, then set Rear to NULL */
   if (Q->Front==NULL)
      Q->Rear=NULL;
}

#ifndef ADSL_62
/*****************************************************************************
;  Prototype: void MasterIntHandler(void);
;
;  This interrupt service routine identifies the interrupt source,
;   optionally executes a (relatively quick) time-critical function and
;   optionally puts a non-time-critical function/task into the task queue
;   for delayed processing. During the master interrupt handler,
;   interrupts are disabled.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;  Global Variables:
;     FGActive             - (I) Flag indicating whether there is a
;                                     foreground process currently running.
;
;****************************************************************************/
int16 gs_FgNestedCount;
void MasterIntHandler(void)
{
   TCB_t *NewTask;
   Queue_t  *Q;
   int16 s_interrupt;
   int16 s_error;

   while ((s_interrupt = DetectInterrupts()) != -1)
   {
      NewTask = &gt_TaskArray[s_interrupt];

      if (NewTask->TimeCriticalTask != NULL)
      {
      gt_TaskFuncPtr.pf_TCTask = (*(NewTask->TimeCriticalTask));

      if (FGActive)
         s_error = E_CODE_STACK_OVERFLOW_IN_NTC;
      else if (gt_TaskFuncPtr.pf_BgTask)
         s_error = E_CODE_STACK_OVERFLOW_IN_BG;
      else
         s_error = 0;

      CheckStackOverflow(s_error);

      /* run time critical task here */
PROFDBG_DO_TIME_CRITICAL_BEGIN
         //(*(NewTask->TimeCriticalTask)) ();
         gt_TaskFuncPtr.pf_TCTask();
PROFDBG_DO_TIME_CRITICAL_END

      CheckStackOverflow(E_CODE_STACK_OVERFLOW_IN_TC);
      }

      /* If there is a non time critical task, run it here */
      if (NewTask->NonTimeCriticalTask != NULL)
         AddTaskToQueue(NewTask,&TaskQueue[WhichThreadIsTask(NewTask)]);
   }

/* If we are in the background when interrupted, exectute the foreground,
otherwise ireturn will return to current foreground */
   if (FGActive == 0)
   {
      FGActive = 1;
      for(Q = &TaskQueue[Thread];Q->Front;DeleteTaskFromQueue(Q)) {
         gt_TaskFuncPtr.pf_NTCTask = (*(Q->Front->NonTimeCriticalTask));

         _enable1();    // allow foreground tasks to be interrupted
         gt_TaskFuncPtr.pf_NTCTask();
         _disable1();

         CheckStackOverflow(E_CODE_STACK_OVERFLOW_IN_NTC);

      }
      FGActive = 0;
   }
   else{
      gs_FgNestedCount++;
   }
}
#endif



/*****************************************************************************
;  Prototype: void CheckStackOverflow(int16 us_ErrorCode)
;
;  This function check the memory content close to the top of stack to detect
;   possible overflow problem.
;
;  Input Arguments: int16 us_ErrorCode
;
;  Output Arguments: none.
;
;  Return: none.
;
;  Global Variables:
;           gus_ExceptionState   -- Exception state
;           gus_ExceptionCode   -- Exception code
;           gs_RxState          -- Current Rx state
;
;****************************************************************************/
void CheckStackOverflow(int16 us_ErrorCode)
{
   //This function can be extended as a general debug function to check whether some memory
   //location has been overwrittened with some unexpected value.
   if ((*gl_StackMem) != 0xdeadbeef)
      KernelException(us_ErrorCode);

}
