/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;    Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;    Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;    File Name: hercules_memrymap.h
;
;    Header file for simext cocomo interface.
;   Note that all addresses are byte addresses!!!
;
*****************************************************************************/
// *****************************************************************************
// hmp.h
//
// History
//
// 21/06/2010 Bhadra : Added new CMV group "DSL".
//                   Grep for  Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//               Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 17/09/2012 Ram: Added code to support the foll CMVs
//                 "CNFG 80" -> Enable/Disable ReTx mode during G.HS
//                 "INFO 229" -> ReTx DS Showtime Status: ReTx On/OFF
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229"
//
// 07/01/2013 Ram: Added fix for JIRA 459. Implementing 'CMV CNTR 51'
//                Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
//
// 27/5/2013 Vinjam: Added CMV remap for INFO 221 using Hercules CMV dictionary entry
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// *****************************************************************************


#ifndef _HERCULES_MP_H
#define _HERCULES_MP_H

#define HMP_VERSION                       0x1

#define HMP_HEADER_SIZE                   (4)        /* hercules MP header */
#define HMP_DESC_SIZE                     (4)        /* each descriptor is 4 32-bit words */
#define NUM_OF_HMP_DESC                   (1)

#define HMP_MBOX_HEADER_SIZE              (6)      // 16-bit words
#define HMP_MBOX_PAYLOAD_SIZE             (128)      // 16-bit words
#define HMP_MAX_FASTREAD_REQUEST          (HMP_MBOX_PAYLOAD_SIZE/3)
#define HMP_MBOX_SIZE                     (HMP_MBOX_HEADER_SIZE + HMP_MBOX_PAYLOAD_SIZE)

// mailbox code literals
#define QUERY_N_RESPONSE                  (0x00)
#define AUTONOMOUS_MSG_NOTIFICATION       (0x01)
#define AUTONOMOUS_MSG_EVENT              (0x02)
#define AUTONOMOUS_MSG_ALARM              (0x04)
#define AUTONOMOUS_MSG_DEBUG              (0x08)
#define CODE_SWAP_REQUEST                 (0x10)
#define FAST_READ_REQUEST                 (0x20)

// autonomous message queue
#define AUTO_MSG_QUEUE_LENGTH                 8

#define AUTO_MSG_QUEUE_OPERATION_SUCCESS      1
#define AUTO_MSG_QUEUE_FULL                   2
#define AUTO_MSG_QUEUE_EMPTY                  3

// HMP msg header related
#define HMP_WORD0_BITSIZE_SHIFT               14
#define HMP_WORD0_BITSIZE_MASK_AFTER_SHIFT    0x0003
#define HMP_WORD0_BITSIZE_MASK_B4_SHIFT       0xC000

#define HMP_WORD0_OPCODE_SHIFT                4
#define HMP_WORD0_OPCODE_MASK_AFTER_SHIFT     0x00FF
#define HMP_WORD0_OPCODE_MASK_B4_SHIFT        0x0FF0

#define HMP_WORD1_SIZE_MASK                   0x03FF
#define HMP_WORD1_INDEX_SHIFT                 13

#define HMP_WORD2_GROUP_MASK                  0x003F

#define HMP_WORD2_ADDRESS_SHIFT               8
#define HMP_WORD2_ADDRESS_MASK_B4_SHIFT       0xFF00
#define HMP_WORD2_ADDRESS_MASK_AFTER_SHIFT    0x00FF

#define HMP_WORD4_LENGTH_MASK                 0x03FF


// Allowed values for datatype/"bitsize" field of MP word 0.
#define HMP_RW_BYTE_DATA         0x0      // Read/write bytes.
#define HMP_RW_WORD_DATA         0x1      // Read/write 16-bit words.
#define HMP_RW_DWORD_DATA        0x2      // Read/write 32-bit doublewords.

// some predefined Message header contents
#define MODEM_READY_HEADER_0      ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define MODEM_READY_HEADER_1      1
#define MODEM_READY_HEADER_2      ((0xFF << 8)|STATGroup)
#define MODEM_READY_HEADER_3      0
#define MODEM_READY_HEADER_4      1

// modem stat auto msg
#define AUTO_MSG_CR_HEADER_0      ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_CR_HEADER_3      0

// XDSLRTFW-3548 (Start)
#define AUTO_MSG_STAT0_HEADER_1   STAT_0_SIZE /* size of CMV */
#define AUTO_MSG_STAT0_HEADER_2   (STATGroup)
#define AUTO_MSG_STAT0_HEADER_4   STAT_0_SIZE /* length = size of CMV */
// XDSLRTFW-3548 (End)

#define AUTO_MSG_STAT5_HEADER_1   1      /* size of CMV */
#define AUTO_MSG_STAT5_HEADER_2   ((5 << 8)|STATGroup)
#define AUTO_MSG_STAT5_HEADER_4   1      /* length = size of CMV */

// modem plam auto msg
#define AUTO_MSG_PLAM0_HEADER_1   1      /* size of CMV */
#define AUTO_MSG_PLAM0_HEADER_2   (PLAMGroup)
#define AUTO_MSG_PLAM0_HEADER_4   1      /* length = size of CMV */

#define AUTO_MSG_PLAM1_HEADER_1   1      /* size of CMV */
#define AUTO_MSG_PLAM1_HEADER_2   ((1 << 8) | PLAMGroup)
#define AUTO_MSG_PLAM1_HEADER_4   1      /* length = size of CMV */

// TC swotch over
#define AUTO_MSG_DSL14_HEADER1    (sizeof(gus_Required_TC_Info)/sizeof(uint16))
#define AUTO_MSG_DSL14_HEADER2    ((14 << 8) | DSLGroup)
#define AUTO_MSG_DSL14_HEADER4    (sizeof(gus_Required_TC_Info)/sizeof(uint16))

#ifdef DEBUG_STREAMING
// Autonomous indication for overflow of Debug Stream Queue
#define AUTO_MSG_INF117_HEADER_0    ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_INF117_HEADER_1    4    // size of CMV
#define AUTO_MSG_INF117_HEADER_2    ((INFO_EVT_DBG_BUFFER_OVERFLOW << 8) | iNFOGroup)
#define AUTO_MSG_INF117_HEADER_3    0
#define AUTO_MSG_INF117_HEADER_4    4

// Autonomous Message containing Debug Stream content
#define AUTO_MSG_INF118_HEADER_0    ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_INF118_HEADER_2    ((INFO_EVT_DBG_DEBUG_STREAM << 8) | iNFOGroup)
#define AUTO_MSG_INF118_HEADER_3    0
#endif

// codeswap header words
#define CODESWAP_MSG_WORD_0       (HMP_RW_WORD_DATA << 14)
#define CODESWAP_MSG_WORD_1       (1)      //  payload size
#define CODESWAP_MSG_WORD_2       0
#define CODESWAP_MSG_WORD_3       0
#define CODESWAP_MSG_WORD_4       1      // num of page

//==============================================================================
// Function OP code definition
//==============================================================================

// Host-to-DSP messages (CMV mode)
#define H2D_CMV_READ                              0x00 /* 0000 0000b */
#define H2D_CMV_WRITE                             0x04 /* 0000 0100b */
#define H2D_CMV_INDICATE_REPLY                    0x10 /* 0001 0000b */

#define H2D_ERROR_OPCODE_UNKNOWN                  0x20 /* 0010 0000b */
#define H2D_ERROR_CMV_UNKNOWN                     0x30 /* 0011 0000b */

// DSP-to-Host messages (CMV mode)
#define D2H_CMV_READ_REPLY                        0x01 /* 0000 0001b */
#define D2H_CMV_WRITE_REPLY                       0x05 /* 0000 0101b */
#define D2H_CMV_INDICATE                          0x11 /* 0001 0001b */

#define D2H_ERROR_OPCODE_UNKNOWN                  0x21 /* 0010 0001b */
#define D2H_ERROR_CMV_UNKNOWN                     0x31 /* 0011 0001b */
#define D2H_ERROR_CMV_READ_NOT_AVAILABLE          0x41 /* 0100 0001b */
#define D2H_ERROR_CMV_WRITE_ONLY                  0x51 /* 0101 0001b */
#define D2H_ERROR_CMV_READ_ONLY                   0x61 /* 0110 0001b */
#define D2H_ERROR_CMV_UNINITIALIZED_ENTRY         0x71 /* 0111 0001b */
#define D2H_ERROR_ILLEGAL_PAYLOAD_SIZE            0x81
#define D2H_ERROR_OPERATION_TEMPORARILY_UNAVAIL   0x91 /* 1001 0001b */
#define D2H_ERROR_MBOXCODE_UNKNOWN                0xA1 /* 1010 0001b */
#define D2H_AUTONOMOUS_MODEM_READY_MSG            0xF1 /* 1111 0001b */

// Host-to-DSP messages (Debug mode)
#define H2D_DEBUG_READ_DM                         0x02 /* 0000 0010b */
#define H2D_DEBUG_READ_PM                         0x06 /* 0000 0110b */
#define H2D_DEBUG_WRITE_DM                        0x0A /* 0000 1010b */
#define H2D_DEBUG_WRITE_PM                        0x0E /* 0000 1110b */
#define H2D_DEBUG_READ_EXT_DM                     0x12 /* 0001 0010b */
#define H2D_DEBUG_READ_EXT_PM                     0x16 /* 0001 0110b */
#define H2D_DEBUG_WRITE_EXT_DM                    0x1A /* 0001 1010b */
#define H2D_DEBUG_WRITE_EXT_PM                    0x1E /* 0001 1110b */

// DSP-to-Host messages (Debug mode)
#define D2H_DEBUG_READ_DM_REPLY                   0x03 /* 0000 0011b */
#define D2H_DEBUG_READ_PM_REPLY                   0x07 /* 0000 0111b */
#define D2H_DEBUG_WRITE_DM_REPLY                  0x0B /* 0000 1011b */
#define D2H_DEBUG_WRITE_PM_REPLY                  0x0F /* 0000 1111b */
#define D2H_DEBUG_READ_EXT_DM_REPLY               0x13 /* 0001 0011b */
#define D2H_DEBUG_READ_EXT_PM_REPLY               0x17 /* 0001 0111b */
#define D2H_DEBUG_WRITE_EXT_DM_REPLY              0x1B /* 0001 1011b */
#define D2H_DEBUG_WRITE_EXT_PM_REPLY              0x1F /* 0001 1111b */

#define D2H_ERROR_ADDR_UNKNOWN                    0x33 /* 0011 0011b */


#define CNTLGroup   1
#define STATGroup   2
#define iNFOGroup   3
#define TESTGroup   4
#define OPTNGroup   5
#define RATEGroup   6
#define PLAMGroup   7
#define CNFGGroup   8
#ifdef HERC_API
#define MONIGroup   9
#define CNTRGroup   10
#define ALGSGroup   11
#define DBUGGroup   12
#define ACFGGroup   13
#define AINFGroup   14
#define AOPTGroup   15
#endif
#define INDIRECT_CMV_TYPE_MASK    0x4000
// Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (START_END)
#define DSLGroup    34

#define NewCNTLType (0)

//Socrates
#define NewSTATType (1)
#define NewINFOType (2)
#define NewTESTType (3)
#define NewOPTNType (4)
#define NewRATEType (5)
#define NewPLAMType (6)
#define NewCNFGType (7)
// Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (START)
#define NewDSLType  (8)
// Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (END)

//HERCULES
#define NewSTAT_0_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 1))
#define NewSTAT_1_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 2))
#define NewSTAT_5_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 3))
#define NewSTATType_HERC               (4)

#define NewINFOType_74_HLOG_HERC       ((int16)(INDIRECT_CMV_TYPE_MASK | 5))
#define NewINFOType_76_QLN_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 6))

#define NewINFO_203_Type_HERC          ((int16)(INDIRECT_CMV_TYPE_MASK | 7))
#define NewINFO_209_Type_HERC          ((int16)(INDIRECT_CMV_TYPE_MASK | 8))
#define NewINFO_211_Type_HERC          ((int16)(INDIRECT_CMV_TYPE_MASK | 9))
#define NewINFO_212_Type_HERC          ((int16)(INDIRECT_CMV_TYPE_MASK | 10))

//XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start)
#define NewINFO_221_Type_HERC          ((int16)(INDIRECT_CMV_TYPE_MASK | 11))

#define NewINFOType_HERC               ((int16)(INDIRECT_CMV_TYPE_MASK | 12))

#define NewTESTType_HERC               (13)

#define NewOPTN_0_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 14))
#define NewOPTN_2_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 15))
#define NewOPTNType_HERC               (16)

#define   NewRATEType_HERC             ((int16)(INDIRECT_CMV_TYPE_MASK | 17))
#define   NewPLAMType_HERC             (18)

#define NewCNFG_0_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 19))
#define NewCNFG_1_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 20))
#define NewCNFG_2_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 21))
#define NewCNFG_3_Type_HERC            ((int16)(INDIRECT_CMV_TYPE_MASK | 22))


#define NewCNFGType_HERC               ((int16)(INDIRECT_CMV_TYPE_MASK | 23))




#ifdef HERC_API
   #define NewMONIType                 ((int16)(INDIRECT_CMV_TYPE_MASK | 24))
   #define NewCNTRType                 ((int16)(INDIRECT_CMV_TYPE_MASK | 25))
   #define NewALGSType                 (26)
   #define NewDBUGType                 (27)
   #define NewACFGType                 (28)
   #define NewAINFType                 ((int16)(INDIRECT_CMV_TYPE_MASK | 29))
   #define NewAOPTType                 (30)
   #define NewDSLType_HERC             ((int16)(INDIRECT_CMV_TYPE_MASK | 31))
   #define NewCNTR_46_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 32))
   //XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
   #define NewCNTR_53_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 33))
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start_end)
   #define NewCNTR_45_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 34))
   //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
   #define NewOPTN_15_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 35))
   //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
   #define NewCNFG_58_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 36))
   //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start_end)
   #define NewOPTN_28_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 37))

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
   #define NewCNTR_43_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 38))
   #define NewCNTR_44_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 39))
    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start)
   #define NewINFO_229_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 40))
   #define NewCNFG_80_Type_HERC       ((int16)(INDIRECT_CMV_TYPE_MASK | 41))
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (End)

   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
   #define NewCNTR_51_Type_HERC       ((int16)(INDIRECT_CMV_TYPE_MASK | 42))
    #define NewOPTN_25_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 43))

   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   #define NewCNTR_56_Type_HERC       ((int16)(INDIRECT_CMV_TYPE_MASK | 44))
   #define NewCNTR_57_Type_HERC       ((int16)(INDIRECT_CMV_TYPE_MASK | 45))
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

   //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (start_End)
    #define NewCNFG_82_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 46))
//XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (End)

    //XDSLRTFW-2382 (Start_End)
   #define NewCNFG_89_Type_HERC       ((int16)(INDIRECT_CMV_TYPE_MASK | 47))
    // XDSLRTFW-1481 (Start_End)
   #define NewPLAM_5_Type_HERC        ((int16)(INDIRECT_CMV_TYPE_MASK | 48))

    // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
   #define NewINFO_241_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 49))
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

   // XDSLRTFW-3566 (Start_End)
   #define NewINFO_244_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 50))

   #define NewDSL_4_Type_HERC         ((int16)(INDIRECT_CMV_TYPE_MASK | 51))     //XDSLRTFW-3705 (Start_End)

#endif   // HERC_API



#ifdef HERC_API
#define CUST_CMV_GROUP_BIT_MASK     0x10
#endif   // HERC_API


#define READ_WRITE_ACCESS           0
#define READ_ACCESS                 1
#define WRITE_ACCESS                2
#define UNKNOWN_ADDRESS             0x1

#define NEW_DICT_ENTRY_LENGTH       7
//Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (Start)
#define NEW_NUM_DICT_ENTRIES_SOC    10

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start_End)
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start_end)
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start_End)
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start_End)
//XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start_End)
//XDSLRTFW-1481 (Start_End)
//XDSLRTFW-3705 (Start_End)
#define NEW_NUM_DICT_ENTRIES_HERC   52
//Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (End)

#define NEW_DICT_SIZE_HERC          NEW_DICT_ENTRY_LENGTH * NEW_NUM_DICT_ENTRIES_HERC
#define NEW_DICT_SIZE_SOC           NEW_DICT_ENTRY_LENGTH * NEW_NUM_DICT_ENTRIES_SOC

// buffer size for logging CW's from API
#define HMP_LOG_BUF_SIZE            128

#endif /* _HERCULES_MP_H */
