/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*      All Rights Reserved
*
*      40, Middlesex Turnpike , Bedford, MA 01730-1413
*      Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*      hmp_data.c
*
*      HMP buffers and global variables
*
*-------------------------------------------------------------------
*/
// *****************************************************************************
// hmp_Data.c
//
// History
//
// 21/06/2010 Bhadra : Added new CMV group "DSL".
//                   Grep for  Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//               Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                       0: disabled (default)
//                       1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                      0 -> GHS Activation startup (Default)
//                      1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 17/09/2012 Ram: Added code to support the foll CMVs
//                 "CNFG 80" -> Enable/Disable ReTx mode during G.HS
//                 "INFO 229" -> ReTx DS Showtime Status: ReTx On/OFF
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229"
//
//
// 07/01/2013 Ram: Added fix for JIRA 459. Implementing 'CMV CNTR 51'
//                Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
//
// 27/5/2013 Vinjam: Added CMV remap for INFO 221 using Hercules CMV dictionary entry
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// *****************************************************************************


/*******************************************************************
*
*      Include Files
*
*******************************************************************/

#include "common.h"
#include "hmp.h"
#include "hmp_data.h"
#include "cmv.h"

AutoMsgPayLoadEntry_t gt_ModemReadyPayLoad;
uint16 gus_BootupResultCode;

#ifdef HERC_API
AutoMsgPayLoadEntry_t gt_EventConfigurePayLoad;
AutoMsgPayLoadEntry_t gt_ModemStatFailPayLoad;
AutoMsgPayLoadEntry_t gt_NearEndFailure;
AutoMsgPayLoadEntry_t gt_FarEndFailure;
AutoMsgPayLoadEntry_t gt_Required_TC;
#endif

int16 gs_MPReturnOpcode;
int16 gs_MPFunctionOpcode;

HerculesMPStruct_t HMP_RxBuffer;
// HerculesMPStruct_t HMP_TxBuffer;     using __gt_Arc2MeMboxMsg directly
HerculesMPStruct_t HMP_AutoBuffer;
#ifndef ADSL_62
HerculesMPStruct_t HMP_FastReadBuffer;    no longer supported
#endif

HMP_AutoMsgQueue_t gt_AutoMsgQueue;

// the order of entry in this table is very important because
// it assumes the dictionary look-up algorithm will do a top
// down search.

int16 NEW_CMV_Dictionary_SOC[NEW_DICT_SIZE_SOC] =
{// Groupfield    AddrRange                   OffsetRange          BlockType                                   ReadWriteAccess
   CNTLGroup,     0, CNTLARRAY_SIZE-1,        0, 0,                NewCNTLType,                                WRITE_ACCESS,
   STATGroup,     0, STATARRAY_SIZE-1,        0, 0,                NewSTATType,                                READ_ACCESS,
   iNFOGroup,     0, INFOMAP_SIZE-1,          0, 0x7fff,           NewINFOType | INDIRECT_CMV_TYPE_MASK,       READ_WRITE_ACCESS,
   TESTGroup,     0, TESTARRAY_SIZE-1,        0, 0,                NewTESTType,                                READ_WRITE_ACCESS,
   OPTNGroup,     0, OPTNARRAY_SIZE-1,        0, 0,                NewOPTNType,                                READ_WRITE_ACCESS,
   RATEGroup,     0, RATEMAP_SIZE-1,          0, 0x7fff,           NewRATEType | INDIRECT_CMV_TYPE_MASK,       READ_ACCESS,
   PLAMGroup,     0, PLAMMAP_SIZE-1,          0, 0x7fff,           NewPLAMType | INDIRECT_CMV_TYPE_MASK,       READ_WRITE_ACCESS,
   CNFGGroup,     0, CNFGMAP_SIZE-1,          0, 0x7fff,           NewCNFGType | INDIRECT_CMV_TYPE_MASK,       READ_WRITE_ACCESS,
   //Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP
   DSLGroup,      0, DSLMAP_SIZE - 1,         0, 0x7fff,           NewDSLType| INDIRECT_CMV_TYPE_MASK,         READ_WRITE_ACCESS
};

#ifdef HERC_API
int16 NEW_CMV_Dictionary_HERC[NEW_DICT_SIZE_HERC] =
{// Groupfield    AddrRange                   OffsetRange          BlockType                                    ReadWriteAccess
   CNTLGroup,     0,    CNTLARRAY_SIZE-1,     0, 0,                NewCNTLType,                                 WRITE_ACCESS,

   STATGroup,     0,    0,                    0, STAT_0_SIZE,      NewSTAT_0_Type_HERC ,                        READ_ACCESS,
   STATGroup,     1,    1,                    0, STAT_1_SIZE,      NewSTAT_1_Type_HERC,                         READ_ACCESS,
   STATGroup,     5,    5,                    0, STAT_5_SIZE,      NewSTAT_5_Type_HERC,                         READ_ACCESS,
   STATGroup,     0,    STATARRAY_SIZE-1,     0, 0,                NewSTATType_HERC,                            READ_ACCESS,

   iNFOGroup,     74,   74,                   0, INFO_74_SIZE,     NewINFOType_74_HLOG_HERC,                    READ_WRITE_ACCESS,
   iNFOGroup,     76,   76,                   0, INFO_76_SIZE,     NewINFOType_76_QLN_HERC,                     READ_WRITE_ACCESS,
   iNFOGroup,     203,  203 ,                 0, INFO_203_SIZE,    NewINFO_203_Type_HERC,                       READ_WRITE_ACCESS,
   iNFOGroup,     209,  209,                  0, INFO_209_SIZE,    NewINFO_209_Type_HERC,                       READ_WRITE_ACCESS,
   iNFOGroup,     211,  211,                  0, INFO_211_SIZE,    NewINFO_211_Type_HERC,                       READ_WRITE_ACCESS,
   iNFOGroup,     212,  212,                  0, INFO_212_SIZE,    NewINFO_212_Type_HERC,                       READ_WRITE_ACCESS,
   //XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start_End)
   iNFOGroup,     221, 221,                   0, INFO_221_SIZE,    NewINFO_221_Type_HERC,                       READ_WRITE_ACCESS,
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (Start)
   iNFOGroup,     229, 229,                   0, INFO_229_SIZE,    NewINFO_229_Type_HERC,                       READ_ACCESS,
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (End)
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
   iNFOGroup,     241, 241,                   0, INFO_241_SIZE,    NewINFO_241_Type_HERC,                       READ_WRITE_ACCESS,
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)
   // XDSLRTFW-3566 (Start_End)
   iNFOGroup,     244,  244,                  0, INFO_244_SIZE,    NewINFO_244_Type_HERC,                       READ_ACCESS,
   iNFOGroup,     0, INFOMAP_SIZE-1,          0, 0x7fff,           NewINFOType_HERC,                            READ_WRITE_ACCESS,

   TESTGroup,     0, TESTARRAY_SIZE-1,        0, 0,                NewTESTType_HERC,                            READ_WRITE_ACCESS,

   OPTNGroup,     0, 0,                       0, OPTN_0_SIZE,      NewOPTN_0_Type_HERC ,                        READ_WRITE_ACCESS,
   OPTNGroup,     2, 2,                       0, OPTN_2_SIZE,      NewOPTN_2_Type_HERC ,                        READ_WRITE_ACCESS,
   //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
   OPTNGroup,     15, 15,                     0, OPTN_15_SIZE,     NewOPTN_15_Type_HERC,                        READ_WRITE_ACCESS,
   OPTNGroup,     25, 25,                     0, OPTN_25_SIZE,     NewOPTN_25_Type_HERC,                        READ_WRITE_ACCESS,
   //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start_end)
   OPTNGroup,     28, 28,                     0, OPTN_28_SIZE,     NewOPTN_28_Type_HERC,                        READ_WRITE_ACCESS,
   OPTNGroup,     0, OPTNARRAY_SIZE-1,        0, 0,                NewOPTNType_HERC,                            READ_WRITE_ACCESS,

   RATEGroup,     0, RATEMAP_SIZE-1,          0, 0x7fff,           NewRATEType_HERC,                            READ_ACCESS,

   // XDSLRTFW-4181 (Start_End)
   PLAMGroup,     5, 5,                       0, PLAM_5_SIZE,      NewPLAM_5_Type_HERC,                         READ_WRITE_ACCESS,
   PLAMGroup,     0, PLAMMAP_SIZE-1,          0, 0x7fff,           NewPLAMType_HERC | INDIRECT_CMV_TYPE_MASK,   READ_WRITE_ACCESS,

   CNFGGroup,     0, 0,                       0, CNFG_0_SIZE,      NewCNFG_0_Type_HERC,                         READ_WRITE_ACCESS,
   CNFGGroup,     1, 1,                       0, CNFG_0_SIZE,      NewCNFG_1_Type_HERC,                         READ_WRITE_ACCESS,
   CNFGGroup,     2, 2,                       0, CNFG_0_SIZE,      NewCNFG_2_Type_HERC,                         READ_WRITE_ACCESS,
   CNFGGroup,     3, 3,                       0, CNFG_0_SIZE,      NewCNFG_3_Type_HERC,                         READ_WRITE_ACCESS,
   //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
   CNFGGroup,     58, 58,                     0, CNFG_58_SIZE,     NewCNFG_58_Type_HERC,                        READ_WRITE_ACCESS,
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (Start)
   CNFGGroup,     80, 80,                     0, CNFG_80_SIZE,     NewCNFG_80_Type_HERC,                        READ_WRITE_ACCESS,
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (End)
   //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs  (Start)
   CNFGGroup,     82, 82,                     0, CNFG_82_SIZE,     NewCNFG_82_Type_HERC,                        READ_WRITE_ACCESS,
   CNFGGroup,     89, 89,                     0, CNFG_89_SIZE,     NewCNFG_89_Type_HERC,                        READ_WRITE_ACCESS,
   CNFGGroup,     0, CNFGMAP_SIZE-1,          0, 0x7fff,           NewCNFGType_HERC,                            READ_WRITE_ACCESS,

   MONIGroup,     0, MONIMAP_SIZE-1,          0, 0x7fff,           NewMONIType,                                 READ_WRITE_ACCESS,

   //XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
   CNTRGroup,     53,53,                      0, CNTR_53_SIZE,     NewCNTR_53_Type_HERC,                        READ_WRITE_ACCESS,
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   CNTRGroup,     56,56,                      0, CNTR_56_SIZE,     NewCNTR_56_Type_HERC,                        READ_WRITE_ACCESS,
   CNTRGroup,     57,57,                      0, CNTR_57_SIZE,     NewCNTR_57_Type_HERC,                        READ_WRITE_ACCESS,
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
   CNTRGroup,     43,43,                      0, CNTR_43_SIZE,     NewCNTR_43_Type_HERC,                        READ_ACCESS,
   CNTRGroup,     44,44,                      0, CNTR_44_SIZE,     NewCNTR_44_Type_HERC,                        READ_ACCESS,
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
   CNTRGroup,     45,45,                      0, CNTR_45_SIZE,     NewCNTR_45_Type_HERC,                        READ_WRITE_ACCESS,
   CNTRGroup,     46,46,                      0, CNTR_46_SIZE,     NewCNTR_46_Type_HERC,                        READ_WRITE_ACCESS,
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
   CNTRGroup,     51,51,                      0, CNTR_51_SIZE,     NewCNTR_51_Type_HERC,                        READ_ACCESS,
   CNTRGroup,     0, CNTRMAP_SIZE-1,          0, 0x7fff,           NewCNTRType,                                 READ_WRITE_ACCESS,

   ALGSGroup,     0, ALGSMAP_SIZE-1,          0, 0x7fff,           NewALGSType | INDIRECT_CMV_TYPE_MASK,        READ_ACCESS,

   DBUGGroup,     0, DBUGMAP_SIZE-1,          0, 0x7fff,           NewDBUGType | INDIRECT_CMV_TYPE_MASK,        READ_ACCESS,

   ACFGGroup,     0, ACFGMAP_SIZE-1,          0, 0x7fff,           NewACFGType | INDIRECT_CMV_TYPE_MASK,        READ_ACCESS,

   AINFGroup,     0, AINFMAP_SIZE-1,          0, 0x7fff,           NewAINFType,                                 READ_ACCESS,

   AOPTGroup,     0, AOPTMAP_SIZE-1,          0, 0x7fff,           NewAOPTType | INDIRECT_CMV_TYPE_MASK,        READ_ACCESS,

   //XDSLRTFW-3705 (Start_End)
   DSLGroup,      4,    4,                    0, DSL_4_SIZE,       NewDSL_4_Type_HERC,                          WRITE_ACCESS,
   //Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (Start_End)
   DSLGroup,      0, DSLMAP_SIZE-1,           0, 0x7fff,           NewDSLType_HERC,                             READ_WRITE_ACCESS
};
#endif

int16 *NewBlockNameArrayPtr;


int16 *NewCMVBlockNamePtr_SOC[] =
{
   // Note the pointers for the indirect CMV groups
   // are really type (int16 **) rather than (int16 *).
   &CNTLArray[0],
   &STATArray[0],
   (int16 *)(void *)&INFOMap[0],
   &TESTArray[0],
   &OPTNArray[0],
   (int16 *)(void *)&RATEMap[0],
   (int16 *)(void *)&PLAMMap[0],
   (int16 *)(void *)&CNFGMap[0],
   //Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (Start_End)
   (int16 *)(void *)&DSLMap[0]
};

int16 *NewCMVBlockNamePtr_HERC[] =
{
   // Note the pointers for the indirect CMV groups
   // are really type (int16 **) rather than (int16 *).
   &CNTLArray[0],

   (int16 *)(void *)&STAT_0_Map[0],
   (int16 *)(void *)&STAT_1_Map[0],
   (int16 *)(void *)&STAT_5_Map[0],
   &STATArray[0],


   (int16 *)(void *)&INFO_74_Map[0],
   (int16 *)(void *)&INFO_76_Map[0],

   (int16 *)(void *)&INFO_203_Map[0],
   (int16 *)(void *)&INFO_209_Map[0],
   (int16 *)(void *)&INFO_211_Map[0],
   (int16 *)(void *)&INFO_212_Map[0],

   //XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start_End)
   (int16 *)(void *)&INFO_221_Map[0],

   (int16 *)(void *)&INFOMap[0],

   &TESTArray[0],

   (int16 *)(void *)&OPTN_0_Map[0],
   (int16 *)(void *)&OPTN_2_Map[0],
   &OPTNArray[0],

   (int16 *)(void *)&RATEMap[0],
   (int16 *)(void *)&PLAMMap[0],
   (int16 *)(void *)&CNFG_0_Map[0],
   (int16 *)(void *)&CNFG_1_Map[0],
   (int16 *)(void *)&CNFG_2_Map[0],
   (int16 *)(void *)&CNFG_3_Map[0],


   (int16 *)(void *)&CNFGMap[0],
   (int16 *)(void *)&MONIMap[0],
   (int16 *)(void *)&CNTRMap[0],
   (int16 *)(void *)&ALGSMap[0],
   (int16 *)(void *)&DBUGMap[0],
   (int16 *)(void *)&ACFGMap[0],
   (int16 *)(void *)&AINFMap[0],
   (int16 *)(void *)&AOPTMap[0],
   //Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (Start_End)
   (int16 *)(void *)&DSLMap[0],
   (int16 *)(void *)&CNTR_46_Map[0],
   //XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
   (int16 *)(void *)&CNTR_53_Map[0],
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start_end)
   (int16 *)(void *)&CNTR_45_Map[0],
   //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
   (int16 *)(void *)&OPTN_15_Map[0],
   //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
   (int16 *)(void *)&CNFG_58_Map[0],
   //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV(start_end)
   (int16 *)(void *)&OPTN_28_Map[0],
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
   (int16 *)(void *)&CNTR_43_Map[0],
   (int16 *)(void *)&CNTR_44_Map[0],
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start)
   (int16 *)(void *)&INFO_229_Map[0],
   (int16 *)(void *)&CNFG_80_Map[0],
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (End)
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
   (int16 *)(void *)&CNTR_51_Map[0],
   (int16 *)(void *)&OPTN_25_Map[0],
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   (int16 *)(void *)&CNTR_56_Map[0],
   (int16 *)(void *)&CNTR_57_Map[0],
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
   //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start_End)
   (int16 *)(void *)&CNFG_82_Map[0],
   //XDSLRTFW-2382 (Start_End)
   (int16 *)(void *)&CNFG_89_Map[0],
   (int16 *)(void *)&PLAM_5_Map[0], // XDSLRTFW-1481 (Start_End)

   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
   (int16 *)(void *)&INFO_241_Map[0],
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

   // XDSLRTFW-3566 (Start_End)
   (int16 *)(void *)&INFO_244_Map[0],
   (int16 *)(void *)&DSL_4_Map[0]      //XDSLRTFW-3705 (Start_End)
};

