/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: hmp_data.h
;
;  Header file for simext cocomo interface.
;   Note that all addresses are byte addresses!!!
;
*****************************************************************************/


#ifndef _HERCULES_MPDATA_H
#define _HERCULES_MPDATA_H

#include "hmp.h"

typedef struct {
    uint16 us_HmpHeaderWord0;
    uint16 us_HmpHeaderWord1;
} HMP_Header_t;

typedef struct {
    int32 *pl_Arc2MeMboxStart;
    int32 l_Arc2MeMboxLength;
    int32 *pl_Me2ArcMboxStart;
    int32 l_Me2ArcMboxLength;
} HMP_Descriptor_t;


typedef struct {
   uint16 us_HmpMboxCode;
   uint16 us_HmpMsgWord0;
   uint16 us_HmpMsgWord1;
   uint16 us_HmpMsgWord2;
   uint16 us_HmpMsgWord3;
   uint16 us_HmpMsgWord4;
} HMP_MsgHeader_t;

typedef struct {
   HMP_MsgHeader_t t_MsgHeader;
   uint16 usa_HmpPayLoad[HMP_MBOX_PAYLOAD_SIZE];
} HerculesMPStruct_t;


typedef struct {
   uint16 *pus_PayLoad;          // should point to global payload which should
   uint8 uc_PayLoadLength;          // exist until msg is actually sent out.
   uint8 uc_PayLoadSent;
} AutoMsgPayLoadEntry_t;

typedef struct {
   HMP_MsgHeader_t t_MsgHeader;
    AutoMsgPayLoadEntry_t *pt_PayLoadEntry;
} AutoMsgQueueEntry_t;

typedef struct {
   int16 s_AutoMsgReadIndex;
   int16 s_AutoMsgWriteIndex;
   AutoMsgQueueEntry_t ta_AutoMsgArray[AUTO_MSG_QUEUE_LENGTH];
} HMP_AutoMsgQueue_t;

#ifdef DEBUG_STREAMING
/** Provides debug information as configured with @ref _MSG_CMD_DBG_DEBUG_STREAM_CONFIGURE_.
   The EVTs are generated only if streaming was enabled by @ref _MSG_CMD_DBG_DEBUG_STREAM_CONTROL_.
   One EVT can contain a whole debug substream or only a fragment (see parameter StreamStatus).
   For overflow situations an "Overflow Pre-Indication" flag and a stream counter are contained.
   @note
   The debug streams are queued in a debug FIFO and then moved to the host-IF
   mailbox (if bigger than the mailbox size, then in fragments). If a debug
   stream does not fit into the FIFO because it is too full, it is discarded
   completely and the overflow flag is set in the last fragment of the
   preceeding message. A stream is either delivered to the host completely or
   discarded completely, not just single fragments of it.
*/
typedef struct {
   // the debug id used for the debug stream
   uint16 us_DbgStreamId;
   // the symbol count the stream was created
   uint32 us_DbgStreamSymCnt;
   // the stream status bits and counter
   uint16 us_DbgStreamStatus;
   // CRC 16 over the stream data, not used due to missing CRC calculation HW
   uint16 us_DbgStreamCrc16;
   // The number of bytes following in this single EVT, excluding this field. \n
   // It is not the overall stream size in case of fragmented streams which are
   // reported with more than one EVT.
   uint16 us_DbgStreamLength;
   /// pointer to next debug stream payload
   uint16 * pus_DbgStreamPayload;
} HMP_DebugStreamMsg_t;
#endif

/* the following variables are defined in the linker command file */
extern volatile HMP_Header_t __gt_HmpHeader;
extern volatile HMP_Descriptor_t __gta_HmpMboxDescriptor[];

extern volatile int16 __gs_Me2ArcMboxCode;
extern volatile HerculesMPStruct_t __gt_Me2ArcMboxMsg;

extern volatile int16 __gs_Arc2MeMboxCode;
extern volatile HerculesMPStruct_t __gt_Arc2MeMboxMsg;

extern HerculesMPStruct_t HMP_RxBuffer;
extern HerculesMPStruct_t HMP_TxBuffer;
extern HerculesMPStruct_t HMP_AutoBuffer;
extern HerculesMPStruct_t HMP_FastReadBuffer;

extern HMP_AutoMsgQueue_t gt_AutoMsgQueue;

extern AutoMsgPayLoadEntry_t gt_ModemReadyPayLoad;
extern uint16 gus_BootupResultCode;

#ifdef HERC_API
extern AutoMsgPayLoadEntry_t gt_EventConfigurePayLoad;
extern AutoMsgPayLoadEntry_t gt_ModemStatFailPayLoad;
extern AutoMsgPayLoadEntry_t gt_NearEndFailure;
extern AutoMsgPayLoadEntry_t gt_FarEndFailure;
extern AutoMsgPayLoadEntry_t gt_Required_TC;
#endif

extern int16 gs_MPReturnOpcode;
extern int16 gs_MPFunctionOpcode;
extern int16 NEW_CMV_Dictionary_SOC[];

#ifdef HERC_API
extern int16 NEW_CMV_Dictionary_HERC[];
#endif

extern int16 *NewBlockNameArrayPtr;

extern int16 *NewCMVBlockNamePtr_SOC[];


extern int16 *NewCMVBlockNamePtr_HERC[];

extern AutoMsgPayLoadEntry_t gt_ModemReadyPayLoad;
extern uint16 gus_BootupResultCode;

// variables not defined in hmp_data.c
extern uint8 guc_MPMsgReq;
extern uint8 guc_CodeSwapMsgReq;
extern uint8 guc_FastReadMsgReq;
extern int16 gs_CodeSwapSection;
#endif /* _HERCULES_MPDATA_H */
