/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: hmp_funcs.h
;
*****************************************************************************/


#ifndef _HERCULES_FUNCS_H
#define _HERCULES_FUNCS_H


int16 NewMPInitialize(void);
//void SetupModemReadyMessage(void);
void NewMPSetupReadyMessage(void);
int16 NewMPCheckMessage(int16);
void NewMPSendMessage(int16 FunctionOpcode, int16 RW_status);
//void AddFastReadRequest(int32 l_Address, uint16 us_Size, uint16 us_RequestNum);
void ProcessTxMailbox(void);
int16 TxMailBoxPending(void);
void SendFastReadRequest(void);
//FlagT CheckForFastReadDone(void);
int16 NewDecodeCMVBlockName(uint16 *pus_BlockNameType, uint16 *pus_ReadWriteStatus, uint16 *pus_StartAddr, uint16 s_HERCSocBit);
void SendCodeSwapRequest(void);
int16 NewMPHandleMessage(int16);
int16 IncrMsgQueueIndex(int16 s_Index);
int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0,
               uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4);
int16 GetNextAutoMsgQueueEntry(AutoMsgQueueEntry_t *pt_NewAutoMsg);
void NewMPSendAutoMessage(AutoMsgQueueEntry_t *pt_AutoMsg);

#ifdef DEBUG_STREAMING
/// Handle host mailbox in the background
/**
    If the DSP to host mailbox is available the next pending messages will be processed by it's priority. Priorities are:

    * Debug messages

    @param ptStatics pointer to port's persistent data structure
    @param Event the event that caused the background handler to be called

    @return A non zero value will tell the background thread to schedule the service again.
 */
void NMP_BgService(void);


/// Test for pending debug message
uint16 NMP_IsDebugMsgPending(void);

/// Set a debug message chunk to be sent asap.
/**
    All information is stored locally until the message could be sent

    @param StreamId     the stream id (1st payload word)
    @param SymCount     the global symbol counter value when registering the stream
    @param Crc16        a CRC16 over the stream data
    @param StreamStatus the stream's status field (2nd payload word)
    @param Length       debug stream message length in number of bytes
    @param pPayload     pointer to debug stream message payload data

    @return The function will return 0 if the message could be scheduled for transmission. A value < 0 idicates an error.
 */
int32 NMP_SendDebugMsg(uint16 StreamId, uint32 SymCount, uint16 Crc16, uint16 StreamStatus, uint16 Length, uint16 * pPayload);
#endif

#endif /* _HERCULES_FUNCS_H */
