/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp_plfm.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*      int16 NewMPInitialize
*      int16 NewMPCheckMessage
*      void  NewMPSendMessage
*
*-------------------------------------------------------------------
*/
// *****************************************************************************
// nmp_plfm.c
//
// History
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//               Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 31/07/2012 Sriram Shastry : Allow API to write to Herc cmv CNTR for near end performance monitoring counter
// like, ecs,es,ses,los,crc & fec.
//              Grep for : XDSLRTFW-425 IOP_ALL_DS_ALL_NECNTR_CMVWrite
//
// 23/8/2012 Vinjam: Removed CMV control while calling "MapHercCNTRtoSOCPLAM( )"
//              Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 07/01/2013 Ram: Added fix for JIRAs 575, 459.
//                 a) When SW/DSL-API either GETs/SETs 'a' CMV (perf counter),
//                    contents of the entire CMV set (CNTR 2,4,8,10,12,14) is being read/written.
//                    This mass read/write is being prevented now by passing the 'CMV number under interest'
//                    as an argument to mapping function.
//                    Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
//                 b) Implementing CMV 'CNTR 51'.
//                    Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// *****************************************************************************

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "string.h"
#include "common.h"
#include "hmp_data.h"
#include "hmp_funcs.h"
#include "aux_regs.h"
#include "cmv.h"
#include "hmp.h"
#include "states.h"
#include "gdata.h"
#include "soc_codeswap.h"
#include "trail.h"
#ifdef HERC_API
#include "cmv_remap.h"
#endif
#ifdef CUSTOMER_TASKS
#include "CustomerTasks.h"
#endif
#include "LL_IOf.h"

#include "ifx_vdsl2_afe_memmap.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#ifdef DEBUG_STREAMING
#include "Fifo.h"
#endif

extern FlagT gft_ByPassCustomerMsgHandling;
extern void CustomerHandleMessage(void);

int16 gs_InterruptCode = 0;
uint8 guc_InterruptReq = 0;


void QueueInterruptRequest(int16 s_InterruptCode)
{
   if (OPTNArray[OPTN_InterruptControl] & OPTN_ARC2MEI_Interrupt_Enable)
   {
      gs_InterruptCode = s_InterruptCode;
      guc_InterruptReq = 1;
   }
}

void CopyHmpBuffers(HerculesMPStruct_t *pt_DestBuf, HerculesMPStruct_t *pt_SrcBuf)
{
   int32 l_MsgSize;
   uint32 ul_PayLoadLength;

   ul_PayLoadLength = pt_SrcBuf->t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;

   l_MsgSize = 2*(HMP_MBOX_HEADER_SIZE + ul_PayLoadLength);  // size in bytes

   if (l_MsgSize > (2*HMP_MBOX_SIZE))
   {
      // log error in Trail
      l_MsgSize = 2*HMP_MBOX_SIZE;
   }

   memcpy((int8 *)pt_DestBuf, (int8 *)pt_SrcBuf, l_MsgSize);
}


#ifdef LOG_HMP_CMV_WRITES
extern int16 gs_HmpLogIndex, gsa_HmpLogBuf[];

void LogHmpBuffer(HerculesMPStruct_t *pt_SrcBuf)
{
   int16 s_Length, FunctionOpcode;

   s_Length = pt_SrcBuf->t_MsgHeader.us_HmpMsgWord4 & HMP_WORD4_LENGTH_MASK;

   if ((gs_HmpLogIndex + s_Length) <= (HMP_LOG_BUF_SIZE - 3))
   {
      FunctionOpcode = (pt_SrcBuf->t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) & HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;

      if (FunctionOpcode == H2D_CMV_WRITE)
      {
         memcpy((int8 *)&gsa_HmpLogBuf[gs_HmpLogIndex], (int8 *)&pt_SrcBuf->t_MsgHeader.us_HmpMsgWord2, (s_Length + 3)*2);
         gs_HmpLogIndex += s_Length + 3;
      }

   }
}
#endif

/*******************************************************************************
 *
 *   Prototype: int16 NewMPCheckMessage(int16)
 *
 *   This function checks to see if a new message has been received.
 *
 *   Input Arguments:

 *   Output Arguments:
 *
 *   Returns:
 *      TRUE (message arrived) / FALSE (no message)
 *
 *   Global Variables:
 *
 *******************************************************************************/


int16 NewMPCheckMessage(int16 s_Mailbox)
{
   int32 l_InterruptStat;
   uint16 us_Group;
   uint16 us_Opcode;

   /* ProcessTxMailbox() arbitrates access to ARC-to-ME Mailbox. */
   ProcessTxMailbox();

   if (TxMailBoxPending() == 0)   // prev TX msg has been served?
   {
      l_InterruptStat = GetDspReg(ARC_INT_STAT_ADDR);
      // No previous message response is pending. A new message is pending
      if ((l_InterruptStat & ARC_INT_MSGAV_MASK) && (guc_MPMsgReq == 0))   // XDSLRTFW-3377
      {

         if (__gs_Me2ArcMboxCode == QUERY_N_RESPONSE)
         {
            us_Group = __gt_Me2ArcMboxMsg.t_MsgHeader.us_HmpMsgWord2 & HMP_WORD2_GROUP_MASK;
            us_Opcode = (__gt_Me2ArcMboxMsg.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) &
               HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;

            // incoming message will be copied to HMP_RxBuffer. Both NewMHandleMessage and
            // CustomterHandleMessage will work with this buffer modifying it in place and
            // set guc_MPMsgReq = 1 to trigger the reply at the end of the processing.
            CopyHmpBuffers(&HMP_RxBuffer, &__gt_Me2ArcMboxMsg);

#ifdef LOG_HMP_CMV_WRITES
            LogHmpBuffer(&__gt_Me2ArcMboxMsg);
#endif
         }
         else
         {
            gs_ModemOperationRequired = FALSE;
            gs_MPReturnOpcode        = D2H_ERROR_MBOXCODE_UNKNOWN;
            guc_MPMsgReq = 1;
         }
         // XDSLRTFW-3377 (Start_End) Clearing the bit here is to early, it needs to be done in NewMPSendMessage()
         // SetDspReg(ARC_INT_STAT_ADDR, ARC_INT_MSGAV_MASK); // clear it by writing 1
         return (1);
      }
   }
   // No new message arrived
   return 0;
}

/*******************************************************************************
 *
 *   Prototype: void NewMPSendMessage(int16 FunctionOpcode, int16 RW_status)
 *
 *   This function constructs and sends messages from modem to ME.
 *
 *   Input Arguments:
 *      FunctionOpcode: 8-bit OP code [11:4] in Function Field
 *      RW_status: normal operation if 1, do nothing if 0
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *******************************************************************************/

void NewMPSendMessage(int16 FunctionOpcode, int16 RW_status)
{

   CopyHmpBuffers(&__gt_Arc2MeMboxMsg, &HMP_RxBuffer);

   // modify the FunctionOpcode before sending
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 =   (__gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 & HMP_WORD0_BITSIZE_MASK_B4_SHIFT) | (FunctionOpcode << HMP_WORD0_OPCODE_SHIFT);

   // set the mailbox code to 0 for MP messages
   __gs_Arc2MeMboxCode = QUERY_N_RESPONSE;

   SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);      // set the mailbox interrupt

   // XDSLRTFW-3377 (Start_End)
   SetDspReg(ARC_INT_STAT_REG, ARC_INT_MSGAV_MASK); // clear it by writing 1
}

/*^^^
 *-------------------------------------------------------------------
 *
 *       Prototype:
 *     void  NewMPSendAutoMessage();
 *
 *       Abstract:
 *     This function is called to transmit autonomous messages (e.g. Modem Ready)
 *
 *       Parameters:
 *
 *       Returns:
 *           None
 *
 *       Notes:
 *
 *-------------------------------------------------------------------
 ^^^*/
//#define DEBUG_AUTO_MSG

void NewMPSendAutoMessage(AutoMsgQueueEntry_t *pt_AutoMsg)
{
   int16 s_PayLoadLength;


   if ((s_PayLoadLength = pt_AutoMsg->pt_PayLoadEntry->uc_PayLoadLength <<1) > 0)
   {
      memcpy((uint8 *)(void *)__gt_Arc2MeMboxMsg.usa_HmpPayLoad,
            (uint8 *)(void *)pt_AutoMsg->pt_PayLoadEntry->pus_PayLoad, s_PayLoadLength);
   }

   pt_AutoMsg->pt_PayLoadEntry->uc_PayLoadSent = 1;
   __gt_Arc2MeMboxMsg.t_MsgHeader = pt_AutoMsg->t_MsgHeader;

   SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);      // set the mailbox interrupt
}

/*^^^
 *-------------------------------------------------------------------
 *
 * Prototype:
 *     int16 TxMailBoxPending(void)
 *
 * Abstract:
 *     This function is called to transmit autonomous messages (e.g. Modem Ready)
 *
 * Parameters:
 *
 * Returns:
 *     None
 *
 * Notes:
 *
 *-------------------------------------------------------------------
 ^^^*/
int32 gl_ARC_ARC2ME_STAT_REG;
// gl_ARC_ARC2ME_STAT_REG_value, gl_ARC_ARC2ME_STAT_REG_mask;

int16 TxMailBoxPending(void)
{
   gl_ARC_ARC2ME_STAT_REG = GetDspReg(ARC_ARC2ME_STAT_REG);
   if ((gl_ARC_ARC2ME_STAT_REG & ARC_ARC2ME_MSGAV_MASK) == 0)   // prev TX msg has been served?
   {
      return(0);
   }
   else
   {
      return(1);
   }
}

/*^^^
 *-------------------------------------------------------------------------------------
 *
 *      Prototype:
 *         void ProcessTxMailbox(void)
 *
 *      Abstract:
 *         This function coordinates messages from Socrates to the ME.  MP messages,
 *      Codeswap requests, and FastDataRead requests are all handled by this function.
 *
 *
 *      Parameters:    None
 *
 *      Returns:      None
 *
 *      Notes:
 *
 *-------------------------------------------------------------------
 ^^^*/
void ProcessTxMailbox(void)
{
   AutoMsgQueueEntry_t t_NewAutoMsg;

   /* Check if there is a previous mailbox access is complete */
   if (TxMailBoxPending() == 0)
   {

      /* if there is an message response waiting */
      if (guc_MPMsgReq != 0)
      {
         /* then send it and clear the request bit */
         NewMPSendMessage(gs_MPReturnOpcode, 1);
         guc_MPMsgReq = 0;
      }
      /* else if there is an autonomuos message waiting */
      else if (GetNextAutoMsgQueueEntry(&t_NewAutoMsg) == AUTO_MSG_QUEUE_OPERATION_SUCCESS)
      {
         /* then send it and clear the request bit */
         NewMPSendAutoMessage(&t_NewAutoMsg);
      }
      /* else if there is codeswap request waiting */
      else if (guc_CodeSwapMsgReq != 0)
      {
         /* then send it and clear the request bit */
         SendCodeSwapRequest();
      }
      /* else if there is fast read request waiting */
      else if (guc_FastReadMsgReq != 0)
      {
         /* then send it and clear the request bit */
         SendFastReadRequest();
         guc_FastReadMsgReq = 0;
      }
   }

}

#ifndef ADSL_62
// For ease of implementation, us_RequestNum is 0-based.
/*void AddFastReadRequest(int32 l_Address, uint16 us_Size, uint16 us_RequestNum)
  {
  uint16 us_Temp2;

  if (us_RequestNum > HMP_MAX_FASTREAD_REQUEST - 1)
  {
// ignore this request
return;
}

us_Temp2 = us_RequestNum + us_RequestNum*2;         // 3*us_RequestNum = index to this new entry

HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord1 = 3 + us_Temp2;      // size of payload = (us_RequestNum + 1)*3;

HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord4 = us_RequestNum + 1;               // update num of request
HMP_FastReadBuffer.usa_HmpPayLoad[us_Temp2] = l_Address >> 16;
HMP_FastReadBuffer.usa_HmpPayLoad[us_Temp2 + 1] = l_Address & 0xFFFF;
HMP_FastReadBuffer.usa_HmpPayLoad[us_Temp2 + 2] = us_Size;
}*/

/****************************************************************************
  ;   Prototype: void SendFastDataRequest(void)
  ;
  ;   Description:
  ;
  ;      This function is called at various points within the code (training
  ;   or showtime) in order to request a Fast Read from the ME.  Typical
  ;   applications include upload of GHS data, SNR tables, messages, etc.
  ;
  ;   Arguments:
  ;      none
  ;
  ;   Return Value:
  ;      none
  ;
  ;
  ;****************************************************************************/
void SendFastReadRequest(void)
{
   uint16 us_Temp;

   // clear the GP_INT bit (dedicated for FAST_READ acknowledgement)
   SetDspReg(ARC_INT_STAT_ADDR, ARC_INT_GP_INT_MASK); // clear it by writing 1

   us_Temp = HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord1;

   if (us_Temp > HMP_MBOX_PAYLOAD_SIZE)
   {
      // ignore this send; may log some info here
      return;
   }

   memcpy((uint8 *)&__gt_Arc2MeMboxMsg, (uint8 *)&HMP_FastReadBuffer, us_Temp*2 + HMP_MBOX_HEADER_SIZE*2);

   // notify MEI of codeswap request by asserting the ARC->MEI mailbox message interrupt
   SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);
}

/*******************************************************************************
 *
 *   Prototype: FlagT CheckForFastReadDone(void)
 *
 *      The CheckForFastRead function tests for the FAST_READ_DONE (bit GP_INT of
 *   the ME2ARC_INT_STAT register.

 *      For polling operation, see the PollForFastReadDone function.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *      TRUE - done
 *      FALSE - not done
 *
 *   Global Variables:
 *
 *******************************************************************************/
/*FlagT CheckForFastReadDone(void)
  {
  if ((guc_FastReadMsgReq == 0) &&      // already submitted
  (_lr(ARC_INT_STAT_ADDR) & ARC_INT_GP_INT_MASK))    // and actually done
  {
  return (TRUE);
  }
  else
  {
  return (FALSE);
  }
  }*/
#endif

/*^^^
 *-------------------------------------------------------------------
 *
 *      Prototype:
 *    int16  NewDecodeCMVBlockName(int16 *, int16 *);
 *
 *      Abstract:
 *    This function reads the message memory access address field,
 *    decodes it into a CMV Block Name and Offset, determines if the
 *    BlockName. Offset variable is read-only, write-only, or read/write, and
 *    determines if the offset is within the allowable range for the Block Name.
 *
 *      Parameters:
 *         int16 BlockNameType:         Function fills in the CMV block name.
 *         int16 ReadWriteStatus:         Function fills in the Read/write access of BlockName.Offset.
 *
 *      Returns:
 *         0 if no errors or Memory Access Error Message Subtype number.
 *
 *      Notes:
 *
 *-------------------------------------------------------------------
 ^^^*/
int16 *NEW_CMV_Dictionary;


int16 NewDecodeCMVBlockName(uint16 *pus_BlockNameType, uint16 *pus_ReadWriteStatus, uint16 *pus_StartAddr, uint16 s_HERCSocBit)
{
   int16 us_DictIndex;
   uint16 us_CMVGroupName,us_AddrField, us_OffsetField;
   int16 MemoryAccessErrorType;
   int16 us_Length,s_DICT_SIZE;

   /* Assume message will be decoded successfully. */

   us_CMVGroupName = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 & HMP_WORD2_GROUP_MASK;

   /* Grab CMV Block Name Offset. */
   us_AddrField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 >> HMP_WORD2_ADDRESS_SHIFT;

   us_OffsetField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;

   us_Length = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord4 & HMP_WORD4_LENGTH_MASK) - 1;


   /* Check the CMV "dictionary." */

   // presume search will fail
   MemoryAccessErrorType = UNKNOWN_ADDRESS;      /* Address MAY not be valid. */

#ifdef HERC_API
   if (s_HERCSocBit == 0)
   {
      //point to Hercules dictionary
      NEW_CMV_Dictionary = &NEW_CMV_Dictionary_HERC[0];
      s_DICT_SIZE = NEW_DICT_SIZE_HERC;
   }
   else
   {
      // point to Socrates dictionary
      NEW_CMV_Dictionary = &NEW_CMV_Dictionary_SOC[0];
      s_DICT_SIZE = NEW_DICT_SIZE_SOC;
   }

#else
   NEW_CMV_Dictionary = &NEW_CMV_Dictionary_SOC[0];
   s_DICT_SIZE = NEW_DICT_SIZE_SOC;
#endif

   for (us_DictIndex = 0; us_DictIndex <= s_DICT_SIZE; us_DictIndex += NEW_DICT_ENTRY_LENGTH )
   {

      // check group name
      if (us_CMVGroupName != NEW_CMV_Dictionary[us_DictIndex])
      {
         continue;                              /* Continue search. */
      }

      // check start address
      if (us_AddrField < NEW_CMV_Dictionary[us_DictIndex + 1])
      {
         continue;                              /* Continue search. */
      }

      // check end address
      if (us_AddrField > NEW_CMV_Dictionary[us_DictIndex + 2])
      {
         continue;                              /* Continue search. */
      }

      // check start offset
      if (us_OffsetField < NEW_CMV_Dictionary[us_DictIndex + 3])
      {
         continue;                              /* Continue search. */
      }

      // check end offset
      if (us_OffsetField > NEW_CMV_Dictionary[us_DictIndex + 4])
      {
         continue;                              /* Continue search. */
      }

      // check range on block operation
      if (NEW_CMV_Dictionary[us_DictIndex + 5] & INDIRECT_CMV_TYPE_MASK)
      {
         if ((us_Length + us_OffsetField) > NEW_CMV_Dictionary[us_DictIndex + 4])
         {
            break;         // illegal size for block operation; break out.
         }
      }
      else
      {
         if ((us_Length + us_AddrField) > NEW_CMV_Dictionary[us_DictIndex + 2])
         {
            break;         // illegal size for block operation; break out.
         }
      }

      /* Set candidate CMV Block Name type. */
      *pus_BlockNameType = NEW_CMV_Dictionary[us_DictIndex + 5];


      /* CMV dictionary entry matches, set read/write status, clear error indicator, and stop search. */
      *pus_ReadWriteStatus = NEW_CMV_Dictionary[us_DictIndex + 6];
      *pus_StartAddr = NEW_CMV_Dictionary[us_DictIndex + 1];

      MemoryAccessErrorType = 0;

      break;
   }


   return(MemoryAccessErrorType);
}  /* DecodeCMVBlockName */



/*^^^
 *----------------------------------------------------------------------------------
 *
 *      Prototype:
 *         int16  NewMPHandleMessage(int16 mailbox);
 *
 *      Abstract:
 *         This function receives the MP message and performs any required
 *         variabe access. This function also sends a response (ACK) message
 *         back to the sender. The hardware layer of the sender is handled
 *         in the hardware layer.
 *
 *      Input Parameters:
 *         int16 mailbox - Not used.
 *
 *      Returns:
 *         int16 :    TRUE   If a message was received which requires modem
 *                     intervention.
 *               FALSE   If no intervention is required
 *
 *      Notes:
 *
 *-------------------------------------------------------------------------------------
 ^^^*/
#define HMP_WORD2_HERCSOCBIT  (0x0080)


int16 NewMPHandleMessage(int16 dummy)
{
   // output
   uint16 ReturnOpcode;
   int16 OperationRequired;

   uint16 FunctionOpcode;
   uint16 us_Length, us_ReceivedPayloadSize, us_PayloadSizeFromLength;
   uint16 us_BlockNameType, us_ReadWriteStatus, us_StartAddr;
   uint16 us_AddrField, us_OffsetField, us_Group;
   uint16 us_BitSize, us_HercSocBit;
   uint32 l_addr_32bit = 0;
   int16 MemAccessError;
   void *p_Src = NULL, *p_Dst = NULL;

   // extract fields from RxMsg
   FunctionOpcode = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) & HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;
   us_BitSize = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_BITSIZE_SHIFT;
   us_ReceivedPayloadSize = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;
   us_Group = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 & HMP_WORD2_GROUP_MASK;
   us_AddrField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 >> HMP_WORD2_ADDRESS_SHIFT;
   us_HercSocBit = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 & HMP_WORD2_HERCSOCBIT) >> 7;
   us_OffsetField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;
   us_Length = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord4 & HMP_WORD4_LENGTH_MASK;
   us_Length = (us_Length << us_BitSize);      // in bytes
   us_PayloadSizeFromLength = (us_Length + 1)/2;

   // default outputs
   ReturnOpcode = FunctionOpcode ^ 1;   // Invert LSB of opcode to form default return opcode.
   OperationRequired = FALSE;


#ifdef HERC_API
   if ((!gft_ByPassCustomerMsgHandling) && ((FunctionOpcode == H2D_CMV_READ) || (FunctionOpcode == H2D_CMV_WRITE)) && ((us_Group & CUST_CMV_GROUP_BIT_MASK) == CUST_CMV_GROUP_BIT_MASK))
   {
      // CustomerHandleMessage() is responsible for setting guc_MPMsgReq and gs_MPReturnOpcode correctly.
      CustomerHandleMessage();
      return OperationRequired;
   }
#endif // HERC_API

   // clear the PayLoadSize in Rx buffer for either write command or invalid command
   HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 &= (~HMP_WORD1_SIZE_MASK);

   // validate message
   if ((us_PayloadSizeFromLength > HMP_MBOX_PAYLOAD_SIZE) || (us_BitSize > HMP_RW_DWORD_DATA))
   {
      ReturnOpcode = D2H_ERROR_ILLEGAL_PAYLOAD_SIZE;
      goto Finish;
   }

   if ((FunctionOpcode == H2D_CMV_READ) || (FunctionOpcode == H2D_CMV_WRITE))
   {
      /* Decode CMV Block Name & Offset; validate Offset is in range and determine read/write status. */
      MemAccessError = NewDecodeCMVBlockName(&us_BlockNameType,&us_ReadWriteStatus, &us_StartAddr, us_HercSocBit );
      /* If error found, send message to ME. */

      if ((MemAccessError > 0) || (us_BitSize != HMP_RW_WORD_DATA))
      {
         ReturnOpcode = D2H_ERROR_CMV_UNKNOWN;
      }
      else
      {

         int16 *CMVPtr;

         if (us_HercSocBit == 0)
            CMVPtr = (int16 *) NewCMVBlockNamePtr_HERC[(us_BlockNameType & ~INDIRECT_CMV_TYPE_MASK)];
         else
            CMVPtr = (int16 *) NewCMVBlockNamePtr_SOC[(us_BlockNameType & ~INDIRECT_CMV_TYPE_MASK)];

         if (us_BlockNameType & INDIRECT_CMV_TYPE_MASK)
         {


            if ((us_BlockNameType == NewSTAT_0_Type_HERC) && (us_HercSocBit == 0))
            {

               MapSocStatMacrosttoHerc();


               CMVPtr = (int16 *)(void *)&gt_HercADSL_STATMap_MacroState.s_Offset0;


            }
            else if ((us_BlockNameType == NewSTAT_1_Type_HERC)   && (us_HercSocBit == 0))
            {

               MapSocStatModetoHerc();


               CMVPtr = (int16 *) &gt_HercADSL_STATMap_ModeSelect.s_Offset0;
            }
            else if ((us_BlockNameType == NewSTAT_5_Type_HERC)  && (us_HercSocBit == 0))

            {
               MapSocStatFailtoHerc();


               CMVPtr = (int16 *)(void *)&gt_HercADSL_STATMap_FailureState.ul_ExceptionCode;

            }

            // OPTN cmvs
            else if ((us_BlockNameType == NewOPTN_0_Type_HERC)   && (us_HercSocBit == 0))
            {

               MapSocOptnModeCnttoHerc();



               CMVPtr = (int16 *) &gt_HercADSL_OPTNMap_ModeControl.s_Offset0;

            }

            else if ((us_BlockNameType == NewOPTN_2_Type_HERC)   && (us_HercSocBit == 0))
            {

               MapSocOptnAlgtoHerc();

               CMVPtr = (int16 *) &gt_HercADSL_OPTNMap_AlgControl.s_Offset0;
            }
            else if ((us_BlockNameType == NewRATEType_HERC) && (us_HercSocBit == 0) && (us_AddrField <= 1) )
            {
               MapSocOutputstoHercRate();

               if (us_AddrField==0)
                  CMVPtr = (int16 *)(void *)&gt_HercADSL_USRateCMV;
               else
                  CMVPtr = (int16 *)(void *)&gt_HercADSL_DSRateCMV;

            }
            //XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start)
            else if ((us_BlockNameType == NewCNTR_53_Type_HERC) && (us_HercSocBit == 0))
            {
               MapSocPLAMNETxCntrs();
               CMVPtr = (int16 *)(void *)&gt_g997_AtmPerf_TX_UICELL.ul_UCELL_P_count;
            }
            //XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (End)
            //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
            else if ((us_BlockNameType == NewCNTR_46_Type_HERC) && (us_HercSocBit == 0))
            {

               MapSocPLAMtoHercNEDPPerfCntrs();

               CMVPtr = (int16 *)(void *)&gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_HECp;
            }
            //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)
            else if ((us_BlockNameType == NewCNTR_45_Type_HERC) && (us_HercSocBit == 0))
            {

               MapSocPLAMtoHercPTMRxPerf();

               CMVPtr = (int16 *)(void *)&gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CRC_P_cnt;
            }

            //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
            else if ((us_BlockNameType == NewCNTR_51_Type_HERC) && (us_HercSocBit == 0))
            {

               MapSocPLAMtoHercFEDPPerfCntrs();

               CMVPtr = (int16 *)(void *)&gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount.l_HECp;
            }
            //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)
            else
            {
               if ( us_BlockNameType == NewAINFType) MapSocCNFGtoHercAINF(us_AddrField);
               // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
               else if ( us_BlockNameType == NewCNTRType) MapSocPLAMtoHercCNTR(us_AddrField);
               // XDSLRTFW-575: Counter Write back in ADSL mode (End)
               else if (us_BlockNameType == NewINFOType_HERC) MapSocINFOtoHercINFO();

               // If indirect reference, we have a table of pointers.
               CMVPtr = (int16 *)(void *)(((int16 **)(void *)CMVPtr) + us_AddrField - us_StartAddr);
               CMVPtr = *(int16 **)(void *)CMVPtr;

               if (CMVPtr == NULL)
               {
                  // This address entry not loaded yet, clear out size and return error.
                  ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
                  goto Finish;
               }
            }

            CMVPtr = CMVPtr + us_OffsetField;
         }
         else
         {
            CMVPtr += us_AddrField;
         }
         l_addr_32bit = (int32)CMVPtr;
      }
   }
   else
   {
      l_addr_32bit = (((uint32)HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2) << 16) | HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;
   }


   switch(FunctionOpcode)
   {
      case H2D_CMV_READ:
         if (us_ReadWriteStatus == WRITE_ACCESS)
         {
            /* If BlockName.Offset is WRITE-ONLY, then send message to ME. */
            ReturnOpcode = D2H_ERROR_CMV_WRITE_ONLY;
         }
         // intentionally fall thru

      case H2D_DEBUG_READ_DM:
      case H2D_DEBUG_READ_PM:
         if (us_ReceivedPayloadSize !=  0)
         {
            ReturnOpcode = D2H_ERROR_CMV_UNKNOWN;
         }
         else
         {
            p_Src = (void *)l_addr_32bit;
            p_Dst = (void *)(&HMP_RxBuffer.usa_HmpPayLoad[0]);
            HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 |= us_PayloadSizeFromLength;
         }
         break;

         /* =================================================================   */
         /*                                                      */
         /* CMV WRITE                                             */
         /*                                                      */
         /* =================================================================   */

      case H2D_CMV_WRITE:
         if (us_ReadWriteStatus == READ_ACCESS)
         {
            /* If BlockName.Offset is READ-ONLY, then send message to ME. */
            ReturnOpcode = D2H_ERROR_CMV_READ_ONLY;
         }
         /* Set variable to signal the modem application */
         else if ((us_BlockNameType == NewCNTLType) &&  (us_AddrField <= CNTL_ModemModeSwitch))
         {
            OperationRequired = 1 + us_AddrField;       // potentially if msg is valid
         }
         // intentionally fall thru

      case H2D_DEBUG_WRITE_DM:
      case H2D_DEBUG_WRITE_PM:
         if (us_PayloadSizeFromLength !=  us_ReceivedPayloadSize)
         {
            ReturnOpcode = D2H_ERROR_ILLEGAL_PAYLOAD_SIZE;
            OperationRequired = FALSE;       // undo setting from previous step
         }
         else
         {
            p_Src = (void *)(&HMP_RxBuffer.usa_HmpPayLoad[0]);
            p_Dst = (void *)l_addr_32bit;
         }
         break;

      default:
         ReturnOpcode = D2H_ERROR_OPCODE_UNKNOWN;
         break;
   }  /* switch (FunctionOpcode) */

   // payload handling
   if (ReturnOpcode == (FunctionOpcode^1))
      // If no error, then read/write data
   {
      if (us_Length > 0)
      {
         memcpy(p_Dst, p_Src, us_Length);
      }

   }

   if ((FunctionOpcode == H2D_CMV_WRITE) && (us_HercSocBit == 0))
   {
      // CMV write
      if (us_BlockNameType == NewOPTN_0_Type_HERC)
      {
         MapHercOptnModetoSOC();

      }
      else if (us_BlockNameType == NewOPTN_2_Type_HERC)
      {
         MapHercOptnAlgtoSOC();

      }
      //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
      else if (us_BlockNameType == NewOPTN_15_Type_HERC)
      {
         MapHercOptnOlrtoSOC();

      }
      //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)
      //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start)
      else if (us_BlockNameType == NewOPTN_28_Type_HERC)
      {
         MapHercOptnMarginDeltatoSOC();

      }
      // XDSLRTFW-1481 (Start_End)
      else if ((us_BlockNameType == NewCNTR_45_Type_HERC) || (us_BlockNameType == NewCNTR_46_Type_HERC) || (us_BlockNameType == NewCNTR_53_Type_HERC))
      {
         MapHercCNTRtoSOCPLAM(us_AddrField);

      }
      //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (end)
      // XDSLRTFW-425 IOP_ALL_DS_ALL_NECNTR_CMVWrite(Start)
      else if (us_BlockNameType == NewCNTRType)
      {
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start_End)
         // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
         MapHercCNTRtoSOCPLAM(us_AddrField);  //Removed CMV control to call this function. CMV (DSL 19 0) control is moved inside this function.
         // XDSLRTFW-575: Counter Write back in ADSL mode (End)
      }
      // XDSLRTFW-425 IOP_ALL_DS_ALL_NECNTR_CMVWrite(End)
      else if  ((us_BlockNameType == NewCNFG_0_Type_HERC)|| (us_BlockNameType == NewCNFG_1_Type_HERC) || (us_BlockNameType == NewCNFG_2_Type_HERC) || (us_BlockNameType == NewCNFG_3_Type_HERC))
      {
         MapHercCNFGtoSOC();
      }
      else if (us_BlockNameType == NewMONIType)
      {
         MapHERCMonitoSocOPTN();

      }
      //XDSLRTFW-3705 (Start)
      //Special handling for DSL 4 - AFE Read, AFE Write
      else if (us_BlockNameType == NewDSL_4_Type_HERC)
      {
         uint16 us_AfeRegAddr, us_AfeRegData, us_FcsiInterface, us_DummyParam;

         //AFERegAddr format -> Refer to "CMD_DBG_AFE_Read" in MCAT ver 3.1 or above
         //  AFERegAddr[15:14] -> FCSI Selector; Selects one of the Full Custom Serial Interfaces (FCSI) in VRX51x.
         //    Bit#15  Bit#14   Description
         //      0       0       FCSI_NO Value for VRX318/VR218 AFE (mentioned just for information here)
         //      0       1       FCSI_CENTRAL: FCSI-IF to AFE for control path in VRX51x
         //      1       0       FCSI_DSL: FCSI-IF to AFE for data path in VRX51x
         //  AFERegAddr[13:0]  -> AFE register address
         us_AfeRegAddr = gt_AFEConfig.us_AFERegAddr;

         us_FcsiInterface  = ((us_AfeRegAddr & 0xC000) >> 14);
         if (us_FcsiInterface == (FCSI_DSL | FCSI_CENTRAL))
         {
            us_FcsiInterface = 0;
         }

         if (us_FcsiInterface != 0)
         {
            HMP_RxBuffer.usa_HmpPayLoad[0] = us_AfeRegAddr;

            //Mask out Bit#15  Bit#14 of AFE Reg address
            us_AfeRegAddr = (us_AfeRegAddr & 0x3FFF);
            if (gt_AFEConfig.us_AFERegOp == AFE_REG_RD_OP)
            {
               us_AfeRegData = VRX5AFE_FCSI_READ(us_FcsiInterface, us_AfeRegAddr, &us_DummyParam);

               HMP_RxBuffer.usa_HmpPayLoad[1] = us_AfeRegData ;

               HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 |= 2;
            }
            else if (gt_AFEConfig.us_AFERegOp == AFE_REG_WR_OP)
            {
               VRX5AFE_FCSI_WRITE(us_FcsiInterface, us_AfeRegAddr, gt_AFEConfig.us_AFERegData);
            }
         }
      }
      //XDSLRTFW-3705 (End)
   }



   // We always send an acknowledgement.
   // Set flag in gs_TxMailboxState to notify ProcessTxMailbox function that an
   // MP message is ready to go out, and
   // use global variable to pass ReturnOpcode to the ProcessTxMailbox function.
   //
Finish:
   gs_MPReturnOpcode = ReturnOpcode;
   guc_MPMsgReq = 1;

   return OperationRequired;
}  /* NewMPHandleMessage */



// modulo increment
int16 IncrMsgQueueIndex(int16 s_Index)
{
   if (++s_Index >= AUTO_MSG_QUEUE_LENGTH)
   {
      return(0);
   }
   else
   {
      return(s_Index);
   }
}


/*^^^
 *----------------------------------------------------------------------------------
 *
 *      Prototype:
 *         int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0
 *               uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4)
 *
 *      Abstract:
 *
 *      Input Parameters:
 *
 *      Returns:
 *
 *      Notes:
 *
 *-------------------------------------------------------------------------------------
 ^^^*/

// return QUEUE_ADDED or QUEUE_FULL
// Important!!!
// pt_PayLoadEntry->pus_PayLoad must contain address of a global or static global
// payload buffer if there is data in the payload. The reason is that
// the payload buffer has to exist at the time this queue entry being served
// by the GetNextAutoMsgQueueEntry() and then ProcessTxMailbox().

void disable1_save(uint32 *pul_stat);
void restore1_save(uint32 ul_stat);

int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0,
      uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4)

{
   int16 s_CurWriteIndex, s_NewWriteIndex;
   int16 s_ReturnCode;
   uint32 ul_IntrStat;

   //_disable1();
   disable1_save(&ul_IntrStat);

   s_CurWriteIndex = gt_AutoMsgQueue.s_AutoMsgWriteIndex;
   s_NewWriteIndex = IncrMsgQueueIndex(s_CurWriteIndex);

   if (gt_AutoMsgQueue.s_AutoMsgReadIndex != s_NewWriteIndex)
   {
      // add new message to queue
      //gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader = *pt_MsgHeader;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMboxCode = us_MailboxCode;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord0 = us_MsgWord0;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord1 = us_MsgWord1;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord2 = us_MsgWord2;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord3 = us_MsgWord3;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord4 = us_MsgWord4;

      // modify the payload to prevent over-writing of payload data
      pt_PayLoadEntry->uc_PayLoadSent = 0;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].pt_PayLoadEntry = pt_PayLoadEntry;

      gt_AutoMsgQueue.s_AutoMsgWriteIndex = s_NewWriteIndex;
      s_ReturnCode = AUTO_MSG_QUEUE_OPERATION_SUCCESS;

   }
   else
   {
      s_ReturnCode = AUTO_MSG_QUEUE_FULL;
   }
   //_enable1();
   restore1_save(ul_IntrStat);
   return(s_ReturnCode);
}

int16 GetNextAutoMsgQueueEntry(AutoMsgQueueEntry_t *pt_NewAutoMsg)
{
   int16 s_ReadIndex;
   int16 s_ReturnCode;
   uint32 ul_IntrStat;


   //_disable1();
   disable1_save(&ul_IntrStat);

   s_ReadIndex = gt_AutoMsgQueue.s_AutoMsgReadIndex;

   if (s_ReadIndex != gt_AutoMsgQueue.s_AutoMsgWriteIndex)
   {
      pt_NewAutoMsg->t_MsgHeader = gt_AutoMsgQueue.ta_AutoMsgArray[s_ReadIndex].t_MsgHeader;
      pt_NewAutoMsg->pt_PayLoadEntry = gt_AutoMsgQueue.ta_AutoMsgArray[s_ReadIndex].pt_PayLoadEntry;
      gt_AutoMsgQueue.s_AutoMsgReadIndex = IncrMsgQueueIndex(s_ReadIndex);
      s_ReturnCode = AUTO_MSG_QUEUE_OPERATION_SUCCESS;
   }
   else
   {
      s_ReturnCode = AUTO_MSG_QUEUE_EMPTY;
   }

   //_enable1();
   restore1_save(ul_IntrStat);
   return(s_ReturnCode);
}
#ifndef ADSL_62
void SendCodeSwapRequest(void)
{
   int32 l_temp,l_temp2;

   //-------------------------------------
   // if Codeswap is via ME
   //-------------------------------------
   // clear the CS_DONE bit
   _sr(ARC_INT_CS_DONE_MASK, ARC_INT_STAT_ADDR); // clear it by writing 1

   // set up mbox code
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMboxCode = CODE_SWAP_REQUEST;

   // set up codeswap message body
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 = CODESWAP_MSG_WORD_0;
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord1 = CODESWAP_MSG_WORD_1;
   // word_2 and word_3 not really need to be programmed, but just for clarity
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord2 = CODESWAP_MSG_WORD_2;
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord3 = CODESWAP_MSG_WORD_3;
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord4 = CODESWAP_MSG_WORD_4;

   __gt_Arc2MeMboxMsg.usa_HmpPayLoad[0] = gs_CodeSwapSection;

   // notify MEI of codeswap request by asserting the ARC->MEI mailbox message interrupt
   SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);

   // indicate that the codeswap request message has been sent
   guc_CodeSwapMsgReq = CODESWAP_REQUEST_SENT;
}
#endif



#ifndef ADSL_62
FlagT CheckForCodeSwapDone(void)
{
   int32 l_data;

   if (guc_CodeSwapMsgReq == CODESWAP_REQUEST_SENT)
   {
#ifdef ADSL_50
      // check if the MEI has finished handling a codeswap page
      l_data = GetDspReg(ARC_INT_STAT_ADDR);

      if(l_data & ARC_INT_CS_DONE_MASK)
      {
         // CS completed. Clear status bit
         SetDspReg(ARC_INT_STAT_ADDR, ARC_INT_CS_DONE_MASK); // clear it by writing 1

         return(TRUE);
      }
#endif

   }

   return(FALSE);
}
#endif

#ifdef DEBUG_STREAMING
uint16 NMP_IsDebugMsgPending(void)
{
   return gt_DebugStreamMsg.us_DbgStreamLength;
}

int32 NMP_SendDebugMsg(uint16 us_StreamId, uint32 ul_SymCount, uint16 us_Crc16, uint16 us_StreamStatus, uint16 us_Length, uint16 * us_pPayload)
{

    gt_DebugStreamMsg.us_DbgStreamId          = us_StreamId;
    gt_DebugStreamMsg.us_DbgStreamSymCnt      = ul_SymCount;
    gt_DebugStreamMsg.us_DbgStreamCrc16       = us_Crc16;
    gt_DebugStreamMsg.us_DbgStreamStatus      = us_StreamStatus;
    gt_DebugStreamMsg.us_DbgStreamLength      = us_Length;
    gt_DebugStreamMsg.pus_DbgStreamPayload    = us_pPayload;

    // XDSLRTFW-2701 The check to avoid E_CODE_BKGD_FIFO_ADD_EXCEPTION is done in the calling function
    AddFunctionToBkgdFifo((PtrToBkgdFunc)NMP_BgService) ;

    return 0;
}

void NMP_BgService(void)
{
   uint32 ul_int_status;
   // first check if we have a debug stream message pending
   if(NMP_IsDebugMsgPending())
   {
      // avoid that gackground task 'mail box check' gets interrupted by foreground and we get corrupted messages in mail box
      disable1_save(&ul_int_status);
      // then check if mailbox is available (previous outgoing message already served)
      if (TxMailBoxPending() == TRUE)
      {
         //busy try again later
          gus_RequeueBGFunction |= DSH_REQUEUE_NMP_BG_SERVICE;
          gus_Dbg_RequeueCnt++;
      }
      else
      {
         uint16 us_Length = gt_DebugStreamMsg.us_DbgStreamLength;

         // Mailbox header
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMboxCode = AUTONOMOUS_MSG_EVENT;                        // Mailbox code
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 =(0x4000) | (D2H_CMV_READ_REPLY << HMP_WORD0_OPCODE_SHIFT);    // Functional code
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord1 = (uint16)((us_Length + 12) >> 1);             // length of payload in 16bit words

         // Message Header
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord2 = AUTO_MSG_INF118_HEADER_2 ;                   // MessageId
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord3 = AUTO_MSG_INF118_HEADER_3 ;                   // Offset
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord4 = (uint16)((us_Length + 12) >> 1);             // Length of payload in 16bit words

         // Debug Stream
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[0] = (uint16)((us_Length+10));   // Length of following bytes (debug stream +10 header bytes)

         // Debug Stream Header (10byte)
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[1] = gt_DebugStreamMsg.us_DbgStreamId;
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[2] = gt_DebugStreamMsg.us_DbgStreamStatus;
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[3] = (uint16)(gt_DebugStreamMsg.us_DbgStreamSymCnt);
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[4] = (uint16)(gt_DebugStreamMsg.us_DbgStreamSymCnt >> 16);
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[5] = gt_DebugStreamMsg.us_DbgStreamCrc16;

         memcpy(&__gt_Arc2MeMboxMsg.usa_HmpPayLoad[6], gt_DebugStreamMsg.pus_DbgStreamPayload, us_Length);

         SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);    // set the mailbox interrupt
         gt_DebugStreamMsg.us_DbgStreamLength      = 0;
      }
      // restore interrupts
      restore1_save(ul_int_status);
   }
}
#endif

