/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*-------------------------------------------------------------------
*/


/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "common.h"
#include "hmp_data.h"
#include "hmp_funcs.h"
#include "aux_regs.h"
#include "string.h"


#define NEWMP_SIZE      (16)
   /* Message Types */
   #define NEWMP_PAYLOAD_SIZE      (12)

   typedef struct {
      int16 FunctionOpcodeAndSize;
      int16 GroupField;
      int16 AddrField;
      int16 IndexField;
      int16 PayLoad[NEWMP_PAYLOAD_SIZE];
   } NewMPStruct;
NewMPStruct NewMPRxBuffer;             /* Highest Level RX buffer */
NewMPStruct NewMPTxBuffer;             /* Highest Level TX buffer */

int16 *NewMPRxArray = (int16 *)(void *)&NewMPRxBuffer;   /* RX buffer pointer */



#ifndef ADSL_62
void FastReadInit(void)
{
   HMP_FastReadBuffer.t_MsgHeader.us_HmpMboxCode = FAST_READ_REQUEST;
   HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord0 = HMP_RW_WORD_DATA << HMP_WORD0_BITSIZE_SHIFT;
   HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord1 = 0;
   HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord2 = 0;
   HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord3 = 0;
   HMP_FastReadBuffer.t_MsgHeader.us_HmpMsgWord4 = 0;
}
#endif

/*^^^
*-------------------------------------------------------------------------------------
*
*     Function name: NewMPInitialize
*
*     Abstract:
*        This function initializes all hardware and required variables
*        for the specified MP source.
*
*       Parameters:     None
*
*       Returns:
*        int   :  Returns TRUE if initialization successful, else
*              FALSE is returned.
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/

int16 NewMPInitialize(void)
{

   // might not be really needed
   // clear the status register for the Rx Message
   _sr(ARC_INT_MSGAV_MASK, ARC_INT_STAT_ADDR);            // no pending message from MEI to ARC

    // set up HMP_HEADER
    __gt_HmpHeader.us_HmpHeaderWord0 = (0x1 << 8) | HMP_VERSION;  //  1 mbox pair and version
    __gt_HmpHeader.us_HmpHeaderWord1 = (0x1 << 8) | HMP_DESC_SIZE;  //  1 mbox pair and version

   // set up first descriptor
   __gta_HmpMboxDescriptor[0].pl_Arc2MeMboxStart = (int32 *)(void *)&__gs_Arc2MeMboxCode;
   __gta_HmpMboxDescriptor[0].l_Arc2MeMboxLength = HMP_MBOX_SIZE; // num of 16-bit words
   __gta_HmpMboxDescriptor[0].pl_Me2ArcMboxStart = (int32 *)(void *)&__gs_Me2ArcMboxCode;
   __gta_HmpMboxDescriptor[0].l_Me2ArcMboxLength = HMP_MBOX_SIZE; // num of 16-bit words

    // set up HMP descriptor

   memset( (int8 *)(void *)&__gs_Me2ArcMboxCode, 0, 2*HMP_MBOX_SIZE);
   memset( (int8 *)(void *)&__gs_Arc2MeMboxCode, 0, 2*HMP_MBOX_SIZE);
#ifndef ADSL_62
   FastReadInit();
#endif
   return(1);
}


/*^^^
*-------------------------------------------------------------------
*
*     Prototype:
*        void SetupModemReadyMessage(void)
*
*     Abstract:
*        This function prepares the MP Ready Message, which is
*     autonomously transmitted to the ME following reset as an indication
*     that the modem is ready to accept MP messages.
*
*        Most fields in the MP Modem Ready field are "don't care".  The
*     length is set to 1, the opcode is set to Modem Ready, and the rest
*     of the message is 0.
*
*       Parameters:
*           None
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
void NewMPSetupReadyMessage(void)
#ifdef ADSL_62
{

    gus_BootupResultCode = 0x0;    // successful, no errors.

   /* set size field to 1, FunctionOpcode to D2H_AUTONOMOUS_MODEM_READY_MSG */
   gt_ModemReadyPayLoad.uc_PayLoadLength = 1;
   gt_ModemReadyPayLoad.uc_PayLoadSent = 0;
   gt_ModemReadyPayLoad.pus_PayLoad= &gus_BootupResultCode;

   SubmitAutoMsg(&gt_ModemReadyPayLoad, AUTONOMOUS_MSG_EVENT, MODEM_READY_HEADER_0, MODEM_READY_HEADER_1,
            MODEM_READY_HEADER_2, MODEM_READY_HEADER_3, MODEM_READY_HEADER_4);
}
#else
{
   int16 j;

   /* set size field to 1, other fields to 0 */
   NewMPRxArray[0] = 1;
   for (j=1; j<NEWMP_SIZE; j++)
      NewMPRxArray[j] = 0;

   /* set opcode */

   if (gft_AC_CLK_NotEnabled == TRUE)
   {
      // If AC_CLK is not enabled by network processor, send a unique code in the CMV group name
      NewMPRxArray[1]  = AC_CLK_NOT_ENABLED_MSG;
   }

   gs_MPReturnOpcode = D2H_AUTONOMOUS_MODEM_READY_MSG;

   /* set flag to notify ProcessTxMailbox message */
   guc_MPMsgReq = 1;

}
#endif
