;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        interrupts_62.s
;
; DESCRIPTION:     This file includes
;                  1. interrupt vector table
;                  2. asm ISRs for all interrupts. These routines will
;                     call c_interrupt_handlers if needed.
;
;*************************************************************************

#define IN_ASM

.include "asm.h"

#ifdef ADSL_62
    .include "interrupts_62.h"
#else
    .include "interrupts.h"
#endif

#include "dsp_regs_62.h"
#include "cri_memmap.h"
#ifdef ADSL_62
    #include "compiler.h"
#else
    #include "vdsl_compiler.h"
#endif

#ifdef TARGET_SIM
    #include "vr9_memorymap.h"
#endif


;**********************************************************
;   interrupt vector table
;**********************************************************

    .file "interrups_62.s"

    .equ    E1_BIT_IN_STATUS32,   0x0002

    .extern gs_FGActive                       ;in paged memory
    .extern gs_FGPending                      ;in paged memory

    .extern MasterIntHandler
    .extern main
    .extern ForegroundHandler
    .extern guc_PortMode
    .extern gl_CurrentStackPointer
    .extern gl_BgDuration
    .extern gl_MaxBgDuration
    .extern HwResetInit

    .global hw_reset_isr

    .global hw_reset
    .global reset
    .global mem_except
    .global instr_err
    .global ivect3          ; not connected
    .global ivect4          ; not connected
    .global ivect5          ; ME_MSG
    .global ivect6          ; ADMA
    .global ivect7          ; XDMA

                            ; note that xdsl0 & xdsl1 are "renamed" xdsl1 & xdsl2 so FW stays unchanged
    .global ivect8          ; xdsl_1_port0
    .global ivect9          ; xdsl_2_port0; not used
    .global ivectA          ; xdsl_1_port1
    .global ivectB          ; xdsl_2_port1; not used
    .global ivectC          ; ME_GP_0
    .global ivectD          ; ME_GP_1
    .global ivectE          ; GPIO14_INT; connected to pin14
    .global ivectF          ; GPIO15_INT; connected to pin15

    .global xDSL1_port0_Handler
    .global xDSL1_port1_Handler


    .global invalid_int_isr
    .global reserved_int_isr


;    .text
    .section .INTVECS, text
    .align 4

reset:
hw_reset:      j hw_reset_isr
mem_except:    j mem_except_isr          ; MEMEX
instr_err:     j instr_err_isr           ; INSTERR
ivect3:        j invalid_int_isr         ; not connected
ivect4:        j invalid_int_isr         ; not connected
ivect5:        j invalid_int_isr         ; ME_MSG
ivect6:        j invalid_int_isr         ; ADMA
ivect7:        j invalid_int_isr         ; XDMA

ivect8:        j xDSL1_port0_Handler     ; xdsl_1_port0
ivect9:        j invalid_int_isr         ; xdsl_2_port0; not used

ivectA:        j xDSL1_port1_Handler     ; xdsl_1_port1
ivectB:        j invalid_int_isr         ; xdsl_2_port1; not used

ivectC:        j invalid_int_isr         ; ME_GP_0
ivectD:        j invalid_int_isr         ; ME_GP_1
ivectE:        j invalid_int_isr         ; GPIO14_INT; connected to pin14
ivectF:        j invalid_int_isr         ; GPIO15_INT; connected to pin15


.extern gt_ExceptionInfo
.extern gl_other_exception
.extern gl_mem_except
.extern gl_instr_err

   .data
   .align   4
gl_Dummy:               ; used by ISR
   .block   0x4

    .section .BG_CACHE_1, text

// for bad exceptions, the code eventually will be written to:
// 1. disable interrupts
// 2. lock the processor in infinite loop while still providing
//    MP message handling.

reserved_int_isr:
invalid_int_isr:
        mov r1, gl_other_exception
        b isr_exception_log



mem_except_isr:
        mov r1, gl_mem_except
        b isr_exception_log

instr_err_isr:
        mov r1, gl_instr_err


isr_exception_log:
        mov r2, gt_ExceptionInfo
        st ilink1, [r2, 0]
        st ilink2, [r2, 4]
        st blink,  [r2, 8]
        lr r4, [status32]
        st r4,     [r2, 0xC]
        lr r4, [status32_l1]
        st r4,     [r2, 0x10]
        lr r4, [status32_l2]
        st r4,     [r2, 0x14]

        st sp,     [r2, 0x18]


err_isr_loop2:
        add r0, r0, 1
        st r0, [r1]
        j err_isr_loop2


//**********************************************
//*********** ASM ISRs *************************
//**********************************************


;**********************************************************
;   Hardware Reset
;**********************************************************


    .section .BG_CACHE_1, text
    .weak    _SDA_BASE_

    .type    hw_reset_isr, @function
    .align 4

hw_reset_isr:

    flag    0                       ; disable all interrupts; redundant to be safe

    ; init XY base registers (in aux space)
    .equ XY_LS_BASE_X, 0x00030000
    .equ XY_LS_BASE_Y, 0x00034000

    mov r0, XY_LS_BASE_X
    sr r0, [xylsbasex]
    mov r0, XY_LS_BASE_Y
    sr r0, [xylsbasey]

    ; setting INT_VECTOR_BASE just in case driver/loader mess it up.
    xor_s r0, r0, r0
    sr r0, [INT_VECTOR_BASE]

    mov    sp, _estack              ; initialize stack pointer to end of .stack section
    mov    gp, _SDA_BASE_           ; initialize small-data base register
    mov    fp, 0

    xor r13, r13, r13   ; r13 = 0
    mov r14, 1          ; r14 = 1
    neg r15, r14        ; r15 = 0xFFFF_FFFF
    mov r16, CRI_PORT_MODE_ADDR
    mov r17, DSP_PORT_SEL
    mov r19, DSP_INT_MASK_XDSL1_PORT0_MASK

    st r13, [CRI_CCR_ADDR]           ; enable clocks for all cores
    st r15, [CRI_RST_ADDR]           ; completely reset all xdsl cores thru CRI_RST
    st r15, [DSP_INT_STAT]           ; clearing DSP_INT_STAT
    st r13, [CRI_RST_ADDR]           ; re-enable all xdsl cores thru CRI_RST
    st  r0, [CRI_TSC_CTRL_ADDR]

    ; check PortMode
;    mov_s r1, gt_PortModeControl
;    ldb_s r1, [r1, 6]
    mov r18, r13

    ldb r1, [gt_PortModeControl + 6]
    bbit0 r1, 0, hw_isr_init_port0

hw_isr_init_port1:
    ; dual port mode; we init port1 first
    mov r18, r15
    st r18, [r16]     ; dual port mode

    st DSP_PORT_1_SEL_MASK, [r17]   ; set DSP_PORT_SEL to port1
    st DSP_PORT_1_SEL_MASK, [r17]   ; make sure previous write done

    ; call HwReset(1, sp)
    mov_s r0, 1
    mov   r1, sp

    jl    HwResetInit

    mov r19, DSP_INT_MASK_XDSL1_2PORT_MASK

    ; clear existing CRI_STAT for port1
    mov r2, -1
    st r2, [CRI_STATUS0_ADDR]

hw_isr_init_port0:
    ; set DSP_PORT_SEL and CRI_PORT_MODE to single-port/port0
    ; init CRI regs on port0
    st r19, [DSP_INT_MASK]
    st r18, [r16]
    st DSP_PORT_0_SEL_MASK, [r17]   ; set DSP_PORT_SEL to port0
    st DSP_PORT_0_SEL_MASK, [r17]   ; make sure previous write done

    ; call HwReset(0, sp)
    xor_s r0, r0, r0    ; port-0
    mov   r1, sp

    jl    HwResetInit

    ; clear existing CRI_STAT for port0
    mov r2, -1
    st r2, [CRI_STATUS0_ADDR]

    ; read CRI_TSC_CTRL_ADDR and enable TSC_CTRL_ENABLE bit-31
    ld r2, [CRI_TSC_CTRL_ADDR]
    bset r2, r2, 31
    st r2, [CRI_TSC_CTRL_ADDR]

    flag    2                       ; enable E1 interrupts for XDSL1

#ifdef TARGET_SIM
    mov r2, CLOCK_CORES_OVERRIDE
    st r2, [SIMEXT_CLOCK_CORE_MODE]
#endif

hw_reset_isr_loop:
    ; waiting for interrupts
    nop
    b_s hw_reset_isr_loop


    .global    _exit_halt
    .type    _exit_halt, @function
    .align 4

_exit_halt:
    flag    0x01                    ; halt the processor
    nop

    ; weak versions of small data symbols normally defined by the linker.
    .weak _fsbss
    .weak _esbss
    .set _fsbss,0
    .set _esbss,0

    ; weak versions of heap section boundaries.  If a .heap section
    ; is provided, our low-level allocator "sbrk" allocates within it.
    ; If no .heap is provided, we allocate from _end to the end of memory.
    .weak _fheap
    .weak _eheap
    .set _fheap,0
    .set _eheap,0

;------------------------------------------------------------------------
;
;  Name :
;
;  Description:
;        the ADSL ASM interrupt handler which will save processor context
;       and call the C interrupt dispatcher.
;
;  Prototype:
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Notes:
;
;------------------------------------------------------------------------


    .text

    .type    xDSL1_port0_Handler, @function
    .align 4

xDSL1_port0_Handler:
    sub sp, sp, ISR_FPSIZE              ; allocate stack space ;
    st_s  r0, [sp, r0_offset]

    mov_s r0, DSP_PORT_0_SEL_MASK
    b_s xDSL1_Handler

    .type    xDSL1_port1_Handler, @function
    .align 4

xDSL1_port1_Handler:
    sub      sp, sp, ISR_FPSIZE              ; allocate stack space ;
    st_s  r0, [sp, r0_offset]

    mov_s r0, DSP_PORT_1_SEL_MASK
;    b_s xDSL1_Handler


xDSL1_Handler:
    ; ==================== ;
    ; save registers
    ; ==================== ;

;    normally, r12-25 will be saved by the callee functions; however, for multiport operation
;    the complete context have to be saved when switching between ports.
;
;   .irep the_reg, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
;                 r11, r12, fp, blink, ilink1, lp_count
;       st       the_reg, [sp, the_reg\&_offset]
;   .endr
;
;   note that r0 has already been saved upon entering ISR

    .irep the_reg, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
                   r11, r12, r13, r14, r15, r16, r17, r18, r19, r20, r21, r22,r23, r24, r25, \\
                   fp, gp, blink, ilink1, lp_count
        st       the_reg, [sp, the_reg\&_offset]
    .endr

    ; reset timer used for profiling and detecting of realtime exception.
    ; more code added once decide which timer will be used for this purpose

    ; ==================== ;
    ; save aux regs
    ; ==================== ;
    lr      r12, [lp_start]
    st      r12, [sp, lp_start_offset]
    lr      r12, [lp_end]
    st      r12, [sp, lp_end_offset]

    ; =============================== ;
    ; saving XMAC registers
    ; =============================== ;

    .irep the_reg, acc1, acc2
        st      the_reg, [sp, the_reg\&_offset]
    .endr

    .irep the_reg, ax0, ax1, ay0, ay1, ay2, mx00, mx01, mx10, mx11, my00, my01, my10, my11, my20, my21, aux_xmac0, \\
        aux_xmac1, aux_xmac2, xyconfig, aux_macmode, status32_l1
        lr      r12, [the_reg]
        st      r12, [sp, the_reg\&_offset]
    .endr


    ; ==================== ;
    ; ARC DMA engine registers
    ; Since ARC DMA can only be preformed in the TC tasks which in not interruptible,
    ; there is no needs to save/restore its context
    ; ==================== ;

    ; clear lp_end to prevent unwanted hw loops due to overlay of PMs.
    sr      0, [lp_end]

    ; save current stack pointer to gl_CurrentStackPointer
    st sp, [gl_CurrentStackPointer]
    st r0, [gl_Dummy]                   ; make sure write to gl_CurrentStackPointer is done

    ; set bank select register
    st r0, [DSP_PORT_SEL]
    st r0, [DSP_PORT_SEL]               ; make sure previous setting of DSP_PORT_SEL done

    ; get new stack pointer
    ld sp, [gl_CurrentStackPointer]


    ; clear CRI stat
    mov r2, CRI_MASK_RX_TSC_INT
    st r2, [CRI_STATUS0_ADDR]

    ; clear DSP_INT_STAT
    mov r2, DSP_INT_MASK_XDSL1_2PORT_MASK
    st r2, [DSP_INT_STAT]

    ;********************************************************************************
    ; check to spawn MAIN BG thread on the first interrupt of the interrupted port
    ;********************************************************************************

    mov r1, guc_KernelState
    ldb r2, [r1]
    bbit1 r2, 0, isr_cont_run_MasterIntHandler

    ; set sp for this new thread
    mov    sp, _estack                 ; initialize stack pointer to end of .stack section

    mov_s r2, 1
    stb r2, [r1]                       ; set guc_KernelState that port-thread has been created
    mov_s r2, gt_PortModeControl
    st  r0, [r2, 16]                ; set ul_BgPortSelRegValue
    ldb  r1, [r2, 21]               ; get ul_MaxBgDuration
    stb  r1, [r2, 22]               ; set ul_BgDuration


    mov ilink1, main            ; for the very first interrupt on each port, the port will
    j.f [ilink1]                ; start main() as the BG thread
    ; never return here

isr_cont_run_MasterIntHandler:

    ; ==================== ;
    ; handle the interrupt ;
    ; ==================== ;

    jl      MasterIntHandler        ; ForeGroundHandler will be called from MasterIntHandler

    ; figure out which port`s background will be resumed before restoring regs
    mov_s r1, gt_PortModeControl
    ldb_s r2, [r1, 6]               ; read uc_PortMode
    bbit0 r2, 0, isr_cont_single_port_mode

isr_cont_dual_port_mode:
    ldb_s r3, [r1, 21]              ; reading uc_BgDuration
    ld_s r0, [r1, 16]               ; get ul_BgPortSelRegValue
    sub.f r3, r3, 1
    b_s.gt isr_cont_prev_BG

    ; swith BG to the other port
    ldb_s r3, [r1, 22]                ; load uc_MaxBgDuration to r3
    xor  r0, r0, DSP_PORT_0_SEL_MASK^DSP_PORT_1_SEL_MASK     ; toggle port selection
    st_s r0, [r1, 16]                 ; updating ul_BgPortSelRegValue

isr_cont_prev_BG:
    stb_s r3, [r1, 21]                ; updating uc_BgDuration
    st r3, [gl_Dummy]                 ; make sure write to uc_BgDuration is done

    ; set DSP_PORT_SEL to the desired port
    st r0, [DSP_PORT_SEL]
    st r0, [DSP_PORT_SEL]               ; make sure previous setting of DSP_PORT_SEL done

    ld sp, [gl_CurrentStackPointer]   ; set stack pointer to the desired port stack


isr_cont_single_port_mode:
    ; =============================== ;
    ; restoring XMAC registers
    ; =============================== ;
    .irep the_reg, acc1, acc2
        ld      r12, [sp, the_reg\&_offset]
        mov the_reg, r12
    .endr

    ; note that aux_xmac0 (the extension register) must be restored after aux_xmac1 and aux_xmac2
    .irep the_reg, ax0, ax1, ay0, ay1, ay2, mx00, mx01, mx10, mx11, my00, my01, my10, my11, my20, my21, aux_xmac1, \\
                   aux_xmac2, aux_xmac0, xyconfig, aux_macmode, status32_l1
        ld      r12, [sp, the_reg\&_offset]
        sr      r12, [the_reg]
    .endr


    ; delay restoring of r12 to the end since r12 being used as a scratch reg now.
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
                   r11, r13, r14, r15, r16, r17, r18, r19, r20, r21, r22,r23, r24, r25, \\
                   fp, gp, blink, ilink1
        ld      the_reg, [sp, the_reg\&_offset]
    .endr

    ld      r12, [sp, lp_start_offset]
    sr      r12, [lp_start]
    ld      r12, [sp, lp_end_offset]
    sr      r12, [lp_end]
    ld      r12, [sp, lp_count_offset]
    mov     lp_count, r12

    ; =======================
    ; No context restoring for ARC DMA engine registers
    ; because only TC can use it.
    ; =======================

    ld      r12, [sp, r12_offset]                   // restore r12 last
    ; ======================= ;
    ; de-allocate stack space ;
    ; ======================= ;
    add     sp, sp, ISR_FPSIZE


    ; ===================== ;
    ; go to the desired BgPort
    ; ===================== ;
    j.f     [ilink1]

;/*
;*-------------------------------------------------------------------------------
;*
;* Prototype: void disable1_save(uint32 *pul_stat)
;*
;* This function disables level 1 interrupt and save status for previous status.
;*
;* Input Arguments:
;*    *pul_stat: pointer to variable to hold interrupt status
;*
;* Output Arguments:
;*
;* Returns:
;*
;* Global Variables:
;*
;*-------------------------------------------------------------------------------
;*/

; disable interrupt level 1 & save previous interrupt status (low priority)
; disable1_save(uint32 *pul_stat)

.text
.global  disable1_save
.type disable1_save, @function
.align 4

disable1_save:

#ifdef ARC6
    lr r1, [status32]
    st_s r1, [r0]
    bic r1, r1, E1_BIT_IN_STATUS32
    j.d [blink]
    flag r1
#else
    st %blink, [r0]
    and %blink, %blink, 0xfbffffff
    j.f [%blink]
#endif

;/*
;*-------------------------------------------------------------------------------
;*
;* Prototype: void restore1_save(uint32 ul_stat)
;*
;* This function restores level 1 interrupt with previously saved status.
;*
;* Input Arguments:
;*    ul_stat: variable to hold previous interrupt status
;*
;* Output Arguments:
;*
;* Returns:
;*
;* Global Variables:
;*
;*-------------------------------------------------------------------------------
;*/
; restore interrupt level 1 with previously saved interrupt status (low priority)
; restore1_save(uint32 ul_stat)

.text
.global  restore1_save
.type restore1_save, @function
.align 4

restore1_save:

#ifdef ARC6
    and.f 0, r0, E1_BIT_IN_STATUS32
    lr r0, [status32]
    or.nz r0, r0, E1_BIT_IN_STATUS32
    j.d [blink]
    flag r0
#else
    and.f %r0, %r0, 0x04000000
    and.z %blink, %blink, 0xfbffffff
    or.nz %blink, %blink, 0x04000000
    j.f [%blink]
#endif
    .end

