/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: LL_IOf.c
;
;  Low-level core interface layer.
;
*****************************************************************************/

#include "common.h"
#include "ll_iof.h"
#include "dsp_regs_62.h"

#ifdef VDSL_62
    #include "vdsl_xception.h"
#endif

#ifdef ADSL_62
    #include "const.h"
    #include "memrymap.h"
#endif

#define OFFSET 4;


#define VDSL_62_LOCAL_LDST_START    0x10000
#define VDSL_62_LOCAL_LDST_END      (VDSL_62_LOCAL_LDST_START + 16*1024)
#define VDSL_62_IIBRAM_START        0x40000

extern int16 FGActive;
extern uint8 guc_ch_id;

void EnterFailStates(uint32);

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    SetUpDMATransfer
 *
 * Prototype:
 *    SetUpDMATransfer(uint32 SourceStart, uint32 SourceEnd, uint32 DestStart);
 *
 *  Abstract:
 *    SetUpDMATransfer() -
 *
 *    Sets up a DMA transfer from the SourceStart to DestStart until the SourceEnd address
 *
 *  Returns:
 *    None
 *
 *------------------------------------------------------------------------
 */


void SetUpDMAFill(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr, uint32 ul_DspAdmaCtrl_FillMask, int32 ul_FillValue)
{

   uint32 ul_adma_status = DSP_ADMA_STAT;
   uint32 ul_adma_status_value;
    uint32 ul_adma_ctrl = DSP_ADMA_CTRL;
    uint32 ul_adma_ctrl_value;



   // If a DMA is currently ready for transfer, do not proceed.
   do {
      ul_adma_status_value = GetDspReg(ul_adma_status);
      ul_adma_ctrl_value = GetDspReg(ul_adma_ctrl);
   } while((ul_adma_status_value & ARC_ADMA_STAT_PROC_MASK) || (ul_adma_ctrl_value & ARC_ADMA_CTRL_START_MASK));

   // setup the source start and end address, destination address, and start
   // the transfer.
   SetDspReg(DSP_ADMA_SA_S, SourceAddr);
   SetDspReg(DSP_ADMA_SA_E, SourceEnd);
   SetDspReg(DSP_ADMA_DA_S, DestAddr);
    SetDspReg(DSP_ADMA_FILL_VAL, ul_FillValue);

    // clear DSP_INT_STAT before starting ADMA
    SetDspReg(DSP_INT_STAT, DSP_INT_STAT_ADMA_DONE_MASK);
   SetDspReg(ul_adma_ctrl, ARC_ADMA_CTRL_START_MASK | ul_DspAdmaCtrl_FillMask);

   // wait for the transfer to complete.
   do {
      ul_adma_status_value = GetDspReg(DSP_INT_STAT);
   } while((ul_adma_status_value & DSP_INT_STAT_ADMA_DONE_MASK) == 0);

    // Enter fail states if error detected
   ul_adma_status_value = GetDspReg(DSP_ADMA_STAT);
    if (ul_adma_status_value & ARC_ADMA_STAT_ERR_MASK)
    {
        EnterFailStates(E_CODE_ADMA_ERROR);
    }

}

void SetUpDMATransfer(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr)
{

#if 0
   uint32 ul_adma_status = DSP_ADMA_STAT;
   uint32 ul_adma_status_value;
    uint32 ul_adma_ctrl = DSP_ADMA_CTRL;
    uint32 ul_adma_ctrl_value;

   // If a DMA is currently ready for transfer, do not proceed.
   do {
      ul_adma_status_value = GetDspReg(ul_adma_status);
      ul_adma_ctrl_value = GetDspReg(ul_adma_ctrl);
   } while((ul_adma_status_value & ARC_ADMA_STAT_PROC_MASK) || (ul_adma_ctrl_value & ARC_ADMA_CTRL_START_MASK));

   // setup the source start and end address, destination address, and start
   // the transfer.
   SetDspReg(DSP_ADMA_SA_S, SourceAddr);
   SetDspReg(DSP_ADMA_SA_E, SourceEnd);
   SetDspReg(DSP_ADMA_DA_S, DestAddr);

    // clear DSP_INT_STAT before starting ADMA
    SetDspReg(DSP_INT_STAT, DSP_INT_STAT_ADMA_DONE_MASK);
   SetDspReg(ul_adma_ctrl, ARC_ADMA_CTRL_START_MASK);

   // wait for the transfer to complete.
   do {
      ul_adma_status_value = GetDspReg(DSP_INT_STAT);
   } while((ul_adma_status_value & DSP_INT_STAT_ADMA_DONE_MASK) == 0);

    // Enter fail states if error detected
   ul_adma_status_value = GetDspReg(DSP_ADMA_STAT);
    if (ul_adma_status_value & ARC_ADMA_STAT_ERR_MASK)
    {
        EnterFailStates(E_CODE_ADMA_ERROR);
    }
#else
    SetUpDMAFill(SourceAddr, SourceEnd, DestAddr, 0, 0);
#endif

}
/****************************************************************************
; Name: ReadCoreBuf32NoDMA
;
; Prototype:
;
; Description:
;  Function for 32-bit read of ADSL core buffer
;
; Arguments:
;  ul_addr     (I)      physical address at which to start reading
;  psa_words   (O)      array containing data read from the buffer
;   us_num      (I)     number of 32-bit words to be read
;
;  Return Value:
;  N/A
*****************************************************************************/
void ReadCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{
   uint16 us_idx;
   uint32 ul_data;
   uint32 *pul_LongBuf;

    if ((int32)psa_words & 0x2)
    {
        // it is a 16-bit aligned buffer
      for(us_idx=0; us_idx<us_num; us_idx++)
      {
         ReadCoreReg(ul_addr, &ul_data);
            ul_addr += OFFSET;

         *psa_words++ = ((uint16 *)(void *)&ul_data)[0];
         *psa_words++ = ((uint16 *)(void *)&ul_data)[1];
      }
    }
    else
    {
        // it is a 32-bit aligned buffer
        pul_LongBuf = (uint32 *)(void *)psa_words;
      for(us_idx=0; us_idx<us_num; us_idx++)
      {
         ReadCoreReg(ul_addr, pul_LongBuf++);
            ul_addr += OFFSET;
      }

    }
}

/****************************************************************************
; Name: WriteCoreBuf32NoDMA
;
; Prototype:
;  void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
;
; Description:
;  Function for writing 32-bit words to a 32-bit buffer in the ADSL cores.
;
; Arguments:
;  ul_addr     (I)      physical address at which to start writing
;  psa_words   (I)      array containing data to be written to the buffer
;  us_num      (I)      number of 32-bit words to write to the buffer
;
;
;  Return Value:
;  N/A
*****************************************************************************/

void WriteCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{
   uint16 us_idx;
   uint32 ul_data;
   uint16 *pus_TwoWords;
   uint32 *pul_LongBuf;

    if ((int32)psa_words & 0x2)
    {
        // it is a 16-bit aligned buffer
        pus_TwoWords = (uint16*)(void *)&ul_data;
      for(us_idx=0; us_idx<us_num; us_idx++)
      {
         ((uint16 *)(void *)&ul_data)[0] = *psa_words++;
         ((uint16 *)(void *)&ul_data)[1] = *psa_words++;
         WriteCoreReg(ul_addr, ul_data);
            ul_addr += OFFSET;
      }
    }
    else
    {
        // it is a 32-bit aligned buffer
        pul_LongBuf = (uint32 *)(void *)psa_words;
      for(us_idx=0; us_idx<us_num; us_idx++)
      {
         WriteCoreReg(ul_addr, *pul_LongBuf++);
            ul_addr += OFFSET;
      }

    }

}

/****************************************************************************
; Name: ReadCoreBuf32
;
; Prototype:
;
; Description:
;  Function for 32-bit read of ADSL core buffer
;
; Arguments:
;  ul_addr     (I)      physical address at which to start reading
;  psa_words   (O)      array containing data read from the buffer
;   us_num      (I)     number of 32-bit words to be read
;
;  Return Value:
;  N/A
*****************************************************************************/
void ReadCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{

   uint32 l_NumberOfBytes;

   // Exit gracefully if numwords to read is zero.
   // Without this check it otherwise, causes kernel exception/ crash
   if (!us_num)
      return;

    if ((us_num < 16) ||
        (FGActive == 0) ||
        ((VDSL_62_LOCAL_LDST_START <= ul_addr) && (ul_addr < VDSL_62_LOCAL_LDST_END)) ||
        ((VDSL_62_LOCAL_LDST_START <= (int32)psa_words) && ((int32)psa_words < VDSL_62_LOCAL_LDST_END)))
    {
        ReadCoreBuf32NoDMA(ul_addr, psa_words, us_num);
    }
    else
    {
        l_NumberOfBytes = 4*us_num-2;

        SetUpDMAFill(ul_addr, (ul_addr + l_NumberOfBytes),(uint32) psa_words, 0 , 0);
    }

}

/****************************************************************************
; Name: WriteCoreBuf32
;
; Prototype:
;  void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
;
; Description:
;  Function for writing 32-bit words to a 32-bit buffer in the ADSL cores.
;
; Arguments:
;  ul_addr     (I)      physical address at which to start writing
;  psa_words   (I)      array containing data to be written to the buffer
;  us_num      (I)      number of 32-bit words to write to the buffer
;
;
;  Return Value:
;  N/A
*****************************************************************************/
void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{

   // Exit gracefully if numwords to read is zero.
   // Without this check it otherwise, causes kernel exception/ crash
   if (!us_num)
      return;

    if ((us_num < 16) ||
        (FGActive == 0) ||
        ((VDSL_62_LOCAL_LDST_START <= ul_addr) && (ul_addr < VDSL_62_LOCAL_LDST_END)) ||
        ((VDSL_62_LOCAL_LDST_START <= (int32)psa_words) && ((int32)psa_words < VDSL_62_LOCAL_LDST_END)))
    {
        WriteCoreBuf32NoDMA(ul_addr, psa_words, us_num);
    }
    else
    {
      SetUpDMAFill((uint32) psa_words, (uint32) &psa_words[2*us_num-1],ul_addr, 0, 0);
    }
}



/****************************************************************************
; Name: FillCoreBuf32
;
; Prototype:
;  void FillCoreBuf32(uint32 ul_addr, int32 s_value, uint16 us_num)
;
; Description:
;
; Arguments:
;  ul_addr     (I)      physical address at which to start writing
;  s_value     (I)      data to be filled in to the buffer
;  us_num      (I)      number of 16-bit words to write to the buffer
;
;
;  Return Value:
;  N/A
*****************************************************************************/
void FillCoreBuf32(uint32 ul_addr, int32 l_value, uint16 us_num)
{
   int32 i;
    if ((us_num < 16) ||
        (FGActive == 0) ||
        ((VDSL_62_LOCAL_LDST_START <= ul_addr) && (ul_addr < VDSL_62_LOCAL_LDST_END)))
    {
        for (i=0;i<us_num;i++) {
            WriteCoreReg(ul_addr, (uint32)l_value);
            ul_addr += OFFSET;
        }
    }
    else
    {
        i = VDSL_62_IIBRAM_START + 4*us_num - 2;
      SetUpDMAFill(VDSL_62_IIBRAM_START, i, ul_addr, ARC_ADMA_CTRL_FILL_MASK, l_value);
    }

}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ReadCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num)
*
*  This function reads a 32-bit word from a core memory.
*
*  Input Arguments:
*     ul_addr: start address
*     *pca_word: pointer to 8-bit data array to be read from the buffer
*     us_num: # of data to read
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ReadCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num)
{
   int32 i;
   uint32 ul_data;

   for (i=0;i<us_num;i++) {
      ReadCoreReg(ul_addr, &ul_data);
      pca_word[i] = (int8)ul_data;
      ul_addr+= OFFSET;
   }
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void WriteCoreBuf8(uint32 ul_addr, uint8 *pca_word, uint16 us_num)
*
*  This function writes a 32-bit word to a core memory.
*
*  Input Arguments:
*     ul_addr: start address
*     *pca_word: pointer to 8-bit data array to be written to the buffer
*     us_num: # of data to write
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WriteCoreBuf8(uint32 ul_addr, uint8 *pca_word, uint16 us_num)
{
   int32 i;
   uint32 ul_data;

   for (i=0;i<us_num;i++) {
      ul_data = (uint32)pca_word[i];
      WriteCoreReg(ul_addr, ul_data);
      ul_addr+=OFFSET;
   }
}



