/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*        All Rights Reserved
*
*        40, Middlesex Turnpike , Bedford, MA 01730-1413
*        Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*        xdma.c
*
*        functions to the reading and writing to XDMA interface
*
*-------------------------------------------------------------------
*/


/*******************************************************************
*
*        Include Files
*
*******************************************************************/


#include "common.h"
#include "dsp_regs_62.h"

#ifdef VDSL_62
    #include "vdsl_xception.h"
#endif

#ifdef ADSL_62
    #include "const.h"
    #include "memrymap.h"
#endif
#include "ll_iof.h"
#include "dsp_op.h"
#include "data_alloc.h"

#ifdef XDMA_AVAILABLE


extern uint8 guc_ch_id;

void EnterFailStates(uint32);
void restore1_save(int32);
void disable1_save(int32*);

//
// XDMA interface
//


DATA_LOCAL_LD_ST_BEGIN
    // get XDMA access status and return (non-blocking)
    int32 gl_XmemXstat = 0xbabef00d;
    int32 gl_XmemDspStat = 0xbabef00d;
    int32 gl_XmemCtrl = 0xbabef00d;
    int32 gl_XdmaLock = 0;
DATA_MAP_END

#ifndef BOOTLOADER_62
FlagT LockXdmaBus(void)
{
   int32 l_int_status;
    FlagT  ft_return;

   disable1_save(&l_int_status);
    if (gl_XdmaLock)
    {
        ft_return = 0;
    }
    else
    {
        gl_XdmaLock = 1;
        ft_return = 1;
    }
    restore1_save(l_int_status);

    return(ft_return);

}

void ReleaseXdmaLock(void)
{
    int32 l_int_status;

   disable1_save(&l_int_status);
    gl_XdmaLock = 0;
    restore1_save(l_int_status);

}
#endif

FlagT GetXdmaAccessStatus(void)
{

    gl_XmemCtrl = GetDspReg(DSP_XDMA_CTRL);     // first read ctrl
    gl_XmemXstat = GetDspReg(DSP_XDMA_STAT);    // second read stat
    gl_XmemDspStat = GetDspReg(DSP_INT_STAT);


    if (((gl_XmemCtrl & DSP_XDMA_CTRL_EN_MASK) == 0) &&
        ((gl_XmemDspStat & DSP_INT_STAT_XDMA_DONE_MASK) != 0))
    {
#ifndef BOOTLOADER_62
        if (gl_XmemXstat & DSP_XDMA_STAT_ERR_MASK)
        {
            EnterFailStates(E_CODE_XDMA_ERROR);
        }
#endif

        return(1);
    }
    return(0);
}

void WaitForXdmaDone(void)
{
    while(GetXdmaAccessStatus() == 0);
}


#ifndef BOOTLOADER_62
int16 gs_XdmaWriteData;

// setting up writing 1-word thru XDMA and wait for XDMA done
// before returning. It's a blocking call but shouldn't take long.
// On VDSL_62 only, the calling code needs to call LockXdmaBus()

void WriteXdmaWord(int16 s_Data, int32 l_DestAddr)
{
    int32 l_Temp;

    gs_XdmaWriteData = s_Data;

    // program source start
    l_Temp = (int32)&gs_XdmaWriteData;
    SetDspReg(DSP_XDMA_SA_S, l_Temp);
    // program source end
    l_Temp++;
    SetDspReg(DSP_XDMA_SA_E, l_Temp);

    // program destination start
    SetDspReg(DSP_XDMA_DA_S, l_DestAddr);

    // write to XCTRL
    SetDspReg(DSP_XDMA_CTRL, DSP_XDMA_CTRL_EN_MASK | DSP_XDMA_CTRL_WR_MASK);

    WaitForXdmaDone();
}
#endif

// set up an XDMA read and return (non-blocking)
// On VDSL_62 only, the calling code needs to call LockXdmaBus()
void SetupReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes)
{
    int32 l_SourceEnd;

    // program source start
    SetDspReg(DSP_XDMA_SA_S, l_SourceStart);

    // program source end
    l_SourceEnd = l_SourceStart + l_NumOfBytes - 1;
    SetDspReg(DSP_XDMA_SA_E, l_SourceEnd);

    // program destination start
    SetDspReg(DSP_XDMA_DA_S, l_DestStart);

    // Clear the interrupt for XDMA
    SetDspReg(DSP_INT_STAT, DSP_INT_STAT_XDMA_DONE_MASK);

    // write to XCTRL - currently we decide to use BARn regs.
    SetDspReg(DSP_XDMA_CTRL, DSP_XDMA_CTRL_EN_MASK | DSP_XDMA_CTRL_RD_MASK);
}

#ifndef BOOTLOADER_62
// this function is blocking
// On VDSL_62 only, the calling code needs to call LockXdmaBus()
void ReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes)
{
    SetupReadXdmaBlock(l_SourceStart, l_DestStart, l_NumOfBytes);
    WaitForXdmaDone();
}
#endif


#endif //XDMA_AVAILABLE
