;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        adsl_int.s
;
; DESCRIPTION:     the Danube ADSL interrupt handler
;
;*************************************************************************
#include "aux_reg_asm.h"
#include "adsl_int.h"

    .file "intvec.s"

    .text

    .global  adsl_interrupt_handler
    .type    adsl_interrupt_handler, @function

adsl_interrupt_handler:
    sub      sp, sp, ISR_FPSIZE              ; allocate stack space ;

    ; ==================== ;
    ; save core registers
    ; ==================== ;
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, fp, blink, ilink1, lp_count
        st       the_reg, [sp, the_reg\&_offset]
    .endr

    ; ==================== ;
    ; set up fp
    ; ==================== ;
    add     fp, sp, ISR_FPSIZE

    ; ==================== ;
    ; save hardware loop regs. these are aux regs
    ; ==================== ;
    lr      r12, [lp_start]
    st      r12, [sp, lp_start_offset]
    lr      r12, [lp_end]
    st      r12, [sp, lp_end_offset]

    ; =============================== ;
    ; saving XMAC registers
    ; =============================== ;

    ; these are extension core regs
    .irep the_reg, acc1, acc2
        st      the_reg, [sp, the_reg\&_offset]
    .endr

    ; these are aux regs
    .irep the_reg, ax0, ax1, ay0, ay1, mx00, mx01, mx10, mx11, my00, my01, my10, my11, aux_xmac0, aux_xmac1, aux_xmac2, xyconfig, aux_macmode, status32_l1
        lr      r12, [the_reg]
        st      r12, [sp, the_reg\&_offset]
    .endr

    ; ==================== ;
    ; save ARC DMA engine registers; these are aux regs
    ; ==================== ;
;    .irep the_reg, ADMA_CTRL_AC , ADMA_STAT_AC , ADMA_SAD_S_AC , ADMA_DAD_S_AC , \
;                   ADMA_SAD_E_AC , ADMA_FILL_AC
;        lr      r12, [the_reg]
;        st      r12, [sp, the_reg\&_offset]
;    .endr


    ; ==================== ;
    ; handle the interrupt ;
    ; ==================== ;
    sr      0, [lp_end]
   bl adsl_interrupt_handler_body

    ; =============================== ;
    ; restoring XMAC registers
    ; =============================== ;
    .irep the_reg, acc1, acc2
        ld      the_reg, [sp, the_reg\&_offset]
    .endr

    ; note that aux_xmac0 (the extension register) must be restored after aux_xmac1 and aux_xmac2
    .irep the_reg, ax0, ax1, ay0, ay1, mx00, mx01, mx10, mx11, my00, my01, my10, my11, aux_xmac1, aux_xmac2, aux_xmac0, xyconfig, aux_macmode, status32_l1
        ld      r12, [sp, the_reg\&_offset]
        sr      r12, [the_reg]
    .endr


    ld      r12, [sp, lp_start_offset]
    sr      r12, [lp_start]
    ld      r12, [sp, lp_end_offset]
    sr      r12, [lp_end]
    ld      r12, [sp, lp_count_offset]
    mov     lp_count, r12


    ; ==================== ;
    ; restore ARC DMA engine registers; these are aux regs
    ; ==================== ;
;    .irep the_reg, ADMA_CTRL_AC , ADMA_STAT_AC , ADMA_SAD_S_AC , ADMA_DAD_S_AC , \
;                   ADMA_SAD_E_AC , ADMA_FILL_AC
;        ld      r12, [sp, the_reg\&_offset]
;        sr      r12, [the_reg]
;    .endr


    ; ==================== ;
    ; restore core registers
    ; ==================== ;
    ; delay restoring of r12 to the end since r12 being used as a scratch reg now.
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, fp, blink, ilink1, r12
        ld      the_reg, [sp, the_reg\&_offset]
    .endr

    ; ======================= ;
    ; de-allocate stack space ;
    ; ======================= ;
    add     sp, sp, ISR_FPSIZE

    ; ===================== ;
    ; return from interrupt ;
    ; ===================== ;
    j.f     [ilink1]

    .end

