;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        codeswap_init.s
;
; DESCRIPTION:     bootstrap program to load the initial codeswap pages
;
;*************************************************************************
.include "soc_codeswap_asm.h"
; REGISTER ADDRESSES
.equ AUX_MB_FIRST, 0x400
.equ OMB_CODESWAP_MESSAGE, (AUX_MB_FIRST+11)
.equ MEI_INT_MC, 0x106
.equ MEI_INT_AC, 0x107

; REGISTER MASKS
.equ OMB_CODESWAP_MESSAGE_MSG_TYPE_MASK, (0x8000_0000)
.equ MEI_INT_AC_ARC_MSGAV_MASK, (0x1)
.equ MEI_INT_MC_CS_DONE_MASK, (0x2)

; PROGRAM CONSTANTS
.equ BYTES_PER_LONGWORD, (4)
.equ LOG2_BYTES_PER_LONGWORD, (2)

; INITIAL CODESWAP PROGRAM
.section .SIM_BOOT, text
.global _initial_codeswap
_initial_codeswap:
   .define codeswapSegmentAddr, %r0
   .define segmentNumber, %r1
   .define scratch, %r2

   nop
        nop
        nop
   ; jump to the _start section of the actual modem code
_initial_codeswap_end:
   j     _start

_codeswapPages:
;  .4byte 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18
   .4byte CSPAGE_RESIDENT
   .4byte CSPAGE_FINI
   .4byte CSPAGE_INIT
   .4byte CSPAGE_TEXT
   .4byte CSPAGE_RODATA
   .4byte CSPAGE_DATA
   .4byte CSPAGE_DEILV_RAM
   .4byte CSPAGE_SIMULATOR_1
   .4byte CSPAGE_SIMULATOR_2
   .4byte CSPAGE_DMT_RAM

_codeswapPagesEnd:
   .type  _codeswapPages, @object
   .size  _codeswapPages, (_codeswapPagesEnd - _codeswapPages)
