;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        crt1.s
;
; DESCRIPTION:     Socrates CRT.  This file is a slightly modified version
;                  of the Metaware supplied crt1.s
;
;*************************************************************************
   .file "crt1.s"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Startup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   .extern main
   .text
   .weak _SDA_BASE_

   .global  _start
   .type _start, @function
_start:
   ; Initialize the register file.  This is necessary because
   ; of an idiosyncracy of the register file implementation.
   ; Compiled code may generate sub  r0, r1, r1, expecting to
   ; load 0 into r0, but the individual reads of r1 for the two source
   ; operands may return different (garbage) values if r1 had never
   ; been written to since reset.
   ; NOTE: This initialization is required ONLY for Tangent ARC4 builds.
   ;       You may comment it out if not using an ARC4 build.

   .irep num, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25
      mov   r\&num, 0
   .endr

   mov   sp, _estack ; initialize stack pointer
   sub   sp, sp, 16  ; allocate expected call frame
   mov   gp, _SDA_BASE_ ; initialize small-data base register
   bl.d  main  ; jump directly to main instead of calling __arc_main
   mov   fp, 0    ; initialize frame pointer
   b  _exit_halt


   .global  _exit_halt
   .type _exit_halt, @function
_exit_halt:
   flag  0x01
   nop
   nop
   nop
   b  _exit_halt
   nop

   ; weak versions of small data symbols normally defined by the linker.
   .weak _fsbss
   .weak _esbss
   .set  _fsbss,0
   .set  _esbss,0

   ; weak versions of heap section boundaries.  If a .heap section
   ; is provided, our low-level allocator "sbrk" allocates within it.
   ; If no .heap is provided, we allocate from _end to the end of memory.
   .weak _fheap
   .weak _eheap
   .set  _fheap,0
   .set  _eheap,0


   .end


