/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: CCloop.c
*
*   This file contains the CircCorrLoop function used in CircularCorrelate (in tdq_init.c).
*
*******************************************************************************/

#include "common.h"
#include "xy_iof.h"

/*******************************************************************************
*
*   Prototype: void CircCorrLoop(int16 *Signal1, int16 *Signal2,
*                       int16 signal1len, int16 signal2len, int16 offset)
*
*   Description:
*       This function is called by CircularCorrelate to compute the loop
*       for circular correlation of two input signals.
*
*   Arguments:
*       int16 *Signal1     - pointer to 16-bit input signal1
*     int16 *Signal2    - pointer to 16-bit input signal2
*     int16 signal1len  - length of input signal1
*     int16 signal2len  - length of input signal2
*     int16 offset      - offset given
*
*   Return Value:
*
*   Global Variables:
*
*******************************************************************************/

extern int32 l_acc48H_p;
extern int32 l_acc48H_n;
extern int32 l_acc48L_p;
extern int32 l_acc48L_n;

void CircAutoCorrLoop(int32 psa_Signal1, int32 psa_Signal2, int16 s_signa1len, int16 s_signal2len, int16 s_offset);
void CircCrossCorrLoop(int32 psa_Signal1, int32 psa_Signal2, int16 s_signa1len, int16 s_signal2len, int16 s_offset);

void CircCorrLoop(int16 *psa_Signal1, int16 *psa_Signal2, int16 s_signal1len, int16 s_signal2len, int16 s_offset) {
   int32 psa_Signal1XY, psa_Signal2XY;

   psa_Signal1XY = XYAddrDecode((int32 *)(void *)psa_Signal1, ADDR_MODE_16);
   if(CheckXYAddrRange((int32 *)(void *)psa_Signal1, XY_BUF_8X0) == FAIL)
      return;

   psa_Signal2XY = XYAddrDecode((int32 *)(void *)psa_Signal2, ADDR_MODE_16);
   if(CheckXYAddrRange((int32 *)(void *)psa_Signal2, XY_BUF_8X0) == PASS)
      CircAutoCorrLoop(psa_Signal1XY, psa_Signal2XY, s_signal1len, s_signal2len, s_offset);
}
