/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#include "cmv.h"
#include "const.h"
#include "gdata.h"


void CheckShowtimeUpdate(uint16 us_SuppressInfo, FlagT ft_ResetTimer, uint16* us_Timer, int16 s_TempMargin1,
                  int16 s_TempMargin2, int16 s_FinalMargin1, int16 s_FinalMargin2)
{
   // 15 sec monitoring of showtime SNR update and negative SNRM update
   if((TESTArray[TEST_SuppressErrorReportingToME] & us_SuppressInfo) == 0)
   {
      if (ft_ResetTimer)
      {
         (*us_Timer) = (uint16)(FRAME_COUNT_FOR_ONE_SEC * 15);
      }
      else
      {
         if (*us_Timer > 0)
         {
            gt_NearEndParam.s_SnrMargin = s_TempMargin1;
            gs_SnrMargin_OneOverTen_dB_Resolution = s_TempMargin2;
            (*us_Timer)--;
         }
         else
         {
            gt_NearEndParam.s_SnrMargin = s_FinalMargin1;
            gs_SnrMargin_OneOverTen_dB_Resolution = s_FinalMargin2;
         }
      }
   }
}
