/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: accum32.c
;
;  This file contains function accum16to32()
;
;***************************************************************************/

#include "typedef.h"
#include "xy_iof.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Accum16to32
 *
 *  Description:
 *
 *    accumulates 16 bit data array into a 32 bit accumulator
 *    array.
 *
 *  Prototype:
 *    Accum16to32(int32 *l_accumbuf, int16 *s_databuf, int16 s_length)
 *
 *
 *  Input Arguments:
 *    int32 *l_accumbbuf - Pointer to 32 bit accumulation array
 *    int16 *s_databuf - Pointer to 16 bit data array
 *    int16 s_length - length of both arrays
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Accum16to32LoopXX(int32 pla_accumbufXY, int32 psa_databufXY, int16 s_length);
void Accum16to32LoopXY(int32 pla_accumbufXY, int32 psa_databufXY, int16 s_length);
void Accum16to32(int32 *pla_accumbuf, int16 s_offset1, int16 *psa_databuf, int16 s_offset2, int16 s_length)
{
   int32 pla_accumbufXY, psa_databufXY;

   /* ================================================== */
   /* Check address pointers                    */
   /* ================================================== */
   pla_accumbuf += s_offset1;
   if(CheckXYAddrRange(pla_accumbuf, XY_BUF_8X0) == FAIL)
      return;
   pla_accumbufXY = XYAddrDecode(pla_accumbuf, ADDR_MODE_32);

   psa_databuf += s_offset2;
   if ((CheckXYAddrRange((int32 *)(void *)psa_databuf, XY_BUF_8X0) == FAIL)  && (CheckXYAddrRange((int32 *)(void *)psa_databuf, XY_BUF_8X1) == FAIL))
      return;
   psa_databufXY = XYAddrDecode((int32 *)(void *)psa_databuf, ADDR_MODE_16);


   /* ================================================== */
   /* Accumulate                                   */
   /* ================================================== */

   if(CheckXYAddrRange((int32 *)(void *)psa_databuf, X_MEM) == PASS)
    {
      Accum16to32LoopXX(pla_accumbufXY, psa_databufXY, s_length);
    }
    else
    {
      Accum16to32LoopXY(pla_accumbufXY, psa_databufXY, s_length);
    }
}


