/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: afe.c
*
*-------------------------------------------------------------------------------
*/

#ifdef TARGET_SIM

#include "typedef.h"
#include "gdata.h"
#include "rt_state.h"
#include "memrymap.h"
#include "delay.h"
#include "pga_set.h"
#include "simext_cocomo_interface.h"
#include "afe.h"
/*
*-------------------------------------------------------------------------------
*
* DataPath DPS8101 Farallon AFE
*
* Farallon has 3 different sub registers to set PGA gain.
*
*-------------------------------------------------------------------------------
*/

int16 pgareg6_table[7] = {32*256, 33*256, 34*256, 35*256, 36*256, 37*256, 38*256};

int16 pgareg6_value[7] = {((0x3f)<<5|(0x1f)), ((0x51)<<5|(0x1f)), ((0x57)<<5|(0x1f)),
    ((0x60)<<5|(0x1f)), ((0x69)<<5|(0x1f)), ((0x73)<<5|(0x1f)), ((0x7f)<<5|(0x1f))};

/* the following table is in db expressed in 8.8 format */
int16 pgareg_table[5] = {0*256, 6*256, 12*256, 18*256, 24*256};

int16 pgareg_value[5] = {0x01, 0x03, 0x07, 0x0f, 0x1f};

/* the following table is in db expressed in 8.8 format */
/* the table is taken from Farallon spec */
int16 paareg_table[64] = {
   /*0*/      0x0,            /*0.000000 */
   /*1*/      0x36,           /*0.211000 */
   /*2*/      0x6b,           /*0.418000 */
   /*3*/      0x9e,           /*0.620000 */
   /*4*/      0xd1,           /*0.818000 */
   /*5*/      0x102,          /*1.011000 */
   /*6*/      0x132,          /*1.199000 */
   /*7*/      0x162,          /*1.384000 */
   /*8*/      0x190,          /*1.565000 */
   /*9*/      0x1be,          /*1.743000 */
   /*10*/     0x1ea,          /*1.916000 */
   /*11*/     0x216,          /*2.087000 */
   /*12*/     0x241,          /*2.254000 */
   /*13*/     0x26a,          /*2.417000 */
   /*14*/     0x293,          /*2.578000 */
   /*15*/     0x2bc,          /*2.736000 */
   /*16*/     0x2e4,          /*2.891000 */
   /*17*/     0x30b,          /*3.044000 */
   /*18*/     0x331,          /*3.194000 */
   /*19*/     0x357,          /*3.341000 */
   /*20*/     0x37c,          /*3.486000 */
   /*21*/     0x3a0,          /*3.628000 */
   /*22*/     0x3c4,          /*3.768000 */
   /*23*/     0x3e7,          /*3.906000 */
   /*24*/     0x40a,          /*4.042000 */
   /*25*/     0x42c,          /*4.175000 */
   /*26*/     0x44e,          /*4.307000 */
   /*27*/     0x46f,          /*4.436000 */
   /*28*/     0x490,          /*4.564000 */
   /*29*/     0x4b0,          /*4.690000 */
   /*30*/     0x4d0,          /*4.814000 */
   /*31*/     0x4ef,          /*4.937000 */
   /*32*/     0x50e,          /*5.057000 */
   /*33*/     0x52d,          /*5.176000 */
   /*34*/     0x54b,          /*5.294000 */
   /*35*/     0x568,          /*5.409000 */
   /*36*/     0x586,          /*5.524000 */
   /*37*/     0x5a2,          /*5.636000 */
   /*38*/     0x5bf,          /*5.748000 */
   /*39*/     0x5db,          /*5.858000 */
   /*40*/     0x5f7,          /*5.966000 */
   /*41*/     0x612,          /*6.074000 */
   /*42*/     0x62d,          /*6.179000 */
   /*43*/     0x648,          /*6.284000 */
   /*44*/     0x663,          /*6.388000 */
   /*45*/     0x67d,          /*6.490000 */
   /*46*/     0x697,          /*6.591000 */
   /*47*/     0x6b0,          /*6.691000 */
   /*48*/     0x6c9,          /*6.789000 */
   /*49*/     0x6e3,          /*6.887000 */
   /*50*/     0x6fb,          /*6.983000 */
   /*51*/     0x714,          /*7.079000 */
   /*52*/     0x72c,          /*7.173000 */
   /*53*/     0x744,          /*7.267000 */
   /*54*/     0x75b,          /*7.359000 */
   /*55*/     0x773,          /*7.450000 */
   /*56*/     0x78a,          /*7.541000 */
   /*57*/     0x7a1,          /*7.630000 */
   /*58*/     0x7b8,          /*7.719000 */
   /*59*/     0x7ce,          /*7.807000 */
   /*60*/     0x7e4,          /*7.894000 */
   /*61*/     0x7fa,          /*7.980000 */
   /*62*/     0x810,          /*8.065000 */
   /*63*/     0x826,          /*8.149000 */
};

/*******************************************************************************
*
*  Prototype: int16 ReadAfe(int16 addr)
*
*  This function reads AFE registers.
*
*  Input Arguments:
*     addr: address of the AFE register
*
*  Output Arguments:
*
*  Returns:
*     content of the AFE register
*
*  Global Variables:
*
*******************************************************************************/

int16 ReadAfe(int16 addr)
{
}

/*******************************************************************************
*
*  Prototype: void WriteAfe(int16 addr, int16 data)
*
*  This function reads AFE registers.
*
*  Input Arguments:
*     addr: address of the AFE register
*     data: data to write
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void WriteAfe(int16 addr, int16 data)
{
}





/*******************************************************************************
*
*  Prototype: void SetPGA(void)
*
*  This function sets the PGA for Datapath Farallon AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*     gs_PGA_reg_setting (I): register value for PGA gain (RX_GAIN)
*
*******************************************************************************/

#define FARALLON_RX_GAIN (0x0006)

void SetPGA(void)
{

   WriteCoreReg(AFE_ADDR_ADDR,FARALLON_RX_GAIN);
   delay(200);
   WriteCoreReg(AFE_WDATA_ADDR,gs_PGA_reg_setting);
   delay(200);

}

#undef FARALLON_RX_GAIN


/*******************************************************************************
*
*  Prototype: void AdjustPathGain(void)
*
*  This function adjusts PATT (Programmable ATTenuator) gain
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables: gs_PATT_lift_dB, gs_AFE_type
*
*******************************************************************************/
#define PATT_MINIMUM_DB          (-24)
#define PATT_STEP_DB          (6)
#define FARALLON_TX_GAIN         (0x0007)
#define AEC_GAIN_DB_NEGATED         (6)

void AdjustPathGain(void) {


   int16 s_PATT_dB, s_PATT_remainder, s_PATT_Hi, s_PATT_Lo;

   /* Lift up Datapath AFE's PATT gain in AEC path (initially set to -24 dB ) */
   if (gs_AFE_type != 1) { /* DataPath DPS8101 Farallon AFE IC */
      s_PATT_dB = PATT_MINIMUM_DB+((gs_PATT_lift_dB>>8) & (int16) 0x00FF);

      if (s_PATT_dB>=PATT_MINIMUM_DB && s_PATT_dB<(PATT_MINIMUM_DB+PATT_STEP_DB)) {
         s_PATT_Hi = (int16) 0x0007;
         s_PATT_remainder = (PATT_MINIMUM_DB+PATT_STEP_DB)-s_PATT_dB;
      }

      if (s_PATT_dB>=(PATT_MINIMUM_DB+PATT_STEP_DB) && s_PATT_dB<(PATT_MINIMUM_DB+PATT_STEP_DB*2)) {
         s_PATT_Hi = (int16) 0x0006;
         s_PATT_remainder = (PATT_MINIMUM_DB+PATT_STEP_DB*2)-s_PATT_dB;
      }

      if (s_PATT_dB>=(PATT_MINIMUM_DB+PATT_STEP_DB*2) && s_PATT_dB<(PATT_MINIMUM_DB+PATT_STEP_DB*3)) {
         s_PATT_Hi = (int16) 0x0004;
         s_PATT_remainder = (PATT_MINIMUM_DB+PATT_STEP_DB*3)-s_PATT_dB;
      }

      if (s_PATT_dB>=(PATT_MINIMUM_DB+PATT_STEP_DB*3) && s_PATT_dB<0) {
         s_PATT_Hi = (int16) 0x0000;
         s_PATT_remainder = (PATT_MINIMUM_DB+PATT_STEP_DB*4)-s_PATT_dB;
      }

      switch (s_PATT_remainder) {
         case 1:
            s_PATT_Lo = (int16) 0x0004;
         case 2:
            s_PATT_Lo = (int16) 0x0008;
         case 3:
            s_PATT_Lo = (int16) 0x000D;
         case 4:
            s_PATT_Lo = (int16) 0x0013;
         case 5:
            s_PATT_Lo = (int16) 0x0019;
         case 6:
            s_PATT_Lo = (int16) 0x001F;
      }
      WriteAfe(FARALLON_TX_GAIN, (int16) ((s_PATT_Hi<<5)+s_PATT_Lo+((int16) 0x8f00))); /* Reg_7[15:8] = 8F H */
   }

}

#undef PATT_MINIMUM_DB
#undef PATT_STEP_DB
#undef FARALLON_TX_GAIN
#undef AEC_GAIN_DB_NEGATED

/*******************************************************************************
*
*  Prototype: void BgPGA(void)
*
*  This background function calculates the PGA setting for Datapath
*  Farallon AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*     gs_PGA_required (I): required gain (dB in 8.8 format)
*     guc_PgaTrainingState (O): status indicator
*     gs_PGA_reg_setting (O): register value for PGA gain (RX_GAIN)
*     gs_PGA_set (O): actual gain (dB in 8.8 format)
*
*******************************************************************************/

int16 gs_PGA_required_used;
void BgPGA(void)
{
   guc_PgaTrainingState = TRAINING_DONE;

}

#else //Not TARGET_SIM

#include "typedef.h"
#include "gdata.h"
#include "rt_state.h"
#include "memrymap.h"
#include "delay.h"
#include "ll_iof.h"
#include "data_alloc.h"

#ifdef DANUBE_TEMP
// only really needed for RUN_ASIM but want to be common for now.
int16 gs_AFE_PGAGain; //used by simext.
#endif











#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */

DATA_MAP_deILV3_BIS

#ifdef ISDN /* Annex B */
/* 02/24/2005 Calibration */
/* Diagnostic Mode Data */
/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 2 and starting from tone 61 */
#ifdef DANUBE
//-110 dBm Calibration
int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[98] = { /* Q9.7 */
 10266,  10310,  10387,  10394,  10458,  10470,  10522,  10554,
 10592,  10605,  10643,  10675,  10720,  10739,  10771,  10829,
 10829,  10861,  10867,  10912,  10918,  10963,  10970,  10976,
 11021,  11008,  11040,  11053,  11072,  11091,  11104,  11104,
 11104,  11136,  11149,  11155,  11168,  11200,  11200,  11206,
 11219,  11200,  11232,  11238,  11258,  11277,  11277,  11309,
 11315,  11334,  11322,  11360,  11354,  11354,  11360,  11366,
 11411,  11418,  11405,  11411,  11430,  11456,  11456,  11443,
 11462,  11450,  11475,  11494,  11488,  11494,  11507,  11507,
 11520,  11514,  11520,  11533,  11539,  11558,  11533,  11552,
 11552,  11546,  11558,  11565,  11546,  11552,  11539,  11533,
 11578,  11539,  11526,  11552,  11558,  11558,  11584,  11558,
 11546,  11578};


/* 02/24/2005 Calibration */
/* Diagnostic Mode Data */
/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 2 and starting from tone 61 */

#else
int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[98] = { /* Q9.7 */
  9783,   9851,   9905,   9972,  10026,  10066,  10133,  10196,
 10246,  10270,  10325,  10337,  10377,  10416,  10474,  10503,
 10521,  10576,  10561,  10590,  10616,  10648,  10690,  10697,
 10732,  10721,  10736,  10761,  10786,  10816,  10826,  10866,
 10849,  10835,  10862,  10879,  10906,  10926,  10900,  10929,
 10930,  10936,  10967,  10971,  10989,  10966,  10995,  10984,
 10986,  11011,  11026,  11035,  11037,  11049,  11036,  11016,
 11035,  11064,  11060,  11055,  11082,  11054,  11059,  11053,
 11078,  11088,  11078,  11113,  11072,  11070,  11073,  11085,
 11099,  11100,  11065,  11079,  11089,  11066,  11092,  11106,
 11100,  11078,  11090,  11070,  11059,  11059,  11071,  11090,
 11059,  11073,  11059,  11051,  11049,  11053,  11086,  11048,
 11062,  11057};

#endif
/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 4 and starting from tone 59 */
#ifdef DANUBE
int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[114] = { /* Q9.7 */
 10240,  10317,  10394,  10477,  10566,  10618,  10688,  10726,
 10810,  10842,  10899,  10938,  10995,  11002,  11034,  11110,
 11098,  11142,  11136,  11174,  11226,  11213,  11251,  11258,
 11296,  11328,  11347,  11366,  11392,  11411,  11424,  11443,
 11437,  11482,  11462,  11482,  11520,  11501,  11526,  11533,
 11552,  11507,  11552,  11552,  11558,  11565,  11571,  11558,
 11558,  11571,  11558,  11533,  11552,  11546,  11552,  11533,
 11546,  11533,  11526,  11533,  11507,  11501,  11482,  11494,
 11488,  11450,  11450,  11418,  11430,  11392,  11386,  11366,
 11334,  11341,  11328,  11322,  11326,  11310,  11318,  11317,
 11320,  11330,  11335,  11307,  11300,  11269,  11257,  11250,
 11244,  11213,  11244,  11234,  11248,  11241,  11230,  11194,
 11180,  11160,  11185,  11201,  11205,  11191,  11170,  11136,
 11117,  11102,  11130,  11160,  11095,  11099,  11062,  11089,
 11113,  11143};

#else
int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[114] = { /* Q9.7 */
  9700,   9869,   9990,  10093,  10218,  10279,  10358,  10449,
 10522,  10577,  10595,  10662,  10706,  10742,  10798,  10833,
 10879,  10863,  10886,  10945,  10953,  10951,  10986,  10983,
 11017,  11029,  11060,  11067,  11047,  11074,  11083,  11075,
 11077,  11082,  11145,  11091,  11108,  11111,  11102,  11092,
 11124,  11088,  11088,  11091,  11082,  11109,  11079,  11090,
 11073,  11080,  11069,  11070,  11075,  11035,  11055,  11026,
 11048,  11014,  11019,  11007,  10993,  11005,  11006,  10992,
 10958,  10970,  10962,  10938,  10942,  10939,  10928,  10912,
 10944,  10925,  10907,  10897,  10922,  10882,  10872,  10887,
 10892,  10866,  10821,  10862,  10857,  10846,  10797,  10823,
 10820,  10759,  10772,  10741,  10735,  10753,  10709,  10754,
 10714,  10653,  10631,  10628,  10660,  10631,  10608,  10516,
 10632,  10582,  10524,  10608,  10693,  10750,  10629,  10809,
 11275,  11414};
#endif

/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 4 and starting from tone 59 */
int16 gsa_Amazon_PlusRxAFEFiltEqOn_dB[114] = { /* Q9.7 */
  9726,   9959,  10054,  10176,  10301,  10381,  10460,  10565,
 10656,  10718,  10742,  10828,  10872,  10922,  10984,  11025,
 11083,  11081,  11123,  11182,  11196,  11207,  11248,  11258,
 11293,  11323,  11354,  11374,  11367,  11414,  11435,  11433,
 11449,  11459,  11536,  11494,  11524,  11527,  11538,  11546,
 11579,  11555,  11568,  11577,  11587,  11621,  11597,  11608,
 11605,  11617,  11626,  11646,  11657,  11611,  11650,  11641,
 11650,  11642,  11652,  11647,  11652,  11664,  11672,  11690,
 11649,  11668,  11666,  11654,  11665,  11682,  11677,  11667,
 11680,  11680,  11675,  11684,  11696,  11657,  11672,  11687,
 11686,  11686,  11673,  11707,  11670,  11678,  11668,  11674,
 11697,  11649,  11662,  11643,  11625,  11611,  11637,  11630,
 11642,  11606,  11604,  11588,  11562,  11585,  11529,  11527,
 11476,  11561,  11535,  11542,  11704,  11697,  11730,  11762,
 12146,  12131};

//Indexes to channels with minimum values (i.e. maximum compensation)
int16 gs_MinValBisChan_AmazonEqOff = 0;
int16 gs_MinValPlusChan_AmazonEqOff = 0;
int16 gs_MinValPlusChan_AmazonEqOn = 0;
#else    /* Annex A */
/* 09/15/2005 Calibration */
/* Diagnostic Mode Data */
/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 2 and starting from tone 33 */


#ifdef DANUBE
/*
int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[112] = {
 10669,  10701,  10778,  10790,  10810,  10861,  10893,  10906,
 10938,  10976,  10995,  11021,  11034,  11059,  11078,  11136,
 11123,  11174,  11162,  11187,  11226,  11226,  11245,  11258,
 11270,  11251,  11296,  11296,  11328,  11322,  11341,  11373,
 11373,  11379,  11405,  11386,  11424,  11424,  11450,  11424,
 11443,  11443,  11456,  11488,  11475,  11475,  11501,  11469,
 11488,  11494,  11494,  11501,  11546,  11552,  11546,  11552,
 11558,  11571,  11565,  11584,  11578,  11603,  11622,  11622,
 11610,  11616,  11635,  11629,  11648,  11661,  11654,  11654,
 11667,  11642,  11661,  11686,  11699,  11686,  11712,  11699,
 11718,  11725,  11731,  11725,  11757,  11750,  11744,  11750,
 11763,  11744,  11763,  11744,  11763,  11770,  11763,  11770,
 11776,  11770,  11789,  11789,  11757,  11776,  11795,  11795,
 11776,  11776,  11789,  11763,  11782,  11763,  11802,  11795 };

*/

 int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[112] = {
 10669,  10701,  10758,  10790,  10810,  10861,  10956,  11033,
 11065,  11103,  11122,  11148,  11161,  11155,  11174,  11199,
 11186,  11237,  11225,  11250,  11257,  11257,  11245,  11258,
 11270,  11251,  11296,  11296,  11328,  11322,  11341,  11373,
 11373,  11379,  11405,  11386,  11424,  11424,  11450,  11424,
 11443,  11443,  11456,  11488,  11475,  11475,  11481,  11469,
 11488,  11494,  11494,  11501,  11546,  11552,  11546,  11552,
 11558,  11571,  11565,  11584,  11578,  11603,  11622,  11622,
 11610,  11616,  11635,  11629,  11648,  11661,  11654,  11654,
 11667,  11642,  11661,  11686,  11699,  11686,  11712,  11699,
 11718,  11725,  11731,  11725,  11757,  11750,  11744,  11750,
 11763,  11744,  11763,  11744,  11763,  11770,  11763,  11770,
 11776,  11770,  11789,  11789,  11757,  11776,  11795,  11795,
 11776,  11776,  11789,  11763,  11782,  11763,  11802,  11795 };




#else
 int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[112] = { /* Q9.7 */
 10336,  10426,  10528,  10605,  10688,  10739,  10816,  10822,
 10880,  10925,  10944,  10982,  11014,  11053,  11059,  11078,
 11123,  11130,  11142,  11149,  11174,  11200,  11219,  11245,
 11245,  11258,  11251,  11296,  11290,  11283,  11283,  11315,
 11302,  11322,  11322,  11328,  11328,  11334,  11334,  11354,
 11334,  11341,  11354,  11366,  11373,  11366,  11379,  11360,
 11366,  11373,  11354,  11379,  11366,  11366,  11366,  11379,
 11379,  11379,  11392,  11360,  11366,  11386,  11379,  11373,
 11392,  11386,  11379,  11373,  11392,  11379,  11392,  11392,
 11398,  11411,  11392,  11373,  11398,  11405,  11398,  11418,
 11411,  11411,  11411,  11411,  11418,  11405,  11418,  11424,
 11424,  11430,  11430,  11443,  11437,  11430,  11430,  11418,
 11437,  11430,  11430,  11418,  11405,  11405,  11424,  11405,
 11411,  11405,  11411,  11437,  11437,  11418,  11411,  11418};

#endif

/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 4 and starting from tone 31 */

#ifdef DANUBE
/* //-110db Standard calibration
int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[121] = {
 10739,  10957,  11110,  11245,  11360,  11469,  11539,  11597,
 11654,  11744,  11795,  11827,  11827,  11859,  11904,  11968,
 11955,  11994,  12026,  12051,  12064,  12070,  12096,  12096,
 12090,  12096,  12134,  12134,  12122,  12154,  12192,  12166,
 12224,  12205,  12224,  12218,  12256,  12262,  12269,  12282,
 12288,  12294,  12301,  12326,  12288,  12307,  12301,  12358,
 12333,  12333,  12346,  12320,  12320,  12339,  12352,  12314,
 12326,  12301,  12314,  12339,  12301,  12320,  12320,  12326,
 12314,  12301,  12314,  12288,  12269,  12262,  12224,  12250,
 12224,  12218,  12205,  12173,  12166,  12154,  12141,  12134,
 12122,  12096,  12090,  12058,  12045,  12032,  12000,  11974,
 11962,  11962,  11930,  11936,  11917,  11878,  11898,  11834,
 11859,  11802,  11821,  11770,  11776,  11718,  11718,  11693,
 11648,  11629,  11584,  11565,  11533,  11507,  11507,  11482,
 11462,  11424,  11450,  11386,  11411,  11379,  11341,  11379,
 11360};
*/
 //-140db manual calibration with 612/6 Hyb and Hpf=1
int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[121] = {
 11347,  11537,  11610,  11718,  11878,  11945,  12010,  12038,
 12064,  12083,  12128,  12200,  12230,  12262,  12198,  12262,
 12250,  12269,  12282,  12294,  12307,  12288,  12288,  12282,
 12314,  12307,  12301,  12333,  12301,  12320,  12339,  12339,
 12378,  12352,  12365,  12365,  12371,  12384,  12358,  12371,
 12371,  12390,  12384,  12378,  12422,  12403,  12371,  12384,
 12390,  12371,  12358,  12365,  12375,  12384,  12339,  12338,
 12337,  12333,  12294,  12320,  12275,  12314,  12301,  12288,
 12275,  12262,  12275,  12237,  12237,  12230,  12269,  12237,
 12237,  12186,  12198,  12198,  12218,  12192,  12109,  12122,
 12096,  12102,  12083,  12090,  12084,  12064,  12038,  12038,
 12026,  12051,  12032,  12032,  12019,  12006,  11987,  11974,
 12006,  12000,  11974,  12013,  11974,  12000,  11955,  11936,
 11917,  11904,  11910,  11885,  11907,  11910,  11903,  11853,
 11859,  11891,  11885,  11873,  11840,  11846,  11866,  11859,
 11859};

#else

int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[121] = { /* Q9.7 */
 11027,  11206,  11379,  11514,  11603,  11699,  11776,  11808,
 11853,  11904,  11936,  11962,  11987,  12013,  12045,  12045,
 12045,  12077,  12077,  12083,  12109,  12109,  12128,  12134,
 12115,  12122,  12115,  12141,  12154,  12160,  12160,  12147,
 12160,  12173,  12166,  12160,  12179,  12166,  12160,  12166,
 12154,  12154,  12173,  12154,  12147,  12160,  12154,  12154,
 12147,  12128,  12147,  12122,  12154,  12115,  12141,  12128,
 12128,  12083,  12102,  12077,  12083,  12083,  12083,  12077,
 12064,  12038,  12045,  12045,  12026,  12045,  12026,  12019,
 12019,  12000,  12019,  11994,  11994,  12000,  11981,  11981,
 11994,  11981,  11955,  11955,  11942,  11949,  11949,  11930,
 11923,  11917,  11898,  11910,  11904,  11898,  11891,  11878,
 11859,  11840,  11840,  11802,  11808,  11802,  11789,  11770,
 11757,  11750,  11725,  11725,  11699,  11699,  11674,  11674,
 11667,  11648,  11661,  11654,  11635,  11642,  11642,  11642,
 11622};


#endif

/* CPE Modem front-end Rx path specific data  (platform dependent) */
/* Subsampled by 4 and starting from tone 31 */
int16 gsa_Amazon_PlusRxAFEFiltEqOn_dB[121] = { /* Q9.7 */
 11014,  11245,  11405,  11546,  11654,  11744,  11802,  11866,
 11917,  11974,  12026,  12077,  12102,  12109,  12160,  12166,
 12218,  12230,  12250,  12269,  12269,  12314,  12314,  12346,
 12378,  12378,  12403,  12422,  12429,  12442,  12461,  12499,
 12499,  12499,  12512,  12525,  12544,  12582,  12557,  12602,
 12602,  12614,  12627,  12621,  12640,  12659,  12659,  12672,
 12672,  12691,  12710,  12710,  12717,  12710,  12736,  12730,
 12742,  12755,  12755,  12762,  12768,  12774,  12749,  12794,
 12787,  12800,  12800,  12787,  12794,  12800,  12800,  12800,
 12800,  12806,  12813,  12819,  12800,  12851,  12838,  12851,
 12838,  12845,  12832,  12851,  12864,  12858,  12864,  12864,
 12858,  12858,  12877,  12870,  12845,  12864,  12864,  12864,
 12864,  12858,  12851,  12832,  12851,  12832,  12851,  12826,
 12832,  12832,  12819,  12800,  12813,  12794,  12774,  12774,
 12800,  12774,  12768,  12749,  12755,  12768,  12787,  12781,
 12768};

//Indexes to channels with minimum values (i.e. maximum compensation)
int16 gs_MinValBisChan_AmazonEqOff = 0;
int16 gs_MinValPlusChan_AmazonEqOff = 0;
int16 gs_MinValPlusChan_AmazonEqOn = 0;
#endif   /* End of #ifdef/#else ISDN*/

DATA_MAP_END

#endif   /* End of #ifdef AMAZON_AFE */

/*******************************************************************************
*
*  Prototype: void BgPGA(void)
*
*  This background function calculates the PGA setting.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*/

/* Global Variables :
*     gs_PGA_required (I): required gain (dB in 8.8 format)
*     guc_PgaTrainingState (O): status indicator
*     gs_PGA_Reg_Setting (O): register value for PGA gain (RX_GAIN)
*     gs_PGA_set (O): actual gain (dB in 8.8 format)
*
*******************************************************************************/









#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
int16 gs_AmazonA_HPFAtten = HPF_ON_AGC1_MARGIN;
int16 gs_HPFEq_Reg_Setting;
#endif   /* End of #ifdef AMAZON_AFE */

/*******************************************************************************
*
*  Prototype: void WriteAfe(int16 addr, int16 data)
*
*  This function writes AFE registers
*
*  Input Arguments:
*     addr: address of the register
*     data: data to write
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/
int16 gs_waitingForAfe;

void WriteAfe(int16 addr, int16 data)
{
   int16 s_event2;

#ifndef HERCULES_ADSL_CPE
   WriteCoreReg(AFE_ADDR_ADDR,addr);
   delay(10);
   //Reset FDF_AFEBUSY Event
   WriteCoreReg(CRI_EVENT2_ADDR,0x20);
   WriteCoreReg(AFE_WDATA_ADDR,data);
    gs_waitingForAfe = 0;

#ifndef RUN_ASIM
      do {
         delay(10);
         ReadCoreReg(CRI_EVENT2_ADDR,(uint16 *)&s_event2);
         gs_waitingForAfe++;
      } while(!(s_event2 & 0x20) ); //Wait until FDF_AFEBUSY goes high
#endif
#endif
}


/*******************************************************************************
*
*  Prototype: int16 ReadAfe(int16 addr)
*
*  This function reads AFE registers.
*
*  Input Arguments:
*     addr: address of the AFE register
*
*  Output Arguments:
*
*  Returns:
*     content of the register
*
*  Global Variables:
*
*******************************************************************************/

int16 ReadAfe(int16 addr)
{
   int16 tmp, s_event2;

#ifndef HERCULES_ADSL_CPE
   WriteCoreReg(AFE_ADDR_ADDR,addr);
   delay(10);
   //Reset FDF_AFEBUSY Event
   WriteCoreReg(CRI_EVENT2_ADDR,0x20);
   WriteCoreReg(AFE_RDATA_ADDR, 0); /* dummy write to start data read */
    gs_waitingForAfe=0;

#ifndef RUN_ASIM
      do {
         delay(10);
         ReadCoreReg(CRI_EVENT2_ADDR,(uint16 *)&s_event2);
         gs_waitingForAfe++;
      } while(!(s_event2 & 0x20));  //Wait until FDF_AFEBUSY goes high
#endif

   ReadCoreReg(AFE_RDATA_ADDR,(uint16 *)&tmp);
#endif
   return(tmp);
}


/*******************************************************************************
*
*  Prototype: void SetPGA(void)
*
*  This function sets the PGA for the AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables :
*     gs_PGA_Reg_Setting1 (I): register value for PGA gain
*     gs_PGA_Reg_Setting2 (I): register value for LPF gain
*
*  Global Variables (Farallon):
*     gs_PGA_Reg_Setting (I): register value for PGA gain (RX_GAIN)
*
*******************************************************************************/








FlagT gft_SetPgaCalled = FALSE;  /* Temp variable */
void SetPGA(void)
{


   if (gft_SetPGADisable != FALSE)
   {
      /* Read the variables used by other functions that might not be disabled. */

      return;
   }











#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
   /* Write into Danube-A AGC control register */
   WriteAfe(DANUBEA_PGA_SET, gs_PGA_Reg_Setting);
#else /* Else for #ifdef DANUBE_AFE */
   /* Write into Amazon-A AGC control register */
   WriteAfe(AMAZONA_AGC_SETTING, gs_PGA_Reg_Setting);
#endif   /* End of #ifdef/#else DANUBE_AFE */
   delay(10);


#endif   /* End of #ifdef AMAZON_AFE */

#ifdef DANUBE_TEMP
// only really needed for RUN_ASIM but want to be common for now.
   gs_AFE_PGAGain = gs_PGA_set;    //This variable is sampled by simext to apply the gain.
#endif
}









/*******************************************************************************
*
*  Prototype: void AdjustPathGain(void)
*
*  This function adjusts PATT (Programmable ATTenuator) gain
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables: gs_PATT_lift_dB
*
*******************************************************************************/







void AdjustPathGain(void) {
#ifndef AMAZON_AFE
   int16 s_PATT_dB, s_PATT_remainder, s_PATT_Hi, s_PATT_Lo;

   if (gft_AFEBypassMode != FALSE) return;






#endif   //amazon_Afe
}








void SetInitialPgaToMax(void)
{

   if (gft_SetPGADisable != FALSE) return;



   gs_PGA_required = gs_max_pga_setting;
}





#endif
