/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: afe_b.c
*
*-------------------------------------------------------------------------------
*/
#include "typedef.h"
#include "gdata.h"
#include "rt_state.h"
#include "memrymap.h"
#include "delay.h"
#include "ll_iof.h"
#include "data_alloc.h"
#include "afe.h"
#include "cmv.h"

/* Local function(s). */
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
C_SCOPE int16 AmazonACalcAGC1(int16 s_PGA_required);
C_SCOPE int16 AmazonACalcAGC2(int16 s_PGA_required);
#endif   /* End of #ifdef AMAZON_AFE */

/*******************************************************************************
*
*  Prototype: void BgPGA(void)
*
*  This background function calculates the PGA setting for one of the following:
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables (KeyWave):
*     gs_PGA_required (I): required gain (dB in 8.8 format)
*     guc_PgaTrainingState (O): status indicator
*     gs_PGA_Reg_Setting1 (O): register value for PGA gain (SUM11)
*     gs_PGA_Reg_Setting2 (O): register value for LPF gain (RFIL1SET)
*     gs_PGA_Reg_Setting3 (O): register value for sum12
*     gs_PGA_set (O): actual gain (dB in 8.8 format)
*     gs_diff_sum11_sum12_table (O):   sum12 can be set lower than sum11
*
*  Global Variables (Farallon):
*     gs_PGA_required (I): required gain (dB in 8.8 format)
*     guc_PgaTrainingState (O): status indicator
*     gs_PGA_Reg_Setting (O): register value for PGA gain (RX_GAIN)
*     gs_PGA_set (O): actual gain (dB in 8.8 format)
*
*******************************************************************************/

#define RFIL_BASE (12) /* set nominal to 1.2 MHz cutoff and 0 dB gain */
#define DIFF_SUM11_SUM12_TABLE (0)  /* e.g., 6 means sum11-sum12=12dB. Note 2 dB step. */




C_SCOPE void BgPGA(void)
{
   int16 i, k, base_sum11, base_sum12, done, remainingPGA;
   int16 s_PGA_Required;



   if (gft_SetPGADisable != FALSE) {
      guc_PgaTrainingState = TRAINING_DONE;
      return;
   }











#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
   /* Calculate the setting for the first AGC stage (HPF attenuation is taken into */
   /* account to prevent clipping when HPF is on) and populate AGC register variable */
   /* which will be written to hardware in SetPGA(). */
   gs_PGA_Reg_Setting = AmazonACalcAGC1(gs_PGA_required - gs_AmazonA_HPFAtten);
   /* Provide the rest of the required PGA setting with the second AGC stage. */
   gs_PGA_Reg_Setting |= AmazonACalcAGC2(gs_PGA_required - gs_PGA_set);
#endif   /* End of #ifdef AMAZON_AFE */

   guc_PgaTrainingState = TRAINING_DONE;

}


#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
/*******************************************************************************
*
*  Prototype: AmazonACalcAGC1(int16 s_PGA_required)
*
*  This function is called by BgPGA() and calculates the setting of the first
*  AGC stage in the Amazon-A AFE IC.
*
*  Arguments:
*     s_PGA_required (I):           Required gain for this stage (dB in 8.8 format)
*
*  Returns:
*
*  Global Variables:
*     gs_PGA_set (O):               Actual gain (dB in 8.8 format)
*
*******************************************************************************/
C_SCOPE int16 AmazonACalcAGC1(int16 s_PGA_required)
{
   int16 s_Reg_Setting;

   s_PGA_required >>= 8;

#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
   /* First AGC stage has settings from 0dB to 28dB in 1dB increments and four */
   /* special settings: -6dB, 30dB, 32dB, and 34dB. Find the largest possible */
   /* setting that is less than or equal to PGA required. */
   if (s_PGA_required < 0)
   {
      s_Reg_Setting = 128;
      gs_PGA_set = (-6 * 256);
   }
   else if (s_PGA_required < 28)
   {
      s_Reg_Setting = s_PGA_required;
      gs_PGA_set = (s_PGA_required * 256);
   }
   else if (s_PGA_required < 30)
   {
      s_Reg_Setting = 28;
      gs_PGA_set = (28 * 256);
   }
   else if (s_PGA_required < 32)
   {
      s_Reg_Setting = 29;
      gs_PGA_set = (30 * 256);
   }
   else if (s_PGA_required < 34)
   {
      s_Reg_Setting = 30;
      gs_PGA_set = (32 * 256);
   }
   else
   {
      s_Reg_Setting = 31;
      gs_PGA_set = (34 * 256);
   }

   return (s_Reg_Setting << 8);
#else /* Else for #ifdef DANUBE_AFE */
   /* First AGC stage has settings from 0dB to 26dB in 1dB increments and three */
   /* special settings: -6dB, 30dB, and 34dB. Find the largest possible setting */
   /* that is less than or equal to PGA required. */
   if (s_PGA_required < 0)
   {
      s_Reg_Setting = 29;
      gs_PGA_set = (-6 * 256);
   }
   else if (s_PGA_required < 26)
   {
      s_Reg_Setting = s_PGA_required;
      gs_PGA_set = (s_PGA_required * 256);
   }
   else if (s_PGA_required < 30)
   {
      s_Reg_Setting = 26;
      gs_PGA_set = (26 * 256);
   }
   else if (s_PGA_required < 34)
   {
      s_Reg_Setting = 27;
      gs_PGA_set = (30 * 256);
   }
   else
   {
      s_Reg_Setting = 28;
      gs_PGA_set = (34 * 256);
   }

   return (s_Reg_Setting << 5);
#endif   /* End of #ifdef/#else DANUBE_AFE */
}


/*******************************************************************************
*
*  Prototype: AmazonACalcAGC2(int16 s_PGA_required)
*
*  This function is called by BgPGA() and calculates the setting of the second
*  AGC stage in the Amazon-A AFE IC.
*
*  Arguments:
*     s_PGA_required (I):           Required gain for this stage (dB in 8.8 format)
*
*  Returns:
*
*  Global Variables:
*     gs_PGA_set (O):               Actual total gain (dB in 8.8 format)
*
*******************************************************************************/
C_SCOPE int16 AmazonACalcAGC2(int16 s_PGA_required)
{
   int16 s_Reg_Setting;

   s_PGA_required >>= 8;

#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
   /* Second AGC stage has settings from -2dB to 29dB in 1dB increments. */
   /* Find the largest possible setting that is less than or equal to PGA */
   /* required. */
   if (s_PGA_required < -1)
   {
      s_Reg_Setting = 0;
      gs_PGA_set += (-2 * 256);
   }
   else if (s_PGA_required < 29)
   {
      s_Reg_Setting = s_PGA_required + 2;
      gs_PGA_set += (s_PGA_required * 256);
   }
   else
   {
      s_Reg_Setting = 31;
      gs_PGA_set += (29 * 256);
   }

   return s_Reg_Setting;
#else /* Else for #ifdef DANUBE_AFE */
   /* Second AGC stage has settings from 0dB to 18dB in 1dB increments and two */
   /* special settings: -1dB, and -2dB. Find the largest possible setting */
   /* that is less than or equal to PGA required. */
   if (s_PGA_required < -1)
   {
      s_Reg_Setting = 20;
      gs_PGA_set += (-2 * 256);
   }
   else if (s_PGA_required < 0)
   {
      s_Reg_Setting = 19;
      gs_PGA_set += (-1 * 256);
   }
   else if (s_PGA_required < 18)
   {
      s_Reg_Setting = s_PGA_required;
      gs_PGA_set += (s_PGA_required * 256);
   }
   else
   {
      s_Reg_Setting = 18;
      gs_PGA_set += (18 * 256);
   }

   return s_Reg_Setting;
#endif   /* End of #ifdef/#else DANUBE_AFE */
}
#endif   /* End of #ifdef AMAZON_AFE */


#undef RFIL_BASE
#undef DIFF_SUM11_SUM12_TABLE



