/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   afe_hyb.c
*
*   Functions supporting programmable hybrid training.
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "gdata.h"
#include "afe.h"

#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
/******************************/
/***  Functions prototypes  ***/
/******************************/
void CalcPGAVars(void);
LoadingFunction LoadHybridHPFAndPGA;

extern void WriteAfe(int16 addr, int16 data);
extern int16 ReadAfe(int16 addr);

#ifdef INFINEON
void ComputeExtraPGAMargin_AnxLBTLoops(void);
#endif

/*******************************************************************************
*
*  Prototype: void CalcPGAVars(void)
*
*  This function populates set and required PGA variables for the loaded hybrid.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gs_LoadHybIndex (I):    Index of the loaded hybrid
*     gpsa_PGARegTable (I):      Array holding AGC register settings for all hybrids
*     gpsa_PGARequiredTable (I): Array holding required PGA values for all hybrids
*     gs_PGA_set (O):            Actual PGA gain (dB in 8.8 format)
*     gs_PGA_required (O):    Required PGA gain (dB in 8.8 format)
*
*******************************************************************************/
C_SCOPE void CalcPGAVars(void)
{
   int16 s_Reg_Setting;

#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
   /* Find AGC1 gain from the AGC register setting. */
   s_Reg_Setting = (gpsa_PGARegTable[gs_LoadHybIndex] >> 8) & 0x9F;
   if (s_Reg_Setting == 29)
   {
      s_Reg_Setting = 30;
   }
   else if (s_Reg_Setting == 30)
   {
      s_Reg_Setting = 32;
   }
   else if (s_Reg_Setting == 31)
   {
      s_Reg_Setting = 34;
   }
   else if (s_Reg_Setting == 128)
   {
      s_Reg_Setting = -6;
   }
#else /* Else for #ifdef DANUBE_AFE */
   /* Find AGC1 gain from the AGC register setting. */
   s_Reg_Setting = gpsa_PGARegTable[gs_LoadHybIndex] >> 5;
   if (s_Reg_Setting == 27)
   {
      s_Reg_Setting = 30;
   }
   else if (s_Reg_Setting == 28)
   {
      s_Reg_Setting = 34;
   }
   else if (s_Reg_Setting == 29)
   {
      s_Reg_Setting = -2;
   }
   else if (s_Reg_Setting > 29)
   {
      s_Reg_Setting = 0;
   }
#endif   /* End of #ifdef/#else DANUBE_AFE */
   /* Store AGC1 gain. */
   gs_PGA_set = s_Reg_Setting;

#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
   /* Find AGC2 gain from the AGC register setting. */
   s_Reg_Setting = gpsa_PGARegTable[gs_LoadHybIndex] & 0x1F;
   s_Reg_Setting -= 2;
#else /* Else for #ifdef DANUBE_AFE */
   /* Find AGC2 gain from the AGC register setting. */
   s_Reg_Setting = gpsa_PGARegTable[gs_LoadHybIndex] & 0x1F;
   if (s_Reg_Setting == 19)
   {
      s_Reg_Setting = -1;
   }
   else if (s_Reg_Setting == 20)
   {
      s_Reg_Setting = -2;
   }
   else if (s_Reg_Setting > 20)
   {
      s_Reg_Setting = 0;
   }
#endif   /* End of #ifdef/#else DANUBE_AFE */
   /* Add AGC2 gain. */
   gs_PGA_set += s_Reg_Setting;

   /* Convert to 8.8 format. */
   gs_PGA_set <<= 8;

   /* Populate analog gain variable needed for loop attenuation calculation. */
   gs_CumulAnlgGain = gs_PGA_set + (int16)ANALOG_GAIN_DB;

   /* Populate required gain variable. */
   gs_PGA_required = gpsa_PGARequiredTable[gs_LoadHybIndex];
}


/*******************************************************************************
*
*  Prototype: void LoadHybridHPFAndPGA(void)
*
*  This functions sets up a specified hybrid from a list of predetermined hybrids.
*  It also loads the AGC register with the corresponding setting.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gs_LoadHybIndex (I):    Index in a table of predetermined hybrids
*     gft_AFEBypassMode (I):     Flag used for AFE bypass mode
*     gft_SetPGADisable (I):     Flag used to disable PGA setting
*     gs_PGA_Reg_Setting (O):    Variable containing hardware AGC register value
*
*******************************************************************************/
C_SCOPE void LoadHybridHPFAndPGA(void)
{
   if (gft_AFEBypassMode == FALSE)
   {
      /* Write value from the hybrid table directly to the AFE hybrid register. */
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
      WriteAfe(DANUBEA_HYB_SET_B, (int16)gpusa_HybridReg0[gs_LoadHybIndex]);
      WriteAfe(DANUBEA_HYB_SET_A, (int16)gpusa_HybridReg1[gs_LoadHybIndex]);
#else /* Else for #ifdef DANUBE_AFE */
      WriteAfe(AMAZONA_HYBRID_SETTING0, (int16)gpusa_HybridReg0[gs_LoadHybIndex]);
#endif   /* End of #ifdef/#else DANUBE_AFE */
      /* Combine the HPF status (on or off) with equalizer setting and HPF corner */
      /* frequency setting from the table and write to the Amazon-A AFE HPF register. */
      gs_HPFEq_Reg_Setting = (gs_HPFEq_Reg_Setting & HPF_ON_OFF_MASK) | ((int16)gpusa_HpfEqReg[gs_LoadHybIndex] & EQ_HPF_FREQ_MASK);
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
      WriteAfe(DANUBEA_HPF_EQ_SET, gs_HPFEq_Reg_Setting);
#else /* Else for #ifdef DANUBE_AFE */
      WriteAfe(AMAZONA_HPF_EQ_SETTING, gs_HPFEq_Reg_Setting);
#endif   /* End of #ifdef/#else DANUBE_AFE */
   }

   if (gft_SetPGADisable == FALSE)
   {
      /* Write a value from the globaly populated AGC table into the AGC register. */
      gs_PGA_Reg_Setting = gpsa_PGARegTable[gs_LoadHybIndex];
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
      WriteAfe(DANUBEA_PGA_SET, gs_PGA_Reg_Setting);
#else /* Else for #ifdef DANUBE_AFE */
      WriteAfe(AMAZONA_AGC_SETTING, gs_PGA_Reg_Setting);
#endif   /* End of #ifdef/#else DANUBE_AFE */
   }
}

#ifdef INFINEON
/*******************************************************************************
*
*  Prototype: void ComputeExtraPGAMargin_AnxLBTLoops(void)
*
*  This function checks if there is a need to give extra 3dB PGA margin for Anx L bridge Tap loops
*  In case hybrid selected is between 3 and 31 (which is the case for long bridge tap loops),
*  give extra PGA margin of 3dB. This is to avoid CRCs seen on these loops.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gs_LoadHybIndex (I):    Index of the loaded hybrid
*     gs_PGA_margin_delta_AnxL_BTloops : delta margin to be added to PGA margin
*     gs_pga_margin_AnxL_BTLoops :  Extra PGA margin for AnxL BT loops
*
*******************************************************************************/
C_SCOPE void ComputeExtraPGAMargin_AnxLBTLoops(void)
{
   if ((gs_LoadHybIndex > 3)
#ifndef DANUBE_AFE
      && (gs_LoadHybIndex < 31)
#endif
      )
      gs_PGA_margin_delta_AnxL_BTloops = gs_pga_margin_AnxL_BTLoops;
   else
      gs_PGA_margin_delta_AnxL_BTloops=0;
}


#ifdef ISDN

// temporary fix for build problem
#define AMAZONA_RX_FILT_SETTING     DANUBEA_DIGITAL_RX
// temporary fix for build problem


/*******************************************************************************
*
*  Prototype: void SetAmznAFE_RXFILT(void)
*
*  This functions sets up the Rx filter setting
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:

*******************************************************************************/
C_SCOPE void SetAmznAFE_RXFILT(int16 s_DecFactor)
{
#ifdef DANUBE
 // this function not needed in FS1. Needs to be modified for FS2
#else
   int16 s_DecFactorSet;

   s_DecFactorSet |= 0x200;
   //Set Bit9 of Reg0A to 1 (Reset)
   WriteAfe(AMAZONA_RX_FILT_SETTING, 0x0200);
   //Set Reg0A to 0xXXX4 (Dec->4)
   WriteAfe(AMAZONA_RX_FILT_SETTING, s_DecFactorSet);
   //Set Bit9 of Reg0A to 0 (Reset Remove)
   WriteAfe(AMAZONA_RX_FILT_SETTING, s_DecFactor);
#endif
}
#endif   /* End of #ifdef ISDN */

#endif   /* End of #ifdef INFINEON */

#endif   /* End of #ifdef AMAZON_AFE */

