/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: afeini.c
*
*-------------------------------------------------------------------------------
*/

#include "typedef.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "memrymap.h"
#include "rt_state.h"
#include "delay.h"
#include "ieee_flt.h"
#include "str_iof.h"
#include "data_alloc.h"
#include "ll_iof.h"
#include "afe.h"

extern void WriteAfe(int16 addr, int16 data);
extern int16 ReadAfe(int16 addr);

#define  ANNEXM_TXCNFG  0x242 // filter at 420 synth impedance 0% for annex a board.
#define  ANNEXM_HYBRID 0x0539

/*******************************************************************************
*
*  Prototype: void afe_reconfig(void)
*
*  This function reconfigures AFE post handshake depending on selected mode
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

C_SCOPE void Reconfig_AFE(void)
{
    //Different annexes on tx filtering:
    //At lower-edge: 3 situations(different starting tones).
    //          I/J(1), A/L/M(6--default), B(33)
    //At higher-edge: 2 situations(different ending tones).
    //          L-Mask2(), A/L-Mask1/I(31--default), B/M/J(up to 63).
    //lower edge is controlled by HPF selection, higher edge is
    //controlled by LPF selection. So the following will
    //select the combinations according to the selected annex.



#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
#ifdef ISDN
//    /* in ISDN mode the tx and rx are identical in Annex-B and Annex-M mode */
//    /* Line driver with 45% SI, Annex-B mode used Annex-M. */
   WriteAfe(DANUBEA_TX_CONF,0x0451);      // 100 1001: SI=0.45, 1.0MHz POFI cutoff-frequency
//    /* use Annex-B equalizter setting */
   WriteAfe(DANUBEA_HPF_EQ_SET,0x0208);
#else
//    /* Line driver with 0% SI, Annex-B mode used Annex-M. */
//    WriteAfe(DANUBEA_TX_CONF,0x0040);      // 360kHz POFI cutoff-frequency
//    /* use Annex-B equalizter setting */
//    WriteAfe(DANUBEA_HPF_EQ_SET,0x0208);
#endif
#else /* Else for #ifdef DANUBE_AFE */
   /* Set POFI cut-off frequency to 420kHz and use default synthesized impedance. */
   /* and Set default hybrid  */
#ifdef ISDN
   WriteAfe(AMAZONA_TX_CONFIG,TX_CONFIG_ISDNAnnexM); // (0x244)
   WriteAfe(AMAZONA_HYBRID_SETTING0,ISDN_HYBRID0);  //0x0E8D);
#else
   WriteAfe(AMAZONA_TX_CONFIG,TX_CONFIG_POTSAnnexM); // (0x246)
   WriteAfe(AMAZONA_HYBRID_SETTING0,POTS_HYBRID0); //0x0539
#endif

   /* Set  HPF corner frequency values. */
   gs_HPFEq_Reg_Setting = 0x000F;
   WriteAfe(AMAZONA_HPF_EQ_SETTING,gs_HPFEq_Reg_Setting);

   /* Manually set POFI corner frequency to default. */
   WriteAfe(AMAZONA_LD_OPTION0,0x0001);
#endif   /* End of #ifdef/#else DANUBE_AFE */
#endif   /* End of #ifdef AMAZON_AFE */
}
