/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: afeini.c
*
*-------------------------------------------------------------------------------
*/

#ifdef TARGET_SIM

#include "typedef.h"
#include "gdata.h"
#include "memrymap.h"
#include "rt_state.h"
#include "delay.h"
#include "data_alloc.h"
#include "afe.h"

extern void WriteAfe(int16 addr, int16 data);

extern void afe_reset(void);

extern int16 ReadAfe(int16 addr);





/*******************************************************************************
*
*  Prototype: void calibrate(void)
*
*  This function calibrates Datapath Farallon AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

#define MAX_WEIGHTS (20)
DATA_MAP_deILV2_BIS
static int32 in_reg4[20];
static int16 out_reg4[20];
static int32 in_reg5[20];
static int16 out_reg5[20];
static int32 coff[20], new_coff[20];
static int32 sum;
DATA_MAP_END

void calibrate(void)
{
   int16 i;
   static int32 sum;
   static int16 tmp;
   Float32 tmpfloat;

   /* read the registers */
   for (i=0;i<MAX_WEIGHTS;i++) {
      WriteAfe(0x5,(int16)(384+i));
      tmp = ReadAfe(0x5);
      if (tmp < 0) {
         in_reg5[i] = (int32) ((int32)tmp + 65536);
      } else {
         in_reg5[i] = (int32) tmp;
      }
      tmp = ReadAfe(0x4);
      if (tmp < 0) {
         in_reg4[i] = (int32) ((int32)tmp + 65536);
      } else {
         in_reg4[i] = (int32) tmp;
      }
   }

   sum = 0;
   for (i=0;i<MAX_WEIGHTS;i++) {
      coff[i] = ((in_reg5[i] & 0x0000f000) << 4) | (in_reg4[i] & 0x0000ffff);
      sum += coff[i];
   }

   for (i=0;i<MAX_WEIGHTS;i++) {
      tmpfloat = mpyf32(int32toFloat32(coff[i]),int32toFloat32((int32) 1048576));
      tmpfloat = divf32(tmpfloat,int32toFloat32(sum));
      new_coff[i] = f32toint32(tmpfloat,0);
      out_reg4[i] =(int16) (new_coff[i] & 0x0000ffff);
      out_reg5[i] = (((new_coff[i]&0x000f0000)>>4) | 0x0180 | i);
      WriteAfe(0x5, out_reg5[i]);
      WriteAfe(0x4, out_reg4[i]);
   }

}

#undef MAX_WEIGHTS


/*******************************************************************************
*
*  Prototype: void afe_reset(void)
*
*  This function resets Datapath Farallon AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void afe_reset(void)
{


}

/*******************************************************************************
*
*  Prototype: void afe_init(void)
*
*  This function initializes Datapath Farallon AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void afe_init(void)
{

}


#else //Not TARGET_SIM

#include "typedef.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "memrymap.h"
#include "rt_state.h"
#include "delay.h"
#include "ieee_flt.h"
#include "str_iof.h"
#include "data_alloc.h"
#include "ll_iof.h"
#include "afe.h"
#include "cmv.h"
#include "gpio.h"
#include "fifo.h"

extern void WriteAfe(int16 addr, int16 data);
extern int16 ReadAfe(int16 addr);

#ifdef DANUBE_AFE
//  Define initial Danube AFE hybrid setting as variable for now so they can be changed via script.
//
//  We select hybrid 3 (for 500 BT) as the initial hybrid.
//  and we select the highest corner HPF (380khz?)
int16  gs_HybB = 0 ; //hybridreg0(3)      //afe reg 6
int16  gs_HybA = 0x204; // hybridreg1(3)    //afe reg 7
int16  gs_HPF_init =0;   // HPF with highest corner.
#endif













/*******************************************************************************
*
*  Prototype: void afe_reset(void)
*
*  This function resets the AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void afe_reset(void)
{
   uint32 ul_data = 0;











#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
      /* Disable AEC path. */
      Strymon_DisableAECPath();
      delay(500);

      /* Put Strymon AFE interface into a reset state. */
      WriteCoreReg(AFE_CONFIG_ADDR,(uint16)0x010C);
      delay(500);

      if (guc_Iridia_Revision_Number >= IRIDIA_31) // need to read iridia revision number as there is no strymon revision number.
      {
         /* Put Strymon AFE interface in Infineon serial and digital mode. */
         WriteCoreReg32(AFE_MODE_SEL_ADDR, 0x00000808);
         delay(500);
         WriteCoreReg32(AFE_TCR_0_ADDR, 0x00006321);
         delay(500);
         WriteCoreReg32(AFE_TCR_1_ADDR, 0x44449999);
         delay(500);
         WriteCoreReg32(AFE_TCR_2_ADDR, 0x00000000);
         delay(500);
      }
      else
      {
         /* Put Strymon AFE interface in SiLabs serial and Fujitsu digital mode */
         /* for CPLD to work properly. */
         WriteCoreReg(AFE_MODE_SEL_ADDR,(uint16)(0x0204));
         delay(500);
         WriteCoreReg(AFE_TCR_0_ADDR, 0x0341);
         delay(500);
         WriteCoreReg(AFE_TCR_1_ADDR, 0x004B);
         delay(500);
         WriteCoreReg(AFE_TCR_2_ADDR, 0x0000);
         delay(500);
      }

      WriteCoreReg(AFE_SERIAL_CONFIG_ADDR,(uint16)0x0018);
      delay(500);

      /* Configure Strymon AFE interface format to 2's complement in both TX and RX. */
      WriteCoreReg(AFE_CONFIG_ADDR,(uint16)0x00C0);
      delay(2000);

#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
      gs_min_pga_setting = (-8*256);
      gs_max_pga_setting = (63*256);
#else /* Else for #ifdef DANUBE_AFE */
      gs_min_pga_setting = (-8*256);
      gs_max_pga_setting = (52*256);
#endif   /* End of #ifdef/#else DANUBE_AFE */
#endif   /* End of #ifdef AMAZON_AFE */

#ifndef HERCULES_ADSL_CPE
   /* Write SMODE2 value (needed for some AFEs). */
   if (guc_Iridia_Revision_Number >= IRIDIA_31) // need to read iridia revision number as there is no cri revision number.
   {
      ul_data = ((((uint32)gus_SMODE2 << 4)&0xFFE0) | ((uint32)(gus_SMODE1&0x1F)));
      WriteCoreReg32((uint16) SMODE1_ADDR, ul_data);
   }
   else
   {
      WriteCoreReg((uint16) SMODE2_ADDR, gus_SMODE2);
   }
#endif
}

/*******************************************************************************
*
*  Prototype: void afe_init(void)
*
*  This function initialize the AFE IC.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

int16 AFETimeOutCount;

uint8 guc_Silab_Chip_Revision_Number;







void afe_init(void)
{
   int16 i, s_temp;
   static int16 tmp;













#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */

      STATArray[STAT_AFETYPE] = STAT_AMAZON_AFE;

#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
#ifdef ISDN
      /* Line driver with 45% SI, Annex-B mode. */
      WriteAfe(DANUBEA_TX_CONF,0x0451); //isdnOnlyBd
#else
      /* Line driver with 0% SI, Annex-A mode. */
      WriteAfe(DANUBEA_TX_CONF,0x0000);
#endif
      /* Decimation factor 4, filter in INIT state. */
      WriteAfe(DANUBEA_DIGITAL_RX,0x0402);
      /* Decimation factor 4, filter active. */
      WriteAfe(DANUBEA_DIGITAL_RX,0x0400);
      /* Reset of TX filter. */
      WriteAfe(DANUBEA_SOFT_RESETS,0x0008);
      /* Interpolation factor 8, US data interface samples at 2nd positive clock */
      /* edge, US data mode is 2's complement. */
      WriteAfe(DANUBEA_DIGITAL_TX,0x0D08);
      /* Release of TX filter reset. */
      WriteAfe(DANUBEA_SOFT_RESETS,0x0000);

        /* Write afe initial regs  */
      WriteAfe(DANUBEA_LD_OPT,  0x0003);  // Register #42
      WriteAfe(DANUBEA_PGA1_OPT,0x0022);  // Register #44
      WriteAfe(DANUBEA_PGA2_OPT,0x0100);
      WriteAfe(DANUBEA_ADC_OPT1,0x408A);  // Register #47
      WriteAfe(DANUBEA_ADC_OPT2,0x0C20);  // Register #48
      WriteAfe(DANUBEA_ADC_OPT3,0x0100);
      WriteAfe(DANUBEA_OSC,   0x0001);



      /* Set the hybrid and HPF corner frequency for loops with 600ft tap (otherwise */
      /* handshake will have problems at 17.5kft bridge tap loops). */
      WriteAfe(DANUBEA_HYB_SET_A, gs_HybA);
      WriteAfe(DANUBEA_HYB_SET_B, gs_HybB);

      /* Turn HPF on and equalizer off and set HPF corner frequency x. */
      gs_HPFEq_Reg_Setting = gs_HPF_init; //0x0001;
      WriteAfe(DANUBEA_HPF_EQ_SET,gs_HPFEq_Reg_Setting);
      /* Power up of the AFE. */
      WriteAfe(DANUBEA_POWER_DOWN,0x0000);
      delay(10000);
#else /* Else for #ifdef DANUBE_AFE */
      /* Power up the entire AFE. */
      WriteAfe(AMAZONA_POWER_DOWN,0x0080);
      delay(10000);
      /* Start POFI tuning. */
      WriteAfe(AMAZONA_TX_CONFIG,0x0242);
      /* Set the hybrid and HPF corner frequency for loops with 600ft tap (otherwise */
      /* handshake will have problems at 17.5kft bridge tap loops). */
      WriteAfe(AMAZONA_HYBRID_SETTING0,0x2D0B);
      WriteAfe(AMAZONA_HYBRID_SETTING1,0x0000);
      WriteAfe(AMAZONA_HYBRID_SETTING2,0x0000);
      /* Turn HPF on and equalizer off and set HPF corner frequency to 180kHz. */
      gs_HPFEq_Reg_Setting = 0x0006;
      WriteAfe(AMAZONA_HPF_EQ_SETTING,gs_HPFEq_Reg_Setting);
      /* ADC2: Set decimation factor to 6 (52.992MS/s down to 8.832MS/s). */
      WriteAfe(AMAZONA_RX_FILT_SETTING,0x0006);
      /* Enable 2's complement in the TX data interface, set */
      /* interpolation factor to 4 (4.416MS/s up to 17.664MS/s), */
      /* and set the TX data sampling at 2nd positive edge. */
      WriteAfe(AMAZONA_TX_FILT_SETTING,0x0504);
      /* Manually set POFI corner frequency to minimum. */
      WriteAfe(AMAZONA_LD_OPTION0,0x000F);
      /* Set AGC1 bias current. */
      WriteAfe(AMAZONA_AGC1_HYB_OPTION,0x0180);
      /* A11: Optimize noise floor for G.dmt/ADSL2+ mode. */
      WriteAfe(AMAZONA_ADC_OPTION0,0x0100);
      /* Trim the voltage regulator output to -8% = 1.68V (1.83V is the default). */
      WriteAfe(AMAZONA_BIAS_OPTION,0x00C0);
      /* Power up the entire AFE. */
      WriteAfe(AMAZONA_POWER_DOWN,0x0080);
      delay(10000);

#endif   /* End of #ifdef/#else DANUBE_AFE */
#endif   /* End of #ifdef AMAZON_AFE */

      gs_PGA_required = 23*256;  /* initial PGA */
      BgPGA();
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetPGA);
}














#endif
